/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javafx.scene.paint.Color;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;

public class ColorToolsFX {
    public static final Color TRANSLUCENT_BLACK_FX = Color.rgb((int)0, (int)0, (int)0, (double)0.5);
    public static final Color TRANSLUCENT_WHITE_FX = Color.rgb((int)255, (int)255, (int)255, (double)0.5);
    private static final Map<Integer, Color> colorMap = new HashMap<Integer, Color>();
    private static final Map<Integer, Color> colorMapWithAlpha = new HashMap<Integer, Color>();
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock r = rwl.readLock();
    private static final Lock w = rwl.writeLock();

    public static Color getCachedColor(int r, int g, int b, int a) {
        return ColorToolsFX.getCachedColor(ColorTools.packARGB((int)a, (int)r, (int)g, (int)b), true);
    }

    public static Color getCachedColor(int r, int g, int b) {
        return ColorToolsFX.getCachedColor(ColorTools.packRGB((int)r, (int)g, (int)b));
    }

    public static Color getCachedColor(Integer rgb) {
        return ColorToolsFX.getCachedColor(rgb, ColorTools.alpha((int)rgb) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getCachedColor(Integer rgb, boolean hasAlpha) {
        Color color;
        if (rgb == null) {
            return null;
        }
        r.lock();
        try {
            Color color2 = color = hasAlpha ? colorMapWithAlpha.get(rgb) : colorMap.get(rgb);
            if (color != null) {
                Color color3 = color;
                return color3;
            }
        }
        finally {
            r.unlock();
        }
        w.lock();
        try {
            if (hasAlpha) {
                color = Color.rgb((int)ColorTools.red((int)rgb), (int)ColorTools.green((int)rgb), (int)ColorTools.blue((int)rgb), (double)((double)ColorTools.alpha((int)rgb) / 255.0));
                colorMapWithAlpha.put(rgb, color);
            } else {
                color = Color.rgb((int)ColorTools.red((int)rgb), (int)ColorTools.green((int)rgb), (int)ColorTools.blue((int)rgb));
                colorMap.put(rgb, color);
            }
            Color color4 = color;
            return color4;
        }
        finally {
            w.unlock();
        }
    }

    public static int getRGB(Color color) {
        return ColorTools.packRGB((int)((int)(color.getRed() * 255.0)), (int)((int)(color.getGreen() * 255.0)), (int)((int)(color.getBlue() * 255.0)));
    }

    public static int getARGB(Color color) {
        return ColorTools.packARGB((int)((int)(color.getOpacity() * 255.0)), (int)((int)(color.getRed() * 255.0)), (int)((int)(color.getGreen() * 255.0)), (int)((int)(color.getBlue() * 255.0)));
    }

    public static Color getDisplayedColor(PathObject pathObject) {
        Integer rgb = ColorToolsFX.getDisplayedColorARGB(pathObject);
        Color color = ColorToolsFX.getCachedColor(rgb);
        return color;
    }

    public static Color getPathClassColor(PathClass pathClass) {
        Color color = ColorToolsFX.getCachedColor(pathClass.getColor());
        if (color == null) {
            return Color.GRAY;
        }
        return color;
    }

    public static Color getColorWithOpacityFX(Integer rgb, double opacity) {
        if (rgb == null) {
            return null;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        } else if (opacity < 0.0) {
            opacity = 0.0;
        }
        return Color.rgb((int)ColorTools.red((int)rgb), (int)ColorTools.green((int)rgb), (int)ColorTools.blue((int)rgb), (double)opacity);
    }

    public static Color getColorWithOpacity(Color color, double opacity) {
        if (color == null) {
            return null;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        } else if (opacity < 0.0) {
            opacity = 0.0;
        }
        return Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)opacity);
    }

    public static Integer getDisplayedColorARGB(PathObject pathObject) {
        Integer color = pathObject.getColor();
        if (color != null) {
            return color;
        }
        PathClass pathClass = pathObject.getPathClass();
        if (pathClass != null) {
            color = pathClass.getColor();
        } else if (pathObject instanceof TMACoreObject) {
            color = PathPrefs.colorTMAProperty().getValue();
        }
        if (color != null) {
            TMACoreObject core;
            if (pathObject instanceof TMACoreObject && (core = (TMACoreObject)pathObject).isMissing()) {
                color = ColorTools.packARGB((int)GeneralTools.clipValue((int)((int)Math.round(255.0 * PathPrefs.opacityTMAMissingProperty().get())), (int)0, (int)255), (int)ColorTools.red((int)color), (int)ColorTools.green((int)color), (int)ColorTools.blue((int)color));
            }
            return color;
        }
        if (pathObject instanceof PathTileObject) {
            return PathPrefs.colorTileProperty().getValue();
        }
        return PathPrefs.colorDefaultObjectsProperty().getValue();
    }
}

