/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.ChartTools;
import qupath.lib.gui.charts.HistogramDisplay;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.gui.measure.ui.SummaryMeasurementTable;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.tma.CenteredTreeTableCell;
import qupath.lib.gui.tma.DragDropTMADataImportListener;
import qupath.lib.gui.tma.ImageListCell;
import qupath.lib.gui.tma.ImageTableCell;
import qupath.lib.gui.tma.KaplanMeierDisplay;
import qupath.lib.gui.tma.NumericTreeTableCell;
import qupath.lib.gui.tma.TMAEntries;
import qupath.lib.gui.tma.TMAImageCache;
import qupath.lib.gui.tma.TMASummaryEntry;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.io.PathIO;
import qupath.lib.io.TMAScoreImporter;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.DefaultTMAGrid;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;

@Deprecated
public class TMASummaryViewer {
    private static final Logger logger = LoggerFactory.getLogger(TMASummaryViewer.class);
    private IntegerProperty maxSmallWidth = new SimpleIntegerProperty(150);
    private TMAImageCache imageCache = new TMAImageCache(this.maxSmallWidth.get());
    private static String MISSING_COLUMN = "Missing";
    private final Stage stage;
    private ObservableList<String> metadataNames = FXCollections.observableArrayList();
    private ObservableList<String> measurementNames = FXCollections.observableArrayList();
    private ObservableList<String> filteredMeasurementNames = new FilteredList(this.measurementNames, m -> !TMASummaryEntry.isSurvivalColumn(m));
    private ObservableList<String> survivalColumns = FXCollections.observableArrayList();
    private ComboBox<String> comboSurvival = new ComboBox(this.survivalColumns);
    private ObservableList<TMAEntries.TMAEntry> entriesBase = FXCollections.observableArrayList();
    private boolean trimUniqueIDs = true;
    private Set<String> lastHiddenColumns = new HashSet<String>();
    private String colCensored = null;
    private Scene scene;
    private ImageData<BufferedImage> imageData;
    private PathObjectHierarchyListener hierarchyListener = this::handleHierarchyChange;
    private static ObjectProperty<ImageAvailability> imageAvailability = new SimpleObjectProperty((Object)ImageAvailability.NONE);
    private ComboBox<String> comboMainMeasurement = new ComboBox(this.filteredMeasurementNames);
    private ComboBox<TMAEntries.MeasurementCombinationMethod> comboMeasurementMethod = new ComboBox();
    private ReadOnlyObjectProperty<TMAEntries.MeasurementCombinationMethod> selectedMeasurementCombinationProperty = this.comboMeasurementMethod.getSelectionModel().selectedItemProperty();
    private TreeTableView<TMAEntries.TMAEntry> table = new TreeTableView();
    private TMATableModel model;
    private TMAEntries.TMAEntry entrySelected = null;
    private BooleanProperty hidePaneProperty = new SimpleBooleanProperty(false);
    private BooleanProperty useSelectedProperty = new SimpleBooleanProperty(false);
    private BooleanProperty skipMissingCoresProperty = new SimpleBooleanProperty(true);
    private BooleanProperty groupByIDProperty = new SimpleBooleanProperty(true);
    private HistogramDisplay histogramDisplay;
    private KaplanMeierDisplay kmDisplay;
    private ScatterPane scatterPane = new ScatterPane();
    private ObservableValue<Predicate<TMAEntries.TMAEntry>> predicateHideMissing = Bindings.createObjectBinding(() -> {
        if (!this.skipMissingCoresProperty.get()) {
            return c -> true;
        }
        return c -> !c.isMissing();
    }, (Observable[])new Observable[]{this.skipMissingCoresProperty});
    private ObjectProperty<Predicate<TMAEntries.TMAEntry>> predicateMetadataFilter = new SimpleObjectProperty();
    private ObjectProperty<Predicate<TMAEntries.TMAEntry>> predicateMeasurements = new SimpleObjectProperty();
    private ObservableValue<Predicate<TMAEntries.TMAEntry>> combinedPredicate;

    public TMASummaryViewer(Stage stage) {
        if (stage == null) {
            this.stage = new Stage();
            FXUtils.addCloseWindowShortcuts((Stage)stage);
        } else {
            this.stage = stage;
        }
        logger.trace("Creating TMA summary viewer");
        this.combinedPredicate = Bindings.createObjectBinding(() -> {
            Predicate thisPredicate = (Predicate)this.predicateHideMissing.getValue();
            if (this.predicateMeasurements.get() != null) {
                thisPredicate = thisPredicate.and((Predicate)this.predicateMeasurements.getValue());
            }
            if (this.predicateMetadataFilter.get() != null) {
                thisPredicate = thisPredicate.and((Predicate)this.predicateMetadataFilter.getValue());
            }
            return thisPredicate;
        }, (Observable[])new Observable[]{this.predicateMeasurements, this.predicateHideMissing, this.predicateMetadataFilter});
        this.initialize();
        this.stage.setTitle("TMA Results Viewer");
        this.stage.setScene(this.scene);
        new DragDropTMADataImportListener(this);
    }

    private void initialize() {
        this.model = new TMATableModel();
        this.groupByIDProperty.addListener((v, o, n) -> this.refreshTableData());
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu("File");
        MenuItem miOpen = new MenuItem("Open...");
        miOpen.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        miOpen.setOnAction(e -> {
            File file = FileChoosers.promptForFile((Window)this.stage, null, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"TMA data files", (String[])new String[]{"*.qptma"})});
            if (file == null) {
                return;
            }
            this.setInputFile(file);
        });
        MenuItem miSave = new MenuItem("Save As...");
        miSave.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        miSave.setOnAction(e -> SummaryMeasurementTable.saveTableModel(this.model, null, Collections.emptyList()));
        MenuItem miImportFromImage = new MenuItem("Import from current image...");
        miImportFromImage.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        miImportFromImage.setOnAction(e -> this.setTMAEntriesFromOpenImage());
        MenuItem miImportFromProject = new MenuItem("Import from current project... (experimental)");
        miImportFromProject.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        miImportFromProject.setOnAction(e -> this.setTMAEntriesFromOpenProject());
        MenuItem miImportClipboard = new MenuItem("Import from clipboard...");
        miImportClipboard.setOnAction(e -> {
            String text = Clipboard.getSystemClipboard().getString();
            if (text == null) {
                Dialogs.showErrorMessage((String)"Import scores", (String)"Clipboard is empty!");
                return;
            }
            int n = this.importScores(text);
            if (n > 0) {
                this.setTMAEntries(new ArrayList<TMAEntries.TMAEntry>((Collection<TMAEntries.TMAEntry>)this.entriesBase));
            }
            Dialogs.showMessageDialog((String)"Import scores", (String)("Number of scores imported: " + n));
        });
        Menu menuEdit = new Menu("Edit");
        MenuItem miCopy = new MenuItem("Copy table to clipboard");
        miCopy.setOnAction(e -> SummaryMeasurementTable.copyTableContentsToClipboard(this.model, Collections.emptyList()));
        this.combinedPredicate.addListener((v, o, n) -> Platform.runLater(() -> this.handleTableContentChange()));
        MenuItem miResetMissingScores = new MenuItem("Reset scores for missing cores");
        miResetMissingScores.setOnAction(e -> {
            int changes = 0;
            for (TMAEntries.TMAEntry entry : this.entriesBase) {
                if (!entry.isMissing()) continue;
                boolean changed = false;
                for (String m : entry.getMeasurementNames().toArray(new String[0])) {
                    if (TMASummaryEntry.isSurvivalColumn(m) || Double.isNaN(entry.getMeasurementAsDouble(m))) continue;
                    entry.putMeasurement(m, null);
                    changed = true;
                }
                if (!changed) continue;
                ++changes;
            }
            if (changes == 0) {
                logger.info("No changes made when resetting scores for missing cores!");
                return;
            }
            logger.info("{} change(s) made when resetting scores for missing cores!", (Object)changes);
            this.table.refresh();
            this.updateSurvivalCurves();
            if (this.scatterPane != null) {
                this.scatterPane.updateChart();
            }
            if (this.histogramDisplay != null) {
                this.histogramDisplay.refreshHistogram();
            }
        });
        menuEdit.getItems().add((Object)miResetMissingScores);
        MenuTools.addMenuItems(menuFile, miOpen, miSave, null, miImportClipboard, null, miImportFromImage, miImportFromProject);
        menuBar.getMenus().add((Object)menuFile);
        menuEdit.getItems().add((Object)miCopy);
        menuBar.getMenus().add((Object)menuEdit);
        menuFile.setOnShowing(e -> {
            boolean imageDataAvailable = QuPathGUI.getInstance() != null && QuPathGUI.getInstance().getImageData() != null && QuPathGUI.getInstance().getImageData().getHierarchy().getTMAGrid() != null;
            miImportFromImage.setDisable(!imageDataAvailable);
            boolean projectAvailable = QuPathGUI.getInstance() != null && QuPathGUI.getInstance().getProject() != null && !QuPathGUI.getInstance().getProject().getImageList().isEmpty();
            miImportFromProject.setDisable(!projectAvailable);
        });
        this.table.setPlaceholder((Node)new Label("Drag TMA data folder onto window, or choose File -> Open"));
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        BorderPane pane = new BorderPane();
        pane.setTop((Node)menuBar);
        SystemMenuBar.manageMainMenuBar(menuBar);
        ToolBar toolbar = new ToolBar();
        Label labelMeasurementMethod = new Label("Combination method");
        labelMeasurementMethod.setLabelFor(this.comboMeasurementMethod);
        labelMeasurementMethod.setTooltip(new Tooltip("Method whereby measurements for multiple cores with the same Case ID will be combined"));
        CheckBox cbHidePane = new CheckBox("Hide pane");
        cbHidePane.setSelected(this.hidePaneProperty.get());
        cbHidePane.selectedProperty().bindBidirectional((Property)this.hidePaneProperty);
        CheckBox cbGroupByID = new CheckBox("Group by ID");
        this.entriesBase.addListener(event -> {
            if (!event.getList().stream().anyMatch(e -> e.getMetadataValue("Case ID") != null)) {
                cbGroupByID.setSelected(false);
                cbGroupByID.setDisable(true);
            } else {
                cbGroupByID.setDisable(false);
            }
        });
        cbGroupByID.setSelected(this.groupByIDProperty.get());
        cbGroupByID.selectedProperty().bindBidirectional((Property)this.groupByIDProperty);
        CheckBox cbUseSelected = new CheckBox("Use selection only");
        cbUseSelected.selectedProperty().bindBidirectional((Property)this.useSelectedProperty);
        CheckBox cbSkipMissing = new CheckBox("Hide missing cores");
        cbSkipMissing.selectedProperty().bindBidirectional((Property)this.skipMissingCoresProperty);
        this.skipMissingCoresProperty.addListener((v, o, n) -> {
            this.table.refresh();
            this.updateSurvivalCurves();
            if (this.histogramDisplay != null) {
                this.histogramDisplay.refreshHistogram();
            }
            this.updateSurvivalCurves();
            if (this.scatterPane != null) {
                this.scatterPane.updateChart();
            }
        });
        toolbar.getItems().addAll((Object[])new Node[]{labelMeasurementMethod, this.comboMeasurementMethod, new Separator(Orientation.VERTICAL), cbHidePane, new Separator(Orientation.VERTICAL), cbGroupByID, new Separator(Orientation.VERTICAL), cbUseSelected, new Separator(Orientation.VERTICAL), cbSkipMissing});
        this.comboMeasurementMethod.getItems().addAll((Object[])TMAEntries.MeasurementCombinationMethod.values());
        this.comboMeasurementMethod.getSelectionModel().select((Object)TMAEntries.MeasurementCombinationMethod.MEDIAN);
        this.selectedMeasurementCombinationProperty.addListener((v, o, n) -> this.table.refresh());
        ContextMenu popup = new ContextMenu();
        MenuItem miSetMissing = new MenuItem("Set missing");
        miSetMissing.setOnAction(e -> this.setSelectedMissingStatus(true));
        MenuItem miSetAvailable = new MenuItem("Set available");
        miSetAvailable.setOnAction(e -> this.setSelectedMissingStatus(false));
        MenuItem miExpand = new MenuItem("Expand all");
        miExpand.setOnAction(e -> {
            if (this.table.getRoot() == null) {
                return;
            }
            for (TreeItem item : this.table.getRoot().getChildren()) {
                item.setExpanded(true);
            }
        });
        MenuItem miCollapse = new MenuItem("Collapse all");
        miCollapse.setOnAction(e -> {
            if (this.table.getRoot() == null) {
                return;
            }
            for (TreeItem item : this.table.getRoot().getChildren()) {
                item.setExpanded(false);
            }
        });
        popup.getItems().addAll((Object[])new MenuItem[]{miSetMissing, miSetAvailable, new SeparatorMenuItem(), miExpand, miCollapse});
        this.table.setContextMenu(popup);
        this.table.setRowFactory(e -> {
            TreeTableRow row = new TreeTableRow();
            row.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (row.isSelected()) {
                    return "";
                }
                TMAEntries.TMAEntry entry = (TMAEntries.TMAEntry)row.getItem();
                if (entry == null || entry instanceof TMASummaryEntry) {
                    return "";
                }
                if (entry.isMissing()) {
                    String style = "-fx-background-color: derive(-fx-control-inner-background, -4%); -fx-text-fill: ladder(-fx-control-inner-background, derive(-fx-text-inner-color,-50%) 49%, derive(-fx-text-inner-color,50%) 50%);";
                    return style;
                }
                return "";
            }, (Observable[])new Observable[]{row.itemProperty(), row.selectedProperty()}));
            return row;
        });
        BorderPane paneTable = new BorderPane();
        paneTable.setTop((Node)toolbar);
        paneTable.setCenter(this.table);
        MasterDetailPane mdTablePane = new MasterDetailPane(Side.RIGHT, (Node)paneTable, (Node)this.createSidePane(), true);
        mdTablePane.showDetailNodeProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.hidePaneProperty.get() && !this.entriesBase.isEmpty(), (Observable[])new Observable[]{this.hidePaneProperty, this.entriesBase}));
        mdTablePane.setDividerPosition(0.6666666666666666);
        pane.setCenter((Node)mdTablePane);
        this.model.getItems().addListener((ListChangeListener)new ListChangeListener<TMAEntries.TMAEntry>(){

            public void onChanged(ListChangeListener.Change<? extends TMAEntries.TMAEntry> c) {
                if (TMASummaryViewer.this.histogramDisplay != null) {
                    TMASummaryViewer.this.histogramDisplay.refreshHistogram();
                }
                TMASummaryViewer.this.updateSurvivalCurves();
                if (TMASummaryViewer.this.scatterPane != null) {
                    TMASummaryViewer.this.scatterPane.updateChart();
                }
            }
        });
        Label labelPredicate = new Label();
        labelPredicate.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        labelPredicate.setAlignment(Pos.CENTER);
        labelPredicate.setStyle("-fx-background-color: rgba(120, 20, 20, 0.15);");
        labelPredicate.textProperty().addListener((v, o, n) -> {
            if (n.trim().length() > 0) {
                pane.setBottom((Node)labelPredicate);
            } else {
                pane.setBottom(null);
            }
        });
        labelPredicate.setMaxWidth(Double.MAX_VALUE);
        labelPredicate.setMaxHeight(labelPredicate.getPrefHeight());
        labelPredicate.setTextAlignment(TextAlignment.CENTER);
        this.predicateMeasurements.addListener((v, o, n) -> {
            if (n == null) {
                labelPredicate.setText("");
            } else if (n instanceof TablePredicate) {
                TablePredicate tp = (TablePredicate)n;
                if (tp.getOriginalCommand().trim().isEmpty()) {
                    labelPredicate.setText("");
                } else {
                    labelPredicate.setText("Predicate: " + tp.getOriginalCommand());
                }
            } else {
                labelPredicate.setText("Predicate: " + n.toString());
            }
        });
        boolean showWarning = true;
        if (showWarning) {
            BorderPane paneWithWarning = new BorderPane((Node)pane);
            Text warning = TMASummaryViewer.createText("Warning! ", true);
            Text message = TMASummaryViewer.createText("The TMA data viewer is not actively maintained - please use cautiously and report any bugs with 'Help > Report bug'", false);
            TextFlow textflow = new TextFlow(new Node[]{warning, message});
            textflow.setTextAlignment(TextAlignment.CENTER);
            textflow.setStyle("-fx-background-color: rgba(150, 0, 0, 0.25);");
            textflow.setMaxWidth(Double.MAX_VALUE);
            textflow.setPadding(new Insets(10.0));
            Tooltip.install((Node)textflow, (Tooltip)new Tooltip("The TMA data viewer isn't often used and isn't actively maintained, which means there is a higher risk of unreported bugs.\nYou can double-click this warning to make it disappear."));
            paneWithWarning.setBottom((Node)textflow);
            textflow.setOnMouseClicked(e -> {
                if (e.getClickCount() == 2) {
                    logger.warn("Hiding warning, but it remains the case that the TMA viewer isn't maintained - use it cautiously!");
                    textflow.setVisible(false);
                    paneWithWarning.setBottom(null);
                }
            });
            this.scene = new Scene((Parent)paneWithWarning);
        } else {
            this.scene = new Scene((Parent)pane);
        }
        this.scene.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            KeyCode code = e.getCode();
            if ((code == KeyCode.SPACE || code == KeyCode.ENTER) && this.entrySelected != null) {
                this.promptForComment();
                return;
            }
        });
    }

    private void setSelectedMissingStatus(boolean status) {
        for (TreeItem item : this.table.getSelectionModel().getSelectedItems()) {
            ((TMAEntries.TMAEntry)item.getValue()).setMissing(status);
        }
        if (this.skipMissingCoresProperty.get()) {
            this.table.getSelectionModel().clearSelection();
            this.refreshTableData();
        } else {
            this.table.refresh();
        }
    }

    private void handleTableContentChange() {
        this.table.refresh();
        this.model.refreshList();
        this.histogramDisplay.refreshHistogram();
        this.updateSurvivalCurves();
        this.scatterPane.updateChart();
        this.table.sort();
    }

    public Stage getStage() {
        return this.stage;
    }

    static String getRequestedSurvivalCensoredColumn(String survivalColumn) {
        if ("Overall survival".equals(survivalColumn)) {
            return "OS censored";
        }
        if ("Recurrence-free survival".equals(survivalColumn)) {
            return "RFS censored";
        }
        return null;
    }

    private String getSurvivalColumn() {
        return (String)this.comboSurvival.getSelectionModel().getSelectedItem();
    }

    private void updateSurvivalCurves() {
        String colID = null;
        String colScore = null;
        this.colCensored = null;
        for (String nameOrig : this.model.getAllNames()) {
            if (nameOrig.equals("Case ID")) {
                colID = nameOrig;
                continue;
            }
            if (nameOrig.trim().length() == 0 || !this.model.getMeasurementNames().contains(nameOrig)) continue;
            String name = nameOrig.toLowerCase();
            if (name.equals("h-score")) {
                colScore = nameOrig;
                continue;
            }
            if (!name.equals("positive %") || colScore != null) continue;
            colScore = nameOrig;
        }
        String colCensoredRequested = null;
        String colSurvival = this.getSurvivalColumn();
        if (colSurvival != null) {
            colCensoredRequested = TMASummaryViewer.getRequestedSurvivalCensoredColumn(colSurvival);
            if (this.model.getAllNames().contains(colCensoredRequested)) {
                this.colCensored = colCensoredRequested;
            } else if (this.model.getAllNames().contains("Censored")) {
                logger.warn("Correct censored column for \"{}\" unavailable - should be \"{}\", but using \"Censored\" column instead", (Object)colSurvival, (Object)colCensoredRequested);
                this.colCensored = "Censored";
            }
        }
        if (this.colCensored == null && colSurvival != null) {
            logger.warn("Unable to find censored column - survival data will be uncensored");
        } else {
            logger.info("Survival column: {}, Censored column: {}", (Object)colSurvival, (Object)this.colCensored);
        }
        colScore = (String)this.comboMainMeasurement.getSelectionModel().getSelectedItem();
        if (colID == null || colSurvival == null || this.colCensored == null) {
            if (!this.model.getItems().isEmpty()) {
                logger.warn("No survival data found!");
            } else {
                logger.trace("No entries or survival data available");
            }
            return;
        }
        Map<String, List<TMAEntries.TMAEntry>> scoreMap = this.createScoresMap((List<TMAEntries.TMAEntry>)this.model.getItems(), colScore, colID);
        ArrayList<TMACoreObject> cores = new ArrayList<TMACoreObject>(scoreMap.size());
        double[] scores = new double[15];
        for (Map.Entry<String, List<TMAEntries.TMAEntry>> entry : scoreMap.entrySet()) {
            TMACoreObject core = new TMACoreObject();
            core.setName("ID: " + entry.getKey());
            MeasurementList ml = core.getMeasurementList();
            Arrays.fill(scores, Double.POSITIVE_INFINITY);
            List<TMAEntries.TMAEntry> list = entry.getValue();
            if (list.size() > scores.length) {
                scores = new double[list.size()];
            }
            for (int i = 0; i < list.size(); ++i) {
                scores[i] = this.model.getNumericValue(list.get(i), colScore);
            }
            Arrays.sort(scores);
            int n = list.size();
            double score = n % 2 == 1 ? scores[n / 2] : (scores[n / 2 - 1] + scores[n / 2]) / 2.0;
            core.putMetadataValue("Case ID", entry.getKey());
            ml.put(colSurvival, list.get(0).getMeasurementAsDouble(colSurvival));
            ml.put(colCensoredRequested, list.get(0).getMeasurementAsDouble(this.colCensored));
            if (colScore != null) {
                ml.put(colScore, score);
            }
            cores.add(core);
        }
        TMAGrid grid = DefaultTMAGrid.create(cores, (int)1);
        PathObjectHierarchy hierarchy = new PathObjectHierarchy();
        hierarchy.setTMAGrid(grid);
        this.kmDisplay.setHierarchy(hierarchy, colSurvival, colCensoredRequested);
        this.kmDisplay.setScoreColumn((String)this.comboMainMeasurement.getSelectionModel().getSelectedItem());
    }

    private Pane createSidePane() {
        BorderPane pane = new BorderPane();
        TabPane tabPane = new TabPane();
        this.kmDisplay = new KaplanMeierDisplay(null, null, null, null);
        BorderPane paneKaplanMeier = new BorderPane();
        paneKaplanMeier.setCenter((Node)this.kmDisplay.getView());
        paneKaplanMeier.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.comboMainMeasurement.setMaxWidth(Double.MAX_VALUE);
        this.comboMainMeasurement.setTooltip(new Tooltip("Measurement thresholded to create survival curves etc."));
        GridPane kmTop = new GridPane();
        kmTop.add((Node)new Label("Score"), 0, 0);
        kmTop.add(this.comboMainMeasurement, 1, 0);
        kmTop.add((Node)new Label("Survival type"), 0, 1);
        kmTop.add(this.comboSurvival, 1, 1);
        this.comboSurvival.setTooltip(new Tooltip("Specify overall or recurrence-free survival (if applicable)"));
        this.comboSurvival.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow(this.comboMainMeasurement, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.comboSurvival, (Priority)Priority.ALWAYS);
        kmTop.setHgap(5.0);
        paneKaplanMeier.setTop((Node)kmTop);
        this.histogramDisplay = new HistogramDisplay(this.model, false);
        this.comboMainMeasurement.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            this.histogramDisplay.refreshCombo();
            this.histogramDisplay.showHistogram((String)n);
            this.updateSurvivalCurves();
        });
        this.comboMeasurementMethod.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            this.histogramDisplay.refreshHistogram();
            this.scatterPane.updateChart();
            this.updateSurvivalCurves();
        });
        this.comboSurvival.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateSurvivalCurves());
        BorderPane paneImages = new BorderPane();
        CheckBox cbShowOverlay = new CheckBox("Show overlay");
        imageAvailability.addListener((c, v, n) -> {
            if (n == ImageAvailability.OVERLAY_ONLY) {
                cbShowOverlay.setSelected(true);
            } else if (n == ImageAvailability.IMAGE_ONLY) {
                cbShowOverlay.setSelected(false);
            }
            cbShowOverlay.setDisable(n != ImageAvailability.BOTH);
        });
        ListView listImages = new ListView();
        listImages.setCellFactory(v -> new ImageListCell((ObservableValue<Boolean>)cbShowOverlay.selectedProperty(), this.imageCache));
        listImages.widthProperty().addListener((v, o, n) -> listImages.refresh());
        listImages.setStyle("-fx-control-inner-background-alt: -fx-control-inner-background ;");
        this.table.getSelectionModel().getSelectedItems().addListener(e -> {
            ArrayList<TMAEntries.TMAEntry> entries = new ArrayList<TMAEntries.TMAEntry>();
            for (TreeItem item : e.getList()) {
                if (item.getChildren().isEmpty()) {
                    if (((TMAEntries.TMAEntry)item.getValue()).hasImage() || ((TMAEntries.TMAEntry)item.getValue()).hasOverlay()) {
                        entries.add((TMAEntries.TMAEntry)item.getValue());
                    }
                } else {
                    for (TreeItem item2 : item.getChildren()) {
                        if (!((TMAEntries.TMAEntry)item2.getValue()).hasImage() && !((TMAEntries.TMAEntry)item2.getValue()).hasOverlay()) continue;
                        entries.add((TMAEntries.TMAEntry)item2.getValue());
                    }
                }
                listImages.getItems().setAll(entries);
            }
        });
        cbShowOverlay.setAlignment(Pos.CENTER);
        cbShowOverlay.setMaxWidth(Double.MAX_VALUE);
        cbShowOverlay.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        cbShowOverlay.selectedProperty().addListener((v, o, n) -> listImages.refresh());
        paneImages.setCenter((Node)listImages);
        paneImages.setTop((Node)cbShowOverlay);
        ScrollPane scrollPane = new ScrollPane((Node)paneKaplanMeier);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Tab tabSurvival = new Tab("Survival", (Node)scrollPane);
        tabPane.getTabs().addAll((Object[])new Tab[]{new Tab("Table", (Node)this.getCustomizeTablePane()), new Tab("Histogram", (Node)this.histogramDisplay.getPane()), new Tab("Scatterplot", (Node)this.scatterPane.getPane()), tabSurvival});
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        pane.setCenter((Node)tabPane);
        pane.setMinWidth(350.0);
        return pane;
    }

    private Pane getCustomizeTablePane() {
        TableView tableColumns = new TableView();
        tableColumns.setPlaceholder((Node)TMASummaryViewer.createText("No columns available", false));
        tableColumns.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        tableColumns.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        SortedList sortedColumns = new SortedList((ObservableList)this.table.getColumns().filtered(p -> !p.getText().trim().isEmpty()));
        sortedColumns.setComparator((c1, c2) -> c1.getText().compareTo(c2.getText()));
        tableColumns.setItems((ObservableList)sortedColumns);
        sortedColumns.comparatorProperty().bind((ObservableValue)tableColumns.comparatorProperty());
        TableColumn columnName = new TableColumn("Column");
        columnName.setCellValueFactory(v -> ((TreeTableColumn)v.getValue()).textProperty());
        TableColumn columnVisible = new TableColumn("Visible");
        columnVisible.setCellValueFactory(v -> ((TreeTableColumn)v.getValue()).visibleProperty());
        tableColumns.setEditable(true);
        columnVisible.setCellFactory(v -> new CheckBoxTableCell());
        tableColumns.getColumns().add((Object)columnName);
        tableColumns.getColumns().add((Object)columnVisible);
        ContextMenu contextMenu = new ContextMenu();
        Action actionShowSelected = new Action("Show selected", e -> {
            for (TreeTableColumn col : tableColumns.getSelectionModel().getSelectedItems()) {
                if (col != null) {
                    col.setVisible(true);
                    continue;
                }
                logger.trace("Selected column is null!");
            }
        });
        Action actionHideSelected = new Action("Hide selected", e -> {
            for (TreeTableColumn col : tableColumns.getSelectionModel().getSelectedItems()) {
                if (col != null) {
                    col.setVisible(false);
                    continue;
                }
                logger.trace("Selected column is null!");
            }
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{ActionUtils.createMenuItem((Action)actionShowSelected), ActionUtils.createMenuItem((Action)actionHideSelected)});
        tableColumns.setContextMenu(contextMenu);
        tableColumns.setTooltip(new Tooltip("Show or hide table columns - right-click to change multiple columns at once"));
        BorderPane paneColumns = new BorderPane((Node)tableColumns);
        paneColumns.setBottom((Node)GridPaneUtils.createColumnGridControls((Node[])new Node[]{ActionUtils.createButton((Action)actionShowSelected), ActionUtils.createButton((Action)actionHideSelected)}));
        VBox paneRows = new VBox();
        ComboBox comboMetadata = new ComboBox();
        comboMetadata.setItems(this.metadataNames);
        comboMetadata.getSelectionModel().getSelectedItem();
        comboMetadata.setPromptText("Select column");
        TextField tfFilter = new TextField();
        CheckBox cbExact = new CheckBox("Exact");
        cbExact.selectedProperty().addListener((v, o, n) -> this.setMetadataTextPredicate((String)comboMetadata.getSelectionModel().getSelectedItem(), tfFilter.getText(), cbExact.isSelected(), !cbExact.isSelected()));
        tfFilter.textProperty().addListener((v, o, n) -> this.setMetadataTextPredicate((String)comboMetadata.getSelectionModel().getSelectedItem(), tfFilter.getText(), cbExact.isSelected(), !cbExact.isSelected()));
        comboMetadata.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.setMetadataTextPredicate((String)comboMetadata.getSelectionModel().getSelectedItem(), tfFilter.getText(), cbExact.isSelected(), !cbExact.isSelected()));
        GridPane paneMetadata = new GridPane();
        paneMetadata.add((Node)comboMetadata, 0, 0);
        paneMetadata.add((Node)tfFilter, 1, 0);
        paneMetadata.add((Node)cbExact, 2, 0);
        paneMetadata.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        paneMetadata.setVgap(2.0);
        paneMetadata.setHgap(5.0);
        comboMetadata.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)tfFilter, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)comboMetadata, (Boolean)Boolean.TRUE);
        GridPane.setFillWidth((Node)tfFilter, (Boolean)Boolean.TRUE);
        TitledPane tpMetadata = new TitledPane("Metadata filter", (Node)paneMetadata);
        tpMetadata.setExpanded(false);
        Tooltip tooltipMetadata = new Tooltip("Enter text to filter entries according to a selected metadata column");
        Tooltip.install((Node)paneMetadata, (Tooltip)tooltipMetadata);
        tpMetadata.setTooltip(tooltipMetadata);
        paneRows.getChildren().add((Object)tpMetadata);
        TextField tfCommand = new TextField();
        tfCommand.setTooltip(new Tooltip("Predicate used to filter entries for inclusion"));
        TextFields.bindAutoCompletion((TextField)tfCommand, e -> {
            int ind = tfCommand.getText().lastIndexOf("\"");
            if (ind < 0) {
                return Collections.emptyList();
            }
            String part = tfCommand.getText().substring(ind + 1);
            return this.measurementNames.stream().filter(n -> n.startsWith(part)).map(n -> "\"" + n + "\" ").toList();
        });
        String instructions = "Enter a predicate to filter entries.\nOnly entries passing the test will be included in any results.\nExamples of predicates include:\n    \"Num Tumor\" > 200\n    \"Num Tumor\" > 100 && \"Num Stroma\" < 1000";
        BorderPane paneMeasurementFilter = new BorderPane((Node)tfCommand);
        Label label = new Label("Predicate: ");
        label.setAlignment(Pos.CENTER);
        label.setMaxHeight(Double.MAX_VALUE);
        paneMeasurementFilter.setLeft((Node)label);
        Button btnApply = new Button("Apply");
        btnApply.setOnAction(e -> {
            TablePredicate predicateNew = new TablePredicate(tfCommand.getText());
            if (predicateNew.isValid()) {
                this.predicateMeasurements.set((Object)predicateNew);
            } else {
                Dialogs.showErrorMessage((String)"Invalid predicate", (String)("Current predicate '" + tfCommand.getText() + "' is invalid!"));
            }
            e.consume();
        });
        TitledPane tpMeasurementFilter = new TitledPane("Measurement filter", (Node)paneMeasurementFilter);
        tpMeasurementFilter.setExpanded(false);
        Tooltip tooltipInstructions = new Tooltip(instructions);
        tpMeasurementFilter.setTooltip(tooltipInstructions);
        Tooltip.install((Node)paneMeasurementFilter, (Tooltip)tooltipInstructions);
        paneMeasurementFilter.setRight((Node)btnApply);
        paneRows.getChildren().add((Object)tpMeasurementFilter);
        logger.info("Predicate set to: {}", this.predicateMeasurements.get());
        VBox pane = new VBox();
        pane.getChildren().addAll((Object[])new Node[]{paneColumns, new Separator(), paneRows});
        VBox.setVgrow((Node)paneColumns, (Priority)Priority.ALWAYS);
        return pane;
    }

    private void setMetadataTextPredicate(String metadataName, String filterText, boolean exact, boolean ignoreCase) {
        if (metadataName == null || filterText == null || metadataName.trim().isEmpty() || filterText.trim().isEmpty()) {
            this.predicateMetadataFilter.set(null);
        } else if (ignoreCase) {
            String filterTextLower = filterText.toLowerCase();
            if (exact) {
                this.predicateMetadataFilter.set(t -> t.getMetadataValue(metadataName) != null && t.getMetadataValue(metadataName).toLowerCase().equals(filterTextLower));
            } else {
                this.predicateMetadataFilter.set(t -> t.getMetadataValue(metadataName) != null && t.getMetadataValue(metadataName).toLowerCase().contains(filterTextLower));
            }
        } else if (exact) {
            this.predicateMetadataFilter.set(t -> t.getMetadataValue(metadataName) != null && t.getMetadataValue(metadataName).equals(filterText));
        } else {
            this.predicateMetadataFilter.set(t -> t.getMetadataValue(metadataName) != null && t.getMetadataValue(metadataName).contains(filterText));
        }
    }

    private Map<String, List<TMAEntries.TMAEntry>> createScoresMap(List<TMAEntries.TMAEntry> entries, String colScore, String colID) {
        HashMap<String, List<TMAEntries.TMAEntry>> scoreMap = new HashMap<String, List<TMAEntries.TMAEntry>>();
        for (TMAEntries.TMAEntry entry : entries) {
            Double score = this.model.getNumericValue(entry, colScore);
            String id = entry.getMetadataValue(colID);
            if (id == null && entry.getMeasurement(colID) != null) {
                id = Double.toString(entry.getMeasurement(colID).doubleValue());
            }
            if (id == null || score == null || Double.isNaN(score)) continue;
            ArrayList<TMAEntries.TMAEntry> list = (ArrayList<TMAEntries.TMAEntry>)scoreMap.get(id);
            if (list == null) {
                list = new ArrayList<TMAEntries.TMAEntry>();
                scoreMap.put(id, list);
            }
            list.add(entry);
        }
        return scoreMap;
    }

    private void setTMAEntriesFromOpenImage() {
        QuPathGUI qupath = QuPathGUI.getInstance();
        if (qupath == null || qupath.getImageData() == null || qupath.getImageData().getHierarchy().getTMAGrid() == null) {
            Dialogs.showErrorMessage((String)"Show TMA summary", (String)"No TMA data available!");
            return;
        }
        ImageData<BufferedImage> imageData = qupath.getImageData();
        this.setTMAEntriesFromImageData(imageData);
    }

    private void setTMAEntriesFromOpenProject() {
        QuPathGUI qupath = QuPathGUI.getInstance();
        if (qupath == null || qupath.getProject() == null || qupath.getProject().getImageList().isEmpty()) {
            GuiTools.showNoProjectError("Show TMA summary");
            return;
        }
        Project<BufferedImage> project = qupath.getProject();
        ArrayList<TMAEntries.TMAEntry> entries = new ArrayList<TMAEntries.TMAEntry>();
        for (ProjectImageEntry imageEntry : project.getImageList()) {
            if (!imageEntry.hasImageData()) continue;
            try {
                ImageData imageData = imageEntry.readImageData();
                entries.addAll(TMASummaryViewer.getEntriesForTMAData((ImageData<BufferedImage>)imageData));
            }
            catch (IOException e) {
                logger.error("Unable to read ImageData for {} ({})", (Object)imageEntry.getImageName(), (Object)e.getLocalizedMessage());
            }
        }
        this.setTMAEntries(entries);
        this.stage.setTitle("TMA Viewer: " + project.getName());
    }

    private static List<TMAEntries.TMAEntry> getEntriesForTMAData(ImageData<BufferedImage> imageData) {
        ArrayList<TMAEntries.TMAEntry> entriesNew = new ArrayList<TMAEntries.TMAEntry>();
        if (imageData.getHierarchy().getTMAGrid() == null) {
            return entriesNew;
        }
        ObservableMeasurementTableData data = new ObservableMeasurementTableData();
        data.setImageData(imageData, imageData.getHierarchy().getTMAGrid().getTMACoreList());
        for (TMACoreObject core : imageData.getHierarchy().getTMAGrid().getTMACoreList()) {
            entriesNew.add(TMAEntries.createTMAObjectEntry(imageData, data, core));
        }
        return entriesNew;
    }

    public void setTMAEntriesFromImageData(ImageData<BufferedImage> imageData) {
        if (this.imageData != null) {
            this.imageData.getHierarchy().removeListener(this.hierarchyListener);
        }
        if (imageData != null) {
            this.imageData = imageData;
            this.imageData.getHierarchy().addListener(this.hierarchyListener);
            this.setTMAEntries(TMASummaryViewer.getEntriesForTMAData(imageData));
            this.stage.setTitle("TMA Viewer: " + ServerTools.getDisplayableImageName((ImageServer)imageData.getServer()));
        }
    }

    public void setInputFile(File file) {
        if (file == null) {
            return;
        }
        if (file.getName().toLowerCase().endsWith(PathPrefs.getSerializationExtension())) {
            try {
                ImageData imageData = PathIO.readImageData((File)file);
                this.setTMAEntriesFromImageData((ImageData<BufferedImage>)imageData);
            }
            catch (IOException e) {
                logger.error("Error reading image data", (Throwable)e);
            }
            return;
        }
        ArrayList<TMAEntries.TMAEntry> entriesTemp = new ArrayList<TMAEntries.TMAEntry>();
        File dir = file.isDirectory() ? file : file.getParentFile();
        for (File fileInput : dir.listFiles()) {
            if (fileInput.isHidden() || fileInput.isDirectory() || !fileInput.getName().toLowerCase().endsWith(".qptma")) continue;
            this.parseInputFile(fileInput, entriesTemp);
        }
        if (entriesTemp.isEmpty()) {
            logger.error("No data found for " + file.getAbsolutePath());
            return;
        }
        this.setTMAEntries(entriesTemp);
        this.stage.setTitle("TMA Results View: " + dir.getName());
    }

    void setTMAEntries(Collection<TMAEntries.TMAEntry> newEntries) {
        if (!newEntries.equals(this.entriesBase)) {
            this.useSelectedProperty.set(false);
            this.imageCache.clear();
            ArrayList<TMAEntries.TMAEntry> duplicateEntries = new ArrayList<TMAEntries.TMAEntry>(newEntries);
            ExecutorService service = Executors.newSingleThreadExecutor();
            service.submit(() -> duplicateEntries.parallelStream().forEach(entry -> {
                this.imageCache.getImage((TMAEntries.TMAEntry)entry, this.maxSmallWidth.get());
                this.imageCache.getOverlay((TMAEntries.TMAEntry)entry, this.maxSmallWidth.get());
            }));
            service.shutdown();
        }
        this.entriesBase.setAll(newEntries);
        this.lastHiddenColumns = this.table.getColumns().stream().filter(c -> !c.isVisible()).map(c -> c.getText()).collect(Collectors.toSet());
        LinkedHashSet<String> namesMeasurements = new LinkedHashSet<String>();
        LinkedHashSet<String> namesMetadata = new LinkedHashSet<String>();
        for (TMAEntries.TMAEntry entry : newEntries) {
            namesMeasurements.addAll(entry.getMeasurementNames());
            namesMetadata.addAll(entry.getMetadataNames());
        }
        String currentSurvival = this.getSurvivalColumn();
        this.survivalColumns.clear();
        if (namesMeasurements.contains("Overall survival")) {
            this.survivalColumns.add((Object)"Overall survival");
        }
        if (namesMeasurements.contains("Recurrence-free survival")) {
            this.survivalColumns.add((Object)"Recurrence-free survival");
        }
        if (currentSurvival != null && this.survivalColumns.contains((Object)currentSurvival)) {
            this.comboSurvival.getSelectionModel().select((Object)currentSurvival);
        } else if (!this.survivalColumns.isEmpty()) {
            this.comboSurvival.getSelectionModel().select((Object)((String)this.survivalColumns.get(0)));
        }
        namesMeasurements.add("Available cores");
        namesMeasurements.remove(null);
        namesMeasurements.remove("");
        String selectedMainMeasurement = (String)this.comboMainMeasurement.getSelectionModel().getSelectedItem();
        this.measurementNames.setAll(namesMeasurements);
        if (namesMeasurements.contains(selectedMainMeasurement)) {
            this.comboMainMeasurement.getSelectionModel().select((Object)selectedMainMeasurement);
        } else {
            namesMeasurements.remove("Case ID");
            namesMeasurements.remove("Overall survival");
            namesMeasurements.remove("Recurrence-free survival");
            namesMeasurements.remove("OS censored");
            namesMeasurements.remove("RFS censored");
            namesMeasurements.remove("Censored");
            if (!namesMeasurements.isEmpty()) {
                this.comboMainMeasurement.getSelectionModel().select(0);
            }
        }
        this.metadataNames.clear();
        this.metadataNames.addAll(namesMetadata);
        this.refreshTableData();
        this.table.setPlaceholder((Node)TMASummaryViewer.createText("No data", false));
    }

    private static Text createText(String contents, boolean makeBold) {
        Text text = new Text(contents);
        if (makeBold) {
            text.setStyle("-fx-fill: -fx-text-base-color;");
        } else {
            text.setStyle("-fx-fill: -fx-text-base-color;");
        }
        return text;
    }

    private void refreshTable() {
        if (this.table != null) {
            this.table.refresh();
        }
    }

    private void handleHierarchyChange(PathObjectHierarchyEvent event) {
        if (this.table != null && !event.isChanging()) {
            this.table.refresh();
        }
    }

    private void refreshTableData() {
        ObservableList<TMAEntries.TMAEntry> entries = this.groupByIDProperty.get() ? this.createSummaryEntries((List<? extends TMAEntries.TMAEntry>)this.entriesBase) : this.entriesBase;
        ArrayList<Object> columns = new ArrayList<Object>();
        TreeTableColumn columnEmpty = new TreeTableColumn("  ");
        columnEmpty.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, String> p) {
                return Bindings.createStringBinding(() -> "", (Observable[])new Observable[0]);
            }
        });
        columnEmpty.setSortable(false);
        columnEmpty.setResizable(false);
        columns.add(columnEmpty);
        boolean hasImages = entries.stream().anyMatch(e -> e.hasImage());
        boolean hasOverlay = entries.stream().anyMatch(e -> e.hasOverlay());
        if (hasImages || hasOverlay) {
            TreeTableColumn columnOverlay;
            TreeTableColumn columnImage = hasImages ? new TreeTableColumn("Thumbnail") : null;
            TreeTableColumn treeTableColumn = columnOverlay = hasOverlay ? new TreeTableColumn("Overlay") : null;
            if (hasImages) {
                columnImage.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, TMAEntries.TMAEntry>, ObservableValue<TMAEntries.TMAEntry>>(this){

                    public ObservableValue<TMAEntries.TMAEntry> call(TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, TMAEntries.TMAEntry> p) {
                        return p.getValue().valueProperty();
                    }
                });
                columnImage.setCellFactory(c -> new ImageTableCell(this.imageCache, false));
                columnImage.maxWidthProperty().bind((ObservableValue)this.maxSmallWidth);
                columnImage.widthProperty().addListener((v, o, n) -> {
                    if (n.doubleValue() == columnImage.getPrefWidth()) {
                        return;
                    }
                    if (hasOverlay) {
                        columnOverlay.setPrefWidth(n.doubleValue());
                    }
                    this.table.refresh();
                });
                columns.add(columnImage);
            }
            if (hasOverlay) {
                columnOverlay.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, TMAEntries.TMAEntry>, ObservableValue<TMAEntries.TMAEntry>>(this){

                    public ObservableValue<TMAEntries.TMAEntry> call(TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, TMAEntries.TMAEntry> p) {
                        return p.getValue().valueProperty();
                    }
                });
                columnOverlay.setCellFactory(c -> new ImageTableCell(this.imageCache, true));
                columnOverlay.maxWidthProperty().bind((ObservableValue)this.maxSmallWidth);
                columnOverlay.widthProperty().addListener((v, o, n) -> {
                    if (n.doubleValue() == columnOverlay.getPrefWidth()) {
                        return;
                    }
                    if (hasImages) {
                        columnImage.setPrefWidth(n.doubleValue());
                    }
                    this.table.refresh();
                });
                columns.add(columnOverlay);
            }
        }
        if (hasImages) {
            if (hasOverlay) {
                imageAvailability.set((Object)ImageAvailability.BOTH);
            } else {
                imageAvailability.set((Object)ImageAvailability.IMAGE_ONLY);
            }
        } else if (hasOverlay) {
            imageAvailability.set((Object)ImageAvailability.OVERLAY_ONLY);
        } else {
            imageAvailability.set((Object)ImageAvailability.NONE);
        }
        for (final String name : this.model.getAllNames()) {
            TreeTableColumn column;
            if (this.model.getMeasurementNames().contains(name)) {
                column = new TreeTableColumn(name);
                column.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, Number>, ObservableValue<Number>>(){

                    public ObservableValue<Number> call(TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, Number> p) {
                        double value = p.getValue() == null ? Double.NaN : TMASummaryViewer.this.model.getNumericValue((TMAEntries.TMAEntry)p.getValue().getValue(), name);
                        return new SimpleDoubleProperty(value);
                    }
                });
                column.setCellFactory(c -> new NumericTreeTableCell());
                columns.add(column);
                continue;
            }
            column = new TreeTableColumn(name);
            column.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, Object>, ObservableValue<Object>>(){

                public ObservableValue<Object> call(TreeTableColumn.CellDataFeatures<TMAEntries.TMAEntry, Object> p) {
                    return new SimpleObjectProperty(p.getValue() == null ? null : TMASummaryViewer.this.model.getStringValue((TMAEntries.TMAEntry)p.getValue().getValue(), name));
                }
            });
            column.setCellFactory(c -> new CenteredTreeTableCell());
            columns.add(column);
        }
        columns.stream().forEach(c -> c.setVisible(!this.lastHiddenColumns.contains(c.getText())));
        this.table.getColumns().setAll(columns);
        RootTreeItem root = new RootTreeItem((Collection<? extends TMAEntries.TMAEntry>)entries, this.combinedPredicate);
        this.table.setShowRoot(false);
        this.table.setRoot((TreeItem)root);
        this.model.refreshList();
    }

    private Collection<? extends TMAEntries.TMAEntry> createSummaryEntries(List<? extends TMAEntries.TMAEntry> entries) {
        TreeMap<String, TMASummaryEntry> summaryEntryMap = new TreeMap<String, TMASummaryEntry>();
        int maxSummaryLength = 0;
        for (TMAEntries.TMAEntry tMAEntry : entries) {
            String id = tMAEntry.getMetadataValue("Case ID");
            if (id == null && tMAEntry.getMeasurement("Case ID") != null) {
                id = tMAEntry.getMeasurement("Case ID").toString();
            }
            if (id == null || id.trim().length() == 0) {
                if ("true".equalsIgnoreCase(tMAEntry.getMetadataValue(MISSING_COLUMN))) continue;
                logger.trace("No ID found for {}", (Object)tMAEntry);
                continue;
            }
            TMASummaryEntry summary = (TMASummaryEntry)summaryEntryMap.get(id);
            if (summary == null) {
                summary = new TMASummaryEntry((ObservableValue<TMAEntries.MeasurementCombinationMethod>)this.selectedMeasurementCombinationProperty, (ObservableBooleanValue)this.skipMissingCoresProperty, this.combinedPredicate);
                summaryEntryMap.put(id, summary);
            }
            summary.addEntry(tMAEntry);
            maxSummaryLength = Math.max(maxSummaryLength, summary.getEntries().size());
        }
        if (summaryEntryMap.isEmpty() || maxSummaryLength <= 1) {
            return entries;
        }
        return summaryEntryMap.values();
    }

    private void parseInputFile(File file, List<TMAEntries.TMAEntry> entries) {
        int nEntries = entries.size();
        String serverPath = null;
        try {
            Scanner scanner = new Scanner(file);
            serverPath = scanner.nextLine().trim();
            scanner.close();
        }
        catch (Exception e) {
            logger.error("Error parsing input file", (Throwable)e);
        }
        if (serverPath == null) {
            logger.error("Unable to find a server with path " + serverPath + " - cannot parse " + file.getAbsolutePath());
            return;
        }
        File dirData = new File(file.getAbsolutePath() + ".data");
        try {
            List nameColumn;
            File fileResults = this.getTMAResultsFile(dirData);
            if (fileResults == null) {
                logger.error("No results file found for {}", (Object)dirData.getAbsolutePath());
                return;
            }
            Map csvData = TMAScoreImporter.readCSV((File)fileResults);
            if (csvData.isEmpty()) {
                logger.warn("Results file empty: {}", (Object)fileResults.getAbsolutePath());
                return;
            }
            LinkedHashMap<String, List> metadataColumns = new LinkedHashMap<String, List>();
            LinkedHashMap<String, double[]> measurementColumns = new LinkedHashMap<String, double[]>();
            List idColumn = (List)csvData.remove("Case ID");
            if (idColumn != null) {
                metadataColumns.put("Case ID", idColumn);
                if (this.trimUniqueIDs) {
                    for (int i = 0; i < idColumn.size(); ++i) {
                        idColumn.set(i, idColumn.get(i) == null ? null : ((String)idColumn.get(i)).trim());
                    }
                }
            }
            if ((nameColumn = (List)csvData.remove("Name")) == null) {
                nameColumn = (List)csvData.remove("Object");
            }
            List missingColumn = (List)csvData.remove(MISSING_COLUMN);
            int n = idColumn == null ? 0 : idColumn.size();
            for (Map.Entry entry : csvData.entrySet()) {
                List list = (List)entry.getValue();
                n = list.size();
                double[] values = TMAScoreImporter.parseNumeric((List)list, (boolean)true);
                if (values == null || GeneralTools.numNaNs((double[])values) == list.size()) {
                    metadataColumns.put((String)entry.getKey(), list);
                    continue;
                }
                measurementColumns.put((String)entry.getKey(), values);
            }
            for (int i = 0; i < n; ++i) {
                if (idColumn != null && "NaN".equals(idColumn.get(i))) continue;
                String name = nameColumn == null ? (String)idColumn.get(i) : (String)nameColumn.get(i);
                boolean missing = missingColumn != null && "true".equalsIgnoreCase((String)missingColumn.get(i));
                File fileImage = new File(dirData, name + ".jpg");
                File fileOverlayImage = new File(dirData, name + "-overlay.jpg");
                if (!fileOverlayImage.exists()) {
                    fileOverlayImage = new File(dirData, name + "-overlay.png");
                }
                TMAEntries.TMAEntry entry = TMAEntries.createDefaultTMAEntry(serverPath, fileImage.getAbsolutePath(), fileOverlayImage.getAbsolutePath(), name, missing);
                for (Map.Entry temp : metadataColumns.entrySet()) {
                    entry.putMetadata((String)temp.getKey(), (String)((List)temp.getValue()).get(i));
                }
                for (Map.Entry temp : measurementColumns.entrySet()) {
                    entry.putMeasurement((String)temp.getKey(), ((double[])temp.getValue())[i]);
                }
                entries.add(entry);
            }
        }
        catch (Exception e) {
            logger.error("Error parsing input file " + String.valueOf(file), (Throwable)e);
        }
        logger.info("Parsed " + (entries.size() - nEntries) + " from " + file.getName() + " (" + entries.size() + " total)");
    }

    private File getTMAResultsFile(File dir) {
        for (File file : dir.listFiles()) {
            if (!file.getName().startsWith("TMA results") && !file.getName().startsWith("TMA_results") || !file.getName().endsWith(".txt")) continue;
            return file;
        }
        return null;
    }

    private void promptForComment() {
        String input = Dialogs.showInputDialog((String)"Add comment", (String)("Type comment for " + this.entrySelected.getName() + "(" + this.entrySelected.getImageName() + ")"), (String)this.entrySelected.getComment());
        if (input == null) {
            return;
        }
        this.entrySelected.setComment(input);
        this.table.refresh();
    }

    private TreeItem<TMAEntries.TMAEntry> getItem(TreeItem<TMAEntries.TMAEntry> item, TMAEntries.TMAEntry entry) {
        if (item == null) {
            return null;
        }
        if (item.getValue() == entry) {
            return item;
        }
        for (TreeItem item2 : item.getChildren()) {
            TreeItem<TMAEntries.TMAEntry> found = this.getItem((TreeItem<TMAEntries.TMAEntry>)item2, entry);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private int importScores(String text) {
        Map data = TMAScoreImporter.readCSV((String)text);
        List idColumn = (List)data.remove("Case ID");
        if (idColumn == null) {
            Dialogs.showErrorMessage((String)"Import TMA data", (String)"No 'Case ID' column found!");
            return 0;
        }
        if (data.isEmpty()) {
            return 0;
        }
        HashMap<String, double[]> dataNumeric = new HashMap<String, double[]>();
        for (String key : data.keySet().toArray(new String[0])) {
            double[] vals = TMAScoreImporter.parseNumeric((List)((List)data.get(key)), (boolean)true);
            if (vals == null || GeneralTools.numNaNs((double[])vals) == vals.length) continue;
            dataNumeric.put(key, vals);
            data.remove(key);
        }
        int counter = 0;
        for (int i = 0; i < idColumn.size(); ++i) {
            boolean matched = false;
            String id = (String)idColumn.get(i);
            if (id == null) {
                logger.debug("Skipping missing ID");
                continue;
            }
            for (TMAEntries.TMAEntry entry : this.entriesBase) {
                if (!id.equals(entry.getMetadataValue("Case ID"))) continue;
                matched = true;
                for (Map.Entry dataEntry : dataNumeric.entrySet()) {
                    entry.putMeasurement((String)dataEntry.getKey(), ((double[])dataEntry.getValue())[i]);
                }
                for (Map.Entry dataEntry : data.entrySet()) {
                    entry.putMetadata((String)dataEntry.getKey(), (String)((List)dataEntry.getValue()).get(i));
                }
                ++counter;
            }
            if (matched) continue;
            logger.warn("No match for ID: " + id);
        }
        Optional<TMAEntries.TMAEntry> objectEntry = this.entriesBase.stream().filter(t -> t instanceof TMAEntries.TMAObjectEntry).findAny();
        if (objectEntry.isPresent()) {
            Dialogs.showInfoNotification((String)"TMA data update", (String)"TMA cores updated!");
        }
        return counter;
    }

    class ScatterPane {
        private BorderPane pane = new BorderPane();
        private ComboBox<String> comboScatterMainMeasurement = new ComboBox();
        private ComboBox<String> comboScatterSecondaryMeasurement = new ComboBox();
        private NumberAxis xAxis = new NumberAxis();
        private NumberAxis yAxis = new NumberAxis();
        private ScatterChart<Number, Number> chart = new ScatterChart((Axis)this.xAxis, (Axis)this.yAxis);
        private TableView<DoubleProperty> tableScatter = new TableView();

        ScatterPane() {
            this.comboScatterMainMeasurement.setItems(TMASummaryViewer.this.measurementNames);
            this.comboScatterSecondaryMeasurement.setItems(TMASummaryViewer.this.measurementNames);
            TMASummaryViewer.this.comboMainMeasurement.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.comboScatterMainMeasurement.getSelectionModel().select(n));
            this.comboScatterMainMeasurement.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> TMASummaryViewer.this.comboMainMeasurement.getSelectionModel().select(n));
            this.comboScatterMainMeasurement.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateChart());
            this.comboScatterSecondaryMeasurement.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateChart());
            GridPane topGrid = new GridPane();
            Label label = new Label("Main measurement");
            label.minWidthProperty().bind((ObservableValue)label.prefWidthProperty());
            topGrid.add((Node)label, 0, 0);
            topGrid.add(this.comboScatterMainMeasurement, 1, 0);
            label = new Label("Secondary measurement");
            label.minWidthProperty().bind((ObservableValue)label.prefWidthProperty());
            topGrid.add((Node)label, 0, 1);
            topGrid.add(this.comboScatterSecondaryMeasurement, 1, 1);
            topGrid.setHgap(5.0);
            this.comboScatterMainMeasurement.setMaxWidth(Double.MAX_VALUE);
            this.comboScatterSecondaryMeasurement.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow(this.comboScatterMainMeasurement, (Priority)Priority.ALWAYS);
            GridPane.setHgrow(this.comboScatterSecondaryMeasurement, (Priority)Priority.ALWAYS);
            topGrid.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
            topGrid.prefWidthProperty().bind((ObservableValue)this.pane.widthProperty());
            TableColumn colName = new TableColumn("Name");
            colName.setCellValueFactory(v -> new SimpleStringProperty(((DoubleProperty)v.getValue()).getName()));
            TableColumn colValue = new TableColumn("Value");
            colValue.setCellValueFactory(v -> new SimpleStringProperty(GeneralTools.formatNumber((double)((DoubleProperty)v.getValue()).getValue(), (int)3)));
            this.tableScatter.getColumns().add((Object)colName);
            this.tableScatter.getColumns().add((Object)colValue);
            this.tableScatter.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            this.tableScatter.setPrefHeight(200.0);
            this.pane.setTop((Node)topGrid);
            this.pane.setCenter(this.chart);
            this.pane.setBottom(this.tableScatter);
            ChartTools.makeChartInteractive(this.chart, this.xAxis, this.yAxis);
            ChartTools.addChartExportMenu(this.chart, null);
        }

        public Pane getPane() {
            return this.pane;
        }

        private void updateChart() {
            String xMeasurement = (String)this.comboScatterMainMeasurement.getSelectionModel().getSelectedItem();
            String yMeasurement = (String)this.comboScatterSecondaryMeasurement.getSelectionModel().getSelectedItem();
            double[] x = TMASummaryViewer.this.model.getDoubleValues(xMeasurement);
            double[] y = TMASummaryViewer.this.model.getDoubleValues(yMeasurement);
            int count = 0;
            ObservableList<TMAEntries.TMAEntry> entries = TMASummaryViewer.this.model.getItems();
            ObservableList data = FXCollections.observableArrayList();
            for (int i = 0; i < x.length; ++i) {
                double xx = x[i];
                double yy = y[i];
                if (Double.isNaN(xx) || Double.isNaN(yy)) continue;
                XYChart.Data item = new XYChart.Data((Object)xx, (Object)yy, entries.get(i));
                data.add((Object)item);
                x[count] = xx;
                y[count] = yy;
                ++count;
            }
            if (this.chart.getData().isEmpty()) {
                this.chart.getData().add((Object)new XYChart.Series(data));
            } else {
                ((XYChart.Series)this.chart.getData().get(0)).setData(data);
            }
            for (XYChart.Data element : data) {
                Node node = element.getNode();
                Object value = element.getExtraValue();
                if (value instanceof TMAEntries.TMAEntry) {
                    TMAEntries.TMAEntry entry = (TMAEntries.TMAEntry)value;
                    if (entry.getMeasurement(TMASummaryViewer.this.colCensored) != null && entry.getMeasurement(TMASummaryViewer.this.colCensored).doubleValue() == 1.0) {
                        node.setStyle("-fx-background-color: rgb(60, 200, 60, 0.75); -fx-opacity: 0.5;");
                    } else {
                        node.setStyle("-fx-opacity: 0.75;");
                    }
                    node.setOnMouseClicked(e -> {
                        TreeItem<TMAEntries.TMAEntry> item;
                        if (!TMASummaryViewer.this.useSelectedProperty.get()) {
                            TMASummaryViewer.this.table.getSelectionModel().clearSelection();
                        }
                        if ((item = TMASummaryViewer.this.getItem((TreeItem<TMAEntries.TMAEntry>)TMASummaryViewer.this.table.getRoot(), entry)) != null) {
                            item.setExpanded(true);
                            TMASummaryViewer.this.table.getSelectionModel().select(item);
                            TMASummaryViewer.this.table.layout();
                            int ind = TMASummaryViewer.this.table.getSelectionModel().getSelectedIndex();
                            if (ind >= 0) {
                                TMASummaryViewer.this.table.scrollTo(ind);
                            }
                        }
                    });
                }
                DropShadow dropShadow = new DropShadow();
                Node nodeFinal = node;
                nodeFinal.hoverProperty().addListener((v, o, n) -> nodeFinal.setEffect((Effect)(n != false ? dropShadow : null)));
            }
            this.xAxis.setLabel(xMeasurement);
            this.yAxis.setLabel(yMeasurement);
            this.chart.setLegendVisible(false);
            if (count == 0) {
                this.tableScatter.getItems().clear();
                return;
            }
            int len = x.length;
            int nNanX = GeneralTools.numNaNs((double[])x);
            int nNanY = GeneralTools.numNaNs((double[])y);
            if (count < x.length) {
                x = Arrays.copyOf(x, count);
                y = Arrays.copyOf(y, count);
            }
            this.tableScatter.getItems().setAll((Object[])new DoubleProperty[]{new SimpleDoubleProperty(null, "Total '" + xMeasurement + "'", (double)(len - nNanX)), new SimpleDoubleProperty(null, "Total '" + yMeasurement + "'", (double)(len - nNanY)), new SimpleDoubleProperty(null, String.format("Total '%s' & '%s'", xMeasurement, yMeasurement), (double)count)});
            if (count > 1) {
                double pearsons = new PearsonsCorrelation().correlation(x, y);
                double spearmans = new SpearmansCorrelation().correlation(x, y);
                this.tableScatter.getItems().addAll((Object[])new DoubleProperty[]{new SimpleDoubleProperty(null, "Pearson's correlation coefficient", pearsons), new SimpleDoubleProperty(null, "Spearman's correlation coefficient", spearmans)});
            }
        }
    }

    private class TMATableModel
    implements PathTableData<TMAEntries.TMAEntry> {
        private ObservableList<TMAEntries.TMAEntry> list = FXCollections.observableArrayList();

        TMATableModel() {
            TMASummaryViewer.this.useSelectedProperty.addListener((v, o, n) -> this.refreshList());
            TMASummaryViewer.this.table.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<TMAEntries.TMAEntry>>(){

                public void onChanged(ListChangeListener.Change<? extends TreeItem<TMAEntries.TMAEntry>> c) {
                    if (TMASummaryViewer.this.useSelectedProperty.get()) {
                        TMATableModel.this.refreshList();
                    }
                }
            });
            this.refreshList();
        }

        private void refreshList() {
            if (TMASummaryViewer.this.table.getRoot() == null) {
                this.list.clear();
            } else if (TMASummaryViewer.this.useSelectedProperty.get()) {
                List<TMAEntries.TMAEntry> selectedList = TMASummaryViewer.this.table.getSelectionModel().getSelectedItems().stream().map(i -> (TMAEntries.TMAEntry)i.getValue()).toList();
                if (selectedList.stream().anyMatch(e -> e instanceof TMASummaryEntry)) {
                    selectedList = selectedList.stream().filter(e -> e instanceof TMASummaryEntry).toList();
                }
                this.list.setAll(selectedList);
            } else {
                this.list.setAll(TMASummaryViewer.this.table.getRoot().getChildren().stream().map(i -> (TMAEntries.TMAEntry)i.getValue()).toList());
            }
        }

        @Override
        public List<String> getAllNames() {
            ArrayList<String> namesList = new ArrayList<String>();
            namesList.add("Image");
            namesList.add("Core");
            namesList.addAll((Collection<String>)TMASummaryViewer.this.metadataNames);
            namesList.addAll((Collection<String>)TMASummaryViewer.this.measurementNames);
            namesList.add("Comment");
            return namesList;
        }

        @Override
        public String getStringValue(TMAEntries.TMAEntry entry, String column) {
            return this.getStringValue(entry, column, Integer.MIN_VALUE);
        }

        @Override
        public String getStringValue(TMAEntries.TMAEntry entry, String column, int decimalPlaces) {
            if ("Image".equals(column)) {
                return entry.getImageName();
            }
            if ("Core".equals(column)) {
                return entry.getName();
            }
            if ("Comment".equals(column)) {
                return entry.getComment();
            }
            if (TMASummaryViewer.this.metadataNames.contains((Object)column)) {
                return entry.getMetadataValue(column);
            }
            double val = this.getNumericValue(entry, column);
            if (Double.isNaN(val)) {
                return "NaN";
            }
            return GeneralTools.formatNumber((double)this.getNumericValue(entry, column), (int)4);
        }

        @Override
        public List<String> getMeasurementNames() {
            return TMASummaryViewer.this.measurementNames;
        }

        @Override
        public double getNumericValue(TMAEntries.TMAEntry entry, String column) {
            if (entry == null) {
                return Double.NaN;
            }
            if ("Available cores".equals(column)) {
                return entry instanceof TMASummaryEntry ? (double)((TMASummaryEntry)entry).nNonMissingEntries() : Double.NaN;
            }
            Number value = entry.getMeasurement(column);
            return value == null ? Double.NaN : value.doubleValue();
        }

        @Override
        public double[] getDoubleValues(String column) {
            ObservableList<TMAEntries.TMAEntry> entries = this.getItems();
            double[] values = new double[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                values[i] = this.getNumericValue((TMAEntries.TMAEntry)entries.get(i), column);
            }
            return values;
        }

        @Override
        public ObservableList<TMAEntries.TMAEntry> getItems() {
            return this.list;
        }
    }

    private static enum ImageAvailability {
        IMAGE_ONLY,
        OVERLAY_ONLY,
        BOTH,
        NONE;

    }

    static class RootTreeItem
    extends TreeItem<TMAEntries.TMAEntry>
    implements ChangeListener<Predicate<TMAEntries.TMAEntry>> {
        private List<TreeItem<TMAEntries.TMAEntry>> entries = new ArrayList<TreeItem<TMAEntries.TMAEntry>>();
        private ObservableValue<Predicate<TMAEntries.TMAEntry>> combinedPredicate;

        RootTreeItem(Collection<? extends TMAEntries.TMAEntry> entries, ObservableValue<Predicate<TMAEntries.TMAEntry>> combinedPredicate) {
            super(null);
            for (TMAEntries.TMAEntry tMAEntry : entries) {
                if (tMAEntry instanceof TMASummaryEntry) {
                    this.entries.add(new SummaryTreeItem((TMASummaryEntry)tMAEntry));
                    continue;
                }
                this.entries.add((TreeItem<TMAEntries.TMAEntry>)new TreeItem((Object)tMAEntry));
            }
            this.combinedPredicate = combinedPredicate;
            this.combinedPredicate.addListener((ChangeListener)new WeakChangeListener((ChangeListener)this));
            this.updateChildren();
        }

        private void updateChildren() {
            ArrayList<TreeItem<TMAEntries.TMAEntry>> children = new ArrayList<TreeItem<TMAEntries.TMAEntry>>();
            for (TreeItem<TMAEntries.TMAEntry> entry : this.entries) {
                if (entry instanceof SummaryTreeItem) {
                    SummaryTreeItem summaryItem = (SummaryTreeItem)entry;
                    summaryItem.updateChildren();
                    if (summaryItem.getChildren().isEmpty()) continue;
                    children.add(summaryItem);
                    continue;
                }
                if (!((Predicate)this.combinedPredicate.getValue()).test((TMAEntries.TMAEntry)entry.getValue())) continue;
                children.add(entry);
            }
            super.getChildren().setAll(children);
        }

        public void changed(ObservableValue<? extends Predicate<TMAEntries.TMAEntry>> observable, Predicate<TMAEntries.TMAEntry> oldValue, Predicate<TMAEntries.TMAEntry> newValue) {
            this.updateChildren();
        }
    }

    static class TablePredicate
    implements Predicate<TMAEntries.TMAEntry> {
        final String commandOriginal;
        final String command;
        final SimpleBindings bindings = new SimpleBindings();
        final ScriptEngine engine;
        private boolean lastEvaluationSucceeded = true;
        private boolean isValid = false;

        TablePredicate(String predicate) {
            this.commandOriginal = predicate;
            String quotedRegex = "\"([^\"]*)\"";
            String test = predicate.replaceAll(quotedRegex, "");
            this.isValid = test.replaceAll("[ ()+-<>=*/&|!]", "").trim().isEmpty();
            this.command = this.isValid ? predicate.replaceAll(quotedRegex, "entry.getMeasurementAsDouble(\"$1\")").trim() : null;
            ScriptEngineManager manager = new ScriptEngineManager();
            this.engine = manager.getEngineByName("JavaScript");
            this.engine.setBindings(this.bindings, 200);
        }

        @Override
        public boolean test(TMAEntries.TMAEntry entry) {
            if (!this.isValid) {
                throw new RuntimeException("Cannot run invalid predicate! Original command: " + this.commandOriginal);
            }
            if (this.command.isEmpty()) {
                return true;
            }
            this.bindings.put("entry", (Object)entry);
            try {
                Object result = this.engine.eval(this.command);
                this.lastEvaluationSucceeded = result instanceof Boolean;
                return Boolean.TRUE.equals(result);
            }
            catch (ScriptException e) {
                this.lastEvaluationSucceeded = false;
                logger.error("Error evaluating {} for {}: {}", new Object[]{this.command, entry, e.getLocalizedMessage()});
                return false;
            }
        }

        public String getOriginalCommand() {
            return this.commandOriginal;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean lastEvaluationSucceeded() {
            return this.lastEvaluationSucceeded;
        }

        public String toString() {
            return this.getCommand();
        }
    }

    static class SummaryTreeItem
    extends TreeItem<TMAEntries.TMAEntry> {
        private TMASummaryEntry entry;

        SummaryTreeItem(TMASummaryEntry entry) {
            super((Object)entry);
            this.entry = entry;
            this.updateChildren();
        }

        private void updateChildren() {
            ArrayList<TreeItem> children = new ArrayList<TreeItem>();
            for (TMAEntries.TMAEntry subEntry : this.entry.getEntries()) {
                children.add(new TreeItem((Object)subEntry));
            }
            super.getChildren().setAll(children);
        }
    }
}

