/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.tma.TMAEntries;

class TMASummaryEntry
implements TMAEntries.TMAEntry {
    private static final Logger logger = LoggerFactory.getLogger(TMASummaryEntry.class);
    private ObservableValue<TMAEntries.MeasurementCombinationMethod> method;
    private ObservableBooleanValue skipMissing;
    private ObservableList<TMAEntries.TMAEntry> entriesBase = FXCollections.observableArrayList();
    private FilteredList<TMAEntries.TMAEntry> entries = new FilteredList(this.entriesBase);

    public TMASummaryEntry(ObservableValue<TMAEntries.MeasurementCombinationMethod> method, ObservableBooleanValue skipMissing, ObservableValue<Predicate<TMAEntries.TMAEntry>> predicate) {
        this.method = method;
        this.skipMissing = skipMissing;
        this.entries.predicateProperty().bind(predicate);
    }

    public void addEntry(TMAEntries.TMAEntry entry) {
        this.entriesBase.add((Object)entry);
    }

    public List<TMAEntries.TMAEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public boolean isMissing() {
        return this.nNonMissingEntries() > 0;
    }

    public int nNonMissingEntries() {
        int n = 0;
        for (TMAEntries.TMAEntry entry : this.entries) {
            if (entry.isMissing()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasImage() {
        return this.entries.stream().anyMatch(e -> e.hasImage());
    }

    @Override
    public boolean hasOverlay() {
        return this.entries.stream().anyMatch(e -> e.hasOverlay());
    }

    @Override
    public String getName() {
        if (this.entries.isEmpty()) {
            return null;
        }
        Set names = this.entries.stream().filter(e -> e.getName() != null).map(e -> e.getName()).collect(Collectors.toSet());
        Object coreNameCached = names.size() == 1 ? (String)names.iterator().next() : (!names.isEmpty() ? "[" + String.join((CharSequence)", ", names) + "]" : "");
        return coreNameCached;
    }

    @Override
    public Number getMeasurement(String name) {
        if (TMASummaryEntry.isSurvivalColumn(name)) {
            double min;
            double max = TMASummaryEntry.getMaxMeasurement(this.entries, name, this.skipMissing.get());
            if (max == (min = TMASummaryEntry.getMinMeasurement(this.entries, name, this.skipMissing.get())) || Double.isNaN(max) && Double.isNaN(min)) {
                return max;
            }
            logger.warn("Measurement {} for {} has different values!", (Object)name, (Object)this);
            return Double.NaN;
        }
        return ((TMAEntries.MeasurementCombinationMethod)((Object)this.method.getValue())).calculate((List<TMAEntries.TMAEntry>)this.entries, name, this.skipMissing.get());
    }

    @Override
    public Collection<String> getMetadataNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (TMAEntries.TMAEntry entry : this.entries) {
            names.addAll(entry.getMetadataNames());
        }
        return names;
    }

    @Override
    public String getMetadataValue(String name) {
        FilteredList<TMAEntries.TMAEntry> entriesToCheck = this.entries;
        if (entriesToCheck.isEmpty()) {
            if ("Case ID".equals(name)) {
                entriesToCheck = this.entriesBase;
            }
            if (entriesToCheck.isEmpty()) {
                return null;
            }
        }
        String value = ((TMAEntries.TMAEntry)entriesToCheck.get(0)).getMetadataValue(name);
        for (TMAEntries.TMAEntry entry : entriesToCheck) {
            String temp = entry.getMetadataValue(name);
            if (value == temp) continue;
            if (value != null && !value.equals(temp)) {
                return "(Mixed)";
            }
            value = temp;
        }
        return value;
    }

    @Override
    public void putMetadata(String name, String value) {
        throw new IllegalArgumentException("Cannot add metadata value to " + this.getClass().getSimpleName());
    }

    @Override
    public Collection<String> getMeasurementNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (TMAEntries.TMAEntry entry : this.entries) {
            names.addAll(entry.getMeasurementNames());
        }
        return names;
    }

    @Override
    public void putMeasurement(String name, Number number) {
        throw new IllegalArgumentException("Cannot add measurement to " + this.getClass().getSimpleName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TMA Entry: [");
        int count = 0;
        for (TMAEntries.TMAEntry entry : this.entries) {
            sb.append(entry.toString());
            if (++count >= this.entries.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public double getMeasurementAsDouble(String name) {
        Number measurement = this.getMeasurement(name);
        return measurement == null ? Double.NaN : measurement.doubleValue();
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    public String getImageName() {
        return null;
    }

    @Override
    public Image getImage(int maxWidth) {
        return null;
    }

    @Override
    public Image getOverlay(int maxWidth) {
        return null;
    }

    public static boolean isSurvivalColumn(String name) {
        return TMAEntries.survivalSet.contains(name);
    }

    public static double getMeanMeasurement(List<TMAEntries.TMAEntry> entries, String measurement, boolean skipMissing) {
        double sum = 0.0;
        int n = 0;
        for (TMAEntries.TMAEntry entry : entries) {
            Number val;
            if (skipMissing && entry.isMissing() || (val = entry.getMeasurement(measurement)) == null || Double.isNaN(val.doubleValue())) continue;
            sum += val.doubleValue();
            ++n;
        }
        return n == 0 ? Double.NaN : sum / (double)n;
    }

    public static double getMaxMeasurement(List<TMAEntries.TMAEntry> entries, String measurement, boolean skipMissing) {
        double max = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (TMAEntries.TMAEntry entry : entries) {
            Number val;
            if (skipMissing && entry.isMissing() || (val = entry.getMeasurement(measurement)) == null || Double.isNaN(val.doubleValue())) continue;
            ++n;
            if (!(val.doubleValue() > max)) continue;
            max = val.doubleValue();
        }
        return n == 0 ? Double.NaN : max;
    }

    public static double getMinMeasurement(List<TMAEntries.TMAEntry> entries, String measurement, boolean skipMissing) {
        double min = Double.POSITIVE_INFINITY;
        int n = 0;
        for (TMAEntries.TMAEntry entry : entries) {
            Number val;
            if (skipMissing && entry.isMissing() || (val = entry.getMeasurement(measurement)) == null || Double.isNaN(val.doubleValue())) continue;
            ++n;
            if (!(val.doubleValue() < min)) continue;
            min = val.doubleValue();
        }
        return n == 0 ? Double.NaN : min;
    }

    public static double getMedianMeasurement(List<TMAEntries.TMAEntry> entries, String measurement, boolean skipMissing) {
        double[] values = new double[entries.size()];
        int n = 0;
        for (TMAEntries.TMAEntry entry : entries) {
            Number val;
            if (skipMissing && entry.isMissing() || (val = entry.getMeasurement(measurement)) == null || Double.isNaN(val.doubleValue())) continue;
            values[n] = val.doubleValue();
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        if (n < values.length) {
            values = Arrays.copyOf(values, n);
        }
        Arrays.sort(values);
        if (n % 2 == 0) {
            return values[n / 2 - 1] / 2.0 + values[n / 2] / 2.0;
        }
        return values[n / 2];
    }

    public static double getRangeMeasurement(List<TMAEntries.TMAEntry> entries, String measurement, boolean skipMissing) {
        return TMASummaryEntry.getMaxMeasurement(entries, measurement, skipMissing) - TMASummaryEntry.getMinMeasurement(entries, measurement, skipMissing);
    }

    @Override
    public void setMissing(boolean missing) {
        for (TMAEntries.TMAEntry entry : this.entries) {
            entry.setMissing(missing);
        }
    }
}

