/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import qupath.lib.gui.tma.TMAEntries;

class TMAImageCache {
    private int maxSmallWidth;
    private Map<TMAEntries.TMAEntry, Image> imageSmall = Collections.synchronizedMap(new HashMap());
    private Map<TMAEntries.TMAEntry, SoftReference<Image>> imageLarge = Collections.synchronizedMap(new HashMap());
    private Map<TMAEntries.TMAEntry, Image> overlaySmall = Collections.synchronizedMap(new HashMap());
    private Map<TMAEntries.TMAEntry, SoftReference<Image>> overlayLarge = Collections.synchronizedMap(new HashMap());

    public TMAImageCache(int maxSmallWidth) {
        this.maxSmallWidth = maxSmallWidth;
    }

    public Image getImage(TMAEntries.TMAEntry entry, double maxWidth) {
        if (!entry.hasImage()) {
            return null;
        }
        return this.getCachedImage(entry, maxWidth, false);
    }

    public Image getOverlay(TMAEntries.TMAEntry entry, double maxWidth) {
        if (!entry.hasOverlay()) {
            return null;
        }
        return this.getCachedImage(entry, maxWidth, true);
    }

    private Image getCachedImage(TMAEntries.TMAEntry entry, double maxWidth, boolean isOverlay) {
        boolean isSmall;
        boolean bl = isSmall = maxWidth > 0.0 && maxWidth <= (double)this.maxSmallWidth;
        if (isSmall) {
            return this.getSmallCachedImage(entry, isOverlay);
        }
        return this.getLargeCachedImage(entry, isOverlay);
    }

    public void clear() {
        this.imageSmall.clear();
        this.imageLarge.clear();
        this.overlaySmall.clear();
        this.overlayLarge.clear();
    }

    private Image getLargeCachedImage(TMAEntries.TMAEntry entry, boolean isOverlay) {
        Image img;
        Map<TMAEntries.TMAEntry, SoftReference<Image>> cache = isOverlay ? this.overlayLarge : this.imageLarge;
        SoftReference<Image> ref = cache.get(entry);
        Image image = img = ref == null ? null : ref.get();
        if (img == null) {
            Image image2 = img = isOverlay ? entry.getOverlay(-1) : entry.getImage(-1);
            if (img != null) {
                cache.put(entry, new SoftReference<Image>(img));
            }
        }
        return img;
    }

    private Image getSmallCachedImage(TMAEntries.TMAEntry entry, boolean isOverlay) {
        Map<TMAEntries.TMAEntry, Image> cache = isOverlay ? this.overlaySmall : this.imageSmall;
        Image img = cache.get(entry);
        if (img == null) {
            Image image = img = isOverlay ? entry.getOverlay(this.maxSmallWidth) : entry.getImage(this.maxSmallWidth);
            if (img != null) {
                cache.put(entry, img);
            }
        }
        return img;
    }
}

