/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tma.TMAEntries;
import qupath.lib.gui.tma.TMASummaryViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.measurements.Measurement;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class TMAExplorer
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(TMAExplorer.class);
    private QuPathGUI qupath;
    private List<TMAEntries.TMAEntry> entries = new ArrayList<TMAEntries.TMAEntry>();

    public TMAExplorer(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        this.createAndShowStage();
    }

    private void createAndShowStage() {
        Project<BufferedImage> project = this.qupath.getProject();
        this.entries.clear();
        if (project != null) {
            File dirBaseImageOutput = Projects.getBaseDirectory(project);
            dirBaseImageOutput = new File(dirBaseImageOutput, "TMA");
            if (!(dirBaseImageOutput = new File(dirBaseImageOutput, "images")).exists()) {
                dirBaseImageOutput.mkdirs();
            }
            HashMap<String, RunningStatistics> statsMap = new HashMap<String, RunningStatistics>();
            for (ProjectImageEntry imageEntry : project.getImageList()) {
                ImageData imageData;
                if (!imageEntry.hasImageData()) continue;
                File dirImageOutput = new File(dirBaseImageOutput, imageEntry.getImageName());
                if (!dirImageOutput.exists()) {
                    dirImageOutput.mkdirs();
                }
                try {
                    imageData = imageEntry.readImageData();
                }
                catch (IOException e) {
                    logger.error("Error reading ImageData for " + imageEntry.getImageName(), (Throwable)e);
                    continue;
                }
                TMAGrid tmaGrid = imageData.getHierarchy().getTMAGrid();
                if (tmaGrid == null) {
                    logger.warn("No TMA data for {}", (Object)imageEntry.getImageName());
                    continue;
                }
                ImageServer server = imageData.getServer();
                double downsample = Math.round(5.0 / server.getPixelCalibration().getAveragedPixelSizeMicrons());
                int counter = 0;
                for (TMACoreObject core : tmaGrid.getTMACoreList()) {
                    File fileOutput;
                    ++counter;
                    String name = core.getName();
                    if (name == null) {
                        name = Integer.toString(counter);
                    }
                    if (!(fileOutput = new File(dirImageOutput, name + ".jpg")).exists()) {
                        try {
                            RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)core.getROI());
                            BufferedImage img = (BufferedImage)server.readRegion(request);
                            ImageIO.write((RenderedImage)img, "jpg", fileOutput);
                        }
                        catch (Exception e) {
                            logger.error("Unable to write {}", (Object)fileOutput.getAbsolutePath());
                        }
                    }
                    TMAEntries.TMAEntry entry = TMAEntries.createDefaultTMAEntry(imageEntry.getImageName(), fileOutput.getAbsolutePath(), null, core.getName(), core.isMissing());
                    MeasurementList ml = core.getMeasurementList();
                    for (Measurement m : ml.getMeasurements()) {
                        String measurement = m.getName();
                        double val = m.getValue();
                        entry.putMeasurement(measurement, val);
                        if (Double.isNaN(val)) continue;
                        RunningStatistics stats = statsMap.computeIfAbsent(measurement, k -> new RunningStatistics());
                        stats.addValue(val);
                    }
                    this.entries.add(entry);
                }
                try {
                    server.close();
                }
                catch (Exception e) {
                    logger.warn("Problem closing server", (Throwable)e);
                }
            }
            double k2 = 3.0;
            for (TMAEntries.TMAEntry entry : this.entries) {
                int outlierCount = 0;
                for (Map.Entry statsEntry : statsMap.entrySet()) {
                    RunningStatistics stats = (RunningStatistics)statsEntry.getValue();
                    double val = entry.getMeasurementAsDouble((String)statsEntry.getKey());
                    if (val >= stats.getMean() - stats.getStdDev() * k2 && val <= stats.getMean() + stats.getStdDev() * k2) continue;
                    ++outlierCount;
                }
                entry.putMeasurement("Outlier count", outlierCount);
            }
        }
        Stage stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        stage.initOwner((Window)this.qupath.getStage());
        TMASummaryViewer summaryViewer = new TMASummaryViewer(stage);
        summaryViewer.setTMAEntries(this.entries);
        summaryViewer.getStage().show();
    }
}

