/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.tma.TMASummaryEntry;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

class TMAEntries {
    public static Set<String> survivalSet = new HashSet<String>(Arrays.asList("Overall survival", "OS censored", "Recurrence-free survival", "RFS censored", "Censored"));

    TMAEntries() {
    }

    public static TMAEntry createDefaultTMAEntry(String imageName, String imagePath, String overlayPath, String coreName, boolean isMissing) {
        return new DefaultTMAEntry(imageName, imagePath, overlayPath, coreName, isMissing);
    }

    public static TMAEntry createTMAObjectEntry(ImageData<BufferedImage> imageData, ObservableMeasurementTableData data, TMACoreObject core) {
        return new TMAObjectEntry(imageData, data, core);
    }

    public static TMAEntry createTMASummaryEntry(ObservableValue<MeasurementCombinationMethod> method, ObservableBooleanValue skipMissing, ObservableValue<Predicate<TMAEntry>> predicate) {
        return new TMASummaryEntry(method, skipMissing, predicate);
    }

    static class DefaultTMAEntry
    implements TMAEntry {
        private static Logger logger = LoggerFactory.getLogger(DefaultTMAEntry.class);
        private String imageName;
        private String name;
        private String imagePath;
        private String overlayPath;
        private String comment;
        private boolean isMissing;
        private Map<String, String> metadata = new LinkedHashMap<String, String>();
        private Map<String, Number> measurements = new LinkedHashMap<String, Number>();

        public DefaultTMAEntry(String imageName, String imagePath, String overlayPath, String coreName, boolean isMissing) {
            this.imageName = imageName;
            this.name = coreName;
            this.isMissing = isMissing;
            this.imagePath = imagePath != null && new File(imagePath).isFile() ? imagePath : null;
            this.overlayPath = overlayPath != null && new File(overlayPath).isFile() ? overlayPath : null;
        }

        @Override
        public Number getMeasurement(String name) {
            return this.measurements.get(name);
        }

        @Override
        public double getMeasurementAsDouble(String name) {
            Number measurement = this.getMeasurement(name);
            if (measurement == null) {
                return Double.NaN;
            }
            return measurement.doubleValue();
        }

        @Override
        public Collection<String> getMetadataNames() {
            return this.metadata.keySet();
        }

        @Override
        public String getMetadataValue(String name) {
            return this.metadata.get(name);
        }

        @Override
        public void putMetadata(String name, String value) {
            this.metadata.put(name, value);
        }

        @Override
        public boolean isMissing() {
            return this.isMissing;
        }

        @Override
        public Collection<String> getMeasurementNames() {
            return this.measurements.keySet();
        }

        @Override
        public void putMeasurement(String name, Number number) {
            if (number == null) {
                this.measurements.remove(name);
            } else {
                this.measurements.put(name, number);
            }
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public void setComment(String comment) {
            this.comment = comment.replace("\t", "  ").replace("\n", "  ");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getImageName() {
            return this.imageName;
        }

        @Override
        public boolean hasImage() {
            return this.imagePath != null;
        }

        @Override
        public boolean hasOverlay() {
            return this.overlayPath != null;
        }

        @Override
        public Image getImage(int maxWidth) {
            if (this.imagePath == null) {
                return null;
            }
            try {
                return new Image(new File(this.imagePath).toURI().toURL().toString(), (double)maxWidth, -1.0, true, false);
            }
            catch (MalformedURLException e) {
                logger.error("Cannot show image: " + this.imagePath, (Throwable)e);
                return null;
            }
        }

        @Override
        public Image getOverlay(int maxWidth) {
            if (this.overlayPath == null) {
                return null;
            }
            try {
                return new Image(new File(this.overlayPath).toURI().toURL().toString(), (double)maxWidth, -1.0, true, false);
            }
            catch (MalformedURLException e) {
                logger.error("Cannot show overlay image: " + this.overlayPath, (Throwable)e);
                return null;
            }
        }

        @Override
        public String toString() {
            return "TMA Entry: " + this.getName();
        }

        @Override
        public void setMissing(boolean missing) {
            this.isMissing = missing;
        }
    }

    static class TMAObjectEntry
    implements TMAEntry {
        private static final Logger logger = LoggerFactory.getLogger(TMAObjectEntry.class);
        private ImageData<BufferedImage> imageData;
        private ObservableMeasurementTableData data;
        private TMACoreObject core;
        private double preferredDownsample;

        public TMAObjectEntry(ImageData<BufferedImage> imageData, ObservableMeasurementTableData data, TMACoreObject core) {
            this(imageData, data, core, 4.0);
        }

        public TMAObjectEntry(ImageData<BufferedImage> imageData, ObservableMeasurementTableData data, TMACoreObject core, double preferredDownsample) {
            this.imageData = imageData;
            this.core = core;
            this.data = data;
            this.preferredDownsample = preferredDownsample;
        }

        @Override
        public Number getMeasurement(String name) {
            return this.data.getNumericValue((PathObject)this.core, name);
        }

        @Override
        public Collection<String> getMetadataNames() {
            return this.data.getMetadataNames();
        }

        @Override
        public String getMetadataValue(String name) {
            String val = (String)this.core.getMetadataValue(name);
            if (val != null) {
                return val;
            }
            if (this.data.getMetadataNames().contains((Object)name)) {
                return this.data.getStringValue((PathObject)this.core, name);
            }
            return null;
        }

        @Override
        public void putMetadata(String name, String value) {
            this.core.putMetadataValue(name, value);
            if (this.imageData != null) {
                this.imageData.getHierarchy().fireObjectMeasurementsChangedEvent((Object)this, Collections.singletonList(this.core));
            }
            this.data.updateMeasurementList();
        }

        @Override
        public boolean isMissing() {
            return this.core.isMissing();
        }

        @Override
        public Collection<String> getMeasurementNames() {
            return this.data.getMeasurementNames();
        }

        @Override
        public void putMeasurement(String name, Number number) {
            this.core.getMeasurementList().put(name, number == null ? Double.NaN : number.doubleValue());
            if (this.imageData != null) {
                this.imageData.getHierarchy().fireObjectMeasurementsChangedEvent((Object)this, Collections.singletonList(this.core));
            }
            this.data.updateMeasurementList();
        }

        @Override
        public String getName() {
            return this.core.getName();
        }

        @Override
        public Image getImage(int maxWidth) {
            if (this.imageData == null) {
                return null;
            }
            ROI roi = this.core.getROI();
            double downsample = this.preferredDownsample;
            if (maxWidth > 0) {
                downsample = Math.max(roi.getBoundsWidth() / (double)maxWidth, this.preferredDownsample);
            }
            try {
                BufferedImage img = (BufferedImage)this.imageData.getServer().readRegion(RegionRequest.createInstance((String)this.imageData.getServerPath(), (double)downsample, (ROI)roi));
                return SwingFXUtils.toFXImage((BufferedImage)img, null);
            }
            catch (IOException e) {
                logger.warn("Unable to return TMA core image for " + String.valueOf(this), (Throwable)e);
                return null;
            }
        }

        @Override
        public Image getOverlay(int maxWidth) {
            return null;
        }

        @Override
        public double getMeasurementAsDouble(String name) {
            Number measurement = this.getMeasurement(name);
            return measurement == null ? Double.NaN : measurement.doubleValue();
        }

        @Override
        public String getComment() {
            return this.core.getMetadataString("Comment");
        }

        @Override
        public void setComment(String comment) {
            this.core.putMetadataValue("Comment", comment);
            if (this.imageData != null) {
                this.imageData.getHierarchy().fireObjectMeasurementsChangedEvent((Object)this, Collections.singletonList(this.core));
            }
            this.data.updateMeasurementList();
        }

        @Override
        public String getImageName() {
            return this.imageData == null ? null : ServerTools.getDisplayableImageName((ImageServer)this.imageData.getServer());
        }

        @Override
        public boolean hasImage() {
            return this.imageData != null;
        }

        @Override
        public boolean hasOverlay() {
            return false;
        }

        @Override
        public void setMissing(boolean missing) {
            this.core.setMissing(missing);
            if (this.imageData != null) {
                this.imageData.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(this.core));
            }
            this.data.updateMeasurementList();
        }
    }

    public static enum MeasurementCombinationMethod {
        MEAN,
        MEDIAN,
        MIN,
        MAX,
        RANGE;


        public double calculate(List<TMAEntry> entries, String measurementName, boolean skipMissing) {
            switch (this.ordinal()) {
                case 3: {
                    return TMASummaryEntry.getMaxMeasurement(entries, measurementName, skipMissing);
                }
                case 0: {
                    return TMASummaryEntry.getMeanMeasurement(entries, measurementName, skipMissing);
                }
                case 1: {
                    return TMASummaryEntry.getMedianMeasurement(entries, measurementName, skipMissing);
                }
                case 2: {
                    return TMASummaryEntry.getMinMeasurement(entries, measurementName, skipMissing);
                }
                case 4: {
                    return TMASummaryEntry.getRangeMeasurement(entries, measurementName, skipMissing);
                }
            }
            return Double.NaN;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 3: {
                    return "Maximum";
                }
                case 0: {
                    return "Mean";
                }
                case 1: {
                    return "Median";
                }
                case 2: {
                    return "Minimum";
                }
                case 4: {
                    return "Range";
                }
            }
            return "Unknown";
        }
    }

    public static interface TMAEntry {
        public Number getMeasurement(String var1);

        public double getMeasurementAsDouble(String var1);

        public Collection<String> getMeasurementNames();

        public void putMeasurement(String var1, Number var2);

        public Collection<String> getMetadataNames();

        public String getMetadataValue(String var1);

        public void putMetadata(String var1, String var2);

        public boolean isMissing();

        public void setMissing(boolean var1);

        public String getComment();

        public void setComment(String var1);

        public String getName();

        public String getImageName();

        public boolean hasImage();

        public boolean hasOverlay();

        public Image getImage(int var1);

        public Image getOverlay(int var1);

        public String toString();
    }
}

