/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.servers.RenderedImageServer;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.measure.ui.SummaryMeasurementTable;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.overlays.HierarchyOverlay;
import qupath.lib.gui.viewer.overlays.TMAGridOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.writers.ImageWriterTools;
import qupath.lib.io.TMAScoreImporter;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.DefaultTMAGrid;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.plugins.AbstractPlugin;
import qupath.lib.plugins.CommandLineTaskRunner;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class TMADataIO {
    private static final Logger logger = LoggerFactory.getLogger(TMADataIO.class);
    public static final String TMA_DEARRAYING_DATA_EXTENSION = ".qptma";
    private static double preferredExportPixelSizeMicrons = 1.0;

    public static void writeTMAData(File file, ImageData<BufferedImage> imageData) throws IOException {
        TMADataIO.writeTMAData(file, imageData, null, -1.0);
    }

    public static void writeTMAData(File file, ImageData<BufferedImage> imageData, OverlayOptions overlayOptions, double downsampleFactor) throws IOException {
        boolean outputCoreImages;
        File dirData;
        String coreExt;
        if (imageData == null || imageData.getHierarchy() == null || imageData.getHierarchy().getTMAGrid() == null) {
            logger.error("No TMA data available to save!");
            return;
        }
        ImageServer server = imageData.getServer();
        String string = coreExt = imageData.getServer().isRGB() ? ".jpg" : ".tif";
        if (file == null) {
            file = FileChoosers.promptToSaveFile((String)"Save TMA data", (File)new File(ServerTools.getDisplayableImageName((ImageServer)server)), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"TMA data", (String[])new String[]{"*.qptma"})});
            if (file == null) {
                return;
            }
        } else if ((file.isDirectory() || !file.exists() && file.getAbsolutePath().endsWith(File.pathSeparator)) && !(file = new File(file, ServerTools.getDisplayableImageName((ImageServer)server) + TMA_DEARRAYING_DATA_EXTENSION)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!(dirData = new File(String.valueOf(file) + ".data")).exists()) {
            dirData.mkdir();
        }
        String delimiter = "\t";
        TMAGrid tmaGrid = imageData.getHierarchy().getTMAGrid();
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.println(server.getPath());
            writer.println(ServerTools.getDisplayableImageName((ImageServer)server));
            writer.println();
            writer.println("TMA grid width: " + tmaGrid.getGridWidth());
            writer.println("TMA grid height: " + tmaGrid.getGridHeight());
            writer.println("Core name" + delimiter + "X" + delimiter + "Y" + delimiter + "Width" + delimiter + "Height" + delimiter + "Present" + delimiter + "Case ID");
            for (int row = 0; row < tmaGrid.getGridHeight(); ++row) {
                for (int col = 0; col < tmaGrid.getGridWidth(); ++col) {
                    TMACoreObject core = tmaGrid.getTMACore(row, col);
                    if (!core.hasROI()) {
                        writer.println(core.getName() + delimiter + delimiter + delimiter + delimiter);
                        continue;
                    }
                    ROI pathROI = core.getROI();
                    int x = (int)pathROI.getBoundsX();
                    int y = (int)pathROI.getBoundsY();
                    int w = (int)Math.ceil(pathROI.getBoundsWidth());
                    int h = (int)Math.ceil(pathROI.getBoundsHeight());
                    String id = core.getCaseID() == null ? "" : core.getCaseID();
                    writer.println(core.getName() + delimiter + x + delimiter + y + delimiter + w + delimiter + h + delimiter + !core.isMissing() + delimiter + id);
                }
            }
            writer.close();
        }
        catch (Exception e) {
            logger.error("Error writing TMA data: " + e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        ObservableMeasurementTableData tableData = new ObservableMeasurementTableData();
        tableData.setImageData(imageData, tmaGrid.getTMACoreList());
        SummaryMeasurementTable.saveTableModel(tableData, new File(dirData, "TMA results - " + ServerTools.getDisplayableImageName((ImageServer)server) + ".txt"), Collections.emptyList());
        boolean bl = outputCoreImages = Double.isNaN(downsampleFactor) || downsampleFactor > 0.0;
        if (outputCoreImages) {
            if (overlayOptions == null) {
                overlayOptions = new OverlayOptions();
                overlayOptions.setFillDetections(true);
            }
            OverlayOptions options = overlayOptions;
            File fileTMAMap = new File(dirData, "TMA map - " + ServerTools.getDisplayableImageName((ImageServer)server) + ".jpg");
            double downsampleThumbnail = Math.max(1.0, (double)Math.max(server.getWidth(), server.getHeight()) / 1024.0);
            RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsampleThumbnail, (int)0, (int)0, (int)server.getWidth(), (int)server.getHeight());
            OverlayOptions optionsThumbnail = new OverlayOptions();
            optionsThumbnail.setShowTMAGrid(true);
            optionsThumbnail.setShowGrid(false);
            optionsThumbnail.setShowAnnotations(false);
            optionsThumbnail.setShowDetections(false);
            try {
                ImageServer<BufferedImage> renderedServer = new RenderedImageServer.Builder(imageData).layers(new TMAGridOverlay(overlayOptions)).downsamples(downsampleThumbnail).build();
                ImageWriterTools.writeImageRegion(renderedServer, (RegionRequest)request, (String)fileTMAMap.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn("Unable to write image overview: " + e.getLocalizedMessage(), (Throwable)e);
            }
            double downsample = Double.isNaN(downsampleFactor) ? (server.getPixelCalibration().hasPixelSizeMicrons() ? ServerTools.getDownsampleFactor((ImageServer)server, (double)preferredExportPixelSizeMicrons) : 1.0) : downsampleFactor;
            ImageServer<BufferedImage> renderedImageServer = new RenderedImageServer.Builder(imageData).layers(new HierarchyOverlay(null, options, imageData)).downsamples(downsample).build();
            ExportCoresPlugin plugin = new ExportCoresPlugin(dirData, renderedImageServer, downsample, coreExt);
            QuPathGUI qupath = QuPathGUI.getInstance();
            if (qupath == null || qupath.getImageData() != imageData) {
                plugin.runPlugin((TaskRunner)new CommandLineTaskRunner(), imageData, null);
            } else {
                try {
                    qupath.runPlugin((PathPlugin<BufferedImage>)plugin, null, false);
                }
                catch (Exception e) {
                    logger.error("Error writing TMA data: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TMAGrid importDearrayedTMAData(File file) {
        try (Scanner scanner = new Scanner(file);){
            int gridWidth = -1;
            int gridHeight = -1;
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (line.startsWith("TMA grid width:")) {
                    gridWidth = Integer.parseInt(line.replace("TMA grid width:", "").trim());
                } else if (line.startsWith("TMA grid height:")) {
                    gridHeight = Integer.parseInt(line.replace("TMA grid height:", "").trim());
                }
                if (gridWidth < 0 || gridHeight < 0) continue;
            }
            if (gridWidth <= 0 || gridHeight <= 0) {
                logger.error("No grid dimensions available!");
                TMAGrid tMAGrid = null;
                return tMAGrid;
            }
            Map csvData = TMAScoreImporter.readCSV((Scanner)scanner);
            List colNames = (List)csvData.get("Core name");
            List colX = (List)csvData.get("X");
            List colY = (List)csvData.get("Y");
            List colWidth = (List)csvData.get("Width");
            List colHeight = (List)csvData.get("Height");
            List colPresent = (List)csvData.get("Present");
            List colID = (List)csvData.get("Case ID");
            if (colX == null || colY == null || colWidth == null || colHeight == null) {
                logger.error("No core locations available!");
                TMAGrid tMAGrid = null;
                return tMAGrid;
            }
            ArrayList<TMACoreObject> cores = new ArrayList<TMACoreObject>();
            for (int i = 0; i < colX.size(); ++i) {
                double x = Double.parseDouble((String)colX.get(i));
                double y = Double.parseDouble((String)colY.get(i));
                double w = Double.parseDouble((String)colWidth.get(i));
                double h = Double.parseDouble((String)colHeight.get(i));
                boolean present = colPresent == null ? true : Boolean.parseBoolean((String)colPresent.get(i));
                String name = colNames == null ? null : (String)colNames.get(i);
                String id = colID == null ? null : (String)colID.get(i);
                TMACoreObject core = PathObjects.createTMACoreObject((double)x, (double)y, (double)w, (double)h, (!present ? 1 : 0) != 0);
                if (name != null) {
                    core.setName(name);
                }
                if (id != null && !id.isEmpty()) {
                    core.setCaseID(id);
                }
                cores.add(core);
            }
            TMAGrid tMAGrid = DefaultTMAGrid.create(cores, (int)gridWidth);
            return tMAGrid;
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot find file: {}", (Object)file);
            return null;
        }
    }

    private static class ExportCoresPlugin
    extends AbstractPlugin<BufferedImage> {
        private double downsample;
        private File dir;
        private String ext;
        private ImageServer<BufferedImage> renderedServer;

        private ExportCoresPlugin(File dirOutput, ImageServer<BufferedImage> renderedServer, double downsample, String ext) {
            this.dir = dirOutput;
            this.renderedServer = renderedServer;
            this.downsample = downsample;
            this.ext = ext;
        }

        protected void addWorkflowStep(ImageData<BufferedImage> imageData, String arg) {
        }

        public String getName() {
            return "Export TMA cores";
        }

        public String getDescription() {
            return "Export TMA cores & thumbnail images";
        }

        public String getLastResultsDescription() {
            return null;
        }

        protected boolean parseArgument(ImageData<BufferedImage> imageData, String arg) {
            return true;
        }

        protected Collection<? extends PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
            return PathObjectTools.getTMACoreObjects((PathObjectHierarchy)imageData.getHierarchy(), (boolean)true);
        }

        protected void addRunnableTasks(final ImageData<BufferedImage> imageData, final PathObject parentObject, List<Runnable> tasks) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    File fileOutput = new File(dir, parentObject.getName() + ext);
                    RegionRequest request = RegionRequest.createInstance((String)imageData.getServerPath(), (double)downsample, (ROI)parentObject.getROI());
                    try {
                        ImageWriterTools.writeImageRegion((ImageServer)imageData.getServer(), (RegionRequest)request, (String)fileOutput.getAbsolutePath());
                        fileOutput = new File(dir, parentObject.getName() + "-overlay.jpg");
                        ImageWriterTools.writeImageRegion(renderedServer, (RegionRequest)request, (String)fileOutput.getAbsolutePath());
                    }
                    catch (IOException e) {
                        logger.error("Unable to write " + String.valueOf(request), (Throwable)e);
                    }
                }
            };
            tasks.add(runnable);
        }
    }
}

