/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import javafx.geometry.Pos;
import javafx.scene.control.TreeTableCell;
import qupath.lib.common.GeneralTools;

class NumericTreeTableCell<T>
extends TreeTableCell<T, Number> {
    NumericTreeTableCell() {
    }

    protected void updateItem(Number item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.setText(null);
            this.setStyle("");
        } else {
            this.setAlignment(Pos.CENTER);
            if (Double.isNaN(item.doubleValue())) {
                this.setText("-");
            } else if (item.doubleValue() >= 1000.0) {
                this.setText(GeneralTools.formatNumber((double)item.doubleValue(), (int)1));
            } else if (item.doubleValue() >= 10.0) {
                this.setText(GeneralTools.formatNumber((double)item.doubleValue(), (int)2));
            } else {
                this.setText(GeneralTools.formatNumber((double)item.doubleValue(), (int)3));
            }
        }
    }
}

