/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.analysis.stats.StatisticsHelper;
import qupath.lib.analysis.stats.survival.KaplanMeierData;
import qupath.lib.analysis.stats.survival.LogRankTest;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.charts.ChartThresholdPane;
import qupath.lib.gui.charts.ChartTools;
import qupath.lib.gui.charts.HistogramChart;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.tma.KaplanMeierChartWrapper;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.plugins.parameters.IntParameter;
import qupath.lib.plugins.parameters.ParameterChangeListener;
import qupath.lib.plugins.parameters.ParameterList;

class KaplanMeierDisplay
implements ParameterChangeListener,
PathObjectHierarchyListener {
    private static final Logger logger = LoggerFactory.getLogger(KaplanMeierDisplay.class);
    private boolean calculateAllPValues = true;
    private PathObjectHierarchy hierarchy;
    private HistogramChart histogramPanel;
    private ChartThresholdPane histogramWrapper;
    private LineChart<Number, Number> chartPValues;
    private ChartThresholdPane pValuesWrapper;
    private KaplanMeierChartWrapper plotter;
    private ParameterList params;
    private ParameterPanelFX panelParams;
    private BorderPane paneMain = new BorderPane();
    private TableView<Integer> table = new TableView();
    private KaplanMeierTableModel tableModel = new KaplanMeierTableModel(this.table);
    private String scoreColumn;
    private ScoreData scoreData;
    private double lastPValueCensorThreshold = Double.NaN;
    private double[] pValues = null;
    private double[] pValuesSmoothed = null;
    private double[] pValueThresholds = null;
    private boolean[] pValueThresholdsObserved = null;
    private DoubleProperty[] threshProperties = new DoubleProperty[]{new SimpleDoubleProperty(Double.NaN), new SimpleDoubleProperty(Double.NaN), new SimpleDoubleProperty(Double.NaN)};
    private String survivalColumn;
    private String censoredColumn;

    public KaplanMeierDisplay(PathObjectHierarchy hierarchy, String scoreColumn, String survivalColumn, String censoredColumn) {
        this.hierarchy = hierarchy;
        if (this.hierarchy != null) {
            this.hierarchy.addListener((PathObjectHierarchyListener)this);
        }
        this.scoreColumn = scoreColumn;
        this.survivalColumn = survivalColumn;
        this.censoredColumn = censoredColumn;
        this.initialize();
    }

    private void initialize() {
        this.generatePlot();
    }

    public Parent getView() {
        return this.paneMain;
    }

    private Stage createStage(Window parent, String title) {
        Stage frame = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)frame);
        if (parent != null) {
            frame.initOwner(parent);
        }
        frame.setTitle("Kaplan Meier: " + title);
        frame.setOnCloseRequest(e -> {
            if (this.hierarchy != null) {
                this.hierarchy.removeListener((PathObjectHierarchyListener)this);
            }
            this.panelParams.removeParameterChangeListener(this);
            frame.hide();
        });
        Scene scene = new Scene(this.getView(), 600.0, 400.0);
        frame.setScene(scene);
        frame.setMinWidth(600.0);
        frame.setMinHeight(400.0);
        return frame;
    }

    public Stage show(Window parent, String title) {
        Stage frame = this.createStage(parent, title);
        frame.show();
        return frame;
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.hierarchyChanged(event));
        } else {
            this.generatePlot();
        }
    }

    public void setHierarchy(PathObjectHierarchy hierarchy, String survivalKey, String censoredKey) {
        if (this.hierarchy != null) {
            this.hierarchy.removeListener((PathObjectHierarchyListener)this);
        }
        this.survivalColumn = survivalKey;
        this.censoredColumn = censoredKey;
        this.hierarchy = hierarchy;
        if (this.hierarchy != null) {
            this.hierarchy.addListener((PathObjectHierarchyListener)this);
        }
        this.generatePlot();
    }

    public String getScoreColumn() {
        return this.scoreColumn;
    }

    public void setScoreColumn(String scoreColumn) {
        this.scoreColumn = scoreColumn;
        this.refresh();
    }

    public void refresh() {
        this.generatePlot();
    }

    private void generatePlot() {
        Histogram histogram;
        Object thresholdMethod;
        ScoreData newScoreData = this.scoreData;
        if (this.hierarchy != null) {
            int i;
            List cores = PathObjectTools.getTMACoreObjects((PathObjectHierarchy)this.hierarchy, (boolean)false);
            double[] survival = new double[cores.size()];
            boolean[] censored = new boolean[cores.size()];
            double[] scores = new double[cores.size()];
            for (i = 0; i < cores.size(); ++i) {
                TMACoreObject core = (TMACoreObject)cores.get(i);
                MeasurementList ml = core.getMeasurementList();
                survival[i] = core.getMeasurementList().get(this.survivalColumn);
                double censoredValue = core.getMeasurementList().get(this.censoredColumn);
                boolean hasCensoredValue = !Double.isNaN(censoredValue) && (censoredValue == 0.0 || censoredValue == 1.0);
                boolean bl = censored[i] = censoredValue != 0.0;
                if (!hasCensoredValue) {
                    scores[i] = Double.NaN;
                    survival[i] = Double.NaN;
                    continue;
                }
                scores[i] = ml.containsKey(this.scoreColumn) ? ml.get(this.scoreColumn) : Double.NaN;
            }
            for (i = 0; i < survival.length; ++i) {
                if (!Double.isNaN(survival[i])) continue;
                scores[i] = Double.NaN;
            }
            newScoreData = new ScoreData(scores, survival, censored);
        }
        if (newScoreData == null || newScoreData.scores.length == 0) {
            return;
        }
        double[] quartiles = StatisticsHelper.getQuartiles((double[])newScoreData.scores);
        double q1 = quartiles[0];
        double median = quartiles[1];
        double q3 = quartiles[2];
        double[] thresholds = this.params != null ? ((thresholdMethod = this.params.getChoiceParameterValue("scoreThresholdMethod")).equals("Median") ? new double[]{median} : (thresholdMethod.equals("Tertiles") ? StatisticsHelper.getTertiles((double[])newScoreData.scores) : (thresholdMethod.equals("Quartiles") ? new double[]{q1, median, q3} : (thresholdMethod.equals("Manual (1)") ? new double[]{this.params.getDoubleParameterValue("threshold1")} : (thresholdMethod.equals("Manual (2)") ? new double[]{this.params.getDoubleParameterValue("threshold1"), this.params.getDoubleParameterValue("threshold2")} : new double[]{this.params.getDoubleParameterValue("threshold1"), this.params.getDoubleParameterValue("threshold2"), this.params.getDoubleParameterValue("threshold3")}))))) : new double[]{median};
        double minVal = Double.POSITIVE_INFINITY;
        double maxVal = Double.NEGATIVE_INFINITY;
        int numNonNaN = 0;
        for (double d : newScoreData.scores) {
            if (Double.isNaN(d)) continue;
            if (d < minVal) {
                minVal = d;
            }
            if (d > maxVal) {
                maxVal = d;
            }
            ++numNonNaN;
        }
        boolean scoresValid = maxVal > minVal;
        double maxTimePoint = 0.0;
        for (double d : newScoreData.survival) {
            if (Double.isNaN(d) || !(d > maxTimePoint)) continue;
            maxTimePoint = d;
        }
        if (this.panelParams != null && maxTimePoint > ((IntParameter)this.params.getParameters().get("censorTimePoints")).getUpperBound()) {
            this.panelParams.setNumericParameterValueRange("censorTimePoints", 0.0, Math.ceil(maxTimePoint));
        }
        double censorThreshold = this.params == null ? maxTimePoint : (double)this.params.getIntParameterValue("censorTimePoints").intValue();
        boolean pValuesChanged = false;
        if (this.calculateAllPValues) {
            if (this.pValues == null || this.pValueThresholds == null || !newScoreData.equals(this.scoreData) || censorThreshold != this.lastPValueCensorThreshold) {
                int n2;
                TreeMap<Object, Double> mapLogRank = new TreeMap<Object, Double>();
                HashSet<Double> setObserved = new HashSet<Double>();
                for (int i = 0; i < newScoreData.scores.length; ++i) {
                    List<KaplanMeierData> kmsTemp;
                    LogRankTest.LogRankResult test;
                    double pValue;
                    boolean bl;
                    Double d = newScoreData.scores[i];
                    boolean bl2 = bl = !newScoreData.censored[i] && newScoreData.survival[i] < censorThreshold;
                    if (bl) {
                        setObserved.add(d);
                    }
                    if (mapLogRank.containsKey(d) || !Double.isFinite(pValue = (test = LogRankTest.computeLogRankTest((KaplanMeierData)(kmsTemp = KaplanMeierDisplay.splitByThresholds(newScoreData, new double[]{d}, censorThreshold, false)).get(0), (KaplanMeierData)kmsTemp.get(1))).getPValue())) continue;
                    mapLogRank.put(d, pValue);
                }
                this.pValueThresholds = new double[mapLogRank.size()];
                this.pValues = new double[mapLogRank.size()];
                this.pValueThresholdsObserved = new boolean[mapLogRank.size()];
                int count = 0;
                for (Map.Entry entry : mapLogRank.entrySet()) {
                    this.pValueThresholds[count] = (Double)entry.getKey();
                    this.pValues[count] = (Double)entry.getValue();
                    if (setObserved.contains(entry.getKey())) {
                        this.pValueThresholdsObserved[count] = true;
                    }
                    ++count;
                }
                int maxSigCount = 0;
                int n3 = -1;
                int sigCurrent = 0;
                int[] sigCount = new int[this.pValues.length];
                for (int i = 0; i < this.pValues.length; ++i) {
                    if (this.pValues[i] < 0.05) {
                        sigCount[i] = ++sigCurrent;
                        if (sigCurrent <= maxSigCount) continue;
                        maxSigCount = sigCurrent;
                        n2 = i;
                        continue;
                    }
                    sigCurrent = 0;
                }
                if (maxSigCount == 0) {
                    logger.info("No p-values < 0.05");
                } else {
                    double minThresh = n2 - maxSigCount < 0 ? this.pValueThresholds[0] - 1.0E-7 : this.pValueThresholds[n2 - maxSigCount];
                    double maxThresh = this.pValueThresholds[n2];
                    int nBetween = 0;
                    int nBetweenObserved = 0;
                    for (int i = 0; i < newScoreData.scores.length; ++i) {
                        if (!(newScoreData.scores[i] > minThresh) || !(newScoreData.scores[i] <= maxThresh)) continue;
                        ++nBetween;
                        if (!(newScoreData.survival[i] < censorThreshold) || newScoreData.censored[i]) continue;
                        ++nBetweenObserved;
                    }
                    logger.info("Longest stretch of p-values < 0.05: {} - {} ({} entries, {} observed)", new Object[]{minThresh, maxThresh, nBetween, nBetweenObserved});
                }
                this.pValuesSmoothed = new double[this.pValues.length];
                Arrays.fill(this.pValuesSmoothed, Double.NaN);
                int n22 = this.pValues.length / 20 * 2 + 1;
                logger.info("Smoothing log-rank test p-values by " + n22);
                for (int i = n22 / 2; i < this.pValues.length - n22 / 2; ++i) {
                    double sum = 0.0;
                    for (int k = i - n22 / 2; k < i - n22 / 2 + n22; ++k) {
                        sum += this.pValues[k];
                    }
                    this.pValuesSmoothed[i] = sum / (double)n22;
                }
                this.lastPValueCensorThreshold = censorThreshold;
                pValuesChanged = true;
            }
        } else {
            this.lastPValueCensorThreshold = Double.NaN;
            this.pValueThresholds = null;
            this.pValues = null;
        }
        if (this.params != null && this.params.getChoiceParameterValue("scoreThresholdMethod").equals("Lowest p-value")) {
            double[] dArray;
            int bestIdx = -1;
            double bestPValue = Double.POSITIVE_INFINITY;
            for (i = this.pValueThresholds.length / 10; i < this.pValueThresholds.length * 9 / 10; ++i) {
                if (!(this.pValues[i] < bestPValue)) continue;
                bestIdx = i;
                bestPValue = this.pValues[i];
            }
            if (bestIdx >= 0) {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = this.pValueThresholds[bestIdx];
            } else {
                dArray = new double[]{};
            }
            thresholds = dArray;
        } else if (this.params != null && this.params.getChoiceParameterValue("scoreThresholdMethod").equals("Lowest smoothed p-value")) {
            double[] dArray;
            int bestIdx = -1;
            double bestPValue = Double.POSITIVE_INFINITY;
            for (i = this.pValueThresholds.length / 10; i < this.pValueThresholds.length * 9 / 10; ++i) {
                if (!(this.pValuesSmoothed[i] < bestPValue)) continue;
                bestIdx = i;
                bestPValue = this.pValuesSmoothed[i];
            }
            if (bestIdx >= 0) {
                double[] dArray3 = new double[1];
                dArray = dArray3;
                dArray3[0] = this.pValueThresholds[bestIdx];
            } else {
                dArray = new double[]{};
            }
            thresholds = dArray;
        }
        List<KaplanMeierData> kms = KaplanMeierDisplay.splitByThresholds(newScoreData, thresholds, censorThreshold, this.params != null && "Quartiles".equals(this.params.getChoiceParameterValue("scoreThresholdMethod")));
        if (this.plotter == null) {
            this.plotter = new KaplanMeierChartWrapper(this.survivalColumn + " time");
        }
        KaplanMeierData[] kmArray = new KaplanMeierData[kms.size()];
        this.plotter.setKaplanMeierCurves(this.survivalColumn + " time", kms.toArray(kmArray));
        this.tableModel.setSurvivalCurves(thresholds, this.params != null && this.params.getChoiceParameterValue("scoreThresholdMethod").equals("Lowest p-value"), kmArray);
        double barWidth = (2.0 * q3 - q1) * Math.pow(numNonNaN, -0.3333333333333333);
        int n4 = 100;
        if (!Double.isNaN(barWidth)) {
            barWidth = (int)Math.max(16.0, Math.ceil((maxVal - minVal) / barWidth));
        }
        Histogram histogram2 = histogram = scoresValid ? new Histogram(newScoreData.scores, n4) : null;
        if (this.histogramPanel == null) {
            GridPane paneHistogram = new GridPane();
            this.histogramPanel = new HistogramChart();
            this.histogramPanel.setAnimated(false);
            this.histogramWrapper = new ChartThresholdPane((XYChart<Number, Number>)this.histogramPanel);
            for (DoubleProperty val : this.threshProperties) {
                this.histogramWrapper.addThreshold((ObservableNumberValue)val);
            }
            this.histogramWrapper.setPrefHeight(150.0);
            paneHistogram.add((Node)this.histogramWrapper, 0, 0);
            Tooltip.install((Node)this.histogramPanel, (Tooltip)new Tooltip("Distribution of scores"));
            GridPane.setHgrow((Node)this.histogramWrapper, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)this.histogramWrapper, (Priority)Priority.ALWAYS);
            NumberAxis xAxis = new NumberAxis();
            xAxis.setLabel("Score threshold");
            NumberAxis yAxis = new NumberAxis();
            yAxis.setLowerBound(0.0);
            yAxis.setUpperBound(1.0);
            yAxis.setTickUnit(0.1);
            yAxis.setAutoRanging(false);
            yAxis.setLabel("P-value");
            this.chartPValues = new LineChart((Axis)xAxis, (Axis)yAxis);
            this.chartPValues.setAnimated(false);
            this.chartPValues.setLegendVisible(false);
            ChartTools.makeChartInteractive(this.chartPValues, xAxis, yAxis);
            pValuesChanged = true;
            Tooltip.install(this.chartPValues, (Tooltip)new Tooltip("Distribution of p-values (log-rank test) comparing low vs. high for all possible score thresholds"));
            this.pValuesWrapper = new ChartThresholdPane((XYChart<Number, Number>)this.chartPValues);
            for (DoubleProperty val : this.threshProperties) {
                this.pValuesWrapper.addThreshold((ObservableNumberValue)val);
            }
            this.pValuesWrapper.setPrefHeight(150.0);
            paneHistogram.add((Node)this.pValuesWrapper, 0, 1);
            GridPane.setHgrow((Node)this.pValuesWrapper, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)this.pValuesWrapper, (Priority)Priority.ALWAYS);
            ContextMenu popup = new ContextMenu();
            ChartTools.addChartExportMenu(this.chartPValues, popup);
            RadioMenuItem miZoomY1 = new RadioMenuItem("0-1");
            miZoomY1.setOnAction(e -> {
                yAxis.setAutoRanging(false);
                yAxis.setUpperBound(1.0);
                yAxis.setTickUnit(0.2);
            });
            RadioMenuItem miZoomY05 = new RadioMenuItem("0-0.5");
            miZoomY05.setOnAction(e -> {
                yAxis.setAutoRanging(false);
                yAxis.setUpperBound(0.5);
                yAxis.setTickUnit(0.1);
            });
            RadioMenuItem miZoomY02 = new RadioMenuItem("0-0.2");
            miZoomY02.setOnAction(e -> {
                yAxis.setAutoRanging(false);
                yAxis.setUpperBound(0.2);
                yAxis.setTickUnit(0.05);
            });
            RadioMenuItem miZoomY01 = new RadioMenuItem("0-0.1");
            miZoomY01.setOnAction(e -> {
                yAxis.setAutoRanging(false);
                yAxis.setUpperBound(0.1);
                yAxis.setTickUnit(0.05);
            });
            RadioMenuItem miZoomY005 = new RadioMenuItem("0-0.05");
            miZoomY005.setOnAction(e -> {
                yAxis.setAutoRanging(false);
                yAxis.setUpperBound(0.05);
                yAxis.setTickUnit(0.01);
            });
            RadioMenuItem miZoomY001 = new RadioMenuItem("0-0.01");
            miZoomY001.setOnAction(e -> {
                yAxis.setAutoRanging(false);
                yAxis.setUpperBound(0.01);
                yAxis.setTickUnit(0.005);
            });
            ToggleGroup tgZoom = new ToggleGroup();
            miZoomY1.setToggleGroup(tgZoom);
            miZoomY05.setToggleGroup(tgZoom);
            miZoomY02.setToggleGroup(tgZoom);
            miZoomY01.setToggleGroup(tgZoom);
            miZoomY005.setToggleGroup(tgZoom);
            miZoomY001.setToggleGroup(tgZoom);
            Menu menuZoomY = new Menu("Set y-axis range");
            menuZoomY.getItems().addAll((Object[])new MenuItem[]{miZoomY1, miZoomY05, miZoomY02, miZoomY01, miZoomY005, miZoomY001});
            MenuItem miCopyData = new MenuItem("Copy chart data");
            miCopyData.setOnAction(e -> {
                String dataString = ChartTools.getChartDataAsString(this.chartPValues);
                ClipboardContent content = new ClipboardContent();
                content.putString(dataString);
                Clipboard.getSystemClipboard().setContent((Map)content);
            });
            popup.getItems().addAll((Object[])new MenuItem[]{miCopyData, menuZoomY});
            this.chartPValues.setOnContextMenuRequested(e -> popup.show(this.chartPValues, e.getScreenX(), e.getScreenY()));
            int col = 0;
            while (col < this.tableModel.getColumnCount()) {
                TableColumn column = new TableColumn(this.tableModel.getColumnName(col));
                final int colNumber = col++;
                column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Integer, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<Integer, String> p) {
                        return new SimpleStringProperty(KaplanMeierDisplay.this.tableModel.getValueAt((Integer)p.getValue(), colNumber));
                    }
                });
                column.setCellFactory((Callback)new Callback<TableColumn<Integer, String>, TableCell<Integer, String>>(this){

                    public TableCell<Integer, String> call(TableColumn<Integer, String> param) {
                        TableCell<Integer, String> cell = new TableCell<Integer, String>(this){

                            protected void updateItem(String item, boolean empty) {
                                super.updateItem((Object)item, empty);
                                this.setText(item);
                                this.setTooltip(new Tooltip(item));
                            }
                        };
                        return cell;
                    }
                });
                this.table.getColumns().add((Object)column);
            }
            this.table.setPrefHeight(250.0);
            this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            this.table.maxHeightProperty().bind((ObservableValue)this.table.prefHeightProperty());
            this.params = new ParameterList();
            this.params.addIntParameter("censorTimePoints", "Max censored time", (int)(censorThreshold + 0.5), null, 0.0, (double)((int)Math.ceil(maxTimePoint)), "Latest time point beyond which data will be censored");
            if (this.calculateAllPValues) {
                this.params.addChoiceParameter("scoreThresholdMethod", "Threshold method", (Object)"Median", Arrays.asList("Manual (1)", "Manual (2)", "Manual (3)", "Median", "Tertiles", "Quartiles", "Lowest p-value"));
            } else {
                this.params.addChoiceParameter("scoreThresholdMethod", "Threshold method", (Object)"Median", Arrays.asList("Manual (1)", "Manual (2)", "Manual (3)", "Median", "Tertiles", "Quartiles"));
            }
            this.params.addDoubleParameter("threshold1", "Threshold 1", thresholds.length > 0 ? thresholds[0] : (minVal + maxVal) / 2.0, null, "Threshold to distinguish between patient groups");
            this.params.addDoubleParameter("threshold2", "Threshold 2", thresholds.length > 1 ? thresholds[1] : (minVal + maxVal) / 2.0, null, "Threshold to distinguish between patient groups");
            this.params.addDoubleParameter("threshold3", "Threshold 3", thresholds.length > 2 ? thresholds[2] : (minVal + maxVal) / 2.0, null, "Threshold to distinguish between patient groups");
            this.params.addBooleanParameter("showAtRisk", "Show at risk", this.plotter.getShowAtRisk(), "Show number of patients at risk below the plot");
            this.params.addBooleanParameter("showTicks", "Show censored ticks", this.plotter.getShowCensoredTicks(), "Show ticks to indicate censored data");
            this.params.addBooleanParameter("showKey", "Show key", this.plotter.getShowKey(), "Show key indicating display of each curve");
            if (!scoresValid) {
                this.histogramPanel.setVisible(false);
            }
            this.panelParams = new ParameterPanelFX(this.params);
            this.panelParams.addParameterChangeListener(this);
            this.updateThresholdsEnabled();
            for (int i = 0; i < this.threshProperties.length; ++i) {
                String p = "threshold" + (i + 1);
                this.threshProperties[i].addListener((v, o, n) -> {
                    if (this.interactiveThresholds() && !GeneralTools.almostTheSame((double)this.params.getDoubleParameterValue(p), (double)n.doubleValue(), (double)1.0E-4)) {
                        this.panelParams.setNumericParameterValue(p, (Number)n);
                    }
                });
            }
            BorderPane paneBottom = new BorderPane();
            TitledPane paneOptions = new TitledPane("Options", (Node)this.panelParams.getPane());
            StackPane paneCanvas = new StackPane();
            paneCanvas.getChildren().add((Object)this.plotter.getCanvas());
            GridPane paneLeft = new GridPane();
            paneLeft.add((Node)paneOptions, 0, 0);
            paneLeft.add(this.table, 0, 1);
            GridPane.setHgrow((Node)paneOptions, (Priority)Priority.ALWAYS);
            GridPane.setHgrow(this.table, (Priority)Priority.ALWAYS);
            paneBottom.setLeft((Node)paneLeft);
            paneBottom.setCenter((Node)paneHistogram);
            this.paneMain.setCenter((Node)paneCanvas);
            this.paneMain.setBottom((Node)paneBottom);
            this.paneMain.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        } else if (thresholds.length > 0) {
            if (!GeneralTools.almostTheSame((double)thresholds[0], (double)this.params.getDoubleParameterValue("threshold1"), (double)1.0E-4)) {
                this.panelParams.setNumericParameterValue("threshold1", thresholds[0]);
            }
            if (thresholds.length > 1 && !GeneralTools.almostTheSame((double)thresholds[1], (double)this.params.getDoubleParameterValue("threshold2"), (double)1.0E-4)) {
                this.panelParams.setNumericParameterValue("threshold2", thresholds[1]);
            }
            if (thresholds.length > 2 && !GeneralTools.almostTheSame((double)thresholds[2], (double)this.params.getDoubleParameterValue("threshold3"), (double)1.0E-4)) {
                this.panelParams.setNumericParameterValue("threshold3", thresholds[2]);
            }
        }
        if (histogram != null) {
            this.histogramPanel.getHistogramData().setAll((Object[])new HistogramChart.HistogramData[]{HistogramChart.createHistogramData(histogram, (Color)null)});
            this.histogramPanel.getXAxis().setLabel(this.scoreColumn);
            this.histogramPanel.getYAxis().setLabel("Count");
            ChartTools.addChartExportMenu((XYChart<Number, Number>)this.histogramPanel, null);
        }
        if (this.pValues != null) {
            if (pValuesChanged) {
                ObservableList data = FXCollections.observableArrayList();
                for (int i = 0; i < this.pValueThresholds.length; ++i) {
                    double pValue = this.pValues[i];
                    if (Double.isNaN(pValue)) continue;
                    data.add((Object)new XYChart.Data((Object)this.pValueThresholds[i], (Object)pValue, (Object)this.pValueThresholdsObserved[i]));
                }
                ObservableList dataSmoothed = null;
                if (this.pValuesSmoothed != null) {
                    dataSmoothed = FXCollections.observableArrayList();
                    for (int i = 0; i < this.pValueThresholds.length; ++i) {
                        double pValueSmoothed = this.pValuesSmoothed[i];
                        if (Double.isNaN(pValueSmoothed)) continue;
                        dataSmoothed.add((Object)new XYChart.Data((Object)this.pValueThresholds[i], (Object)pValueSmoothed));
                    }
                }
                this.chartPValues.getData().setAll((Object[])new XYChart.Series[]{new XYChart.Series("P-values", data)});
                if (this.pValueThresholds.length > 1) {
                    XYChart.Data sigData1 = new XYChart.Data((Object)this.pValueThresholds[0], (Object)0.05);
                    XYChart.Data sigData2 = new XYChart.Data((Object)this.pValueThresholds[this.pValueThresholds.length - 1], (Object)0.05);
                    XYChart.Series dataSignificant = new XYChart.Series("Significance 0.05", FXCollections.observableArrayList((Object[])new XYChart.Data[]{sigData1, sigData2}));
                    this.chartPValues.getData().add((Object)dataSignificant);
                    sigData1.getNode().setVisible(false);
                    sigData2.getNode().setVisible(false);
                }
                for (XYChart.Data dataPoint : data) {
                    if (Boolean.TRUE.equals(dataPoint.getExtraValue())) continue;
                    dataPoint.getNode().setVisible(false);
                }
            }
            for (int i = 0; i < this.threshProperties.length; ++i) {
                if (i < thresholds.length) {
                    this.threshProperties[i].set(thresholds[i]);
                    continue;
                }
                this.threshProperties[i].set(Double.NaN);
            }
            boolean isInteractive = this.interactiveThresholds();
            this.histogramWrapper.setIsInteractive(isInteractive);
            this.pValuesWrapper.setIsInteractive(isInteractive);
            this.chartPValues.setVisible(true);
        }
        this.scoreData = newScoreData;
    }

    static List<KaplanMeierData> splitByThresholds(ScoreData scoreData, double[] thresholds, double censorThreshold, boolean usesQuartiles) {
        int i;
        ArrayList<KaplanMeierData> kms = new ArrayList<KaplanMeierData>();
        int nThresholds = thresholds.length;
        double[] sortedThresholds = (double[])thresholds.clone();
        Arrays.sort(sortedThresholds);
        for (i = 0; i <= nThresholds; ++i) {
            if (nThresholds == 0) {
                kms.add(new KaplanMeierData("All"));
                continue;
            }
            if (nThresholds == 1) {
                kms.add(new KaplanMeierData(i == 0 ? "Low" : "High"));
                continue;
            }
            if (nThresholds == 2 && sortedThresholds[0] < sortedThresholds[1]) {
                kms.add(new KaplanMeierData(i == 0 ? "Low" : (i == 1 ? "Moderate" : "High")));
                continue;
            }
            if (usesQuartiles) {
                kms.add(new KaplanMeierData("Quartile " + (i + 1)));
                continue;
            }
            if (i == 0) {
                kms.add(new KaplanMeierData(String.format("x < %.2f", sortedThresholds[i])));
                continue;
            }
            if (i == nThresholds) {
                kms.add(new KaplanMeierData(String.format("x >= %.2f", sortedThresholds[i - 1])));
                continue;
            }
            kms.add(new KaplanMeierData(String.format("%.2f <= x < %.2f", sortedThresholds[i - 1], sortedThresholds[i])));
        }
        for (i = 0; i < scoreData.survival.length; ++i) {
            int t;
            double surv;
            double s = scoreData.scores[i];
            if (Double.isNaN(s) || Double.isNaN(surv = scoreData.survival[i])) continue;
            for (t = sortedThresholds.length; t > 0 && !(s >= sortedThresholds[t - 1]); --t) {
            }
            if (censorThreshold > 0.0 && surv > censorThreshold) {
                ((KaplanMeierData)kms.get(t)).addEvent(censorThreshold, true);
                continue;
            }
            ((KaplanMeierData)kms.get(t)).addEvent(surv, scoreData.censored[i]);
        }
        return kms;
    }

    static double[] calculateOptimalExtremePositiveNegativeThresholds(ScoreData scoreData, double censorThreshold) {
        double t1;
        double[] thresholds = (double[])scoreData.scores.clone();
        Arrays.sort(thresholds);
        double t1Optimal = Double.NaN;
        double t2Optimal = Double.NaN;
        double bestP = Double.POSITIVE_INFINITY;
        double bestPSplit = Double.POSITIVE_INFINITY;
        int g1 = 0;
        int g2 = 0;
        int g3 = 0;
        int skip = thresholds.length / 10;
        double median = thresholds[thresholds.length / 2];
        for (int i = skip; i < thresholds.length - skip && !((t1 = thresholds[i]) > median); ++i) {
            for (int j = i + 1; j < thresholds.length - skip; ++j) {
                double split;
                double t2 = thresholds[j];
                if (t2 < median) continue;
                List<KaplanMeierData> kmsTemp = KaplanMeierDisplay.splitByThresholds(scoreData, new double[]{t1, t2}, censorThreshold, false);
                kmsTemp.get(0).addEvents((Collection)kmsTemp.get(2).getEvents());
                LogRankTest.LogRankResult test = LogRankTest.computeLogRankTest((KaplanMeierData)kmsTemp.get(0), (KaplanMeierData)kmsTemp.get(1));
                double pValue = test.getPValue();
                if (!(pValue < bestP) || !(Math.abs((split = (double)kmsTemp.get(0).nEvents() / (double)(kmsTemp.get(0).nEvents() + kmsTemp.get(1).nEvents())) - 0.5) < bestPSplit)) continue;
                bestP = pValue;
                bestPSplit = split;
                t1Optimal = t1;
                t2Optimal = t2;
                g3 = kmsTemp.get(2).getEvents().size();
                g2 = kmsTemp.get(1).getEvents().size();
                g1 = kmsTemp.get(0).getEvents().size() - g3;
            }
        }
        logger.info("Optimal split thresholds: {} and {} (p-value {}; group sizes {}, {} and {})", new Object[]{t1Optimal, t2Optimal, bestP, g1, g2, g3});
        return new double[]{bestP, t1Optimal, t2Optimal};
    }

    private boolean interactiveThresholds() {
        return this.params != null && Arrays.asList("Manual (1)", "Manual (2)", "Manual (3)").contains(this.params.getChoiceParameterValue("scoreThresholdMethod"));
    }

    public void parameterChanged(ParameterList parameterList, String key, boolean isAdjusting) {
        if ("showTicks".equals(key)) {
            this.plotter.setShowCensoredTicks(parameterList.getBooleanParameterValue("showTicks"));
            return;
        }
        if ("showKey".equals(key)) {
            this.plotter.setShowKey(parameterList.getBooleanParameterValue("showKey"));
            return;
        }
        if ("showAtRisk".equals(key)) {
            this.plotter.setShowAtRisk(parameterList.getBooleanParameterValue("showAtRisk"));
            return;
        }
        if ("scoreThresholdMethod".equals(key)) {
            this.updateThresholdsEnabled();
        }
        this.generatePlot();
    }

    private void updateThresholdsEnabled() {
        Object value = this.panelParams.getParameters().getChoiceParameterValue("scoreThresholdMethod");
        if ("Manual (1)".equals(value)) {
            this.panelParams.setParameterEnabled("threshold1", true);
            this.panelParams.setParameterEnabled("threshold2", false);
            this.panelParams.setParameterEnabled("threshold3", false);
        } else if ("Manual (2)".equals(value)) {
            this.panelParams.setParameterEnabled("threshold1", true);
            this.panelParams.setParameterEnabled("threshold2", true);
            this.panelParams.setParameterEnabled("threshold3", false);
        } else if ("Manual (3)".equals(value)) {
            this.panelParams.setParameterEnabled("threshold1", true);
            this.panelParams.setParameterEnabled("threshold2", true);
            this.panelParams.setParameterEnabled("threshold3", true);
        } else {
            this.panelParams.setParameterEnabled("threshold1", false);
            this.panelParams.setParameterEnabled("threshold2", false);
            this.panelParams.setParameterEnabled("threshold3", false);
        }
    }

    static String getLogRankComparisonName(String conditionA, String conditionB) {
        return String.format("%s vs %s log-rank (HR)", conditionA, conditionB);
    }

    static class KaplanMeierTableModel {
        private static DecimalFormat df2 = new DecimalFormat("#.##");
        private static DecimalFormat df4 = new DecimalFormat("#.####");
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();
        private TableView<Integer> table;

        KaplanMeierTableModel(TableView<Integer> table) {
            this.table = table;
        }

        void setSurvivalCurves(double[] thresholds, boolean correctPValues, KaplanMeierData ... kms) {
            this.names.clear();
            this.values.clear();
            if (kms.length == 0) {
                return;
            }
            boolean multipleThresholds = thresholds.length > 1;
            int count = 0;
            for (double t : thresholds) {
                ++count;
                if (multipleThresholds) {
                    this.names.add("Score threshold " + count);
                } else {
                    this.names.add("Score threshold");
                }
                this.values.add(df2.format(t));
            }
            this.names.add("Max time");
            double maxTime = Double.NEGATIVE_INFINITY;
            int nEvents = 0;
            int nObserved = 0;
            int nCensored = 0;
            for (KaplanMeierData km : kms) {
                maxTime = Math.max(maxTime, km.getMaxTime());
                nEvents += km.nEvents();
                nObserved += km.nObserved();
                nCensored += km.nCensored();
            }
            this.values.add(df2.format(maxTime));
            this.names.add("Total events");
            this.values.add(Integer.toString(nEvents));
            this.names.add("Num observed");
            this.values.add(Integer.toString(nObserved));
            this.names.add("Num censored");
            this.values.add(Integer.toString(nCensored));
            for (KaplanMeierData km : kms) {
                this.names.add(km.getName());
                this.values.add(km.nEvents() + " (" + km.nObserved() + " observed)");
            }
            for (int i = 0; i < kms.length; ++i) {
                for (int j = i + 1; j < kms.length; ++j) {
                    KaplanMeierData km1 = kms[i];
                    KaplanMeierData km2 = kms[j];
                    LogRankTest.LogRankResult logRankResult = LogRankTest.computeLogRankTest((KaplanMeierData)km1, (KaplanMeierData)km2);
                    this.names.add(KaplanMeierDisplay.getLogRankComparisonName(km1.getName(), km2.getName()));
                    this.values.add(logRankResult.getResultString());
                    double pValue = logRankResult.getPValue();
                    if (!correctPValues) continue;
                    this.names.add("Log-rank (corrected P-value, e=0.1)");
                    double pValueAdjustedQuick = -1.63 * pValue * (1.0 + 2.35 * Math.log(pValue));
                    double epsilon = 0.1;
                    double z = 1.0 - pValue / 2.0;
                    NormalDistribution dist = new NormalDistribution();
                    z = dist.inverseCumulativeProbability(1.0 - pValue / 2.0);
                    double phi = dist.density(z);
                    double pValueAdjusted = phi * (z - 1.0 / z) * Math.log((1.0 - epsilon) * (1.0 - epsilon) / (epsilon * epsilon)) + 4.0 * phi / z;
                    this.values.add(df4.format(pValueAdjusted));
                    logger.info("Original P-value: {}", (Object)pValue);
                    logger.info("Quick adjusted P-value (epsilon = {}): {}", (Object)epsilon, (Object)pValueAdjustedQuick);
                    logger.info("Full adjusted P-value (epsilon = {}): {}", (Object)epsilon, (Object)pValueAdjusted);
                }
            }
            if (kms.length == 3) {
                KaplanMeierData kmExtreme = new KaplanMeierData("Low+High");
                kmExtreme.addEvents((Collection)kms[0].getEvents());
                kmExtreme.addEvents((Collection)kms[2].getEvents());
                LogRankTest.LogRankResult logRankResult = LogRankTest.computeLogRankTest((KaplanMeierData)kmExtreme, (KaplanMeierData)kms[1]);
                this.names.add(KaplanMeierDisplay.getLogRankComparisonName(kmExtreme.getName(), kms[1].getName()));
                this.values.add(logRankResult.getResultString());
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < this.getRowCount(); ++i) {
                list.add(i);
            }
            this.table.getItems().setAll(list);
        }

        public int getRowCount() {
            return this.names.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Name";
            }
            return "Value";
        }

        public String getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.names.get(rowIndex);
            }
            return this.values.get(rowIndex);
        }
    }

    private static class ScoreData {
        double[] scores;
        double[] survival;
        boolean[] censored;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.censored);
            result = 31 * result + Arrays.hashCode(this.scores);
            result = 31 * result + Arrays.hashCode(this.survival);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScoreData other = (ScoreData)obj;
            if (!Arrays.equals(this.censored, other.censored)) {
                return false;
            }
            if (!Arrays.equals(this.scores, other.scores)) {
                return false;
            }
            return Arrays.equals(this.survival, other.survival);
        }

        ScoreData(double[] scores, double[] survival, boolean[] censored) {
            this.scores = scores;
            this.survival = survival;
            this.censored = censored;
        }
    }
}

