/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Chart;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Transform;
import javafx.util.StringConverter;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.survival.KaplanMeierData;
import qupath.lib.analysis.stats.survival.LogRankTest;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.charts.ChartTools;

class KaplanMeierChartWrapper {
    private static final Logger logger = LoggerFactory.getLogger(KaplanMeierChartWrapper.class);
    private List<KaplanMeierData> kmList = new ArrayList<KaplanMeierData>();
    private NumberAxis xAxis = new NumberAxis();
    private NumberAxis yAxis = new NumberAxis();
    private KaplanMeierChart chart = new KaplanMeierChart((Axis<Number>)this.xAxis, (Axis<Number>)this.yAxis);
    private BooleanProperty showAtRisk = new SimpleBooleanProperty(false);

    KaplanMeierChartWrapper(String survivalKey) {
        this.yAxis.setTickUnit(0.1);
        this.yAxis.setLabel("Probability");
        this.xAxis.setLabel(survivalKey);
        this.xAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number object) {
                double d = object.doubleValue();
                Object s = GeneralTools.formatNumber((double)d, (int)2);
                if (KaplanMeierChartWrapper.this.showAtRisk.get()) {
                    s = (String)s + (d == 0.0 ? "\n-At risk-" : "\n---");
                    for (KaplanMeierData kmData : KaplanMeierChartWrapper.this.kmList) {
                        if (d == 0.0) {
                            s = (String)s + "\n" + kmData.getName() + ": " + kmData.getAtRisk(d);
                            continue;
                        }
                        s = (String)s + "\n" + kmData.getAtRisk(d - 1.0E-4);
                    }
                }
                return s;
            }

            public Number fromString(String s) {
                if (s == null) {
                    return null;
                }
                return Double.parseDouble(s.split("\n")[0]);
            }
        });
        this.xAxis.getTickMarks().addListener(v -> {
            for (Node node : this.xAxis.getChildrenUnmodifiable()) {
                if (!(node instanceof Text)) continue;
                Text text = (Text)node;
                text.setTextAlignment(TextAlignment.CENTER);
            }
        });
        this.showAtRisk.addListener((v, o, n) -> {
            this.updateChart();
            this.chart.layout();
        });
        ContextMenu menu = new ContextMenu();
        Menu menuLegendSide = new Menu("Set legend...");
        ToggleGroup toggleSide = new ToggleGroup();
        Action actionNoLegend = new Action("None", e -> this.chart.setLegendVisible(false));
        RadioMenuItem riNone = ActionUtils.createRadioMenuItem((Action)actionNoLegend);
        menuLegendSide.getItems().add((Object)riNone);
        toggleSide.getToggles().add((Object)riNone);
        RadioMenuItem riTop = ActionUtils.createRadioMenuItem((Action)new Action("Top", e -> {
            this.chart.setLegendSide(Side.TOP);
            this.chart.setLegendVisible(true);
        }));
        menuLegendSide.getItems().add((Object)riTop);
        toggleSide.getToggles().add((Object)riTop);
        RadioMenuItem riBottom = ActionUtils.createRadioMenuItem((Action)new Action("Bottom", e -> {
            this.chart.setLegendSide(Side.BOTTOM);
            this.chart.setLegendVisible(true);
        }));
        menuLegendSide.getItems().add((Object)riBottom);
        toggleSide.getToggles().add((Object)riBottom);
        RadioMenuItem riRight = ActionUtils.createRadioMenuItem((Action)new Action("Right", e -> {
            this.chart.setLegendSide(Side.RIGHT);
            this.chart.setLegendVisible(true);
        }));
        menuLegendSide.getItems().add((Object)riRight);
        toggleSide.getToggles().add((Object)riRight);
        RadioMenuItem riLeft = ActionUtils.createRadioMenuItem((Action)new Action("Left", e -> {
            this.chart.setLegendSide(Side.LEFT);
            this.chart.setLegendVisible(true);
        }));
        menuLegendSide.getItems().add((Object)riLeft);
        toggleSide.getToggles().add((Object)riLeft);
        toggleSide.selectToggle((Toggle)riRight);
        this.chart.createSymbolsProperty().addListener((v, o, n) -> this.updateChart());
        ChartTools.expandChartClip((Chart)this.chart, 5.0);
        MenuItem miCopyPanel = new MenuItem("Entire panel");
        miCopyPanel.setOnAction(e -> {
            double scale = 2.0;
            Region region = (Region)this.chart.getParent().getParent();
            int w = (int)(region.getWidth() * scale + 0.5);
            int h = (int)(region.getHeight() * scale + 0.5);
            SnapshotParameters params = new SnapshotParameters();
            params.setTransform((Transform)Transform.scale((double)scale, (double)scale));
            WritableImage img = region.snapshot(params, new WritableImage(w, h));
            ClipboardContent content = new ClipboardContent();
            content.putImage((Image)img);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        MenuItem miCopy = new MenuItem("Chart only");
        miCopy.setOnAction(e -> {
            double scale = 4.0;
            KaplanMeierChart region = this.chart;
            int w = (int)(region.getWidth() * scale + 0.5);
            int h = (int)(region.getHeight() * scale + 0.5);
            SnapshotParameters params = new SnapshotParameters();
            params.setTransform((Transform)Transform.scale((double)scale, (double)scale));
            WritableImage img = region.snapshot(params, new WritableImage(w, h));
            ClipboardContent content = new ClipboardContent();
            content.putImage((Image)img);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        Menu menuCopy = new Menu("Copy...");
        menuCopy.getItems().addAll((Object[])new MenuItem[]{miCopy, miCopyPanel});
        MenuItem miPrint = new MenuItem("Print (experimental)");
        miPrint.setOnAction(e -> {
            boolean success;
            PrinterJob job = PrinterJob.createPrinterJob();
            logger.warn("Printing does not yet work properly! (At least not on OSX)");
            if (job != null && job.showPrintDialog(this.chart.getScene().getWindow()) && (success = job.printPage((Node)this.chart.getParent().getParent()))) {
                job.endJob();
            }
        });
        menu.getItems().addAll((Object[])new MenuItem[]{menuLegendSide, menuCopy, miPrint});
        this.chart.setOnContextMenuRequested(e -> menu.show((Node)this.chart, e.getScreenX(), e.getScreenY()));
    }

    KaplanMeierChartWrapper addKaplanMeier(KaplanMeierData km) {
        this.kmList.add(km);
        return this;
    }

    KaplanMeierChartWrapper setKaplanMeierCurves(String survivalKey, KaplanMeierData ... kms) {
        this.kmList.clear();
        double maxTime = 0.0;
        for (KaplanMeierData km : kms) {
            this.kmList.add(km);
            maxTime = Math.max(maxTime, km.getMaxTime());
        }
        this.xAxis.setAutoRanging(false);
        this.xAxis.setLowerBound(0.0);
        this.xAxis.setUpperBound(maxTime);
        this.xAxis.setLabel(survivalKey);
        this.yAxis.setAutoRanging(false);
        this.yAxis.setLowerBound(0.0);
        this.yAxis.setUpperBound(1.0);
        this.chart.setLegendSide(Side.RIGHT);
        this.updateChart();
        return this;
    }

    public Node getCanvas() {
        return this.chart;
    }

    public void setShowKey(boolean showKey) {
        this.chart.setLegendVisible(showKey);
    }

    public boolean getShowKey() {
        return this.chart.isLegendVisible();
    }

    public boolean getShowAtRisk() {
        return this.showAtRisk.get();
    }

    public void setShowAtRisk(boolean show) {
        this.showAtRisk.set(show);
    }

    public boolean getShowCensoredTicks() {
        return this.chart.getCreateSymbols();
    }

    public void setShowCensoredTicks(boolean showTicks) {
        this.chart.setCreateSymbols(showTicks);
    }

    void updateChart() {
        double maxTime = -1.0;
        for (KaplanMeierData kaplanMeierData : this.kmList) {
            maxTime = Math.max(maxTime, kaplanMeierData.getMaxTime());
        }
        if (maxTime < 0.0) {
            return;
        }
        this.chart.setAnimated(false);
        int count = 0;
        for (KaplanMeierData km : this.kmList) {
            XYChart.Series series = new XYChart.Series();
            series.setName(km.getName());
            double[] times = km.getAllTimes();
            double[] stats = km.getStatistic();
            double x1 = 0.0;
            double y1 = 1.0;
            series.getData().add((Object)new XYChart.Data((Object)x1, (Object)y1));
            for (int i = 0; i < times.length; ++i) {
                double x2 = times[i];
                double y2 = stats[i];
                XYChart.Data data = new XYChart.Data((Object)x2, (Object)y1);
                series.getData().add((Object)data);
                if (y1 != y2) {
                    data = new XYChart.Data((Object)x2, (Object)y2);
                    data.setExtraValue((Object)Boolean.FALSE);
                    series.getData().add((Object)data);
                } else {
                    data.setExtraValue((Object)Boolean.TRUE);
                }
                x1 = x2;
                y1 = y2;
            }
            if (count < this.chart.getData().size()) {
                this.chart.getData().set(count, (Object)series);
            } else {
                this.chart.getData().add((Object)series);
            }
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                if (node == null) continue;
                if (data.getExtraValue() == Boolean.TRUE) {
                    ((StackPane)node).setPrefWidth(2.0);
                    continue;
                }
                if (data.getNode() == null) continue;
                node.setVisible(false);
            }
            ++count;
        }
        while (count < this.chart.getData().size()) {
            this.chart.getData().remove(count);
        }
        if (this.kmList.size() == 2) {
            logRankResult = LogRankTest.computeLogRankTest((KaplanMeierData)this.kmList.get(0), (KaplanMeierData)this.kmList.get(1));
            String pValueString = "p = " + GeneralTools.formatNumber((double)logRankResult.getPValue(), (int)3);
            XYChart.Series series = new XYChart.Series();
            series.setName(pValueString);
            series.setNode(null);
            this.chart.getData().add((Object)series);
        } else if (this.kmList.size() == 3) {
            logRankResult = LogRankTest.computeLogRankTest((KaplanMeierData)this.kmList.get(0), (KaplanMeierData)this.kmList.get(1));
            XYChart.Series series = new XYChart.Series();
            series.nameProperty().bind((ObservableValue)((XYChart.Series)this.chart.getData().get(0)).nameProperty().concat((Object)" vs ").concat((Object)((XYChart.Series)this.chart.getData().get(1)).nameProperty()).concat((Object)String.format(": p = %.4f", logRankResult.getPValue())));
            series.setNode(null);
            this.chart.getData().add((Object)series);
            logRankResult = LogRankTest.computeLogRankTest((KaplanMeierData)this.kmList.get(0), (KaplanMeierData)this.kmList.get(2));
            XYChart.Series series2 = new XYChart.Series();
            series2.nameProperty().bind((ObservableValue)((XYChart.Series)this.chart.getData().get(0)).nameProperty().concat((Object)" vs ").concat((Object)((XYChart.Series)this.chart.getData().get(2)).nameProperty()).concat((Object)String.format(": p = %.4f", logRankResult.getPValue())));
            series2.setNode(null);
            this.chart.getData().add((Object)series2);
            logRankResult = LogRankTest.computeLogRankTest((KaplanMeierData)this.kmList.get(1), (KaplanMeierData)this.kmList.get(2));
            XYChart.Series series3 = new XYChart.Series();
            series3.nameProperty().bind((ObservableValue)((XYChart.Series)this.chart.getData().get(1)).nameProperty().concat((Object)" vs ").concat((Object)((XYChart.Series)this.chart.getData().get(2)).nameProperty()).concat((Object)String.format(": p = %.4f", logRankResult.getPValue())));
            series3.setNode(null);
            this.chart.getData().add((Object)series3);
        }
    }

    static class KaplanMeierChart
    extends LineChart<Number, Number> {
        public KaplanMeierChart(Axis<Number> xAxis, Axis<Number> yAxis) {
            super(xAxis, yAxis);
        }

        protected void updateLegend() {
            super.updateLegend();
            if (this.getLegend() instanceof TilePane) {
                TilePane tp = (TilePane)this.getLegend();
                tp.setTranslateX(0.0);
                tp.setOrientation(Orientation.VERTICAL);
            }
            block0: for (Node node : ((Pane)this.getLegend()).getChildren()) {
                if (!(node instanceof Label)) continue;
                Label label = (Label)node;
                String name = label.getText();
                for (XYChart.Series series : this.getData()) {
                    if (!series.getName().equals(name)) continue;
                    if (series.getData().isEmpty()) {
                        label.setGraphic(null);
                        label.setMaxWidth(Double.MAX_VALUE);
                        continue block0;
                    }
                    label.setContentDisplay(ContentDisplay.LEFT);
                    continue block0;
                }
            }
        }
    }
}

