/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Screen;
import org.controlsfx.control.PopOver;
import qupath.lib.gui.tma.TMAEntries;
import qupath.lib.gui.tma.TMAImageCache;
import qupath.lib.gui.tools.GuiTools;

class ImageTableCell
extends TreeTableCell<TMAEntries.TMAEntry, TMAEntries.TMAEntry> {
    private final Canvas canvas = new Canvas();
    private TMAImageCache cache;
    private boolean isOverlay;
    private PopOver popOver = null;
    private ContextMenu menu = new ContextMenu();
    private MenuItem miCopy = new MenuItem("Copy");
    private Image img;

    public ImageTableCell(TMAImageCache cache, boolean isOverlay) {
        this.cache = cache;
        this.isOverlay = isOverlay;
        this.canvas.setStyle("-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.5), 4, 0, 1, 1);");
        this.canvas.setWidth(100.0);
        this.canvas.setHeight(100.0);
        this.canvas.heightProperty().bind((ObservableValue)this.canvas.widthProperty());
        this.menu.getItems().add((Object)this.miCopy);
    }

    protected void updateItem(TMAEntries.TMAEntry item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.popOver = null;
        if (item == null || empty) {
            this.setGraphic(null);
            this.img = null;
            return;
        }
        double w = this.getTableColumn().getWidth() - 10.0;
        Image image = this.img = this.isOverlay ? this.cache.getOverlay(item, w) : this.cache.getImage(item, w);
        if (this.img == null) {
            this.setGraphic(null);
            this.img = null;
            return;
        }
        this.canvas.setWidth(w);
        this.setGraphic((Node)this.canvas);
        this.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                if (this.popOver == null) {
                    this.createPopOver(item, this.isOverlay);
                }
                if (this.popOver != null) {
                    this.popOver.show((Node)this);
                }
            }
        });
        this.setContentDisplay(ContentDisplay.CENTER);
        this.setAlignment(Pos.CENTER);
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, w, w);
        this.img = this.isOverlay ? this.cache.getOverlay(item, w) : this.cache.getImage(item, w);
        GuiTools.paintImage(this.canvas, this.img);
    }

    private void createPopOver(TMAEntries.TMAEntry entry, boolean isOverlay) {
        String name;
        Image image;
        Image image2 = image = isOverlay ? this.cache.getOverlay(entry, -1.0) : this.cache.getImage(entry, -1.0);
        if (image == null) {
            return;
        }
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        imageView.setFitWidth(Math.min(primaryScreenBounds.getWidth() * 0.5, image.getWidth()));
        imageView.setFitHeight(Math.min(primaryScreenBounds.getHeight() * 0.75, image.getHeight()));
        this.miCopy.setOnAction(e -> {
            ClipboardContent content = new ClipboardContent();
            content.putImage(image);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        imageView.setOnContextMenuRequested(e -> this.menu.show((Node)this, e.getScreenX(), e.getScreenY()));
        this.popOver = new PopOver((Node)imageView);
        String string = name = this.getTreeTableRow().getItem() == null ? null : ((TMAEntries.TMAEntry)this.getTreeTableRow().getItem()).getName();
        if (name != null) {
            this.popOver.setTitle(name);
        }
    }
}

