/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import qupath.lib.gui.tma.TMAEntries;
import qupath.lib.gui.tma.TMAImageCache;
import qupath.lib.gui.tools.GuiTools;

class ImageListCell
extends ListCell<TMAEntries.TMAEntry> {
    private final TMAImageCache imageCache;
    private final Canvas canvas = new Canvas();
    private final ObservableValue<Boolean> showOverlay;
    private Image img;

    public ImageListCell(ObservableValue<Boolean> showOverlay, TMAImageCache imageCache) {
        this.showOverlay = showOverlay;
        this.imageCache = imageCache;
        this.canvas.setStyle("-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.5), 4, 0, 1, 1);");
        this.canvas.setWidth(250.0);
        this.canvas.setHeight(250.0);
        this.canvas.heightProperty().bind((ObservableValue)this.canvas.widthProperty());
    }

    protected void updateItem(TMAEntries.TMAEntry entry, boolean empty) {
        super.updateItem((Object)entry, empty);
        if (entry == null || empty) {
            this.setGraphic(null);
            this.setTooltip(null);
            this.img = null;
            return;
        }
        double w = this.getListView().getWidth() - 40.0;
        if (w <= 0.0) {
            this.setGraphic(null);
            return;
        }
        if (((Boolean)this.showOverlay.getValue()).booleanValue()) {
            if (!entry.hasOverlay()) {
                this.setGraphic(null);
                return;
            }
            this.img = this.imageCache.getOverlay(entry, w);
        } else {
            if (!entry.hasImage()) {
                this.setGraphic(null);
                return;
            }
            this.img = this.imageCache.getImage(entry, w);
        }
        this.canvas.setWidth(w);
        this.setGraphic((Node)this.canvas);
        this.setContentDisplay(ContentDisplay.CENTER);
        this.setAlignment(Pos.CENTER);
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, w, w);
        if (this.img == null) {
            return;
        }
        if (this.img != null) {
            GuiTools.paintImage(this.canvas, this.img);
        }
    }
}

