/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tma;

import java.io.File;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.tma.TMASummaryViewer;

class DragDropTMADataImportListener
implements EventHandler<DragEvent> {
    private static final Logger logger = LoggerFactory.getLogger(DragDropTMADataImportListener.class);
    private TMASummaryViewer tmaViewer;

    public DragDropTMADataImportListener(TMASummaryViewer tmaViewer) {
        this.tmaViewer = tmaViewer;
        this.setupTarget(tmaViewer.getStage().getScene());
    }

    void setupTarget(Scene target) {
        target.setOnDragOver((EventHandler)new EventHandler<DragEvent>(this){

            public void handle(DragEvent event) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                event.consume();
            }
        });
        target.setOnDragDropped((EventHandler)this);
    }

    public void handle(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        Object source = event.getSource();
        if (dragboard.hasFiles()) {
            logger.debug("Files dragged onto {}", source);
            this.handleFileDrop(this.tmaViewer, dragboard.getFiles());
        }
        event.setDropCompleted(true);
        event.consume();
    }

    void handleFileDrop(TMASummaryViewer tmaViewer, List<File> list) {
        if (list.isEmpty()) {
            logger.warn("No files selected for import");
            return;
        }
        if (list.size() > 1) {
            Dialogs.showErrorMessage((String)"TMA data viewer", (String)"Only one file or directory can be selected for import");
            return;
        }
        tmaViewer.setInputFile(list.get(0));
    }
}

