/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import qupath.lib.gui.scripting.syntax.GeneralCodeSyntax;

class YamlSyntax
extends GeneralCodeSyntax {
    private static final Logger logger = LoggerFactory.getLogger(YamlSyntax.class);

    YamlSyntax() {
    }

    @Override
    public String getLineCommentString() {
        return "#";
    }

    @Override
    public String beautify(String text) {
        try {
            DumperOptions options = new DumperOptions();
            options.setPrettyFlow(true);
            Yaml yaml = new Yaml(options);
            Object obj = yaml.load(text);
            return yaml.dump(obj);
        }
        catch (Exception ex) {
            logger.warn("Could not beautify this YAML text", (Throwable)ex);
            return text;
        }
    }

    @Override
    public boolean canBeautify() {
        return true;
    }

    @Override
    public boolean canCompress() {
        return true;
    }

    @Override
    public String compress(String text) {
        try {
            Yaml yaml = new Yaml();
            Object obj = yaml.load(text);
            return yaml.dump(obj);
        }
        catch (Exception ex) {
            logger.warn("Could not compress this YAML text", (Throwable)ex);
            return text;
        }
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("yaml");
    }
}

