/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.scripting.EditableText;
import qupath.lib.gui.scripting.syntax.GeneralCodeSyntax;

class XmlSyntax
extends GeneralCodeSyntax {
    private static final Logger logger = LoggerFactory.getLogger(XmlSyntax.class);
    private static String trimWhitespace = "<?xml version=\"1.0\"?>\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n    <xsl:output indent=\"no\" />\n    <xsl:strip-space elements=\"*\"/>\n    <xsl:template match=\"@*|node()\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"@*|node()\"/>\n        </xsl:copy>\n    </xsl:template>\n</xsl:stylesheet>";

    XmlSyntax() {
    }

    @Override
    public void handleLineComment(EditableText control) {
        String text = control.getText();
        int rangeStart = control.getSelectionStart();
        int rangeEnd = control.getSelectionEnd();
        int rangeLength = control.getSelectionLength();
        boolean hasSelection = rangeLength > 0;
        boolean hasMultilineSelection = hasSelection && control.getSelectedText().contains("\n");
        String textBetween = control.getSelectedText();
        if (hasSelection && !hasMultilineSelection && !textBetween.startsWith("<!--") && !textBetween.startsWith("-->")) {
            String newText = "<!--" + textBetween + "-->";
            control.replaceSelection(newText);
            control.selectRange(rangeStart, rangeStart + newText.length());
        } else {
            int endRowPos;
            int startRowPos = this.getRowStartPosition(text, rangeStart);
            textBetween = text.substring(startRowPos, endRowPos = this.getRowEndPosition(text, rangeEnd));
            if (textBetween.trim().startsWith("<!--") && textBetween.trim().endsWith("-->")) {
                int indStart2 = textBetween.indexOf("<!--");
                int indEnd2 = textBetween.lastIndexOf("-->");
                endRowPos = startRowPos + indEnd2 + 3;
                startRowPos += indStart2;
                if (indEnd2 > indStart2 + 4) {
                    control.selectRange(startRowPos, endRowPos);
                    String newText = textBetween.substring(indStart2 + 4, indEnd2);
                    control.replaceSelection(newText);
                    control.selectRange(startRowPos, startRowPos + newText.length());
                }
            } else {
                String newText = "<!--" + textBetween + "-->";
                control.selectRange(startRowPos, endRowPos);
                control.replaceSelection(newText);
                control.selectRange(startRowPos, startRowPos + newText.length());
            }
        }
    }

    private static Transformer createTransformer(boolean indent) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(trimWhitespace)));
        if (indent) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return transformer;
    }

    private static String applyTransform(Transformer transformer, String text) throws TransformerException {
        StreamSource source = new StreamSource(new StringReader(text));
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    @Override
    public String beautify(String text) {
        try {
            Transformer transformer = XmlSyntax.createTransformer(true);
            return XmlSyntax.applyTransform(transformer, text);
        }
        catch (Exception ex) {
            logger.warn("Could not beautify this XML", (Throwable)ex);
            return text;
        }
    }

    @Override
    public boolean canBeautify() {
        return true;
    }

    @Override
    public boolean canCompress() {
        return true;
    }

    @Override
    public String compress(String text) {
        try {
            Transformer transformer = XmlSyntax.createTransformer(false);
            return XmlSyntax.applyTransform(transformer, text);
        }
        catch (Exception ex) {
            logger.warn("Could not compress this XML", (Throwable)ex);
            return text;
        }
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("xml");
    }
}

