/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.scripting.syntax.GroovySyntax;
import qupath.lib.gui.scripting.syntax.ImageJMacroSyntax;
import qupath.lib.gui.scripting.syntax.JsonSyntax;
import qupath.lib.gui.scripting.syntax.PlainSyntax;
import qupath.lib.gui.scripting.syntax.PropertiesSyntax;
import qupath.lib.gui.scripting.syntax.PythonSyntax;
import qupath.lib.gui.scripting.syntax.ScriptSyntax;
import qupath.lib.gui.scripting.syntax.XmlSyntax;
import qupath.lib.gui.scripting.syntax.YamlSyntax;

public class ScriptSyntaxProvider {
    private static final Logger logger = LoggerFactory.getLogger(ScriptSyntaxProvider.class);
    public static final ScriptSyntax GROOVY = new GroovySyntax();
    public static final ScriptSyntax XML = new XmlSyntax();
    public static final ScriptSyntax YAML = new YamlSyntax();
    public static final ScriptSyntax JSON = new JsonSyntax();
    public static final ScriptSyntax IMAGEJ_MACRO = new ImageJMacroSyntax();
    public static final ScriptSyntax PLAIN = new PlainSyntax();
    public static final ScriptSyntax PROPERTIES = new PropertiesSyntax();
    public static final ScriptSyntax PYTHON = new PythonSyntax();
    private static ServiceLoader<ScriptSyntax> serviceLoader = ServiceLoader.load(ScriptSyntax.class);
    private static final Collection<ScriptSyntax> availableSyntaxes = ScriptSyntaxProvider.loadAvailableScriptSyntaxes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<ScriptSyntax> loadAvailableScriptSyntaxes() {
        LinkedHashSet<ScriptSyntax> availableSyntaxes = new LinkedHashSet<ScriptSyntax>();
        ServiceLoader<ScriptSyntax> serviceLoader = ScriptSyntaxProvider.serviceLoader;
        synchronized (serviceLoader) {
            for (ScriptSyntax syntax : ScriptSyntaxProvider.serviceLoader) {
                if (syntax == null) continue;
                availableSyntaxes.add(syntax);
            }
        }
        availableSyntaxes.add(GROOVY);
        availableSyntaxes.add(XML);
        availableSyntaxes.add(YAML);
        availableSyntaxes.add(JSON);
        availableSyntaxes.add(IMAGEJ_MACRO);
        availableSyntaxes.add(PYTHON);
        availableSyntaxes.add(PLAIN);
        availableSyntaxes.add(PROPERTIES);
        logger.debug("Number of script syntax items loaded: {}", (Object)availableSyntaxes.size());
        return availableSyntaxes;
    }

    public static Collection<ScriptSyntax> getAvailableSyntaxes() {
        return Collections.unmodifiableCollection(availableSyntaxes);
    }

    public static ScriptSyntax getSyntaxFromName(String name) {
        for (ScriptSyntax syntax : availableSyntaxes) {
            for (String supported : syntax.getLanguageNames()) {
                if (!name.equalsIgnoreCase(supported)) continue;
                logger.debug("Returning {} for {}", (Object)syntax, (Object)name);
                return syntax;
            }
        }
        logger.debug("No syntax found for {}", (Object)name);
        return PLAIN;
    }

    public static boolean installSyntax(ScriptSyntax syntax) {
        return availableSyntaxes.add(syntax);
    }
}

