/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import java.util.Set;
import qupath.lib.gui.scripting.EditableText;

public interface ScriptSyntax {
    public Set<String> getLanguageNames();

    default public String getTabString() {
        return "    ";
    }

    default public String getLineCommentString() {
        return "";
    }

    default public void handleLeftParenthesis(EditableText control, boolean smartEditing) {
        control.insertText(control.getCaretPosition(), "(");
    }

    default public void handleRightParenthesis(EditableText control, boolean smartEditing) {
        control.insertText(control.getCaretPosition(), ")");
    }

    default public void handleQuotes(EditableText control, boolean isDoubleQuote, boolean smartEditing) {
        String quote = isDoubleQuote ? "\"" : "'";
        control.replaceSelection(quote);
    }

    default public void handleLineComment(EditableText control) {
    }

    default public void handleNewLine(EditableText control, boolean smartEditing) {
        control.insertText(control.getCaretPosition(), System.lineSeparator());
    }

    default public boolean handleBackspace(EditableText control, boolean smartEditing) {
        return false;
    }

    default public void handleTabPress(EditableText control, boolean shiftDown) {
        control.insertText(control.getCaretPosition(), this.getTabString());
    }

    default public String beautify(String text) {
        return text;
    }

    default public boolean canBeautify() {
        return false;
    }

    default public String compress(String text) {
        return text;
    }

    default public boolean canCompress() {
        return false;
    }
}

