/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import qupath.lib.gui.scripting.syntax.ScriptSyntax;

class PropertiesSyntax
implements ScriptSyntax {
    PropertiesSyntax() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("properties");
    }

    @Override
    public String getLineCommentString() {
        return "#";
    }

    @Override
    public String compress(String text) {
        return text.lines().filter(l -> !l.isBlank()).map(PropertiesSyntax::compressLine).collect(Collectors.joining("\n"));
    }

    @Override
    public boolean canCompress() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String beautify(String text) {
        List<String> lines = text.lines().filter(l -> !l.isBlank()).map(l -> l.strip()).toList();
        StringBuilder sb = new StringBuilder();
        boolean lastLineIsComment = false;
        boolean isContinuation = false;
        for (String string : lines) {
            void var7_7;
            boolean prependNewline = false;
            if (!isContinuation) {
                if (PropertiesSyntax.isComment(string)) {
                    if (sb.length() > 0 && !lastLineIsComment) {
                        prependNewline = true;
                    }
                    lastLineIsComment = true;
                } else {
                    lastLineIsComment = false;
                    if (PropertiesSyntax.isConfigHeader(string)) {
                        prependNewline = true;
                    } else {
                        int indSplit = PropertiesSyntax.findSplitIndex(string);
                        if (indSplit >= 0) {
                            if (string.charAt(indSplit) == '=') {
                                String string2 = string.substring(0, indSplit).strip() + " = " + string.substring(indSplit + 1).strip();
                            } else if (string.charAt(indSplit) == ':') {
                                String string3 = string.substring(0, indSplit).strip() + ": " + string.substring(indSplit + 1).strip();
                            }
                        }
                        isContinuation = PropertiesSyntax.lineContinues((String)var7_7);
                    }
                }
            }
            if (prependNewline) {
                sb.append("\n");
            }
            sb.append((String)var7_7);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String compressLine(String line) {
        if (PropertiesSyntax.isComment(line) || PropertiesSyntax.isConfigHeader(line)) {
            return line;
        }
        int indSplit = PropertiesSyntax.findSplitIndex(line);
        if (indSplit < 0) {
            return line;
        }
        return line.substring(0, indSplit).strip() + line.charAt(indSplit) + line.substring(indSplit + 1).strip();
    }

    private static int findSplitIndex(String line) {
        int indEquals = line.indexOf("=");
        int indColon = line.indexOf(":");
        if (indEquals >= 0) {
            if (indColon < 0 || indColon > indEquals) {
                return indEquals;
            }
            return indColon;
        }
        return indColon;
    }

    private static boolean lineContinues(String line) {
        return line.endsWith("\\");
    }

    private static boolean isConfigHeader(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("!");
    }

    @Override
    public boolean canBeautify() {
        return true;
    }
}

