/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.scripting.EditableText;
import qupath.lib.gui.scripting.syntax.GeneralCodeSyntax;
import qupath.lib.io.GsonTools;

class JsonSyntax
extends GeneralCodeSyntax {
    private static final Logger logger = LoggerFactory.getLogger(JsonSyntax.class);
    private static final Gson gson = GsonTools.getInstance((boolean)true);
    private static final Gson gsonCompress = GsonTools.getInstance((boolean)false);

    JsonSyntax() {
    }

    @Override
    public void handleLineComment(EditableText control) {
    }

    @Override
    public String beautify(String text) {
        try {
            return gson.toJson((JsonElement)gson.fromJson(text, JsonElement.class));
        }
        catch (JsonSyntaxException ex) {
            logger.warn("Could not beautify this JSON text", (Throwable)ex);
            return text;
        }
    }

    @Override
    public boolean canBeautify() {
        return true;
    }

    @Override
    public boolean canCompress() {
        return true;
    }

    @Override
    public String compress(String text) {
        try {
            return gsonCompress.toJson((JsonElement)gsonCompress.fromJson(text, JsonElement.class));
        }
        catch (JsonSyntaxException ex) {
            logger.warn("Could not compress this JSON text", (Throwable)ex);
            return text;
        }
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("json");
    }
}

