/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import java.util.Set;
import qupath.lib.gui.scripting.EditableText;
import qupath.lib.gui.scripting.syntax.GeneralCodeSyntax;

class GroovySyntax
extends GeneralCodeSyntax {
    private static final String ifStatementPattern = "(else\\s*)?if\\s*\\(.*\\)$";
    private static final String elseStatementPattern = "\\}?\\s*else$";

    GroovySyntax() {
    }

    @Override
    public String getLineCommentString() {
        return "//";
    }

    @Override
    public void handleNewLine(EditableText control, boolean smartEditing) {
        int caretPos = control.getCaretPosition();
        String text = control.getText();
        int startRowPos = this.getRowStartPosition(text, caretPos);
        int endRowPos = this.getRowEndPosition(text, caretPos);
        String subString = text.substring(startRowPos, caretPos);
        String trimmedSubString = subString.trim();
        int indentation = subString.length() - subString.stripLeading().length();
        int ind = trimmedSubString.isEmpty() ? subString.length() : subString.indexOf(trimmedSubString);
        int finalPos = caretPos;
        Object insertText = System.lineSeparator();
        if (!smartEditing) {
            super.handleNewLine(control, smartEditing);
            return;
        }
        String tabString = this.getTabString();
        if (trimmedSubString.startsWith("/*") && !trimmedSubString.contains("*/")) {
            insertText = ind == 0 ? "\n" + subString.substring(0, indentation) + " * \n */" : "\n" + subString.substring(0, indentation) + " * \n" + subString.substring(0, indentation) + " */ ";
            control.insertText(caretPos, (String)insertText);
            control.positionCaret(finalPos += ((String)insertText).length() - (indentation == 0 ? -1 : indentation) - 5);
            return;
        }
        if (trimmedSubString.startsWith("*") && !trimmedSubString.contains("*/")) {
            insertText = ind == 0 ? "\n* " : "\n" + subString.substring(0, ind) + "* ";
            control.insertText(caretPos, (String)insertText);
            finalPos += ((String)insertText).length();
            return;
        }
        if (trimmedSubString.endsWith("{")) {
            String lineRemainder = text.substring(startRowPos + subString.length(), endRowPos);
            insertText = "\n" + subString.substring(0, indentation) + tabString + lineRemainder.strip();
            if (text.replaceAll("[^{]", "").length() != text.replaceAll("[^}]", "").length()) {
                insertText = (String)insertText + "\n" + subString.substring(0, indentation) + "}";
            }
            finalPos += 1 + indentation + tabString.length() + lineRemainder.strip().length();
            if (trimmedSubString.length() >= 2 && trimmedSubString.charAt(trimmedSubString.length() - 2) != ' ') {
                control.insertText(++caretPos - 2, " ");
            }
            control.insertText(caretPos, (String)insertText);
            control.deleteText(control.getCaretPosition(), control.getCaretPosition() + lineRemainder.length());
            control.positionCaret(finalPos);
        } else if (trimmedSubString.endsWith("[")) {
            String lineRemainder = text.substring(startRowPos + subString.length(), endRowPos);
            insertText = "\n" + subString.substring(0, indentation) + tabString + lineRemainder.strip();
            if (text.replaceAll("[^\\[]", "").length() != text.replaceAll("[^\\]]", "").length()) {
                insertText = (String)insertText + "\n" + subString.substring(0, indentation) + "]";
            }
            control.insertText(caretPos, (String)insertText);
            control.deleteText(control.getCaretPosition(), control.getCaretPosition() + lineRemainder.length());
            control.positionCaret(finalPos += 1 + indentation + tabString.length() + lineRemainder.strip().length());
        } else if (trimmedSubString.matches(ifStatementPattern) || trimmedSubString.matches(elseStatementPattern)) {
            insertText = "\n" + subString.substring(0, ind) + tabString;
            control.insertText(caretPos, (String)insertText);
            finalPos += ((String)insertText).length();
        } else {
            int endPrevRowPos;
            int startPrevRowPos;
            String prevSubString;
            if (text.substring(0, startRowPos).contains("\n") && indentation > 0 && ((prevSubString = text.substring(startPrevRowPos = this.getRowStartPosition(text, startRowPos - 1), endPrevRowPos = this.getRowEndPosition(text, startPrevRowPos))).matches(ifStatementPattern) || prevSubString.matches(elseStatementPattern))) {
                insertText = "\n" + subString.substring(0, Math.max(0, ind - tabString.length()));
                control.insertText(caretPos, (String)insertText);
                finalPos += ((String)insertText).length();
                return;
            }
            String lineRemainder = text.substring(startRowPos + subString.length(), endRowPos);
            insertText = "\n" + subString.substring(0, indentation) + lineRemainder.strip();
            control.insertText(caretPos, (String)insertText);
            control.deleteText(control.getCaretPosition(), control.getCaretPosition() + lineRemainder.length());
            control.positionCaret(finalPos += 1 + indentation);
        }
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("groovy", "java");
    }
}

