/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.syntax;

import qupath.lib.gui.scripting.EditableText;
import qupath.lib.gui.scripting.syntax.ScriptSyntax;

abstract class GeneralCodeSyntax
implements ScriptSyntax {
    GeneralCodeSyntax() {
    }

    @Override
    public void handleLeftParenthesis(EditableText control, boolean smartEditing) {
        char nextChar;
        control.insertText(control.getCaretPosition(), "(");
        if (!smartEditing) {
            return;
        }
        String text = control.getText();
        int pos = control.getCaretPosition();
        if (pos < text.length() && Character.isLetterOrDigit(nextChar = text.charAt(pos))) {
            return;
        }
        control.insertText(pos, ")");
        control.positionCaret(control.getCaretPosition() - 1);
    }

    @Override
    public void handleRightParenthesis(EditableText control, boolean smartEditing) {
        control.insertText(control.getCaretPosition(), ")");
        if (!smartEditing) {
            return;
        }
        String text = control.getText();
        int caretPos = control.getCaretPosition();
        if (text.length() >= caretPos + 1 && text.charAt(caretPos) == ')') {
            control.deleteText(caretPos, caretPos + 1);
        }
    }

    @Override
    public void handleQuotes(EditableText control, boolean isDoubleQuote, boolean smartEditing) {
        String quotes;
        String string = quotes = isDoubleQuote ? "\"" : "'";
        if (control.getSelectionLength() == 0) {
            control.insertText(control.getCaretPosition(), quotes);
        } else {
            control.replaceSelection(quotes);
        }
        if (!smartEditing) {
            return;
        }
        String text = control.getText();
        int caretPos = control.getCaretPosition();
        if (caretPos < 3 || !text.substring(caretPos - 3, caretPos).equals("\"\"\"")) {
            if (text.length() >= caretPos + 1 && text.charAt(caretPos) == quotes.charAt(0)) {
                control.deleteText(caretPos, caretPos + 1);
            } else {
                boolean checkEnd;
                boolean checkStart = caretPos <= 1 || Character.isWhitespace(text.charAt(caretPos - 2));
                boolean bl = checkEnd = caretPos >= text.length() || Character.isWhitespace(text.charAt(caretPos));
                if (checkStart && checkEnd) {
                    control.insertText(control.getCaretPosition(), quotes);
                    control.positionCaret(control.getCaretPosition() - 1);
                }
            }
        }
    }

    @Override
    public void handleLineComment(EditableText control) {
        Object replaceText;
        boolean allComments;
        String commentString = this.getLineCommentString();
        if (commentString == null) {
            return;
        }
        String text = control.getText();
        boolean hasSelection = control.getSelectionLength() > 0;
        int startRowPos = this.getRowStartPosition(text, control.getSelectionStart());
        int endRowPos = this.getRowEndPosition(text, control.getSelectionEnd());
        String textBetween = text.substring(startRowPos, endRowPos);
        int nNewLines = textBetween.length() - textBetween.replace("\n", "").length();
        int nCommentLines = textBetween.length() - textBetween.replace("\n" + commentString, commentString).length();
        boolean bl = allComments = textBetween.startsWith(commentString) && nNewLines == nCommentLines;
        if (allComments) {
            replaceText = textBetween.replace("\n" + commentString, "\n");
            if (((String)replaceText).startsWith(commentString)) {
                replaceText = ((String)replaceText).substring(commentString.length());
            }
        } else {
            replaceText = commentString + textBetween.replace("\n", "\n" + commentString);
        }
        control.selectRange(startRowPos, endRowPos);
        control.replaceSelection((String)replaceText);
        if (hasSelection) {
            control.selectRange(startRowPos, startRowPos + ((String)replaceText).length());
        }
    }

    @Override
    public void handleNewLine(EditableText control, boolean smartEditing) {
        String text = control.getText();
        int caretPos = control.getCaretPosition();
        int startRowPos = this.getRowStartPosition(text, caretPos);
        String subString = text.substring(startRowPos, caretPos);
        String indentation = subString.substring(0, subString.length() - subString.stripLeading().length());
        ScriptSyntax.super.handleNewLine(control, smartEditing);
        if (smartEditing) {
            control.insertText(control.getCaretPosition(), indentation);
        }
    }

    @Override
    public boolean handleBackspace(EditableText control, boolean smartEditing) {
        int caretPos = control.getCaretPosition();
        int selectionLength = control.getSelectionLength();
        if (caretPos - 1 < 0 || selectionLength >= 1 || !smartEditing) {
            return false;
        }
        if (!(caretPos < control.getText().length() && (control.getText().charAt(caretPos - 1) == '(' && control.getText().charAt(caretPos) == ')' || control.getText().charAt(caretPos - 1) == '\"' && control.getText().charAt(caretPos) == '\"' || control.getText().charAt(caretPos - 1) == '\'' && control.getText().charAt(caretPos) == '\''))) {
            return false;
        }
        control.deleteText(caretPos - 1, caretPos + 1);
        return true;
    }

    @Override
    public void handleTabPress(EditableText textArea, boolean shiftDown) {
        Object replaceText;
        String text = textArea.getText();
        int rangeStart = textArea.getSelectionStart();
        int rangeEnd = textArea.getSelectionEnd();
        int rangeLength = textArea.getSelectionLength();
        int startRowPos = this.getRowStartPosition(text, rangeStart);
        int endRowPos = this.getRowEndPosition(text, rangeEnd);
        String textBetween = text.substring(startRowPos, endRowPos);
        String tabString = this.getTabString();
        if (rangeLength == 0) {
            int caretPos = textArea.getCaretPosition();
            if (shiftDown) {
                if (textBetween.startsWith(tabString)) {
                    textArea.deleteText(startRowPos, startRowPos + tabString.length());
                    textArea.positionCaret(caretPos - tabString.length());
                } else if (textBetween.startsWith("\t")) {
                    textArea.deleteText(startRowPos, startRowPos + "\t".length());
                    textArea.positionCaret(caretPos - "\t".length());
                }
            } else {
                textArea.insertText(caretPos, tabString);
            }
            return;
        }
        if (shiftDown) {
            replaceText = (textBetween = textBetween.replaceAll("\t", tabString)).replace("\n" + tabString, "\n");
            if (((String)replaceText).startsWith(tabString)) {
                replaceText = ((String)replaceText).substring(tabString.length());
            }
        } else {
            replaceText = tabString + textBetween.replace("\n", "\n" + tabString);
        }
        textArea.selectRange(startRowPos, endRowPos);
        textArea.replaceSelection((String)replaceText);
        textArea.selectRange(startRowPos, startRowPos + ((String)replaceText).length());
    }

    protected int getRowStartPosition(String text, int pos) {
        return text.substring(0, pos).lastIndexOf("\n") + 1;
    }

    protected int getRowEndPosition(String text, int pos) {
        int pos2 = text.substring(pos).indexOf("\n");
        if (pos2 < 0) {
            return text.length();
        }
        return pos + pos2;
    }
}

