/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.languages;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.scripting.languages.CssLanguage;
import qupath.lib.gui.scripting.languages.DefaultScriptLanguage;
import qupath.lib.gui.scripting.languages.GroovyLanguage;
import qupath.lib.gui.scripting.languages.ImageJMacroLanguage;
import qupath.lib.gui.scripting.languages.JsonLanguage;
import qupath.lib.gui.scripting.languages.MarkdownLanguage;
import qupath.lib.gui.scripting.languages.PlainLanguage;
import qupath.lib.gui.scripting.languages.PropertiesLanguage;
import qupath.lib.gui.scripting.languages.XmlLanguage;
import qupath.lib.gui.scripting.languages.YamlLanguage;
import qupath.lib.scripting.languages.ScriptLanguage;

public class ScriptLanguageProvider {
    private static final Logger logger = LoggerFactory.getLogger(ScriptLanguageProvider.class);
    private static ScriptEngineManager manager;
    private static Collection<ScriptLanguage> availableLanguages;

    private static Collection<ScriptLanguage> getAvailableScriptLanguages() {
        if (availableLanguages == null) {
            availableLanguages = ScriptLanguageProvider.loadAvailableScriptLanguages();
        }
        return availableLanguages;
    }

    private static Collection<ScriptLanguage> loadAvailableScriptLanguages() {
        LinkedHashSet<ScriptLanguage> languages = new LinkedHashSet<ScriptLanguage>(ScriptLanguageProvider.getDefaultLanguages());
        ScriptEngineManager manager = new ScriptEngineManager(ScriptLanguageProvider.getExtensionClassLoader());
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            boolean builtIn = false;
            for (ScriptLanguage l : languages) {
                if (!factory.getNames().contains(l.getName().toLowerCase())) continue;
                builtIn = true;
                break;
            }
            if (builtIn) continue;
            try {
                DefaultScriptLanguage l = new DefaultScriptLanguage(factory);
                languages.add(l);
            }
            catch (Exception ex) {
                logger.warn("Could not integrate script engine [{}] in the Script Editor: {}", (Object)factory.getEngineName(), (Object)ex.getLocalizedMessage());
            }
        }
        return languages;
    }

    private static List<ScriptLanguage> getDefaultLanguages() {
        return List.of(GroovyLanguage.getInstance(), MarkdownLanguage.getInstance(), CssLanguage.getInstance(), JsonLanguage.getInstance(), ImageJMacroLanguage.getInstance(), PropertiesLanguage.getInstance(), XmlLanguage.getInstance(), YamlLanguage.getInstance(), PlainLanguage.getInstance());
    }

    private static ClassLoader getExtensionClassLoader() {
        return QuPathGUI.getExtensionCatalogManager().getExtensionClassLoader();
    }

    public static Collection<ScriptLanguage> getAvailableLanguages() {
        return List.copyOf(ScriptLanguageProvider.getAvailableScriptLanguages());
    }

    public static ScriptLanguage getLanguageFromName(String name) {
        for (ScriptLanguage l : ScriptLanguageProvider.getAvailableScriptLanguages()) {
            for (String possibleExt : l.getExtensions()) {
                if (!name.toLowerCase().endsWith(possibleExt)) continue;
                return l;
            }
        }
        return PlainLanguage.getInstance();
    }

    public static ScriptLanguage fromString(String languageString) {
        return ScriptLanguageProvider.getAvailableScriptLanguages().stream().filter(l -> l.getName().equalsIgnoreCase(languageString)).findFirst().orElseGet(PlainLanguage::getInstance);
    }

    public static ScriptLanguage getLanguageFromExtension(String ext) {
        for (ScriptLanguage l : ScriptLanguageProvider.getAvailableScriptLanguages()) {
            for (String tempExt : l.getExtensions()) {
                if (!tempExt.equals(ext)) continue;
                return l;
            }
        }
        return null;
    }

    public static boolean installLanguage(ScriptLanguage language) {
        ScriptLanguageProvider.getAvailableLanguages();
        return availableLanguages.add(language);
    }

    private static ScriptEngineManager createManager() {
        Thread.currentThread().setContextClassLoader(ScriptLanguageProvider.getExtensionClassLoader());
        ScriptEngineManager manager = new ScriptEngineManager(ScriptLanguageProvider.getExtensionClassLoader());
        for (ScriptEngineFactory factory : manager.getEngineFactories()) {
            boolean builtIn = false;
            for (ScriptLanguage l : ScriptLanguageProvider.getAvailableScriptLanguages()) {
                if (!factory.getNames().contains(l.getName().toLowerCase())) continue;
                try {
                    logger.trace("-------------------------------");
                    logger.trace(factory.getLanguageName());
                    logger.trace(factory.getLanguageVersion());
                    logger.trace(factory.getEngineName());
                    logger.trace(factory.getEngineVersion());
                    logger.trace("Names: {}", factory.getNames());
                    logger.trace("MIME types: {}", (Object)factory.getMimeTypes().toString());
                    logger.trace("Extensions: {}", (Object)factory.getExtensions().toString());
                    logger.trace(factory.getMethodCallSyntax("QuPath", "runPlugin", "imageData", "\"{ key : value }\""));
                    logger.trace(factory.getOutputStatement("This is my output"));
                    manager.registerEngineName(l.toString(), factory);
                    builtIn = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn("Exception registering script language: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (builtIn) continue;
            manager.registerEngineName(factory.getEngineName(), factory);
        }
        return manager;
    }

    public static ScriptEngine getEngineByName(String languageName) {
        if (manager == null) {
            manager = ScriptLanguageProvider.createManager();
        }
        return manager.getEngineByName(languageName);
    }
}

