/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.languages;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.script.ScriptException;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import qupath.lib.gui.scripting.languages.HtmlRenderer;
import qupath.lib.scripting.ScriptParameters;
import qupath.lib.scripting.languages.ScriptLanguage;

public class MarkdownLanguage
extends ScriptLanguage
implements HtmlRenderer {
    private static final MarkdownLanguage INSTANCE = new MarkdownLanguage();

    private MarkdownLanguage() {
        super("Markdown", (Collection)ImmutableSet.of((Object)".md", (Object)".markdown"));
    }

    public static MarkdownLanguage getInstance() {
        return INSTANCE;
    }

    public Object execute(ScriptParameters params) throws ScriptException {
        try {
            Node doc = Parser.builder().build().parse(params.getScript());
            return org.commonmark.renderer.html.HtmlRenderer.builder().build().render(doc);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }
}

