/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.languages;

import java.util.Collection;
import java.util.Collections;
import qupath.lib.gui.scripting.completors.GroovyAutoCompletor;
import qupath.lib.gui.scripting.languages.DefaultScriptLanguage;
import qupath.lib.scripting.languages.AutoCompletions;
import qupath.lib.scripting.languages.ExecutableLanguage;

public class GroovyLanguage
extends DefaultScriptLanguage
implements ExecutableLanguage {
    private static final GroovyLanguage INSTANCE_WITH_COMPLETIONS = new GroovyLanguage();
    private static final GroovyLanguage INSTANCE_NO_COMPLETIONS = new GroovyLanguage(Collections.emptyList());

    private GroovyLanguage(Collection<? extends AutoCompletions.Completion> completions) {
        super("Groovy", Collections.singleton(".groovy"), new GroovyAutoCompletor(completions));
    }

    private GroovyLanguage() {
        super("Groovy", Collections.singleton(".groovy"), new GroovyAutoCompletor());
    }

    public static GroovyLanguage getInstance() {
        return INSTANCE_WITH_COMPLETIONS;
    }

    public static GroovyLanguage getInstanceWithCompletions(Collection<? extends AutoCompletions.Completion> completions) {
        if (completions == null || completions.isEmpty()) {
            return INSTANCE_NO_COMPLETIONS;
        }
        return new GroovyLanguage(completions);
    }

    @Override
    protected DefaultScriptLanguage.ImportStatementGenerator getImportStatementGenerator() {
        return JAVA_IMPORTER;
    }
}

