/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.languages;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.imagej.tools.IJTools;
import qupath.lib.gui.scripting.QPEx;
import qupath.lib.gui.scripting.completors.DefaultAutoCompletor;
import qupath.lib.gui.scripting.completors.GroovyAutoCompletor;
import qupath.lib.gui.scripting.completors.PythonAutoCompletor;
import qupath.lib.gui.scripting.languages.ScriptLanguageProvider;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObjects;
import qupath.lib.projects.Project;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.ShapeSimplifier;
import qupath.lib.scripting.QP;
import qupath.lib.scripting.ScriptParameters;
import qupath.lib.scripting.languages.ExecutableLanguage;
import qupath.lib.scripting.languages.ScriptAutoCompletor;
import qupath.lib.scripting.languages.ScriptLanguage;

public class DefaultScriptLanguage
extends ScriptLanguage
implements ExecutableLanguage {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScriptLanguage.class);
    private ScriptAutoCompletor completor;
    private Cache<String, CompiledScript> compiledMap = CacheBuilder.newBuilder().maximumSize(100L).build();
    private static Map<String, Class<?>> CONFUSED_CLASSES = new HashMap();
    protected static final ImportStatementGenerator JAVA_IMPORTER;
    protected static final ImportStatementGenerator PYTHON_IMPORTER;

    public DefaultScriptLanguage(ScriptEngineFactory factory) {
        super(factory.getEngineName(), factory.getExtensions());
        String name = factory.getLanguageName().toLowerCase();
        this.completor = this.getDefaultAutoCompletor(name);
    }

    protected ScriptAutoCompletor getDefaultAutoCompletor(String languageName) {
        String name = languageName.toLowerCase();
        if ("groovy".equals(name)) {
            return new GroovyAutoCompletor();
        }
        if ("java".equals(name)) {
            return new DefaultAutoCompletor();
        }
        if (Set.of("python", "cpython", "python py4j", "jython", "graalpy").contains(name)) {
            return new PythonAutoCompletor();
        }
        return null;
    }

    public DefaultScriptLanguage(String name, Collection<String> exts, ScriptAutoCompletor completor) {
        super(name, exts);
        this.completor = completor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ScriptParameters params) throws ScriptException {
        QP.setBatchProjectAndImage((Project)params.getProject(), (ImageData)params.getImageData());
        String script = params.getScript();
        Object script2 = script;
        Object result = null;
        String importsString = this.getImportStatements(params.getDefaultImports()) + this.getStaticImportStatements(params.getDefaultStaticImports());
        int extraLines = 0;
        boolean defaultImportsAvailable = false;
        if (importsString.isBlank()) {
            script2 = script;
        } else {
            extraLines = importsString.replaceAll("[^\\n]", "").length() + 1;
            script2 = importsString + System.lineSeparator() + script;
            defaultImportsAvailable = true;
        }
        ScriptContext context = this.createContext(params);
        File file = params.getFile();
        String filename = file != null ? file.getName() : this.getDefaultScriptName();
        try {
            CompiledScript compiled;
            ScriptEngine engine = null;
            boolean useCompiled = params.useCompiled();
            CompiledScript compiledScript = compiled = useCompiled ? (CompiledScript)this.compiledMap.getIfPresent(script2) : null;
            if (useCompiled && compiled == null) {
                engine = ScriptLanguageProvider.getEngineByName(this.getName());
                if (engine == null) {
                    throw new ScriptException("Unable to find ScriptEngine for " + this.getName());
                }
                if (engine instanceof Compilable) {
                    Compilable compilable = (Compilable)((Object)engine);
                    Cache<String, CompiledScript> cache = this.compiledMap;
                    synchronized (cache) {
                        compiled = (CompiledScript)this.compiledMap.getIfPresent(script2);
                        if (compiled == null || !Objects.equals(compiled.getEngine().getClass(), engine.getClass())) {
                            compiled = (CompiledScript)this.compiledMap.getIfPresent(script2);
                            logger.debug("Compiling script");
                            compiled = compilable.compile((String)script2);
                            this.compiledMap.put(script2, (Object)compiled);
                        }
                    }
                } else {
                    logger.debug("Script engine does not support compilation: {}", (Object)engine);
                }
            }
            context.setAttribute("javax.script.argv", params.getArgs(), 100);
            context.setAttribute("javax.script.filename", filename, 100);
            if (compiled != null) {
                logger.debug("Evaluating compiled script: {}", (Object)compiled);
                result = compiled.eval(context);
            } else {
                if (engine == null && (engine = ScriptLanguageProvider.getEngineByName(this.getName())) == null) {
                    throw new ScriptException("Unable to find ScriptEngine for " + this.getName());
                }
                logger.debug("Evaluating script engine: {}", (Object)engine);
                result = engine.eval((String)script2, context);
            }
            if (params.doUpdateHierarchy() && params.getImageData() != null) {
                params.getImageData().getHierarchy().fireHierarchyChangedEvent((Object)params);
            }
        }
        catch (ScriptException e) {
            try {
                Matcher lineMatcher;
                Throwable cause;
                int line = e.getLineNumber();
                for (cause = e; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                }
                Object message = cause.getLocalizedMessage();
                if (message != null && line < 0 && (lineMatcher = Pattern.compile("@ line ([\\d]+)").matcher((CharSequence)message)).find()) {
                    line = Integer.parseInt(lineMatcher.group(1));
                    message = ((String)message).substring(0, lineMatcher.start(1)) + (line - extraLines) + ((String)message).substring(lineMatcher.end(1));
                }
                StackTraceElement[] stackTraceTemp = cause.getStackTrace();
                for (int i = 0; i < stackTraceTemp.length; ++i) {
                    StackTraceElement element2;
                    boolean updateStackTrace;
                    StackTraceElement element = stackTraceTemp[i];
                    String elementFileName = element.getFileName();
                    if (elementFileName == null || !elementFileName.equals(filename)) continue;
                    boolean bl = updateStackTrace = line - extraLines != element.getLineNumber();
                    if (line < 0) {
                        line = element.getLineNumber();
                    }
                    if (!updateStackTrace) break;
                    stackTraceTemp[i] = element2 = new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), line - extraLines);
                    cause.setStackTrace(stackTraceTemp);
                    break;
                }
                Writer errorWriter = context.getErrorWriter();
                String extra = this.tryToInterpretMessage(cause, line - extraLines, defaultImportsAvailable);
                if (!extra.isBlank()) {
                    errorWriter.append(extra);
                }
                String newMessage = message;
                ScriptException updatedException = new ScriptException(newMessage, filename, line - extraLines, e.getColumnNumber());
                updatedException.initCause(cause);
                throw updatedException;
            }
            catch (IOException | RuntimeException e2) {
                logger.debug("Error fixing script exception: " + e2.getLocalizedMessage(), (Throwable)e2);
                throw e;
            }
        }
        finally {
            QP.resetBatchProjectAndImage();
        }
        return result;
    }

    protected String tryToInterpretMessage(Throwable cause, int line, boolean defaultImportsAvailable) {
        Matcher matcherQuotationMarks;
        Matcher matcherMethod;
        Matcher matcherProperty;
        Matcher matcher;
        String message = cause.getLocalizedMessage();
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder();
        if (cause instanceof ConcurrentModificationException) {
            sb.append("ERROR: ConcurrentModificationException! This usually happen when two threads try to modify a collection (e.g. a list) at the same time.\nIt might indicate a QuPath bug (or just something wrong in the script).\n");
        }
        if ((matcher = Pattern.compile("unable to resolve class ([A-Za-z0-9_.-]+)").matcher(message)).find()) {
            Class<?> suggestedClass;
            int ind;
            String missingClass = matcher.group(1).strip();
            sb.append("ERROR: It looks like you've tried to import a class '" + missingClass + "' that couldn't be found\n");
            if (!defaultImportsAvailable) {
                sb.append("Turning on 'Run -> Include default imports' *may* help fix this.\n");
            }
            if ((ind = missingClass.lastIndexOf(".")) >= 0) {
                missingClass = missingClass.substring(ind + 1);
            }
            if ((suggestedClass = CONFUSED_CLASSES.get(missingClass)) != null) {
                if (line >= 0) {
                    sb.append("You should probably remove the broken import statement in your script (around line " + line + "), and include\n");
                } else {
                    sb.append("You should probably remove the broken import statement in your script, and include \n");
                }
                sb.append("\n    import " + suggestedClass.getName() + "\nat the start of the script.");
            }
        }
        if ((matcherProperty = Pattern.compile("No such property: ([A-Za-z_.-]+)").matcher(message)).find()) {
            String missingProperty = matcherProperty.group(1).strip();
            if (!defaultImportsAvailable) {
                sb.append("ERROR: It looks like you've tried to access a property '" + missingProperty + "' that doesn't exist\n");
                sb.append("This error can sometimes by fixed by turning on 'Run -> Include default imports'.\n");
            }
        }
        if ((matcherMethod = Pattern.compile("No signature of method").matcher(message)).find()) {
            sb.append("ERROR: It looks like you've tried to access a method that doesn't exist.\n");
            if (!defaultImportsAvailable) {
                sb.append("This error can sometimes by fixed by turning on 'Run -> Include default imports'.\n");
            }
        }
        if (message.contains("Not on FX application thread")) {
            sb.append("ERROR: The script involves interacting with JavaFX, and should be called on the JavaFX Application thread.\n");
            sb.append("You can often fix this by passing your code to 'Platform.runLater()', e.g. in Groovy use \n\n    Platform.runLater {\n        // your code\n    }\n");
        }
        if ((matcherQuotationMarks = Pattern.compile("Unexpected input: .*([\\x{2018}|\\x{201c}|\\x{2019}|\\x{201D}]+)' @ line (\\d+), column (\\d+).").matcher(message)).find()) {
            int nLine = Integer.parseInt(matcherQuotationMarks.group(2));
            String quotationMark = matcherQuotationMarks.group(1);
            String suggestion = quotationMark.equals("\u2018") || quotationMark.equals("\u2019") ? "'" : "\"";
            sb.append(String.format("At least one invalid quotation mark (%s) was found @ line %s column %s! ", quotationMark, nLine - 1, matcherQuotationMarks.group(3)));
            sb.append(String.format("You can try replacing it with a straight quotation mark (%s).%n", suggestion));
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String getDefaultScriptName() {
        return "QuPathScript";
    }

    protected ScriptContext createContext(ScriptParameters params) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute("args", params.getArgs(), 100);
        File file = params.getFile();
        if (file != null) {
            context.setAttribute("qupath.script.file", file.getAbsolutePath(), 100);
        }
        context.setAttribute("qupath.script.batchSize", params.getBatchSize(), 100);
        context.setAttribute("qupath.script.batchIndex", params.getBatchIndex(), 100);
        context.setAttribute("qupath.script.batchLast", params.getBatchIndex() == params.getBatchSize() - 1, 100);
        context.setAttribute("qupath.script.batchSave", params.getBatchSaveResult(), 100);
        context.setWriter(params.getWriter());
        context.setErrorWriter(params.getErrorWriter());
        return context;
    }

    public ScriptAutoCompletor getAutoCompletor() {
        return this.completor;
    }

    public String getImportStatements(Collection<Class<?>> classes) {
        ImportStatementGenerator generator;
        if (classes != null && !classes.isEmpty() && (generator = this.getImportStatementGenerator()) != null) {
            return generator.getImportStatments(classes);
        }
        return "";
    }

    public String getStaticImportStatements(Collection<Class<?>> classes) {
        ImportStatementGenerator generator;
        if (classes != null && !classes.isEmpty() && (generator = this.getImportStatementGenerator()) != null) {
            return generator.getStaticImportStatments(classes);
        }
        return "";
    }

    protected ImportStatementGenerator getImportStatementGenerator() {
        String name = this.getName().toLowerCase();
        if (Set.of("java", "groovy", "kotlin", "scala").contains(name)) {
            return JAVA_IMPORTER;
        }
        if (Set.of("jython", "python", "ipython", "cpython").contains(name)) {
            return PYTHON_IMPORTER;
        }
        return null;
    }

    static {
        for (Class cls : QP.getCoreClasses()) {
            CONFUSED_CLASSES.put(cls.getSimpleName(), cls);
        }
        CONFUSED_CLASSES.put("PathRoiToolsAwt", RoiTools.class);
        CONFUSED_CLASSES.put("PathDetectionObject", PathObjects.class);
        CONFUSED_CLASSES.put("PathAnnotationObject", PathObjects.class);
        CONFUSED_CLASSES.put("PathCellObject", PathObjects.class);
        CONFUSED_CLASSES.put("RoiConverterIJ", IJTools.class);
        CONFUSED_CLASSES.put("QP", QP.class);
        CONFUSED_CLASSES.put("QPEx", QPEx.class);
        CONFUSED_CLASSES.put("ShapeSimplifierAwt", ShapeSimplifier.class);
        CONFUSED_CLASSES.put("ImagePlusServerBuilder", IJTools.class);
        CONFUSED_CLASSES.put("DisplayHelpers", Dialogs.class);
        CONFUSED_CLASSES.put("Dialogs", Dialogs.class);
        CONFUSED_CLASSES = Collections.unmodifiableMap(CONFUSED_CLASSES);
        JAVA_IMPORTER = new JavaImportStatementGenerator();
        PYTHON_IMPORTER = new PythonImportStatementGenerator();
    }

    protected static interface ImportStatementGenerator {
        public String getImportStatments(Collection<Class<?>> var1);

        public String getStaticImportStatments(Collection<Class<?>> var1);
    }

    static class JavaImportStatementGenerator
    implements ImportStatementGenerator {
        JavaImportStatementGenerator() {
        }

        @Override
        public String getImportStatments(Collection<Class<?>> classes) {
            return classes.stream().map(c -> "import " + c.getName() + ";").collect(Collectors.joining(" "));
        }

        @Override
        public String getStaticImportStatments(Collection<Class<?>> classes) {
            return classes.stream().map(c -> "import static " + c.getName() + ".*").collect(Collectors.joining(" "));
        }
    }

    static class PythonImportStatementGenerator
    implements ImportStatementGenerator {
        PythonImportStatementGenerator() {
        }

        @Override
        public String getImportStatments(Collection<Class<?>> classes) {
            return classes.stream().map(c -> "import " + c.getName() + ";").collect(Collectors.joining(" "));
        }

        @Override
        public String getStaticImportStatments(Collection<Class<?>> classes) {
            return classes.stream().map(c -> "from " + c.getName() + " import *;").collect(Collectors.joining(" "));
        }
    }
}

