/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.completors;

import ij.macro.MacroConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.scripting.completors.DefaultAutoCompletor;
import qupath.lib.scripting.languages.AutoCompletions;

public class ImageJMacroCompletor
extends DefaultAutoCompletor {
    private static final Logger logger = LoggerFactory.getLogger(ImageJMacroCompletor.class);

    public ImageJMacroCompletor() {
        super(Collections.emptyList());
        try {
            this.addCompletions(this.readCompletionsFromResource());
        }
        catch (Exception e) {
            logger.debug("Unable to read ImageJ macro autocompletions: {}", (Object)e.getMessage(), (Object)e);
            this.addCompletionsFromCode();
        }
    }

    private List<AutoCompletions.Completion> readCompletionsFromResource() throws IOException {
        try (InputStream stream = ImageJMacroCompletor.class.getResourceAsStream("ij-macro-functions.txt");){
            List<AutoCompletions.Completion> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                list = reader.lines().map(String::strip).filter(l -> !l.isBlank() && !l.startsWith("//") && !l.startsWith("#")).map(ImageJMacroCompletor::resourceCompletion).toList();
            }
            return list;
        }
    }

    private void addCompletionsFromCode() {
        for (String keyword : MacroConstants.keywords) {
            this.addCompletion(ImageJMacroCompletor.keywordCompletion(keyword, null));
        }
        for (String keyword : MacroConstants.variableFunctions) {
            this.addCompletion(ImageJMacroCompletor.keywordCompletion(keyword, "variable function"));
        }
        for (String fun : MacroConstants.functions) {
            this.addCompletion(ImageJMacroCompletor.functionCompletion(fun, null));
        }
        for (String fun : MacroConstants.numericFunctions) {
            this.addCompletion(ImageJMacroCompletor.functionCompletion(fun, "numeric function"));
        }
        for (String fun : MacroConstants.arrayFunctions) {
            this.addCompletion(ImageJMacroCompletor.functionCompletion(fun, "array function"));
        }
        for (String fun : MacroConstants.stringFunctions) {
            this.addCompletion(ImageJMacroCompletor.functionCompletion(fun, "string function"));
        }
    }

    private static AutoCompletions.Completion resourceCompletion(String text) {
        return AutoCompletions.createJavaCompletion(null, (String)text, (String)ImageJMacroCompletor.textToCompletion(text));
    }

    private static String textToCompletion(String text) {
        int indParen = text.indexOf("(");
        if (indParen <= 0) {
            return text;
        }
        int indParenClose = text.indexOf(")");
        if (indParenClose <= indParen + 1) {
            return text;
        }
        String functionName = text.substring(0, indParen);
        String arg = text.substring(indParen + 1, indParenClose).strip();
        if (arg.startsWith("\"") && arg.endsWith("\"") && arg.replaceAll("\"", "").length() == arg.length() - 2) {
            return text;
        }
        return functionName + "()";
    }

    private static AutoCompletions.Completion functionCompletion(String fun, String category) {
        if (Character.isUpperCase(fun.charAt(0))) {
            return ImageJMacroCompletor.keywordCompletion(fun, category);
        }
        return AutoCompletions.createJavaCompletion(null, (String)ImageJMacroCompletor.appendCategory(fun + "(...)", category), (String)(fun + "()"));
    }

    private static AutoCompletions.Completion keywordCompletion(String keyword, String category) {
        return AutoCompletions.createJavaCompletion(null, (String)ImageJMacroCompletor.appendCategory(keyword, category), (String)keyword);
    }

    private static String appendCategory(String text, String category) {
        if (category == null) {
            return text;
        }
        return text + "    \t[" + category + "]";
    }
}

