/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.completors;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.scripting.QPEx;
import qupath.lib.scripting.languages.AutoCompletions;
import qupath.lib.scripting.languages.ScriptAutoCompletor;

public class DefaultAutoCompletor
implements ScriptAutoCompletor {
    private static final Logger logger;
    private static final Set<AutoCompletions.Completion> DEFAULT_QUPATH_JAVA_COMPLETIONS;
    private final Set<AutoCompletions.Completion> allCompletions = new HashSet<AutoCompletions.Completion>();

    static int addStaticMethods(Class<?> cls, Collection<? super AutoCompletions.Completion> completions) {
        int countStatic = 0;
        for (Method method : cls.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !completions.add((AutoCompletions.Completion)AutoCompletions.createJavaCompletion(method.getDeclaringClass(), (Method)method))) continue;
            ++countStatic;
        }
        if (countStatic > 0) {
            completions.add((AutoCompletions.Completion)AutoCompletions.createJavaCompletion(cls));
        }
        return countStatic;
    }

    public DefaultAutoCompletor(Collection<? extends AutoCompletions.Completion> completions) {
        if (completions != null) {
            this.allCompletions.addAll(completions);
        }
    }

    public DefaultAutoCompletor() {
        this(DEFAULT_QUPATH_JAVA_COMPLETIONS);
    }

    protected void addCompletion(AutoCompletions.Completion completion) {
        this.allCompletions.add(completion);
    }

    protected void addCompletions(AutoCompletions.Completion ... completions) {
        for (AutoCompletions.Completion c : completions) {
            this.addCompletion(c);
        }
    }

    protected void addCompletions(Collection<? extends AutoCompletions.Completion> completions) {
        for (AutoCompletions.Completion completion : completions) {
            this.addCompletion(completion);
        }
    }

    public List<AutoCompletions.Completion> getCompletions(String text, int pos) {
        Map<AutoCompletions.CompletionTokenizer, String> tokenMap = this.allCompletions.stream().map(c -> c.getTokenizer()).distinct().collect(Collectors.toMap(c -> c, c -> c.getToken(text, pos)));
        List<AutoCompletions.Completion> completions = text.contains(".") ? this.allCompletions.stream().filter(e -> e.isCompatible(text, pos, (String)tokenMap.getOrDefault(e, null))).toList() : this.allCompletions.stream().filter(s -> s.isCompatible(text, pos, (String)tokenMap.getOrDefault(s, null)) && (!s.getCompletionText().contains(".") || s.getCompletionText().lastIndexOf(".") == s.getCompletionText().length() - 1)).toList();
        String start = AutoCompletions.JAVA_TOKENIZER.getToken(text, pos);
        if (completions.isEmpty() && start.contains(".")) {
            String className = start.substring(0, start.lastIndexOf("."));
            try {
                Class<?> cls = Class.forName(className);
                if (DefaultAutoCompletor.addStaticMethods(cls, this.allCompletions) > 0) {
                    return this.getCompletions(text, pos);
                }
            }
            catch (Exception e2) {
                logger.debug("Unable to find autocomplete methods for class {}", (Object)className);
            }
        }
        return completions;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_6;
        void var2_4;
        logger = LoggerFactory.getLogger(DefaultAutoCompletor.class);
        DEFAULT_QUPATH_JAVA_COMPLETIONS = new HashSet<AutoCompletions.Completion>();
        AccessibleObject[] accessibleObjectArray = QPEx.class.getMethods();
        int n = accessibleObjectArray.length;
        boolean bl = false;
        while (var2_4 < n) {
            Method method = accessibleObjectArray[var2_4];
            if (method.getAnnotation(Deprecated.class) == null) {
                DEFAULT_QUPATH_JAVA_COMPLETIONS.add(AutoCompletions.createJavaCompletion(method.getDeclaringClass(), (Method)method));
                DEFAULT_QUPATH_JAVA_COMPLETIONS.add(AutoCompletions.createJavaCompletion(null, (Method)method));
            }
            ++var2_4;
        }
        accessibleObjectArray = QPEx.class.getFields();
        n = accessibleObjectArray.length;
        boolean bl2 = false;
        while (var2_6 < n) {
            AccessibleObject accessibleObject = accessibleObjectArray[var2_6];
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) && Modifier.isPublic(((Field)accessibleObject).getModifiers())) {
                DEFAULT_QUPATH_JAVA_COMPLETIONS.add(AutoCompletions.createJavaCompletion(((Field)accessibleObject).getDeclaringClass(), (Field)accessibleObject));
                DEFAULT_QUPATH_JAVA_COMPLETIONS.add(AutoCompletions.createJavaCompletion(null, (Field)accessibleObject));
            }
            ++var2_6;
        }
        HashSet classesToAdd = new HashSet(QPEx.getCoreClasses());
        for (Class clazz : classesToAdd) {
            DefaultAutoCompletor.addStaticMethods(clazz, DEFAULT_QUPATH_JAVA_COMPLETIONS);
        }
    }
}

