/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextArea;
import qupath.lib.gui.scripting.ScriptEditorControl;

public class TextAreaControl
implements ScriptEditorControl<TextArea> {
    private TextArea textArea;

    public TextAreaControl(boolean isEditable) {
        this(new TextArea(), isEditable);
    }

    public TextAreaControl(TextArea textArea, boolean isEditable) {
        Objects.requireNonNull(textArea);
        this.textArea = textArea;
        this.textArea.setEditable(isEditable);
    }

    @Override
    public StringProperty textProperty() {
        return this.textArea.textProperty();
    }

    @Override
    public void setText(String text) {
        this.textArea.setText(text);
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public ObservableValue<String> selectedTextProperty() {
        return this.textArea.selectedTextProperty();
    }

    @Override
    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    @Override
    public TextArea getRegion() {
        return this.textArea;
    }

    @Override
    public boolean isUndoable() {
        return this.textArea.isUndoable();
    }

    @Override
    public boolean isRedoable() {
        return this.textArea.isRedoable();
    }

    @Override
    public void undo() {
        this.textArea.undo();
    }

    @Override
    public void redo() {
        this.textArea.redo();
    }

    @Override
    public void copy() {
        this.textArea.copy();
    }

    @Override
    public void cut() {
        this.textArea.cut();
    }

    @Override
    public void paste() {
        this.textArea.paste();
    }

    @Override
    public void clear() {
        this.textArea.clear();
    }

    @Override
    public void appendText(String text) {
        this.textArea.appendText(text);
    }

    @Override
    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    @Override
    public void insertText(int pos, String text) {
        this.textArea.insertText(pos, text);
    }

    @Override
    public void deleteText(int startIdx, int endIdx) {
        this.textArea.deleteText(startIdx, endIdx);
    }

    @Override
    public void deselect() {
        this.textArea.deselect();
    }

    @Override
    public IndexRange getSelection() {
        return this.textArea.getSelection();
    }

    @Override
    public void selectRange(int startIdx, int endIdx) {
        this.textArea.selectRange(startIdx, endIdx);
    }

    @Override
    public BooleanProperty wrapTextProperty() {
        return this.textArea.wrapTextProperty();
    }

    @Override
    public void positionCaret(int index) {
        this.textArea.positionCaret(index);
    }

    @Override
    public void replaceSelection(String text) {
        this.textArea.replaceSelection(text);
    }

    @Override
    public void setContextMenu(ContextMenu menu) {
        this.textArea.setContextMenu(menu);
    }

    @Override
    public ContextMenu getContextMenu() {
        return this.textArea.getContextMenu();
    }

    @Override
    public void requestFocus() {
        this.textArea.requestFocus();
    }

    @Override
    public ReadOnlyIntegerProperty caretPositionProperty() {
        return this.textArea.caretPositionProperty();
    }
}

