/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.scripting.ScriptEditorControl;
import qupath.lib.gui.scripting.languages.ScriptLanguageProvider;
import qupath.lib.scripting.languages.ScriptLanguage;

public class ScriptTab {
    private static final Logger logger = LoggerFactory.getLogger(ScriptTab.class);
    private File file = null;
    private long lastModified = -1L;
    private String lastSavedContents = null;
    private static int untitledCounter = 0;
    private ScriptLanguage language;
    private BooleanProperty isModified = new SimpleBooleanProperty(false);
    private String name;
    private ScriptEditorControl<? extends Region> console;
    private ScriptEditorControl<? extends Region> editor;
    private boolean isRunning = false;

    ScriptTab(ScriptEditorControl<? extends Region> editor, ScriptEditorControl<? extends Region> console, String script, ScriptLanguage language) {
        this.editor = editor;
        this.console = console;
        this.initialize();
        this.language = language;
        if (script != null) {
            editor.setText(script);
        }
        this.name = "Untitled " + ++untitledCounter;
    }

    ScriptTab(ScriptEditorControl<? extends Region> editor, ScriptEditorControl<? extends Region> console, File file) throws IOException {
        this.editor = editor;
        this.console = console;
        this.initialize();
        this.readFile(file);
    }

    protected void readFile(File file) throws IOException {
        logger.info("Loading file {} to Script Editor", (Object)file.getAbsolutePath());
        String content = GeneralTools.readFileAsString((File)file);
        this.editor.setText(content);
        this.editor.positionCaret(0);
        this.name = file.getName();
        this.file = file;
        this.lastModified = file.lastModified();
        this.lastSavedContents = content;
        this.language = ScriptLanguageProvider.getLanguageFromName(this.name);
        this.updateIsModified();
    }

    protected void refreshFileContents() {
        try {
            if (this.file != null && this.file.lastModified() > this.lastModified) {
                logger.debug("Calling refresh!");
                this.readFile(this.file);
                this.updateIsModified();
            }
        }
        catch (IOException e) {
            logger.error("Cannot refresh script file", (Throwable)e);
        }
    }

    void initialize() {
        BorderPane panelMainEditor = new BorderPane();
        panelMainEditor.setCenter((Node)this.editor.getRegion());
        ContextMenu popup = this.console.getContextMenu();
        if (popup == null) {
            popup = new ContextMenu();
            popup.getItems().add((Object)ActionUtils.createMenuItem((Action)new Action("Copy", e -> this.console.copy())));
        }
        popup.getItems().add((Object)ActionUtils.createMenuItem((Action)new Action("Clear console", e -> this.console.setText(""))));
        popup.getStyleClass().setAll((Object[])new String[]{"context-menu"});
        this.console.setContextMenu(popup);
        this.updateIsModified();
    }

    ScriptEditorControl<? extends Region> getEditorControl() {
        return this.editor;
    }

    boolean hasScript() {
        return !this.editor.getText().isEmpty();
    }

    ScriptEditorControl<? extends Region> getConsoleControl() {
        return this.console;
    }

    File getFile() {
        return this.file;
    }

    boolean fileExists() {
        return this.file != null && this.file.exists();
    }

    boolean isRunning() {
        return this.isRunning;
    }

    void setRunning(boolean running) {
        this.isRunning = running;
    }

    public boolean isModified() {
        return this.isModified.get();
    }

    public BooleanProperty isModifiedProperty() {
        return this.isModified;
    }

    void updateIsModified() {
        boolean newState;
        boolean bl = newState = !this.fileExists() || !this.editor.getText().equals(this.lastSavedContents);
        if (this.isModified.get() == newState) {
            return;
        }
        this.isModified.set(newState);
    }

    void saveToFile(String text, File file) throws IOException {
        Files.writeString(file.toPath(), (CharSequence)text, new OpenOption[0]);
        this.file = file;
        this.name = file.getName();
        this.lastSavedContents = text;
        this.lastModified = file.lastModified();
        this.updateIsModified();
    }

    ScriptLanguage getLanguage() {
        return this.language;
    }

    void setLanguage(ScriptLanguage language) {
        this.language = language;
        this.editor.setLanguage(language);
    }

    Set<String> getRequestedExtensions() {
        return this.language.getExtensions();
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.isModified.get() ? "*" + this.name : this.name;
    }
}

