/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import com.sun.javafx.css.PseudoClassState;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.scripting.DefaultScriptEditor;
import qupath.lib.gui.scripting.ScriptEditorControl;

class ScriptFindCommand
implements Runnable {
    private Stage stage;
    private final DefaultScriptEditor scriptEditor;
    private final TextField tfFind = new TextField();
    private final TextField tfReplace = new TextField();
    private final Button btNext = new Button("Next");
    private final Label lbReplacedOccurrences = new Label();
    private final Label lbFoundOccurrences = new Label();
    private final CheckBox cbIgnoreCase = new CheckBox("Ignore case");
    private double xPos = -1.0;
    private double yPos = -1.0;
    private EventHandler<KeyEvent> eventHandler = e -> {
        if (e.getCode() == KeyCode.ENTER) {
            this.findNextAction(true);
            e.consume();
        }
    };

    ScriptFindCommand(DefaultScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
    }

    @Override
    public void run() {
        String selectedText;
        if (this.stage != null) {
            this.stage.hide();
        }
        if (!(selectedText = this.scriptEditor.getSelectedText()).isEmpty()) {
            if (selectedText.replace("\t", "").length() != 0) {
                this.tfFind.setText(selectedText);
                this.btNext.requestFocus();
            } else {
                this.tfFind.setText("");
            }
        } else {
            this.tfFind.selectAll();
        }
        this.createFindStage();
        this.lbReplacedOccurrences.setText("");
        this.lbFoundOccurrences.setText("");
        this.stage.show();
        this.tfFind.requestFocus();
        this.tfFind.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
        this.tfReplace.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
    }

    private void createFindStage() {
        this.stage = new Stage();
        this.stage.setTitle("Find/Replace");
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.initOwner((Window)this.scriptEditor.getStage());
        this.stage.initModality(Modality.NONE);
        this.stage.setOnHiding(e -> {
            this.xPos = this.stage.getX();
            this.yPos = this.stage.getY();
            this.stage = null;
        });
        ScriptEditorControl<? extends Region> control = this.scriptEditor.getCurrentEditorControl();
        Button btPrevious = new Button("Previous");
        Button btClose = new Button("Close");
        Button btReplaceNext = new Button("Replace/Next");
        Button btReplaceAll = new Button("Replace all");
        GridPane pane = new GridPane();
        pane.setVgap(10.0);
        pane.setHgap(10.0);
        this.tfFind.setMinWidth(350.0);
        this.tfReplace.setMinWidth(350.0);
        this.lbFoundOccurrences.setMinWidth(150.0);
        HBox.setHgrow((Node)this.lbFoundOccurrences, (Priority)Priority.ALWAYS);
        int row = 0;
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Enter the text to find", (Node[])new Node[]{new Label("Find: "), this.tfFind, this.tfFind, this.tfFind});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Replace instance of query with the specified word", (Node[])new Node[]{new Label("Replace with: "), this.tfReplace, this.tfReplace, this.tfReplace});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Ignore case when searching query", (Node[])new Node[]{this.cbIgnoreCase, this.cbIgnoreCase, this.cbIgnoreCase, this.cbIgnoreCase});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{btReplaceNext, btReplaceAll, this.lbReplacedOccurrences, this.lbReplacedOccurrences});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{btPrevious, this.btNext, this.lbFoundOccurrences, btClose});
        btPrevious.setMinWidth(100.0);
        this.btNext.setMinWidth(100.0);
        btReplaceNext.setMinWidth(100.0);
        btReplaceAll.setMinWidth(100.0);
        btClose.setMinWidth(100.0);
        this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), true);
        this.tfFind.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), true);
            }
        });
        this.tfReplace.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), true);
            }
        });
        this.stage.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                btClose.fire();
                e.consume();
            }
        });
        this.btNext.setOnAction(e -> this.findNextAction(true));
        btPrevious.setOnAction(e -> this.findPrevious(this.scriptEditor.getCurrentEditorControl(), this.tfFind.getText(), this.cbIgnoreCase.isSelected()));
        this.btNext.disableProperty().bind((ObservableValue)this.tfFind.textProperty().isEmpty());
        btPrevious.disableProperty().bind((ObservableValue)this.tfFind.textProperty().isEmpty());
        btReplaceNext.disableProperty().bind((ObservableValue)this.tfFind.textProperty().isEmpty().or((ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cbIgnoreCase.isSelected()) {
                return !this.tfFind.getText().toLowerCase().equals(((String)this.scriptEditor.getCurrentEditorControl().selectedTextProperty().getValue()).toLowerCase());
            }
            return !this.tfFind.getText().equals(this.scriptEditor.getCurrentEditorControl().selectedTextProperty().getValue());
        }, (Observable[])new Observable[]{control.selectedTextProperty(), this.cbIgnoreCase.selectedProperty(), this.tfFind.textProperty()})));
        btReplaceAll.disableProperty().bind((ObservableValue)this.tfFind.textProperty().isEmpty());
        btReplaceNext.setOnAction(e -> {
            ScriptEditorControl<? extends Region> controlTemp = this.scriptEditor.getCurrentEditorControl();
            this.replaceFind(controlTemp, this.tfFind.getText(), this.cbIgnoreCase.isSelected());
            if (!controlTemp.getText().contains(this.tfFind.getText())) {
                this.tfFind.requestFocus();
                this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), true);
            }
        });
        btReplaceAll.setOnAction(e -> this.replaceAll(this.scriptEditor.getCurrentEditorControl(), this.tfFind.getText(), this.cbIgnoreCase.isSelected()));
        btClose.setOnAction(e -> this.stage.hide());
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.stage.setScene(new Scene((Parent)pane));
        if (this.xPos != -1.0 && this.yPos != -1.0) {
            this.stage.setX(this.xPos);
            this.stage.setY(this.yPos);
        }
    }

    private void findNextAction(boolean btNextFocus) {
        int found = this.findNext(this.scriptEditor.getCurrentEditorControl(), this.tfFind.getText(), this.cbIgnoreCase.isSelected());
        this.lbFoundOccurrences.setText(found == -1 ? "String not found" : "");
        this.lbReplacedOccurrences.setText("");
        this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), btNextFocus);
    }

    private void replaceFind(ScriptEditorControl control, String text, boolean ignoreCase) {
        this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), false);
        this.lbReplacedOccurrences.setText("");
        this.lbFoundOccurrences.setText("");
        String selected = control.getSelectedText();
        IndexRange range = control.getSelection();
        control.deleteText(range.getStart(), range.getEnd());
        control.insertText(range.getStart(), this.tfReplace.getText());
        this.findNext(control, selected, ignoreCase);
    }

    private void replaceAll(ScriptEditorControl control, String text, boolean ignoreCase) {
        this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), false);
        String controlText = control.getText();
        int initialCaretPos = control.getSelection().getStart();
        Pattern pattern = Pattern.compile(text, 0x10 | (ignoreCase ? 2 : 0) | 0x40);
        String subTextTemp = pattern.matcher(controlText.substring(0, initialCaretPos)).replaceAll(this.tfReplace.getText());
        int finalCaretPos = initialCaretPos + subTextTemp.length() - controlText.substring(0, initialCaretPos).length();
        Matcher matcher = pattern.matcher(controlText);
        long count = matcher.results().count();
        if (count != 0L) {
            control.setText(matcher.replaceAll(this.tfReplace.getText()));
            control.positionCaret(finalCaretPos);
            control.requestFollowCaret();
        }
        this.lbFoundOccurrences.setText("");
        this.lbReplacedOccurrences.setText((String)(count == 0L ? "String not found" : count + " match" + (count > 1L ? "es" : "") + " replaced"));
    }

    private int findNext(ScriptEditorControl control, String findText, boolean ignoreCase) {
        if (control == null || findText == null || findText.isEmpty()) {
            return -1;
        }
        String text = control.getText();
        String toFind = null;
        if (ignoreCase) {
            toFind = findText.toLowerCase();
            text = text.toLowerCase();
        } else {
            toFind = findText;
        }
        if (!text.contains(toFind)) {
            return -1;
        }
        int pos = control.getSelection().getEnd();
        int ind = text.substring(pos).indexOf(toFind);
        ind = ind < 0 ? text.indexOf(toFind) : (ind += pos);
        control.selectRange(ind, ind + toFind.length());
        control.requestFollowCaret();
        return ind;
    }

    private int findPrevious(ScriptEditorControl control, String findText, boolean ignoreCase) {
        int ind;
        this.lbFoundOccurrences.setText("String not found");
        if (control == null || findText == null || findText.isEmpty()) {
            return -1;
        }
        this.btNext.pseudoClassStateChanged(PseudoClassState.getPseudoClass((String)"focused"), false);
        this.lbReplacedOccurrences.setText("");
        String text = control.getText();
        String toFind = null;
        if (ignoreCase) {
            toFind = findText.toLowerCase();
            text = text.toLowerCase();
        } else {
            toFind = findText;
        }
        if (!text.contains(toFind)) {
            return -1;
        }
        int pos = control.getSelection().getStart();
        int n = ind = pos == 0 ? text.lastIndexOf(toFind) : text.substring(0, pos).lastIndexOf(toFind);
        if (ind < 0) {
            ind = text.lastIndexOf(toFind);
        }
        control.selectRange(ind, ind + toFind.length());
        control.requestFollowCaret();
        this.lbFoundOccurrences.setText(ind == -1 ? "String not found" : "");
        return ind;
    }
}

