/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import qupath.ext.extensionmanager.gui.ExtensionManager;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.scripting.languages.ScriptLanguageProvider;

class ScriptEditorDragDropListener
implements EventHandler<DragEvent> {
    private final QuPathGUI qupath;

    public ScriptEditorDragDropListener(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public void handle(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        if (dragboard.hasFiles()) {
            List list = dragboard.getFiles();
            if (list == null) {
                return;
            }
            List<File> jars = list.stream().filter(f -> f.getName().toLowerCase().endsWith(".jar")).toList();
            if (!jars.isEmpty()) {
                ExtensionManager.promptToCopyFilesToExtensionDirectory((List)list, (ReadOnlyObjectProperty)QuPathGUI.getExtensionCatalogManager().getExtensionDirectoryPath(), () -> Commands.requestUserDirectory(true));
            }
            List<File> remainingFiles = list.stream().filter(f -> !f.getName().toLowerCase().endsWith(".jar")).toList();
            HashSet supported = ScriptLanguageProvider.getAvailableLanguages().stream().flatMap(l -> l.getExtensions().stream()).collect(Collectors.toCollection(HashSet::new));
            supported.add(".qpproj");
            supported.add(".qpdata");
            block0: for (File file : remainingFiles) {
                for (String supportedExt : supported) {
                    if (!file.getName().toLowerCase().endsWith(supportedExt)) continue;
                    this.qupath.getScriptEditor().showScript(file);
                    continue block0;
                }
            }
        }
    }
}

