/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.layout.Region;
import qupath.lib.gui.logging.TextAppendable;
import qupath.lib.gui.scripting.EditableText;
import qupath.lib.scripting.languages.ScriptLanguage;

public interface ScriptEditorControl<T extends Region>
extends TextAppendable,
EditableText {
    public StringProperty textProperty();

    public IndexRange getSelection();

    @Override
    default public int getSelectionStart() {
        return this.getSelection().getStart();
    }

    @Override
    default public int getSelectionEnd() {
        return this.getSelection().getEnd();
    }

    public void paste();

    public ObservableValue<String> selectedTextProperty();

    public boolean isUndoable();

    public boolean isRedoable();

    public T getRegion();

    public void undo();

    public void redo();

    public void copy();

    public void cut();

    public BooleanProperty wrapTextProperty();

    default public void requestFollowCaret() {
    }

    public ReadOnlyIntegerProperty caretPositionProperty();

    public void setContextMenu(ContextMenu var1);

    public ContextMenu getContextMenu();

    default public void requestFocus() {
        this.getRegion().requestFocus();
    }

    default public void setLanguage(ScriptLanguage language) {
    }

    default public ScriptLanguage getLanguage() {
        return null;
    }
}

