/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.ThreadTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.display.settings.DisplaySettingUtils;
import qupath.lib.display.settings.ImageDisplaySettings;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.TaskRunnerFX;
import qupath.lib.gui.UserDirectoryManager;
import qupath.lib.gui.charts.Charts;
import qupath.lib.gui.commands.SummaryMeasurementTableCommand;
import qupath.lib.gui.images.servers.RenderedImageServer;
import qupath.lib.gui.logging.LogManager;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.measure.ui.SummaryMeasurementTable;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tma.TMADataIO;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MeasurementExporter;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.LabeledImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.writers.ImageWriterTools;
import qupath.lib.io.UriUpdater;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.plugins.CommandLineTaskRunner;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.TaskRunnerUtils;
import qupath.lib.projects.Project;
import qupath.lib.projects.ResourceManager;
import qupath.lib.regions.RegionRequest;
import qupath.lib.scripting.QP;

public class QPEx
extends QP {
    private static final Logger logger = LoggerFactory.getLogger(QPEx.class);
    private static final Collection<Class<?>> CORE_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(QuPathGUI.class, Dialogs.class, FileChoosers.class, GuiTools.class, Charts.class, MenuTools.class, GridPaneUtils.class, LabeledImageServer.class, MeasurementExporter.class, PathPrefs.class, LogManager.class, Platform.class)));

    public static Collection<Class<?>> getCoreClasses() {
        LinkedHashSet set = new LinkedHashSet(QP.getCoreClasses());
        set.addAll(CORE_CLASSES);
        return set;
    }

    public static void exportTMAData(String path, double downsampleFactor) throws IOException {
        QPEx.exportTMAData((ImageData<BufferedImage>)QPEx.getCurrentImageData(), QPEx.resolvePath((String)path), downsampleFactor);
    }

    public static void exportTMAData(ImageData<BufferedImage> imageData, String path, double downsampleFactor) throws IOException {
        if (imageData == null) {
            return;
        }
        TMADataIO.writeTMAData(new File(QPEx.resolvePath((String)path)), imageData, null, downsampleFactor);
    }

    public static QuPathGUI getQuPath() {
        return QuPathGUI.getInstance();
    }

    public static QuPathViewer getCurrentViewer() {
        QuPathGUI qupath = QuPathGUI.getInstance();
        return qupath == null ? null : qupath.getViewer();
    }

    public static String locateFile(String nameOrPath) throws IOException {
        return QPEx.locateFile(nameOrPath, 4);
    }

    public static String locateFile(String nameOrPath, int searchDepth) throws IOException {
        Path userPath;
        Path path;
        ArrayList<Path> paths = new ArrayList<Path>();
        Project project = QPEx.getProject();
        Path path2 = path = project == null ? null : project.getPath();
        if (path != null) {
            paths.add(path);
        }
        if ((userPath = UserDirectoryManager.getInstance().getUserPath()) != null) {
            paths.add(userPath);
        }
        if (!paths.isEmpty()) {
            return UriUpdater.locateFile((String)nameOrPath, (int)searchDepth, (Path[])((Path[])paths.toArray(Path[]::new)));
        }
        return nameOrPath;
    }

    public static boolean runPlugin(String className, ImageData<?> imageData, String args) throws InterruptedException {
        if (imageData == null) {
            return false;
        }
        boolean completed = false;
        String pluginName = className;
        boolean cancelled = false;
        try {
            Class<?> cPlugin = QP.class.getClassLoader().loadClass(className);
            Constructor<?> cons = cPlugin.getConstructor(new Class[0]);
            PathPlugin plugin = (PathPlugin)cons.newInstance(new Object[0]);
            pluginName = plugin.getName();
            QuPathGUI qupath = QPEx.getQuPath();
            if (QPEx.isBatchMode() || imageData != qupath.getImageData()) {
                CommandLineTaskRunner runner = new CommandLineTaskRunner();
                completed = plugin.runPlugin((TaskRunner)runner, imageData, args);
                cancelled = runner.isCancelled();
            } else {
                completed = qupath.runPlugin((PathPlugin<BufferedImage>)plugin, args, false);
                cancelled = !completed;
            }
        }
        catch (Exception e) {
            logger.error("Error running plugin {}: {}", (Object)className, (Object)e.getLocalizedMessage());
            logger.error("", (Throwable)e);
        }
        if (cancelled) {
            throw new InterruptedException(pluginName + " cancelled!");
        }
        return completed;
    }

    public static boolean runPlugin(String className, String args) throws InterruptedException {
        ImageData imageData = QPEx.getCurrentImageData();
        if (imageData == null) {
            return false;
        }
        return QPEx.runPlugin(className, imageData, args);
    }

    static boolean isBatchMode() {
        return QPEx.getQuPath() == null || !QPEx.getQuPath().getStage().isShowing();
    }

    public static TaskRunner createTaskRunner() {
        return QPEx.createTaskRunner(ThreadTools.getParallelism());
    }

    public static TaskRunner createTaskRunner(int nThreads) {
        if (QPEx.isBatchMode() || QPEx.getCurrentViewer().getImageData() != QPEx.getCurrentImageData()) {
            logger.info("Creating headless task runner with {} threads", (Object)nThreads);
            return TaskRunnerUtils.getDefaultInstance().createHeadlessTaskRunner(nThreads);
        }
        logger.info("Creating interactive task runner with {} threads", (Object)nThreads);
        return new TaskRunnerFX(QPEx.getQuPath(), nThreads);
    }

    public static File promptForFile(String ... extensions) {
        String filterDescription;
        String string = filterDescription = extensions == null || extensions.length == 0 ? null : "Valid files";
        if (extensions != null && extensions.length == 0) {
            extensions = null;
        }
        return FileChoosers.promptForFile((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)filterDescription, (String[])extensions)});
    }

    public static void writeRenderedImage(ImageData<BufferedImage> imageData, String path) throws IOException {
        QPEx.writeRenderedImageRegion(imageData, null, path);
    }

    public static void writeRenderedImage(QuPathViewer viewer, String path) throws IOException {
        QPEx.writeRenderedImageRegion(viewer, null, path);
    }

    public static void writeRenderedImageRegion(ImageData<BufferedImage> imageData, RegionRequest request, String path) throws IOException {
        ImageServer<BufferedImage> renderedServer = new RenderedImageServer.Builder(imageData).build();
        if (request == null) {
            ImageWriterTools.writeImage(renderedServer, (String)path);
        } else {
            ImageWriterTools.writeImageRegion(renderedServer, (RegionRequest)request, (String)path);
        }
    }

    public static void writeRenderedImageRegion(QuPathViewer viewer, RegionRequest request, String path) throws IOException {
        ImageServer<BufferedImage> renderedServer = RenderedImageServer.createRenderedServer(viewer);
        if (request == null) {
            ImageWriterTools.writeImage(renderedServer, (String)path);
        } else {
            ImageWriterTools.writeImageRegion(renderedServer, (RegionRequest)request, (String)path);
        }
    }

    public static void writeImage(Image image, String path) throws IOException {
        QPEx.writeImage((BufferedImage)SwingFXUtils.fromFXImage((Image)image, null), (String)path);
    }

    public static void setChannelDisplayRange(int channel, double minDisplay, double maxDisplay) {
        QPEx.setChannelDisplayRange((ImageData<BufferedImage>)QPEx.getCurrentImageData(), channel, minDisplay, maxDisplay);
    }

    public static boolean setChannelDisplayRange(ImageData<BufferedImage> imageData, int channel, double minDisplay, double maxDisplay) {
        ImageDisplay display;
        QuPathViewer viewer = QPEx.getQuPath().getAllViewers().stream().filter(v -> v.getImageData() == imageData).findFirst().orElse(null);
        if (viewer == null) {
            try {
                display = ImageDisplay.create(imageData);
            }
            catch (IOException e) {
                logger.warn("Unable to set the display range for {} - ImageDisplay could not be initialized", imageData, (Object)e);
                return false;
            }
        } else {
            display = viewer.getImageDisplay();
        }
        ObservableList<ChannelDisplayInfo> available = display.availableChannels();
        if (channel < 0 || channel >= available.size()) {
            logger.warn("Channel {} is out of range ({}-{}) - cannot set display range", new Object[]{channel, 0, available.size() - 1});
            return false;
        }
        ChannelDisplayInfo info = (ChannelDisplayInfo)display.availableChannels().get(channel);
        display.setMinMaxDisplay(info, (float)minDisplay, (float)maxDisplay);
        if (viewer != null) {
            viewer.repaintEntireImage();
        }
        return true;
    }

    public static void setChannelDisplayRange(String channelName, double minDisplay, double maxDisplay) {
        QPEx.setChannelDisplayRange((ImageData<BufferedImage>)QPEx.getCurrentImageData(), channelName, minDisplay, maxDisplay);
    }

    public static void setChannelDisplayRange(ImageData<BufferedImage> imageData, String channelName, double minDisplay, double maxDisplay) {
        ImageDisplay display;
        QuPathViewer viewer = QPEx.getQuPath().getAllViewers().stream().filter(v -> v.getImageData() == imageData).findFirst().orElse(null);
        if (viewer == null) {
            try {
                display = ImageDisplay.create(imageData);
            }
            catch (IOException e) {
                logger.warn("Unable to set the display range for {} - ImageDisplay could not be initialized", imageData, (Object)e);
                return;
            }
        } else {
            display = viewer.getImageDisplay();
        }
        ObservableList<ChannelDisplayInfo> available = display.availableChannels();
        ChannelDisplayInfo info = null;
        List serverChannels = imageData.getServerMetadata().getChannels();
        for (ChannelDisplayInfo c : available) {
            int channelNumber;
            if (channelName.equals(c.getName())) {
                info = c;
                break;
            }
            if (!(c instanceof DirectServerChannelInfo) || (channelNumber = ((DirectServerChannelInfo)c).getChannel()) < 0 || channelNumber >= serverChannels.size() || !channelName.equals(((ImageChannel)serverChannels.get(channelNumber)).getName())) continue;
            info = c;
            break;
        }
        if (info == null) {
            logger.warn("No channel found with name {} - cannot set display range", (Object)channelName);
            return;
        }
        display.setMinMaxDisplay(info, (float)minDisplay, (float)maxDisplay);
        if (viewer != null) {
            viewer.repaintEntireImage();
        }
    }

    public static void saveAnnotationMeasurements(String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), PathAnnotationObject.class, path, includeColumns);
    }

    public static void saveTMAMeasurements(String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), TMACoreObject.class, path, includeColumns);
    }

    public static void saveDetectionMeasurements(String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), PathDetectionObject.class, path, includeColumns);
    }

    public static void saveCellMeasurements(String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), PathCellObject.class, path, includeColumns);
    }

    public static void saveTileMeasurements(String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), PathTileObject.class, path, includeColumns);
    }

    public static void saveImageMeasurements(String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), PathRootObject.class, path, includeColumns);
    }

    public static void saveImageMeasurements(ImageData<?> imageData, String path, String ... includeColumns) {
        QPEx.saveMeasurements(imageData, PathRootObject.class, path, includeColumns);
    }

    public static void saveAnnotationMeasurements(ImageData<?> imageData, String path, String ... includeColumns) {
        QPEx.saveMeasurements(imageData, PathAnnotationObject.class, path, includeColumns);
    }

    public static void saveTMAMeasurements(ImageData<?> imageData, String path, String ... includeColumns) {
        QPEx.saveMeasurements(imageData, TMACoreObject.class, path, includeColumns);
    }

    public static void saveDetectionMeasurements(ImageData<?> imageData, String path, String ... includeColumns) {
        QPEx.saveMeasurements(imageData, PathDetectionObject.class, path, includeColumns);
    }

    public static void saveMeasurements(Class<? extends PathObject> type, String path, String ... includeColumns) {
        QPEx.saveMeasurements(QPEx.getCurrentImageData(), type, path, includeColumns);
    }

    public static void saveMeasurements(ImageData<?> imageData, Class<? extends PathObject> type, String path, String ... includeColumns) {
        File fileOutput = new File(QPEx.resolvePath((String)path));
        if (fileOutput.isDirectory()) {
            String ext = ",".equals(PathPrefs.tableDelimiterProperty().get()) ? ".csv" : ".txt";
            fileOutput = new File(fileOutput, ServerTools.getDisplayableImageName((ImageServer)imageData.getServer()) + " " + PathObjectTools.getSuitableName(type, (boolean)true) + ext);
        }
        ObservableMeasurementTableData model = new ObservableMeasurementTableData();
        model.setImageData(imageData, imageData == null ? Collections.emptyList() : imageData.getHierarchy().getObjects(null, type));
        try (PrintWriter writer = new PrintWriter(fileOutput, StandardCharsets.UTF_8);){
            List<String> excludeColumns;
            if (includeColumns.length == 0) {
                excludeColumns = Collections.emptyList();
            } else {
                excludeColumns = new LinkedHashSet<String>(model.getAllNames());
                excludeColumns.removeAll(Arrays.asList(includeColumns));
            }
            for (String row : SummaryMeasurementTable.getTableModelStrings(model, (String)PathPrefs.tableDelimiterProperty().get(), excludeColumns)) {
                writer.println(row);
            }
            writer.close();
        }
        catch (IOException e) {
            logger.error("Error writing file to {}", (Object)fileOutput, (Object)e);
        }
    }

    public static Window getWindow(String title) {
        for (Window window : Window.getWindows()) {
            Stage stage;
            if (!(window instanceof Stage) || !title.equals((stage = (Stage)window).getTitle())) continue;
            return stage;
        }
        return null;
    }

    public static void copyToClipboard(Object o) {
        if (!Platform.isFxApplicationThread()) {
            Object o2 = o;
            Platform.runLater(() -> QPEx.copyToClipboard(o2));
            return;
        }
        ClipboardContent content = new ClipboardContent();
        if (o instanceof BufferedImage) {
            o = SwingFXUtils.toFXImage((BufferedImage)((BufferedImage)o), null);
        }
        if (o instanceof QuPathGUI) {
            o = ((QuPathGUI)o).getStage();
        }
        if (o instanceof QuPathViewer) {
            o = ((QuPathViewer)o).getView();
        }
        if (o instanceof Window) {
            o = ((Window)o).getScene();
        }
        if (o instanceof Scene) {
            o = ((Scene)o).snapshot(null);
        }
        if (o instanceof Node) {
            o = ((Node)o).snapshot(null, null);
        }
        if (o instanceof Image) {
            content.putImage((Image)o);
        }
        List<File> files = null;
        if (o instanceof File) {
            files = Arrays.asList((File)o);
        } else if (o instanceof File[]) {
            files = Arrays.asList((File[])o);
        } else if (o instanceof Collection) {
            files = new ArrayList<File>();
            for (Object something : (Collection)o) {
                if (!(something instanceof File)) continue;
                files.add((File)something);
            }
        }
        if (files != null && !files.isEmpty()) {
            content.putFiles(files);
        }
        if (o instanceof URL) {
            content.putUrl(((URL)o).toString());
        }
        content.putString(o.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public static ImageDisplaySettings loadDisplaySettings(String name) {
        Path path;
        Project project = QPEx.getProject();
        if (project != null) {
            ResourceManager.Manager<ImageDisplaySettings> manager = DisplaySettingUtils.getResourcesForProject(project);
            try {
                if (manager.getNames().contains(name)) {
                    return (ImageDisplaySettings)manager.get(name);
                }
            }
            catch (IOException e) {
                logger.error("Error attempting to access resource manager for project {}", (Object)project, (Object)e);
            }
        }
        if (Files.exists(path = Paths.get(name, new String[0]), new LinkOption[0])) {
            try {
                return DisplaySettingUtils.parseDisplaySettings(path);
            }
            catch (IOException e) {
                logger.error("Error attempting to read {}", (Object)path, (Object)e);
            }
        }
        logger.warn("Cannot find display settings {} either as a file path or in the current project", (Object)name);
        return null;
    }

    public static boolean applyDisplaySettings(String name) {
        ImageDisplaySettings settings = QPEx.loadDisplaySettings(name);
        if (settings != null) {
            return QPEx.applyDisplaySettings(QPEx.getCurrentViewer(), settings);
        }
        logger.warn("Unable to load display settings from {}", (Object)name);
        return false;
    }

    public static boolean applyDisplaySettings(ImageDisplaySettings settings) {
        return QPEx.applyDisplaySettings(QPEx.getCurrentViewer(), settings);
    }

    public static boolean applyDisplaySettings(QuPathViewer viewer, ImageDisplaySettings settings) {
        if (viewer != null && settings != null && DisplaySettingUtils.applySettingsToDisplay(viewer.getImageDisplay(), settings)) {
            QPEx.maybeSyncSettingsAcrossViewers(viewer.getImageDisplay());
            return true;
        }
        return false;
    }

    private static void maybeSyncSettingsAcrossViewers(ImageDisplay display) {
        QuPathGUI qupath = QPEx.getQuPath();
        if (qupath == null || display == null || !PathPrefs.keepDisplaySettingsProperty().get()) {
            return;
        }
        for (QuPathViewer otherViewer : qupath.getAllViewers()) {
            if (!otherViewer.hasServer() || Objects.equals(display, otherViewer.getImageDisplay())) continue;
            otherViewer.getImageDisplay().updateFromDisplay(display);
        }
    }

    public static void showTmaCoreMeasurementTable() {
        QPEx.showTmaCoreMeasurementTable((ImageData<BufferedImage>)QPEx.getCurrentImageData());
    }

    public static void showTmaCoreMeasurementTable(ImageData<BufferedImage> imageData) {
        QPEx.showMeasurementTable(imageData, (Predicate<PathObject>)PathObjectFilter.TMA_CORES);
    }

    public static void showDetectionMeasurementTable() {
        QPEx.showDetectionMeasurementTable((ImageData<BufferedImage>)QPEx.getCurrentImageData());
    }

    public static void showDetectionMeasurementTable(ImageData<BufferedImage> imageData) {
        QPEx.showMeasurementTable(imageData, (Predicate<PathObject>)PathObjectFilter.DETECTIONS_ALL);
    }

    public static void showAnnotationMeasurementTable() {
        QPEx.showAnnotationMeasurementTable((ImageData<BufferedImage>)QPEx.getCurrentImageData());
    }

    public static void showAnnotationMeasurementTable(ImageData<BufferedImage> imageData) {
        QPEx.showMeasurementTable(imageData, (Predicate<PathObject>)PathObjectFilter.ANNOTATIONS);
    }

    public static void showCellMeasurementTable() {
        QPEx.showCellMeasurementTable((ImageData<BufferedImage>)QPEx.getCurrentImageData());
    }

    public static void showCellMeasurementTable(ImageData<BufferedImage> imageData) {
        QPEx.showMeasurementTable(imageData, (Predicate<PathObject>)PathObjectFilter.CELLS);
    }

    public static void showTileMeasurementTable() {
        QPEx.showTileMeasurementTable((ImageData<BufferedImage>)QPEx.getCurrentImageData());
    }

    public static void showTileMeasurementTable(ImageData<BufferedImage> imageData) {
        QPEx.showMeasurementTable(imageData, (Predicate<PathObject>)PathObjectFilter.TILES);
    }

    public static void showMeasurementTable(Predicate<PathObject> filter) {
        QPEx.showMeasurementTable((ImageData<BufferedImage>)QPEx.getCurrentImageData(), filter);
    }

    public static void showMeasurementTable(ImageData<BufferedImage> imageData, Predicate<PathObject> filter) {
        if (imageData == null) {
            logger.warn("Can't show measurement table - image data is null");
            return;
        }
        SummaryMeasurementTableCommand command = new SummaryMeasurementTableCommand(QuPathGUI.getInstance());
        FXUtils.runOnApplicationThread(() -> command.showTable(imageData, filter));
    }
}

