/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.script.ScriptException;
import org.apache.commons.text.StringEscapeUtils;
import org.controlsfx.control.ListSelectionView;
import org.controlsfx.control.action.Action;
import org.controlsfx.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.JavadocViewerRunner;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.dialogs.ProjectDialogs;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.logging.LogManager;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.scripting.QPEx;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.scripting.ScriptEditorControl;
import qupath.lib.gui.scripting.ScriptEditorDragDropListener;
import qupath.lib.gui.scripting.ScriptFindCommand;
import qupath.lib.gui.scripting.ScriptTab;
import qupath.lib.gui.scripting.TextAreaControl;
import qupath.lib.gui.scripting.languages.DefaultScriptLanguage;
import qupath.lib.gui.scripting.languages.GroovyLanguage;
import qupath.lib.gui.scripting.languages.HtmlRenderer;
import qupath.lib.gui.scripting.languages.PlainLanguage;
import qupath.lib.gui.scripting.languages.ScriptLanguageProvider;
import qupath.lib.gui.scripting.syntax.ScriptSyntax;
import qupath.lib.gui.scripting.syntax.ScriptSyntaxProvider;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.tools.WebViews;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;
import qupath.lib.scripting.QP;
import qupath.lib.scripting.ScriptParameters;
import qupath.lib.scripting.languages.ExecutableLanguage;
import qupath.lib.scripting.languages.ScriptLanguage;

public class DefaultScriptEditor
implements ScriptEditor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScriptEditor.class);
    private final ScriptEditorDragDropListener dragDropListener;
    private StringProperty fontSize = PathPrefs.createPersistentPreference("scriptingFontSize", null);
    private ObjectProperty<Future<?>> runningTask = new SimpleObjectProperty();
    private QuPathGUI qupath;
    private Stage dialog;
    private SplitPane splitMain;
    private ToggleGroup toggleLanguages = new ToggleGroup();
    private Font fontMain = Font.font((String)"Courier");
    private boolean quitCancelled = false;
    private BorderPane paneCode = new BorderPane();
    private BorderPane paneConsole = new BorderPane();
    private BorderPane paneBottom = new BorderPane((Node)this.paneConsole);
    private ObjectProperty<ScriptTab> selectedScript = new SimpleObjectProperty();
    private ObjectProperty<ScriptLanguage> currentLanguage = new SimpleObjectProperty();
    private ObjectProperty<ScriptSyntax> currentSyntax = new SimpleObjectProperty();
    private StringProperty timeProperty = new SimpleStringProperty();
    private AnimationTimer timer = new AnimationTimer(){
        private long startTime = 0L;

        public void start() {
            this.startTime = System.nanoTime();
            super.start();
        }

        public void stop() {
            super.stop();
        }

        public void handle(long now) {
            Duration duration = Duration.ofNanos(System.nanoTime() - this.startTime);
            String time = String.format("%d:%02d:%02d", duration.toHours(), duration.toMinutesPart(), duration.toSecondsPart());
            DefaultScriptEditor.this.timeProperty.set((Object)time);
        }
    };
    private StringBinding title = Bindings.createStringBinding(() -> {
        if (this.runningTask.get() == null) {
            return "Script Editor";
        }
        return "Script Editor (Running)";
    }, (Observable[])new Observable[]{this.runningTask});
    private Collection<KeyCombination> accelerators = new HashSet<KeyCombination>();
    protected KeyCombination comboPasteEscape = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN});
    protected final KeyCodeCombination completionCodeCombination = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
    protected Action beautifySourceAction = ActionTools.createAction(this::beautifySource, "Beautify source");
    protected Action compressSourceAction = ActionTools.createAction(this::compressSource, "Compress source");
    private IntegerProperty caretPosition = new SimpleIntegerProperty();
    private StringProperty scriptText = new SimpleStringProperty();
    private StringProperty selectedScriptText = new SimpleStringProperty();
    private ObservableStringValue caretPositionText = Bindings.createStringBinding(() -> {
        Object text = (String)this.scriptText.get();
        int pos = this.caretPosition.getValue();
        int lineNumber = 1;
        int col = pos + 1;
        if (text != null && pos > 0) {
            if (pos < ((String)text).length()) {
                text = ((String)text).substring(0, pos);
            }
            text = (String)text + " ";
            List<String> lines = ((String)text).lines().toList();
            lineNumber = lines.size();
            col = lines.get(lines.size() - 1).length();
            if (col == 0) {
                col = 1;
            }
        }
        return "[" + lineNumber + ":" + col + "]";
    }, (Observable[])new Observable[]{this.caretPosition, this.scriptText, this.selectedScriptText});
    private BooleanBinding disableRun = this.runningTask.isNotNull().or((ObservableBooleanValue)Bindings.createBooleanBinding(() -> !(this.currentLanguage.getValue() instanceof ExecutableLanguage), (Observable[])new Observable[]{this.currentLanguage})).or((ObservableBooleanValue)this.scriptText.isEmpty());
    private BooleanBinding disableRunSelected = this.disableRun.or((ObservableBooleanValue)this.selectedScriptText.isEmpty());
    private BooleanBinding canBeautifyBinding = Bindings.createBooleanBinding(() -> {
        ScriptSyntax syntax = this.getCurrentSyntax();
        return syntax == null || !syntax.canBeautify();
    }, (Observable[])new Observable[]{this.currentSyntaxProperty()});
    private BooleanBinding canCompressBinding = Bindings.createBooleanBinding(() -> {
        ScriptSyntax syntax = this.getCurrentSyntax();
        return syntax == null || !syntax.canCompress();
    }, (Observable[])new Observable[]{this.currentSyntaxProperty()});
    protected Action copyAction;
    protected Action cutAction;
    protected Action pasteAction;
    protected Action pasteAndEscapeAction;
    protected Action undoAction;
    protected Action redoAction;
    private Action zapGremlinsAction = this.createReplaceTextAction("Zap gremlins", GeneralTools::zapGremlins, true);
    private Action replaceQuotesAction = this.createReplaceTextAction("Replace curly quotes", GeneralTools::replaceCurlyQuotes, true);
    private final Action showJavadocsAction;
    protected Action runScriptAction;
    protected Action runSelectedAction;
    protected Action runProjectScriptAction;
    protected Action runProjectScriptNoSaveAction;
    protected Action killRunningScriptAction;
    protected Action insertMuAction;
    protected Action insertQPImportAction;
    protected Action insertQPExImportAction;
    protected Action insertAllDefaultImportAction;
    protected Action insertPixelClassifiersAction;
    protected Action insertObjectClassifiersAction;
    protected Action insertDetectionMeasurementsAction;
    protected Action findAction;
    protected Action smartEditingAction;
    private BooleanProperty useDefaultBindings = PathPrefs.createPersistentPreference("scriptingUseDefaultBindings", true);
    private BooleanProperty autoRefreshFiles = PathPrefs.createPersistentPreference("scriptingAutoRefreshFiles", true);
    private BooleanProperty sendLogToConsole = PathPrefs.createPersistentPreference("scriptingSendLogToConsole", true);
    private BooleanProperty outputScriptStartTime = PathPrefs.createPersistentPreference("scriptingOutputScriptStartTime", false);
    private BooleanProperty autoClearConsole = PathPrefs.createPersistentPreference("scriptingAutoClearConsole", true);
    private BooleanProperty clearCache = PathPrefs.createPersistentPreference("scriptingClearCache", false);
    protected BooleanProperty smartEditing = PathPrefs.createPersistentPreference("scriptingSmartEditing", true);
    private BooleanProperty wrapTextProperty = PathPrefs.createPersistentPreference("scriptingWrapText", false);
    private BooleanProperty useCompiled = PathPrefs.createPersistentPreference("scriptingUseCompiled", false);
    private static Pattern patternGuiScript = Pattern.compile("guiscript *?= *?true");
    private ListView<ScriptTab> listScripts = new ListView();
    private static Stage stageHtml;
    private static WebView webview;
    private List<ProjectImageEntry<BufferedImage>> previousImages = new ArrayList<ProjectImageEntry<BufferedImage>>();

    private void beautifySource() {
        ScriptTab tab = this.getCurrentScriptTab();
        ScriptEditorControl<? extends Region> editor = tab == null ? null : tab.getEditorControl();
        ScriptSyntax syntax = this.getCurrentSyntax();
        if (editor == null || syntax == null || !syntax.canBeautify()) {
            return;
        }
        editor.setText(syntax.beautify(editor.getText()));
    }

    private void compressSource() {
        ScriptTab tab = this.getCurrentScriptTab();
        ScriptEditorControl<? extends Region> editor = tab == null ? null : tab.getEditorControl();
        ScriptSyntax syntax = this.getCurrentSyntax();
        if (editor == null || syntax == null || !syntax.canCompress()) {
            return;
        }
        editor.setText(syntax.compress(editor.getText()));
    }

    private ScriptSyntax getSyntax(ScriptLanguage language) {
        return language == null ? null : ScriptSyntaxProvider.getSyntaxFromName(language.getName());
    }

    public DefaultScriptEditor(QuPathGUI qupath) {
        this.qupath = qupath;
        this.dragDropListener = new ScriptEditorDragDropListener(qupath);
        this.initializeActions();
        this.currentLanguage.bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Toggle language = this.toggleLanguages.getSelectedToggle();
            return language == null ? null : ScriptLanguageProvider.fromString((String)language.getUserData());
        }, (Observable[])new Observable[]{this.toggleLanguages.selectedToggleProperty()}));
        this.currentSyntax.bind((ObservableValue)Bindings.createObjectBinding(() -> this.getSyntax((ScriptLanguage)this.currentLanguage.get()), (Observable[])new Observable[]{this.currentLanguage}));
        this.selectedScript.addListener((v, o, n) -> {
            this.scriptText.unbind();
            this.selectedScriptText.unbind();
            this.caretPosition.unbind();
            if (n == null || n.getLanguage() == null) {
                return;
            }
            this.setToggle(n.getLanguage());
            File file = n.getFile();
            if (file != null) {
                URI uri = file.toURI();
                ObservableList<URI> list = PathPrefs.getRecentScriptsList();
                if (list.contains((Object)uri)) {
                    if (!uri.equals(list.get(0))) {
                        list.remove((Object)uri);
                        list.add(0, (Object)uri);
                    }
                } else {
                    list.add(0, (Object)uri);
                }
            }
            this.caretPosition.bind((ObservableValue)n.getEditorControl().caretPositionProperty());
            this.scriptText.bind((ObservableValue)n.getEditorControl().textProperty());
            this.selectedScriptText.bind(n.getEditorControl().selectedTextProperty());
        });
        String style = (String)this.fontSize.get();
        this.paneCode.setStyle(style);
        this.paneConsole.setStyle(style);
        this.showJavadocsAction = ActionTools.createAction(new JavadocViewerRunner(qupath.getStage()), "Show Javadocs");
    }

    private void setToggle(ScriptLanguage language) {
        String languageName;
        Object currentSelected = this.toggleLanguages.getSelectedToggle() == null ? null : this.toggleLanguages.getSelectedToggle().getUserData();
        String string = languageName = language == null ? null : language.toString();
        if (Objects.equals(languageName, currentSelected)) {
            return;
        }
        for (Toggle button : this.toggleLanguages.getToggles()) {
            if (!language.toString().equals(button.getUserData())) continue;
            button.setSelected(true);
            break;
        }
    }

    private void initializeActions() {
        this.copyAction = this.createCopyAction("Copy", null);
        this.cutAction = this.createCutAction("Cut", null);
        this.pasteAction = this.createPasteAction("Paste", false, null);
        this.pasteAndEscapeAction = this.createPasteAction("Paste & escape", true, this.comboPasteEscape);
        this.undoAction = this.createUndoAction("Undo", null);
        this.redoAction = this.createRedoAction("Redo", null);
        this.runScriptAction = this.createRunScriptAction("Run", false);
        this.runSelectedAction = this.createRunScriptAction("Run selected code", true);
        this.runProjectScriptAction = this.createRunProjectScriptAction("Run for project", true);
        this.runProjectScriptNoSaveAction = this.createRunProjectScriptAction("Run for project (without saving)", false);
        this.killRunningScriptAction = this.createKillRunningScriptAction("Kill running script");
        this.insertMuAction = this.createInsertAction("\u00b5");
        this.insertQPImportAction = this.createInsertAction("QP");
        this.insertQPExImportAction = this.createInsertAction("QPEx");
        this.insertAllDefaultImportAction = this.createInsertAction("All default");
        this.insertPixelClassifiersAction = this.createInsertAction("Pixel classifiers");
        this.insertObjectClassifiersAction = this.createInsertAction("Object classifiers");
        this.insertDetectionMeasurementsAction = this.createInsertAction("Detection");
        this.beautifySourceAction.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}));
        this.beautifySourceAction.disabledProperty().bind((ObservableValue)this.canBeautifyBinding);
        this.compressSourceAction.disabledProperty().bind((ObservableValue)this.canCompressBinding);
        this.qupath.projectProperty().addListener((v, o, n) -> this.previousImages.clear());
        this.findAction = this.createFindAction("Find");
        this.smartEditingAction = ActionTools.createSelectableAction((ObservableValue<Boolean>)this.smartEditing, "Enable smart editing");
    }

    Action createReplaceTextAction(String name, Function<String, String> fun, boolean limitToSelected) {
        Action action = new Action(name, e -> this.replaceCurrentEditorText(fun, limitToSelected));
        action.disabledProperty().bind((ObservableValue)this.selectedScript.isNull());
        return action;
    }

    void replaceCurrentEditorText(Function<String, String> fun, boolean limitToSelected) {
        ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
        if (editor == null) {
            return;
        }
        String selected = editor.getSelectedText();
        if (limitToSelected && !selected.isEmpty()) {
            String updated = fun.apply(selected);
            if (!Objects.equals(selected, updated)) {
                editor.replaceSelection(updated);
            }
        } else {
            editor.setText(fun.apply(editor.getText()));
        }
    }

    @Override
    public boolean supportsFile(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        String name = file.getName();
        for (ScriptLanguage l : ScriptLanguageProvider.getAvailableLanguages()) {
            for (String ext : l.getExtensions()) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean requestClose() {
        ScriptTab tab;
        if (this.quitCancelled) {
            logger.debug("Script editor quit was cancelled, won't close or prompt again");
            return false;
        }
        boolean ret = true;
        while (ret && (tab = this.getCurrentScriptTab()) != null) {
            if (this.dialog != null && !this.dialog.isShowing() && tab.isModifiedProperty().get() && tab.hasScript()) {
                this.dialog.show();
            }
            ret = this.promptToClose(tab);
        }
        if (ret && this.dialog != null) {
            this.dialog.close();
        } else if (!ret) {
            this.quitCancelled = true;
            logger.trace("Script Editor quit was cancelled");
            Platform.runLater(() -> {
                this.quitCancelled = false;
            });
        }
        return ret;
    }

    void maybeRefreshTab(ScriptTab tab, boolean updateLanguage) {
        if (tab != null && this.autoRefreshFiles.get()) {
            tab.refreshFileContents();
            if (updateLanguage) {
                this.setToggle(tab.getLanguage());
            }
        }
    }

    public Stage getStage() {
        return this.dialog;
    }

    public ObservableValue<Boolean> scriptRunning() {
        return this.runningTask.isNotNull();
    }

    protected void promptToSetFontSize() {
        String output;
        String current = this.fontSize.getValue();
        if (current != null && current.length() - current.replaceAll(";", "").length() == 1) {
            current = current.replaceAll("-fx-font-size: ", "").replaceAll(";", "").strip();
        }
        if ((output = Dialogs.showInputDialog((String)"Set font size", (String)"Enter the font size, in points or as a percentage \n(e.g. 16, 120%)", (String)current)) == null) {
            return;
        }
        Object style = null;
        if (!(output = output.strip()).isBlank() && !((String)(style = output.contains("-fx") ? output : "-fx-font-size: " + output)).endsWith(";")) {
            style = (String)style + ";";
        }
        this.fontSize.setValue(style);
        this.paneCode.setStyle((String)style);
        this.paneConsole.setStyle((String)style);
    }

    public void addNewScript(String script, ScriptLanguage language, boolean doSelect) {
        ScriptEditorControl<?> editor = this.getNewEditor();
        editor.wrapTextProperty().bindBidirectional((Property)this.wrapTextProperty);
        ScriptTab tab = new ScriptTab(editor, this.getNewConsole(), script, language);
        editor.textProperty().addListener((v, o, n) -> {
            this.updateUndoActionState();
            tab.updateIsModified();
        });
        editor.selectedTextProperty().addListener((v, o, n) -> this.updateCutCopyActionState());
        tab.isModifiedProperty().addListener((v, o, n) -> {
            if (this.listScripts != null) {
                this.listScripts.refresh();
            }
        });
        this.listScripts.getItems().add((Object)tab);
        if (doSelect) {
            this.listScripts.getSelectionModel().select((Object)tab);
        }
        this.updateSelectedScript(true);
    }

    protected ReadOnlyObjectProperty<ScriptTab> selectedScriptProperty() {
        return this.selectedScript;
    }

    private void addScript(File file, boolean doSelect) throws IOException {
        ScriptTab tab2;
        for (ScriptTab tab2 : this.listScripts.getItems()) {
            if (!file.equals(tab2.getFile())) continue;
            if (doSelect) {
                this.listScripts.getSelectionModel().select((Object)tab2);
            }
            return;
        }
        ScriptEditorControl<?> editor = this.getNewEditor();
        editor.wrapTextProperty().bindBidirectional((Property)this.wrapTextProperty);
        tab2 = new ScriptTab(editor, this.getNewConsole(), file);
        editor.textProperty().addListener((v, o, n) -> {
            this.updateUndoActionState();
            tab2.updateIsModified();
        });
        editor.selectedTextProperty().addListener((v, o, n) -> this.updateCutCopyActionState());
        tab2.isModifiedProperty().addListener((v, o, n) -> {
            if (this.listScripts != null) {
                this.listScripts.refresh();
            }
        });
        this.listScripts.getItems().add((Object)tab2);
        if (doSelect) {
            this.listScripts.getSelectionModel().select((Object)tab2);
        }
        this.setToggle(tab2.getLanguage());
    }

    void updateSelectedScript(boolean updateLanguage) {
        ScriptTab tab;
        ScriptTab scriptTab = tab = this.listScripts == null ? null : (ScriptTab)this.listScripts.getSelectionModel().getSelectedItem();
        if (tab == this.selectedScript.get()) {
            return;
        }
        if (tab != null) {
            this.paneCode.setCenter((Node)tab.getEditorControl().getRegion());
            this.paneConsole.setCenter((Node)tab.getConsoleControl().getRegion());
            this.maybeRefreshTab(tab, false);
            this.selectedScript.set((Object)tab);
            this.setToggle(tab.getLanguage());
        } else {
            this.selectedScript.set((Object)tab);
            this.paneCode.setCenter(null);
            this.paneConsole.setCenter(null);
        }
    }

    ScriptLanguage getSelectedLanguage() {
        return this.getCurrentScriptTab() == null ? null : this.getCurrentScriptTab().getLanguage();
    }

    protected ScriptEditorControl<?> getNewConsole() {
        return new TextAreaControl(false);
    }

    public ScriptEditorControl<?> createNewEditor() {
        return this.getNewEditor();
    }

    protected ScriptEditorControl<?> getNewEditor() {
        CustomTextArea editor = new CustomTextArea();
        editor.setFont(this.fontMain);
        TextAreaControl control = new TextAreaControl(editor, true);
        editor.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            ScriptLanguage language = (ScriptLanguage)this.currentLanguage.getValue();
            if (language == null) {
                return;
            }
            ScriptSyntax syntax = this.getSyntax(language);
            if (e.getCode() == KeyCode.TAB) {
                syntax.handleTabPress(control, e.isShiftDown());
                e.consume();
            } else if (e.isShortcutDown() && e.getCode() == KeyCode.SLASH) {
                syntax.handleLineComment(control);
                e.consume();
            } else if (e.getCode() == KeyCode.ENTER && control.getSelectedText().isEmpty()) {
                syntax.handleNewLine(control, this.smartEditing.get());
                e.consume();
            }
        });
        return control;
    }

    private void createDialog() {
        ScriptEditorControl<? extends Region> consoleComponent;
        this.dialog = new Stage();
        this.dialog.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.maybeRefreshTab(this.getCurrentScriptTab(), false);
            }
        });
        this.dialog.setOnCloseRequest(e -> {
            if (this.dialog != null) {
                this.dialog.hide();
                e.consume();
            }
        });
        if (this.qupath != null) {
            this.dialog.initOwner((Window)this.qupath.getStage());
        }
        this.dialog.titleProperty().bind((ObservableValue)this.title);
        MenuBar menubar = new MenuBar();
        Menu menuFile = new Menu("File");
        MenuTools.addMenuItems(menuFile, this.createNewAction("New"), this.createOpenAction("Open..."), this.createRecentScriptsMenu(), null, this.createSaveAction("Save", false), this.createSaveAction("Save As...", true), null, this.createRevertAction("Revert/Refresh"), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.autoRefreshFiles, "Auto refresh files")), null, this.createCloseAction("Close script"), this.createExitAction("Close editor"));
        menubar.getMenus().add((Object)menuFile);
        CheckMenuItem miWrapLines = new CheckMenuItem("Wrap lines");
        miWrapLines.selectedProperty().bindBidirectional((Property)this.wrapTextProperty);
        Menu menuEdit = new Menu("Edit");
        MenuTools.addMenuItems(menuEdit, this.undoAction, this.redoAction, null, this.cutAction, this.copyAction, this.pasteAction, this.pasteAndEscapeAction, null, this.findAction, null, this.beautifySourceAction, this.compressSourceAction, this.zapGremlinsAction, this.replaceQuotesAction, null, this.smartEditingAction, miWrapLines);
        menubar.getMenus().add((Object)menuEdit);
        Menu menuView = new Menu("View");
        MenuItem miSetFontSize = new MenuItem("Set font size");
        miSetFontSize.setOnAction(e -> this.promptToSetFontSize());
        menuView.getItems().add((Object)miSetFontSize);
        menubar.getMenus().add((Object)menuView);
        Menu menuLanguages = new Menu("Language");
        ArrayList<RadioMenuItem> nonRunnableLanguages = new ArrayList<RadioMenuItem>();
        for (ScriptLanguage language : ScriptLanguageProvider.getAvailableLanguages()) {
            String languageName = language.toString();
            RadioMenuItem item = new RadioMenuItem(languageName);
            item.setToggleGroup(this.toggleLanguages);
            item.setUserData((Object)languageName);
            if (language instanceof ExecutableLanguage) {
                menuLanguages.getItems().add((Object)item);
            } else {
                nonRunnableLanguages.add(item);
            }
            item.selectedProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.setCurrentTabLanguage(language);
                }
            });
        }
        if (!nonRunnableLanguages.isEmpty()) {
            menuLanguages.getItems().add((Object)new SeparatorMenuItem());
            for (RadioMenuItem item : nonRunnableLanguages) {
                menuLanguages.getItems().add((Object)item);
            }
        }
        Toggle defaultLanguage = this.toggleLanguages.getToggles().stream().filter(t -> t.getUserData().equals((Object)GroovyLanguage.getInstance())).findFirst().orElseGet(() -> (Toggle)this.toggleLanguages.getToggles().get(0));
        defaultLanguage.setSelected(true);
        menubar.getMenus().add((Object)menuLanguages);
        Menu menuInsert = new Menu("Insert");
        Menu subMenuSymbols = new Menu("Symbols");
        Menu subMenuImports = new Menu("Imports");
        Menu subMenuClassifiers = new Menu("Classifiers");
        Menu subMenuMeasurements = new Menu("Measurements");
        MenuTools.addMenuItems(menuInsert, MenuTools.addMenuItems(subMenuSymbols, this.insertMuAction), MenuTools.addMenuItems(subMenuImports, this.insertQPImportAction, this.insertQPExImportAction, this.insertAllDefaultImportAction), MenuTools.addMenuItems(subMenuClassifiers, this.insertPixelClassifiersAction, this.insertObjectClassifiersAction), MenuTools.addMenuItems(subMenuMeasurements, this.insertDetectionMeasurementsAction));
        menubar.getMenus().add((Object)menuInsert);
        Menu menuRun = new Menu("Run");
        MenuTools.addMenuItems(menuRun, this.runScriptAction, this.runSelectedAction, this.runProjectScriptAction, this.runProjectScriptNoSaveAction, null, this.killRunningScriptAction, null, ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.useDefaultBindings, "Include default imports")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.sendLogToConsole, "Show log in console")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.outputScriptStartTime, "Log script time")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.autoClearConsole, "Auto clear console")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.clearCache, "Clear cache (batch processing)")), null, ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.useCompiled, "Use compiled scripts")));
        menubar.getMenus().add((Object)menuRun);
        Menu menuHelp = new Menu("Help");
        MenuTools.addMenuItems(menuHelp, this.showJavadocsAction);
        menubar.getMenus().add((Object)menuHelp);
        BorderPane panelList = new BorderPane();
        TitledPane titledScripts = new TitledPane("Scripts", this.listScripts);
        titledScripts.prefWidthProperty().bind((ObservableValue)panelList.widthProperty());
        titledScripts.prefHeightProperty().bind((ObservableValue)panelList.heightProperty());
        titledScripts.setCollapsible(false);
        panelList.setCenter((Node)titledScripts);
        this.listScripts.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateSelectedScript(true));
        this.listScripts.setCellFactory((Callback)new Callback<ListView<ScriptTab>, ListCell<ScriptTab>>(this){

            public ListCell<ScriptTab> call(ListView<ScriptTab> list) {
                return new ScriptObjectListCell();
            }
        });
        this.listScripts.setMinWidth(150.0);
        this.runningTask.addListener((v, o, n) -> {
            this.listScripts.refresh();
            if (n != null) {
                this.timer.start();
            } else {
                this.timer.stop();
            }
        });
        SplitPane splitCode = new SplitPane();
        splitCode.setOrientation(Orientation.VERTICAL);
        Pane paneRun = this.createRunPane();
        this.paneBottom.setBottom((Node)paneRun);
        ScriptEditorControl<? extends Region> textComponent = this.getCurrentEditorControl();
        if (textComponent != null) {
            this.paneCode.setCenter((Node)textComponent.getRegion());
        }
        if ((consoleComponent = this.getCurrentConsoleControl()) != null) {
            this.paneConsole.setCenter((Node)consoleComponent.getRegion());
        }
        splitCode.getItems().setAll((Object[])new Node[]{this.paneCode, this.paneBottom});
        splitCode.setDividerPosition(0, 0.6);
        SplitPane.setResizableWithParent((Node)this.paneBottom, (Boolean)Boolean.FALSE);
        this.splitMain = new SplitPane();
        this.splitMain.getItems().addAll((Object[])new Node[]{panelList, splitCode});
        this.splitMain.setOrientation(Orientation.HORIZONTAL);
        SplitPane.setResizableWithParent((Node)panelList, (Boolean)Boolean.FALSE);
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)this.splitMain);
        pane.setTop((Node)menubar);
        this.dialog.setScene(new Scene((Parent)pane));
        this.dialog.setMinWidth(400.0);
        this.dialog.setMinHeight(400.0);
        this.dialog.setWidth(600.0);
        this.dialog.setHeight(400.0);
        this.dialog.getScene().setOnDragOver(event -> {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            event.consume();
        });
        this.dialog.getScene().setOnDragDropped((EventHandler)this.dragDropListener);
        this.splitMain.setDividerPosition(0, 0.25);
        SystemMenuBar.manageChildMenuBar(menubar);
        this.updateUndoActionState();
        this.updateCutCopyActionState();
    }

    private Pane createRunPane() {
        GridPane paneRun = new GridPane();
        Button btnRun = ActionTools.createButton(this.runScriptAction);
        btnRun.setPadding(new Insets(0.0, 20.0, 0.0, 20.0));
        ContextMenu popup = new ContextMenu(new MenuItem[]{ActionTools.createMenuItem(this.runProjectScriptAction), ActionTools.createMenuItem(this.runProjectScriptNoSaveAction), ActionTools.createMenuItem(this.runSelectedAction), new SeparatorMenuItem(), ActionTools.createMenuItem(this.killRunningScriptAction), new SeparatorMenuItem(), ActionTools.createMenuItem(this.showJavadocsAction), new SeparatorMenuItem(), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.useDefaultBindings, "Include default imports")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.sendLogToConsole, "Show log in console")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.outputScriptStartTime, "Log script time")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.autoClearConsole, "Auto clear console")), ActionTools.createCheckMenuItem(ActionTools.createSelectableAction((ObservableValue<Boolean>)this.clearCache, "Clear cache (batch processing)"))});
        Button btnMore = GuiTools.createMoreButton(popup, Side.RIGHT);
        Label labelPosition = new Label();
        labelPosition.textProperty().bind((ObservableValue)this.caretPositionText);
        labelPosition.setOpacity(0.5);
        labelPosition.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        labelPosition.setTooltip(new Tooltip("Caret position [line:column]"));
        Label labelRunning = new Label();
        labelRunning.setOpacity(0.5);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.runningTask.get() == null ? "No script running" : "Script run time", (Observable[])new Observable[]{this.runningTask}));
        labelRunning.setTooltip(tooltip);
        labelRunning.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.runningTask.get() == null) {
                if (this.timeProperty.getValueSafe().isEmpty()) {
                    return "";
                }
                return "Stopped: " + (String)this.timeProperty.get();
            }
            return "Running: " + (String)this.timeProperty.get();
        }, (Observable[])new Observable[]{this.runningTask, this.timeProperty}));
        int col = 0;
        paneRun.add((Node)labelPosition, col++, 0);
        paneRun.add((Node)labelRunning, col++, 0);
        Pane paneSpace = new Pane();
        paneRun.add((Node)paneSpace, col++, 0);
        paneRun.add((Node)btnRun, col++, 0);
        paneRun.add((Node)btnMore, col++, 0);
        paneRun.setPadding(new Insets(5.0));
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{paneSpace});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{paneSpace});
        GridPaneUtils.setMaxHeight((double)Double.MAX_VALUE, (Region[])new Region[]{labelRunning, paneSpace, btnRun, btnMore});
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{labelRunning, paneSpace, btnRun, btnMore});
        GridPaneUtils.setFillHeight((Boolean)Boolean.TRUE, (Node[])new Node[]{labelRunning, paneSpace, btnRun, btnMore});
        return paneRun;
    }

    void setCurrentTabLanguage(ScriptLanguage language) {
        ScriptTab tab = this.getCurrentScriptTab();
        if (tab == null) {
            return;
        }
        for (ScriptLanguage l : ScriptLanguageProvider.getAvailableLanguages()) {
            if (l != language) continue;
            tab.setLanguage(l);
            break;
        }
    }

    protected ReadOnlyObjectProperty<ScriptLanguage> currentLanguageProperty() {
        return this.currentLanguage;
    }

    protected ReadOnlyObjectProperty<ScriptSyntax> currentSyntaxProperty() {
        return this.currentSyntax;
    }

    protected ScriptLanguage getCurrentLanguage() {
        return (ScriptLanguage)this.currentLanguage.get();
    }

    protected ScriptSyntax getCurrentSyntax() {
        return (ScriptSyntax)this.currentSyntax.get();
    }

    protected ScriptTab getCurrentScriptTab() {
        return (ScriptTab)this.selectedScript.get();
    }

    protected ScriptEditorControl<? extends Region> getCurrentEditorControl() {
        ScriptTab tab = this.getCurrentScriptTab();
        return tab == null ? null : tab.getEditorControl();
    }

    protected ScriptEditorControl<? extends Region> getCurrentConsoleControl() {
        ScriptTab tab = this.getCurrentScriptTab();
        return tab == null ? null : tab.getConsoleControl();
    }

    protected String getSelectedText() {
        ScriptEditorControl<? extends Region> comp = this.getCurrentEditorControl();
        return comp != null ? comp.getSelectedText() : null;
    }

    protected String getCurrentText() {
        ScriptEditorControl<? extends Region> comp = this.getCurrentEditorControl();
        return comp != null ? comp.getText() : "";
    }

    void updateCutCopyActionState() {
        String selectedText = this.getSelectedText();
        this.copyAction.setDisabled(selectedText == null || selectedText.isEmpty());
        this.cutAction.setDisabled(selectedText == null || selectedText.isEmpty());
        this.pasteAction.setDisabled(false);
    }

    void updateUndoActionState() {
        ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
        this.undoAction.setDisabled(editor == null || !editor.isUndoable());
        this.redoAction.setDisabled(editor == null || !editor.isRedoable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(ScriptTab tab, String script, Project<BufferedImage> project, ImageData<BufferedImage> imageData, int batchIndex, int batchSize, boolean batchSave, boolean useCompiled) {
        ScriptLanguage language = tab.getLanguage();
        if (!(language instanceof ExecutableLanguage)) {
            return;
        }
        ScriptEditorControl<? extends Region> console = tab.getConsoleControl();
        ScriptConsoleWriter writer = new ScriptConsoleWriter(console, false);
        ScriptParameters.Builder builder = ScriptParameters.builder().setWriter((Writer)writer).setErrorWriter((Writer)new ScriptConsoleWriter(console, true)).setScript(script).setFile(tab.getFile()).setProject(project).setImageData(imageData).setBatchIndex(batchIndex).setBatchSize(batchSize).useCompiled(useCompiled).setBatchSaveResult(batchSave);
        if (this.useDefaultBindings.get()) {
            builder.setDefaultImports(QPEx.getCoreClasses()).setDefaultStaticImports(Collections.singletonList(QPEx.class));
        }
        ScriptParameters params = builder.build();
        PrintWriter printWriter = new PrintWriter(writer);
        boolean attachToLog = this.sendLogToConsole.get();
        if (attachToLog) {
            LogManager.addTextAppendableFX(console);
        }
        long startTime = System.nanoTime();
        if (this.outputScriptStartTime.get()) {
            printWriter.println("Starting script at " + new Date(System.currentTimeMillis()).toString());
        }
        try {
            Object result = ((ExecutableLanguage)language).execute(params);
            if (result != null) {
                printWriter.println("Result: " + String.valueOf(result));
            }
            if (result instanceof String && language instanceof HtmlRenderer) {
                this.showHtml(tab.getName(), (String)result);
            }
            if (this.outputScriptStartTime.get()) {
                printWriter.println(String.format("Total run time: %.2f seconds", (double)(System.nanoTime() - startTime) / 1.0E9));
            }
        }
        catch (ScriptException e) {
            Writer errorWriter = params.getErrorWriter();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("ERROR: " + e.getLocalizedMessage() + "\n");
                Throwable cause = e.getCause();
                Object stackTrace = Arrays.stream(cause.getStackTrace()).filter(s -> s != null).map(s -> s.toString()).collect(Collectors.joining("\n    "));
                if (stackTrace != null) {
                    stackTrace = (String)stackTrace + "\n";
                }
                sb.append((String)stackTrace);
                sb.append("\nFor help interpreting this error, please search the forum at https://forum.image.sc/tag/qupath\nYou can also start a new discussion there, including both your script & the messages in this log.");
                errorWriter.append(sb.toString());
            }
            catch (IOException exIO) {
                logger.error(exIO.getLocalizedMessage(), (Throwable)exIO);
            }
        }
        catch (Exception e1) {
            logger.error("Script error: " + e1.getLocalizedMessage(), (Throwable)e1);
        }
        catch (Throwable t) {
            logger.error(t.getLocalizedMessage(), t);
        }
        finally {
            if (attachToLog) {
                Platform.runLater(() -> LogManager.removeTextAppendableFX(console));
            }
        }
    }

    private Menu createRecentScriptsMenu() {
        ObservableList<URI> recentScripts = PathPrefs.getRecentScriptsList();
        Menu menuRecent = GuiTools.createRecentItemsMenu("Recent scripts...", recentScripts, uri -> {
            try {
                Path path = GeneralTools.toPath((URI)uri);
                if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
                    this.showScript(path.toFile());
                } else {
                    Dialogs.showErrorMessage((String)"Open script", (String)("No script found for " + String.valueOf(path)));
                }
            }
            catch (Exception e1) {
                Dialogs.showErrorMessage((String)"Open script", (String)("Cannot load script " + String.valueOf(uri)));
                logger.error("Error loading script", (Throwable)e1);
            }
        });
        return menuRecent;
    }

    private void showHtml(String title, String html) {
        QuPathGUI qupath = QuPathGUI.getInstance();
        if (qupath == null || qupath.getStage() == null) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.showHtml(title, html));
            return;
        }
        if (webview == null) {
            webview = WebViews.create(true);
            stageHtml = new Stage();
            stageHtml.setScene(new Scene((Parent)webview));
            stageHtml.setTitle(title);
            stageHtml.initOwner((Window)QuPathGUI.getInstance().getStage());
        }
        webview.getEngine().loadContent(html);
        if (!stageHtml.isShowing()) {
            stageHtml.show();
        } else {
            stageHtml.toFront();
        }
    }

    boolean save(ScriptTab tab, boolean saveAs) {
        try {
            if (!tab.fileExists() || saveAs) {
                File dir;
                block11: {
                    dir = tab.getFile();
                    if (dir == null) {
                        try {
                            File dirProject;
                            Project<BufferedImage> project = this.qupath.getProject();
                            if (project == null || (dirProject = Projects.getBaseDirectory(project)) == null || !dirProject.isDirectory()) break block11;
                            File dirScripts = new File(dirProject, "scripts");
                            if (!dirScripts.exists()) {
                                try {
                                    dirScripts.mkdir();
                                }
                                catch (Exception e) {
                                    logger.error("Unable to make script directory: " + e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                            if (dirScripts.isDirectory()) {
                                dir = dirScripts;
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Problem trying to find project scripts directory: {}", (Object)e.getLocalizedMessage());
                        }
                    }
                }
                Set<String> extensions = tab.getRequestedExtensions();
                File file = FileChoosers.promptToSaveFile((Window)this.dialog, (String)"Save script file", (File)(tab.getName() == null ? null : new File(dir, tab.getName())), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)(((ScriptLanguage)this.currentLanguage.getValue()).getName() + " file"), extensions)});
                if (file == null) {
                    return false;
                }
                tab.saveToFile(this.getCurrentText(), file);
                this.listScripts.refresh();
                return true;
            }
            tab.saveToFile(this.getCurrentText(), tab.getFile());
        }
        catch (Exception e) {
            logger.error("Error saving file", (Throwable)e);
        }
        return false;
    }

    protected ObservableBooleanValue sendLogToConsoleProperty() {
        return this.sendLogToConsole;
    }

    Action createKillRunningScriptAction(String name) {
        Action action = new Action(name, e -> {
            Future future = (Future)this.runningTask.get();
            if (future == null) {
                return;
            }
            if (future.isDone()) {
                this.runningTask.set(null);
            } else {
                future.cancel(true);
            }
        });
        action.disabledProperty().bind((ObservableValue)this.runningTask.isNull());
        action.setLongText("Try to stop the script that's currently running");
        return action;
    }

    private static boolean requestGuiScript(String script) {
        String[] lines = GeneralTools.splitLines((String)script);
        if (lines.length > 0) {
            String firstLine = lines[0].toLowerCase();
            return patternGuiScript.matcher(firstLine).find();
        }
        return false;
    }

    Action createRunScriptAction(String name, boolean selectedText) {
        Action action = new Action(name, e -> {
            boolean runInPlatformThread;
            final String script = selectedText ? this.getSelectedText() : this.getCurrentText();
            if (script == null || script.trim().length() == 0) {
                logger.warn("No script selected!");
                return;
            }
            ScriptLanguage language = this.getSelectedLanguage();
            if (language == null) {
                return;
            }
            final ScriptTab tab = this.getCurrentScriptTab();
            if (this.autoClearConsole.get() && this.getCurrentScriptTab() != null) {
                tab.getConsoleControl().clear();
            }
            if (runInPlatformThread = DefaultScriptEditor.requestGuiScript(script)) {
                logger.info("Running script in Platform thread...");
                try {
                    tab.setRunning(true);
                    this.executeScript(tab, script, this.qupath.getProject(), this.qupath.getImageData(), 0, 1, false, this.useCompiled.get());
                }
                finally {
                    tab.setRunning(false);
                    this.runningTask.setValue(null);
                }
            } else {
                this.runningTask.setValue(this.qupath.getThreadPoolManager().getSingleThreadExecutor(this).submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            tab.setRunning(true);
                            DefaultScriptEditor.this.executeScript(tab, script, DefaultScriptEditor.this.qupath.getProject(), DefaultScriptEditor.this.qupath.getImageData(), 0, 1, false, DefaultScriptEditor.this.useCompiled.get());
                        }
                        finally {
                            tab.setRunning(false);
                            Platform.runLater(() -> DefaultScriptEditor.this.runningTask.setValue(null));
                        }
                    }
                }));
            }
        });
        action.setLongText("Run the current script");
        if (selectedText) {
            action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
            action.disabledProperty().bind((ObservableValue)this.disableRunSelected);
        } else {
            action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            action.disabledProperty().bind((ObservableValue)this.disableRun);
        }
        return action;
    }

    Action createRunProjectScriptAction(String name, boolean doSave) {
        Action action = new Action(name, e -> this.handleRunProject(doSave));
        action.disabledProperty().bind((ObservableValue)this.disableRun.or((ObservableBooleanValue)this.qupath.projectProperty().isNull()));
        if (doSave) {
            action.setLongText("Run the current script for multiple images in the project and save the results");
        } else {
            action.setLongText("Run the current script for multiple images in the project but don't save the results");
        }
        return action;
    }

    void handleRunProject(boolean doSave) {
        Project<BufferedImage> project = this.qupath.getProject();
        if (project == null) {
            GuiTools.showNoProjectError("Script editor");
            return;
        }
        ScriptTab tab = this.getCurrentScriptTab();
        if (tab == null || tab.getEditorControl().getText().trim().length() == 0) {
            Dialogs.showErrorMessage((String)"Script editor", (String)"No script selected!");
            return;
        }
        if (tab.getLanguage() == null) {
            Dialogs.showErrorMessage((String)"Script editor", (String)"Scripting language is unknown!");
            return;
        }
        String sameImageWarning = "A selected image is open in the viewer!\nAny unsaved changes will be ignored.";
        List imageList = project.getImageList();
        this.previousImages.retainAll(new HashSet(imageList));
        ListSelectionView<ProjectImageEntry<BufferedImage>> listSelectionView = ProjectDialogs.createImageChoicePane(this.qupath, imageList, this.previousImages, sameImageWarning);
        Dialog dialog = new Dialog();
        dialog.initOwner((Window)this.qupath.getStage());
        dialog.setTitle("Select project images");
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        dialog.getDialogPane().setContent(listSelectionView);
        dialog.setResizable(true);
        dialog.getDialogPane().setPrefWidth(600.0);
        dialog.initModality(Modality.APPLICATION_MODAL);
        Optional result = dialog.showAndWait();
        if (result.isEmpty() || result.get() != ButtonType.OK) {
            return;
        }
        this.previousImages.clear();
        this.previousImages.addAll((Collection<ProjectImageEntry<BufferedImage>>)listSelectionView.getTargetItems());
        if (this.previousImages.isEmpty()) {
            return;
        }
        ArrayList<ProjectImageEntry<BufferedImage>> imagesToProcess = new ArrayList<ProjectImageEntry<BufferedImage>>(this.previousImages);
        ProjectTask worker = new ProjectTask(project, imagesToProcess, tab, doSave, this.useCompiled.get());
        ProgressDialog progress = new ProgressDialog((Worker)worker);
        progress.initOwner((Window)this.qupath.getStage());
        progress.setTitle("Batch script");
        progress.getDialogPane().setHeaderText("Batch processing...");
        progress.getDialogPane().setGraphic(null);
        progress.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        progress.getDialogPane().lookupButton(ButtonType.CANCEL).addEventFilter(ActionEvent.ACTION, e -> {
            if (Dialogs.showYesNoDialog((String)"Cancel batch script", (String)"Are you sure you want to stop the running script after the current image?")) {
                worker.quietCancel();
                progress.setHeaderText("Cancelling...");
                progress.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(true);
            }
            e.consume();
        });
        if (this.autoClearConsole.get() && this.getCurrentScriptTab() != null) {
            tab.getConsoleControl().clear();
        }
        this.runningTask.set(this.qupath.getThreadPoolManager().getSingleThreadExecutor(this).submit((Runnable)((Object)worker)));
        progress.showAndWait();
        if (doSave) {
            Boolean reload = null;
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                ImageData<BufferedImage> imageData = viewer.getImageData();
                ProjectImageEntry entry = imageData == null ? null : project.getEntry(imageData);
                if (entry == null || !imagesToProcess.contains(entry)) continue;
                if (reload == null) {
                    reload = Dialogs.showYesNoDialog((String)"Script editor", (String)"Refresh open images?\nThis will show any changes from the script - \nbut unsaved changes in the current viewer will be lost.");
                }
                if (!reload.booleanValue()) continue;
                try {
                    ImageData imageDataReloaded = entry.readImageData();
                    viewer.setImageData((ImageData<BufferedImage>)imageDataReloaded);
                }
                catch (IOException e2) {
                    Dialogs.showErrorNotification((String)"Script editor", (String)("Error reloading data: " + e2.getLocalizedMessage()));
                    logger.error(e2.getLocalizedMessage(), (Throwable)e2);
                }
            }
        }
    }

    public static String getClipboardText(boolean escapeCharacters) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        List files = clipboard.getFiles();
        String text = clipboard.getString();
        if (files != null && !files.isEmpty()) {
            Object s = files.size() == 1 ? ((File)files.getFirst()).getAbsolutePath() : "[" + files.stream().map(f -> "\"" + f.getAbsolutePath() + "\"").collect(Collectors.joining("," + System.lineSeparator())) + "]";
            if ("\\".equals(File.separator)) {
                s = ((String)s).replace("\\", "/");
            }
            text = s;
        }
        if (text != null && escapeCharacters) {
            text = StringEscapeUtils.escapeJava((String)text);
        }
        return text;
    }

    protected static boolean pasteFromClipboard(ScriptEditorControl<?> control, boolean escapeCharacters) {
        String text = DefaultScriptEditor.getClipboardText(escapeCharacters);
        if (text == null) {
            return false;
        }
        if (text.equals(Clipboard.getSystemClipboard().getString())) {
            control.paste();
        } else {
            control.replaceSelection(text);
        }
        return true;
    }

    Action createCopyAction(String name, KeyCombination accelerator) {
        Action action = new Action(name, e -> {
            if (e.isConsumed()) {
                return;
            }
            ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
            if (editor != null) {
                editor.copy();
            }
            e.consume();
        });
        if (accelerator != null) {
            action.setAccelerator(accelerator);
            this.accelerators.add(accelerator);
        }
        return action;
    }

    Action createCutAction(String name, KeyCombination accelerator) {
        Action action = new Action(name, e -> {
            if (e.isConsumed()) {
                return;
            }
            ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
            if (editor != null) {
                editor.cut();
            }
            e.consume();
        });
        if (accelerator != null) {
            action.setAccelerator(accelerator);
            this.accelerators.add(accelerator);
        }
        return action;
    }

    Action createPasteAction(String name, boolean doEscape, KeyCombination accelerator) {
        Action action = new Action(name, e -> {
            if (e.isConsumed()) {
                return;
            }
            ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
            if (editor != null) {
                DefaultScriptEditor.pasteFromClipboard(editor, doEscape);
            }
            e.consume();
        });
        if (accelerator != null) {
            action.setAccelerator(accelerator);
            this.accelerators.add(accelerator);
        }
        return action;
    }

    Action createUndoAction(String name, KeyCombination accelerator) {
        Action action = new Action(name, e -> {
            ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
            if (editor != null && editor.isUndoable()) {
                editor.undo();
            }
            e.consume();
        });
        if (accelerator != null) {
            action.setAccelerator(accelerator);
            this.accelerators.add(accelerator);
        }
        return action;
    }

    Action createRedoAction(String name, KeyCombination accelerator) {
        Action action = new Action(name, e -> {
            ScriptEditorControl<? extends Region> editor = this.getCurrentEditorControl();
            if (editor != null && editor.isRedoable()) {
                editor.redo();
            }
            e.consume();
        });
        if (accelerator != null) {
            action.setAccelerator(accelerator);
            this.accelerators.add(accelerator);
        }
        return action;
    }

    Action createOpenAction(String name) {
        Action action = new Action(name, e -> {
            String dirPath = (String)PathPrefs.scriptsPathProperty().get();
            File dir = null;
            if (dirPath != null) {
                dir = new File(dirPath);
            }
            List compatibleExtensions = ScriptLanguageProvider.getAvailableLanguages().stream().flatMap(l -> l.getExtensions().stream()).distinct().sorted().toList();
            File file = ((FileChooser)FileChoosers.buildFileChooser().title("Choose script file").extensionFilters(new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Compatible files", compatibleExtensions)}).initialDirectory(dir).build()).showOpenDialog((Window)this.getStage());
            if (file == null) {
                return;
            }
            try {
                this.addScript(file, true);
                PathPrefs.scriptsPathProperty().set((Object)file.getParent());
            }
            catch (Exception ex) {
                logger.error("Unable to open script file", (Throwable)ex);
                ex.printStackTrace();
            }
        });
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        return action;
    }

    Action createNewAction(String name) {
        Action action = new Action(name, e -> this.addNewScript("", this.getDefaultLanguage(null), true));
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        return action;
    }

    Action createCloseAction(String name) {
        Action action = new Action(name, e -> {
            ScriptTab tab = this.getCurrentScriptTab();
            if (tab == null) {
                return;
            }
            this.promptToClose(tab);
        });
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        return action;
    }

    Action createSaveAction(String name, boolean saveAs) {
        Action action = new Action(name, e -> {
            ScriptTab tab = this.getCurrentScriptTab();
            if (tab == null) {
                return;
            }
            this.save(tab, saveAs);
        });
        if (saveAs) {
            action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        } else {
            action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        return action;
    }

    Action createRevertAction(String name) {
        Action action = new Action(name, e -> {
            ScriptTab tab = this.getCurrentScriptTab();
            if (tab != null) {
                tab.refreshFileContents();
                this.setToggle(tab.getLanguage());
            }
        });
        return action;
    }

    Action createFindAction(String name) {
        ScriptFindCommand findCommand = new ScriptFindCommand(this);
        Action action = new Action(name, e -> {
            findCommand.run();
            e.consume();
        });
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        return action;
    }

    Action createExitAction(String name) {
        Action action = new Action(name, e -> {
            if (this.dialog != null) {
                this.dialog.hide();
            }
            e.consume();
        });
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        return action;
    }

    Action createInsertAction(String name) {
        Action action = new Action(name, e -> {
            ScriptEditorControl<? extends Region> control = this.getCurrentEditorControl();
            String join = "," + System.lineSeparator() + "  ";
            String listFormat = "[" + System.lineSeparator() + "  %s" + System.lineSeparator() + "]";
            if (name.toLowerCase().equals("pixel classifiers")) {
                try {
                    String classifiers = this.qupath.getProject().getPixelClassifiers().getNames().stream().map(classifierName -> "\"" + classifierName + "\"").collect(Collectors.joining(join));
                    String s = classifiers.isEmpty() ? "[]" : String.format(listFormat, classifiers);
                    control.replaceSelection(s);
                }
                catch (IOException ex) {
                    logger.error("Could not fetch classifiers", (Throwable)ex);
                }
            } else if (name.toLowerCase().equals("object classifiers")) {
                try {
                    String classifiers = this.qupath.getProject().getObjectClassifiers().getNames().stream().map(classifierName -> "\"" + classifierName + "\"").collect(Collectors.joining(join));
                    String s = classifiers.isEmpty() ? "[]" : String.format(listFormat, classifiers);
                    control.replaceSelection(s);
                }
                catch (IOException ex) {
                    logger.error("Could not fetch classifiers", (Throwable)ex);
                }
            } else if (name.toLowerCase().equals("detection")) {
                ImageData<BufferedImage> imageData = this.qupath.getImageData();
                String measurements = "";
                if (imageData != null) {
                    measurements = imageData.getHierarchy().getDetectionObjects().stream().flatMap(d -> d.getMeasurementList().getNames().stream()).distinct().map(m -> "\"" + m + "\"").collect(Collectors.joining(join));
                }
                String s = measurements.isEmpty() ? "[]" : String.format(listFormat, measurements);
                control.replaceSelection(s);
            } else if (name.toLowerCase().equals("\u00b5")) {
                control.replaceSelection("\u00b5");
            } else {
                Collection<Object> classes = Collections.emptyList();
                List<Object> staticClasses = Collections.emptyList();
                if (name.toLowerCase().equals("qpex")) {
                    staticClasses = Collections.singletonList(QPEx.class);
                } else if (name.toLowerCase().equals("qp")) {
                    staticClasses = Collections.singletonList(QP.class);
                } else if (name.toLowerCase().equals("all default")) {
                    classes = QPEx.getCoreClasses();
                }
                ScriptLanguage language = (ScriptLanguage)this.currentLanguage.get();
                DefaultScriptLanguage defaultLanguage = language instanceof DefaultScriptLanguage ? (DefaultScriptLanguage)language : GroovyLanguage.getInstance();
                Object lines = "";
                if (!staticClasses.isEmpty() && ((String)(lines = staticClasses.stream().map(c -> defaultLanguage.getStaticImportStatements(Collections.singletonList(c))).collect(Collectors.joining("\n")))).length() > 0) {
                    lines = (String)lines + "\n";
                }
                if (!classes.isEmpty() && ((String)(lines = (String)lines + classes.stream().map(c -> defaultLanguage.getImportStatements(Collections.singletonList(c))).collect(Collectors.joining("\n")))).length() > 0) {
                    lines = (String)lines + "\n";
                }
                control.replaceSelection((String)lines);
            }
            e.consume();
        });
        if (name.equals("\u00b5")) {
            action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        } else if (name.toLowerCase().equals("pixel classifiers") || name.toLowerCase().equals("object classifiers")) {
            action.disabledProperty().bind((ObservableValue)this.qupath.projectProperty().isNull());
        } else if (name.toLowerCase().equals("detection")) {
            action.disabledProperty().bind((ObservableValue)this.qupath.imageDataProperty().isNull());
        }
        return action;
    }

    boolean promptToClose(ScriptTab tab) {
        int ind = this.listScripts.getItems().indexOf((Object)tab);
        if (ind < 0) {
            return false;
        }
        if (tab.isModifiedProperty().get() && tab.hasScript()) {
            ButtonType option = Dialogs.showYesNoCancelDialog((String)("Close " + tab.getName()), (String)String.format("Save %s before closing?", tab.getName()));
            if (option == ButtonType.CANCEL) {
                return false;
            }
            if (option == ButtonType.YES && !this.save(tab, false)) {
                return false;
            }
        }
        this.listScripts.getItems().remove(ind);
        if (ind >= this.listScripts.getItems().size()) {
            --ind;
        }
        if (ind < 0) {
            this.dialog.close();
        } else {
            this.listScripts.getSelectionModel().select(ind);
        }
        return true;
    }

    @Override
    public void showEditor() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(this::showEditor);
            return;
        }
        if (this.dialog == null) {
            this.createDialog();
        } else {
            this.dialog.setX(this.dialog.getX());
            this.dialog.setY(this.dialog.getY());
        }
        if (this.listScripts.getItems().isEmpty()) {
            this.showScript(null, null);
        }
        if (!this.dialog.isShowing()) {
            this.dialog.show();
        }
    }

    @Override
    public void showScript(String name, String script) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.showScript(name, script));
            return;
        }
        if (this.dialog == null) {
            this.createDialog();
        }
        this.addNewScript(script, this.getDefaultLanguage(name), true);
        if (!this.dialog.isShowing()) {
            this.dialog.show();
            ScriptEditorControl<? extends Region> current = this.getCurrentEditorControl();
            if (current != null) {
                current.requestFocus();
            }
        }
    }

    private ScriptLanguage getDefaultLanguage(String fileName) {
        String ext = fileName == null ? null : (String)GeneralTools.getExtension((String)fileName).orElse(null);
        Collection<ScriptLanguage> availableLanguages = ScriptLanguageProvider.getAvailableLanguages();
        if (ext == null) {
            if (availableLanguages.contains((Object)GroovyLanguage.getInstance())) {
                return GroovyLanguage.getInstance();
            }
            return PlainLanguage.getInstance();
        }
        ext = ext.toLowerCase();
        for (ScriptLanguage language : availableLanguages) {
            for (String ext2 : language.getExtensions()) {
                if (!Objects.equals(ext, ext2.toLowerCase())) continue;
                return language;
            }
        }
        return PlainLanguage.getInstance();
    }

    @Override
    public void showScript(File file) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.showScript(file));
            return;
        }
        try {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.addScript(file, true);
            if (!this.dialog.isShowing()) {
                this.dialog.show();
            }
        }
        catch (Exception e) {
            logger.error("Could not load script from {}", (Object)file);
            logger.error("", (Throwable)e);
        }
    }

    static class CustomTextArea
    extends TextArea {
        CustomTextArea() {
            this.setStyle("-fx-font-family: monospaced;");
        }

        public void paste() {
            String text = DefaultScriptEditor.getClipboardText(false);
            if (text != null) {
                this.replaceSelection(text);
            }
        }
    }

    class ScriptConsoleWriter
    extends Writer {
        private ScriptEditorControl<?> doc;
        private boolean isErrorWriter = false;
        private StringBuilder sb = new StringBuilder();

        ScriptConsoleWriter(ScriptEditorControl<?> doc, boolean isErrorWriter) {
            this.doc = doc;
            this.isErrorWriter = isErrorWriter;
        }

        @Override
        public synchronized void write(char[] cbuf, int off, int len) throws IOException {
            Level level = this.isErrorWriter ? Level.ERROR : Level.INFO;
            String s = String.valueOf(cbuf, off, len);
            if (!DefaultScriptEditor.this.sendLogToConsole.get()) {
                this.sb.append(s);
                this.flush();
            }
            if (s.startsWith("WARN: ")) {
                level = Level.WARN;
                s = s.substring("WARN: ".length());
            } else if (s.startsWith("INFO: ")) {
                level = Level.INFO;
                s = s.substring("INFO: ".length());
            } else if (s.startsWith("ERROR: ")) {
                level = Level.ERROR;
                s = s.substring("ERROR: ".length());
            } else if (s.startsWith("DEBUG: ")) {
                level = Level.DEBUG;
                s = s.substring("DEBUG: ".length());
            } else if (s.startsWith("TRACE: ")) {
                level = Level.TRACE;
                s = s.substring("TRACE: ".length());
            }
            if (len == 1 && cbuf[off] == '\n' || s.equals(System.lineSeparator())) {
                return;
            }
            logger.atLevel(level).log(s);
        }

        @Override
        public synchronized void flush() throws IOException {
            String s = this.sb.toString();
            this.sb.setLength(0);
            if (s.isEmpty()) {
                return;
            }
            if (Platform.isFxApplicationThread()) {
                this.doc.appendText(s);
            } else {
                Platform.runLater(() -> this.doc.appendText(s));
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    class ProjectTask
    extends Task<Void> {
        private Project<BufferedImage> project;
        private Collection<ProjectImageEntry<BufferedImage>> imagesToProcess;
        private ScriptTab tab;
        private boolean quietCancel = false;
        private boolean doSave = false;
        private boolean useCompiled = false;

        ProjectTask(Project<BufferedImage> project, Collection<ProjectImageEntry<BufferedImage>> imagesToProcess, ScriptTab tab, boolean doSave, boolean useCompiled) {
            this.project = project;
            this.imagesToProcess = imagesToProcess;
            this.tab = tab;
            this.doSave = doSave;
            this.useCompiled = useCompiled;
        }

        public void quietCancel() {
            this.quietCancel = true;
        }

        public boolean isQuietlyCancelled() {
            return this.quietCancel;
        }

        public Void call() {
            long startTime = System.currentTimeMillis();
            this.tab.setRunning(true);
            int counter = 0;
            int batchSize = this.imagesToProcess.size();
            int batchIndex = 0;
            for (ProjectImageEntry<BufferedImage> entry : this.imagesToProcess) {
                try {
                    if (this.isQuietlyCancelled() || this.isCancelled()) {
                        logger.warn("Script cancelled with " + (this.imagesToProcess.size() - counter) + " image(s) remaining");
                        break;
                    }
                    this.updateProgress(counter, this.imagesToProcess.size());
                    this.updateMessage(entry.getImageName() + " (" + ++counter + "/" + this.imagesToProcess.size() + ")");
                    System.gc();
                    ImageData imageData = entry.readImageData();
                    if (imageData == null) {
                        logger.warn("Unable to open {} - will be skipped", (Object)entry.getImageName());
                        continue;
                    }
                    DefaultScriptEditor.this.executeScript(this.tab, this.tab.getEditorControl().getText(), this.project, (ImageData<BufferedImage>)imageData, batchIndex, batchSize, this.doSave, this.useCompiled);
                    if (this.doSave) {
                        entry.saveImageData(imageData);
                    }
                    imageData.close();
                    if (DefaultScriptEditor.this.clearCache.get()) {
                        try {
                            DefaultImageRegionStore store;
                            DefaultImageRegionStore defaultImageRegionStore = store = DefaultScriptEditor.this.qupath == null ? null : DefaultScriptEditor.this.qupath.getImageRegionStore();
                            if (store != null) {
                                store.clearCache();
                            }
                            System.gc();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    logger.error("Error running batch script", (Throwable)e);
                }
                ++batchIndex;
            }
            this.updateProgress(this.imagesToProcess.size(), this.imagesToProcess.size());
            long endTime = System.currentTimeMillis();
            long timeMillis = endTime - startTime;
            String time = null;
            time = timeMillis > 60000L ? String.format("Total processing time: %.2f minutes", (double)timeMillis / 60000.0) : (timeMillis > 1000L ? String.format("Total processing time: %.2f seconds", (double)timeMillis / 1000.0) : String.format("Total processing time: %d milliseconds", timeMillis));
            logger.info("Processed {} images", (Object)this.imagesToProcess.size());
            logger.info(time);
            return null;
        }

        protected void done() {
            super.done();
            this.tab.setRunning(false);
            Platform.runLater(() -> DefaultScriptEditor.this.runningTask.setValue(null));
        }
    }

    static class ScriptObjectListCell
    extends ListCell<ScriptTab> {
        private Tooltip tooltip = new Tooltip();
        private ContextMenu popup = new ContextMenu();

        ScriptObjectListCell() {
            MenuItem miOpenDirectory = new MenuItem("Open directory...");
            miOpenDirectory.disableProperty().bind((ObservableValue)this.itemProperty().isNull());
            miOpenDirectory.setOnAction(e -> {
                File file;
                ScriptTab item = (ScriptTab)this.getItem();
                File file2 = file = item == null ? null : item.getFile();
                if (file == null) {
                    return;
                }
                GuiTools.browseDirectory(file);
            });
            this.popup.getItems().add((Object)miOpenDirectory);
            this.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, e -> {
                if (this.getItem() == null || ((ScriptTab)this.getItem()).getFile() == null) {
                    e.consume();
                }
            });
        }

        public void updateItem(ScriptTab item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setTooltip(null);
                this.setContextMenu(null);
                return;
            }
            Object text = item.toString();
            if (item.isRunning()) {
                text = (String)text + " (Running)";
                this.setStyle("-fx-font-style: italic;");
            } else {
                this.setStyle(null);
            }
            this.setText((String)text);
            this.tooltip.setText((String)text);
            this.setTooltip(this.tooltip);
            this.setContextMenu(this.popup);
        }
    }
}

