/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.prefs;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.MenuBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.prefs.PathPrefs;

public class SystemMenuBar {
    private static final Logger logger = LoggerFactory.getLogger(SystemMenuBar.class);
    private static final BooleanProperty overrideSystemMenuBar = new SimpleBooleanProperty(false);
    private static final Set<MenuBar> mainMenuBars = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<MenuBar> childMenuBars = Collections.newSetFromMap(new WeakHashMap());
    private static final ObjectProperty<SystemMenuBarOption> systemMenuBar = SystemMenuBar.supportsSystemMenubar() ? PathPrefs.createPersistentPreference("systemMenubar", SystemMenuBarOption.ALL_WINDOWS, SystemMenuBarOption.class) : new SimpleObjectProperty((Object)SystemMenuBarOption.NEVER);

    private static void updateOverrideMenubars(ObservableValue<? extends Boolean> value, Boolean old, Boolean newValue) {
        SystemMenuBar.updateMenuBars(systemMenuBar, (SystemMenuBarOption)((Object)systemMenuBar.get()), (SystemMenuBarOption)((Object)systemMenuBar.get()));
    }

    public static boolean supportsSystemMenubar() {
        return !GeneralTools.isWindows() && !"false".equalsIgnoreCase(System.getProperty("qupath.enableSystemMenuBar"));
    }

    private static void updateMenuBars(ObservableValue<? extends SystemMenuBarOption> value, SystemMenuBarOption old, SystemMenuBarOption newValue) {
        if (Platform.isFxApplicationThread()) {
            for (MenuBar mb : mainMenuBars) {
                SystemMenuBar.updateMainMenuBar(mb, newValue);
            }
            for (MenuBar mb : childMenuBars) {
                SystemMenuBar.updateChildMenuBar(mb, newValue);
            }
        } else {
            Platform.runLater(() -> SystemMenuBar.updateMenuBars(value, old, newValue));
        }
    }

    private static void updateMainMenuBar(MenuBar menuBar, SystemMenuBarOption option) {
        if (menuBar.useSystemMenuBarProperty().isBound()) {
            logger.warn("MenuBar.useSystemMenuBarProperty() is already bound for {}", (Object)menuBar);
        } else if (overrideSystemMenuBar.get()) {
            menuBar.setUseSystemMenuBar(false);
        } else {
            menuBar.setUseSystemMenuBar(option == SystemMenuBarOption.ALL_WINDOWS);
        }
    }

    private static void updateChildMenuBar(MenuBar menuBar, SystemMenuBarOption option) {
        if (menuBar.useSystemMenuBarProperty().isBound()) {
            logger.warn("MenuBar.useSystemMenuBarProperty() is already bound for {}", (Object)menuBar);
        } else if (overrideSystemMenuBar.get()) {
            menuBar.setUseSystemMenuBar(false);
        } else {
            menuBar.setUseSystemMenuBar(option == SystemMenuBarOption.ALL_WINDOWS);
        }
    }

    public static ObjectProperty<SystemMenuBarOption> systemMenubarProperty() {
        return systemMenuBar;
    }

    public static void manageMainMenuBar(MenuBar menuBar) {
        mainMenuBars.add(menuBar);
        SystemMenuBar.updateMainMenuBar(menuBar, (SystemMenuBarOption)((Object)systemMenuBar.get()));
    }

    public static void manageChildMenuBar(MenuBar menuBar) {
        childMenuBars.add(menuBar);
        SystemMenuBar.updateChildMenuBar(menuBar, (SystemMenuBarOption)((Object)systemMenuBar.get()));
    }

    public static void unmanageMenuBar(MenuBar menuBar) {
        mainMenuBars.remove(menuBar);
        childMenuBars.remove(menuBar);
    }

    public static BooleanProperty overrideSystemMenuBarProperty() {
        return overrideSystemMenuBar;
    }

    public static boolean getOverrideSystemMenuBar() {
        return overrideSystemMenuBar.get();
    }

    public static void setOverrideSystemMenuBar(boolean doOverride) {
        overrideSystemMenuBar.set(doOverride);
    }

    static {
        systemMenuBar.addListener(SystemMenuBar::updateMenuBars);
        overrideSystemMenuBar.addListener(SystemMenuBar::updateOverrideMenubars);
    }

    public static enum SystemMenuBarOption {
        ALL_WINDOWS,
        NEVER;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Yes";
                case 1 -> "No";
            };
        }
    }
}

