/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.text.FontWeight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.prefs.PreferenceManager;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.objects.classes.PathClass;

public class PathPrefs {
    private static final Logger logger = LoggerFactory.getLogger(PathPrefs.class);
    private static final String PROP_PREFS = "qupath.prefs.name";
    private static final String DEFAULT_NODE_NAME = "io.github.qupath/0.6";
    private static final String PREVIOUS_NODE_NAME = "io.github.qupath/0.5";
    private static final PreferenceManager MANAGER = PathPrefs.createPreferenceManager();
    private static final BooleanProperty useSystemMenubar = new SimpleBooleanProperty();
    private static StringProperty scriptsPath = PathPrefs.createPersistentPreference("scriptsPath", null);
    private static IntegerProperty numCommandThreads = PathPrefs.createPersistentPreference("Requested number of threads", ForkJoinPool.getCommonPoolParallelism());
    private static BooleanProperty showImageNameInTitle = PathPrefs.createPersistentPreference("showImageNameInTitle", Boolean.TRUE);
    private static ObjectProperty<AutoUpdateType> autoUpdateCheck = PathPrefs.createPersistentPreference("autoUpdateCheck", AutoUpdateType.QUPATH_AND_EXTENSIONS, AutoUpdateType.class);
    private static BooleanProperty maskImageNames = PathPrefs.createPersistentPreference("maskImageNames", Boolean.FALSE);
    private static ObjectProperty<Locale> defaultLocale = PathPrefs.createPersistentPreference("locale", null, Locale.US);
    private static ObjectProperty<Locale> defaultLocaleFormat = PathPrefs.createPersistentPreference("localeFormat", Locale.Category.FORMAT, Locale.getDefault(Locale.Category.FORMAT));
    private static ObjectProperty<Locale> defaultLocaleDisplay = PathPrefs.createPersistentPreference("localeDisplay", Locale.Category.DISPLAY, Locale.getDefault(Locale.Category.DISPLAY));
    private static BooleanProperty showStartupMessage = PathPrefs.createPersistentPreference("showStartupMessage", true);
    private static BooleanProperty showLicenseMessageProperty = PathPrefs.createPersistentPreference("showLicenseMessage", true);
    private static StringProperty startupScriptPath = PathPrefs.createPersistentPreference("startupScriptPath", null);
    private static BooleanProperty showToolBarBadges = PathPrefs.createPersistentPreference("showToolBarBadges", true);
    private static IntegerProperty maxMemoryMB;
    private static IntegerProperty scrollSpeedProperty;
    private static IntegerProperty navigationSpeedProperty;
    private static BooleanProperty navigationAccelerationProperty;
    private static BooleanProperty skipMissingCoresProperty;
    private static boolean showAllRGBTransforms;
    private static BooleanProperty useTileBrush;
    private static BooleanProperty selectionMode;
    private static BooleanProperty tempSelectionMode;
    private static BooleanBinding selectionModeStatus;
    private static BooleanProperty clipROIsForHierarchy;
    private static BooleanProperty showExperimentalOptions;
    private static BooleanProperty showTMAOptions;
    private static BooleanProperty showLegacyOptions;
    private static BooleanProperty doCreateLogFilesProperty;
    private static ObjectProperty<String> userPath;
    private static final ObservableList<URI> recentProjects;
    private static final IntegerProperty maxUndoLevels;
    private static final IntegerProperty maxUndoHierarchySize;
    private static final ObservableList<URI> recentScripts;
    private static final BooleanProperty skipProjectUriChecks;
    private static BooleanProperty invertScrolling;
    private static BooleanProperty invertZSlider;
    private static final DoubleProperty gridStartX;
    private static final DoubleProperty gridStartY;
    private static final DoubleProperty gridSpacingX;
    private static final DoubleProperty gridSpacingY;
    private static final BooleanProperty gridScaleMicrons;
    private static final BooleanProperty showViewerPlaceholderText;
    private static final DoubleProperty autoBrightnessContrastSaturation;
    private static BooleanProperty keepDisplaySettings;
    private static BooleanProperty doubleClickToZoom;
    private static ObjectProperty<ImageTypeSetting> imageTypeSettingProperty;
    private static BooleanProperty paintSelectedBounds;
    private static StringProperty tableDelimiter;
    private static BooleanProperty showMeasurementTableThumbnailsProperty;
    private static BooleanProperty showMeasurementTableObjectIDsProperty;
    private static BooleanProperty enableFreehandTools;
    private static BooleanProperty useZoomGestures;
    private static BooleanProperty useRotateGestures;
    private static BooleanProperty useScrollGestures;
    private static BooleanProperty brushCreateNewObjects;
    private static BooleanProperty brushScaleByMag;
    private static IntegerProperty brushDiameter;
    private static BooleanProperty returnToMoveMode;
    private static DoubleProperty tileCachePercentage;
    private static BooleanProperty useCalibratedLocationString;
    private static BooleanProperty showPointHulls;
    private static BooleanProperty useSelectedColor;
    private static BooleanProperty multipointTool;
    private static DoubleProperty tmaExportDownsampleProperty;
    private static DoubleProperty viewerGammaProperty;
    private static IntegerProperty viewerBackgroundColor;
    private static IntegerProperty colorDefaultObjects;
    private static IntegerProperty colorSelectedObject;
    private static IntegerProperty colorTMA;
    private static DoubleProperty opacityTMAMissing;
    private static IntegerProperty colorTile;
    private static ObjectProperty<PathClass> autoSetAnnotationClass;
    private static BooleanProperty alwaysPaintSelectedObjects;
    private static BooleanProperty viewerInterpolateBilinear;
    private static ObjectProperty<DetectionTreeDisplayModes> detectionTreeDisplayMode;
    private static IntegerProperty maxObjectsToClipboard;
    private static ObjectProperty<FontSize> scalebarFontSize;
    private static ObjectProperty<FontSize> locationFontSize;
    private static ObjectProperty<FontWeight> scalebarFontWeight;
    private static DoubleProperty scalebarLineWidth;
    private static DoubleProperty allredMinPercentagePositive;
    private static IntegerProperty minPyramidDimension;
    private static IntegerProperty pointRadiusProperty;
    private static DoubleProperty strokeThinThickness;
    private static DoubleProperty strokeThickThickness;
    private static final BooleanProperty newDetectionRendering;
    private static final BooleanProperty usePixelSnapping;

    private static PreferenceManager createPreferenceManager() {
        String name = System.getProperty(PROP_PREFS);
        String nodeName = DEFAULT_NODE_NAME;
        if (name != null && !name.isBlank()) {
            logger.info("Setting preference node to {}", (Object)name);
            nodeName = name;
        }
        return PreferenceManager.createForUserPreferences((String)nodeName);
    }

    @Deprecated
    public static BooleanProperty useSystemMenubarProperty() {
        if (!useSystemMenubar.isBound()) {
            logger.warn("PathPrefs.useSystemMenubarProperty() is deprecated - please use PathPrefs.systemMenubarProperty() instead");
            useSystemMenubar.bind((ObservableValue)SystemMenuBar.systemMenubarProperty().isEqualTo((Object)SystemMenuBar.SystemMenuBarOption.ALL_WINDOWS));
        }
        return useSystemMenubar;
    }

    private static void addNumThreadsListener() {
        numCommandThreads.addListener((v, o, n) -> {
            int threads = n.intValue();
            if (threads > 0) {
                ThreadTools.setParallelism((int)threads);
            } else {
                logger.warn("Cannot set parallelism to {}", (Object)threads);
            }
        });
        int threads = numCommandThreads.get();
        if (threads > 0) {
            ThreadTools.setParallelism((int)numCommandThreads.get());
        }
    }

    public static void exportPreferences(OutputStream stream) throws IOException, BackingStoreException {
        PathPrefs.getUserPreferences().exportSubtree(stream);
    }

    public static void importPreferences(InputStream stream) throws IOException, InvalidPreferencesFormatException {
        Preferences.importPreferences(stream);
    }

    public static IntegerProperty numCommandThreadsProperty() {
        return numCommandThreads;
    }

    public static BooleanProperty showImageNameInTitleProperty() {
        return showImageNameInTitle;
    }

    public static ObjectProperty<AutoUpdateType> autoUpdateCheckProperty() {
        return autoUpdateCheck;
    }

    public static BooleanProperty maskImageNamesProperty() {
        return maskImageNames;
    }

    public static ObjectProperty<Locale> defaultLocaleProperty() {
        return defaultLocale;
    }

    public static ObjectProperty<Locale> defaultLocaleFormatProperty() {
        return defaultLocaleFormat;
    }

    public static ObjectProperty<Locale> defaultLocaleDisplayProperty() {
        return defaultLocaleDisplay;
    }

    private static void addLocaleListeners() {
        defaultLocale.addListener((v, o, n) -> {
            if (n == null) {
                return;
            }
            defaultLocaleFormat.set((Object)Locale.getDefault(Locale.Category.FORMAT));
            defaultLocaleDisplay.set((Object)Locale.getDefault(Locale.Category.DISPLAY));
        });
        defaultLocaleFormat.addListener((v, o, n) -> QuPathResources.getLocalizedResourceManager().refresh());
        defaultLocaleDisplay.addListener((v, o, n) -> QuPathResources.getLocalizedResourceManager().refresh());
    }

    public static BooleanProperty showStartupMessageProperty() {
        return showStartupMessage;
    }

    public static BooleanProperty showLicenseMessageOnStartupProperty() {
        return showLicenseMessageProperty;
    }

    public static StringProperty startupScriptProperty() {
        return startupScriptPath;
    }

    public static BooleanProperty showToolBarBadgesProperty() {
        return showToolBarBadges;
    }

    public static boolean hasJavaPreferences() {
        try {
            Path path = PathPrefs.getConfigPath();
            if (path == null) {
                return false;
            }
            return Files.exists(path, new LinkOption[0]) && Files.isWritable(path);
        }
        catch (Exception e) {
            logger.error("Error trying to find config file", (Throwable)e);
            return false;
        }
    }

    public static Path getConfigPath() throws IOException, URISyntaxException {
        Path path = Paths.get(PathPrefs.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        return PathPrefs.searchForConfigFile(path);
    }

    private static Path searchForConfigFile(Path dir) throws IOException {
        String configRequest = System.getProperty("qupath.config");
        try (Stream<Path> stream = Files.list(dir);){
            List<Path> paths = stream.filter(p -> {
                String name = p.getFileName().toString();
                if (configRequest != null && !configRequest.isBlank()) {
                    return name.toLowerCase().contains(configRequest.toLowerCase());
                }
                return name.endsWith(".cfg") && !name.endsWith("(console).cfg");
            }).sorted(Comparator.comparingInt(p -> p.getFileName().toString().length())).toList();
            if (paths.isEmpty()) {
                Path path = null;
                return path;
            }
            Path path = paths.get(0);
            return path;
        }
    }

    public static synchronized IntegerProperty maxMemoryMBProperty() {
        if (maxMemoryMB == null) {
            maxMemoryMB = PathPrefs.createPersistentPreference("maxMemoryMB", -1);
            long requestedMaxMemoryMB = maxMemoryMB.get();
            long currentMaxMemoryMB = Runtime.getRuntime().maxMemory() / 0x100000L;
            if (requestedMaxMemoryMB > 0L && requestedMaxMemoryMB != currentMaxMemoryMB) {
                logger.debug("Requested max memory ({} MB) does not match the current max ({} MB) - resetting preference to default value", (Object)requestedMaxMemoryMB, (Object)currentMaxMemoryMB);
                maxMemoryMB.set(-1);
            }
            maxMemoryMB.addListener((v, o, n) -> {
                try {
                    if (n.intValue() <= 512) {
                        logger.warn("Cannot set memory to {}, must be >= 512 MB", n);
                        n = 512;
                    }
                    String memory = "java-options=-Xmx" + n.intValue() + "M";
                    Path config = PathPrefs.getConfigPath();
                    if (config == null || !Files.exists(config, new LinkOption[0])) {
                        logger.error("Cannot find config file!");
                        return;
                    }
                    logger.info("Reading config file {}", (Object)config);
                    List<String> lines = Files.readAllLines(config);
                    int jvmOptions = -1;
                    int argOptions = -1;
                    int lineXx = -1;
                    int lineXmx = -1;
                    int i = 0;
                    for (String line : lines) {
                        if (line.startsWith("[JVMOptions]") || line.startsWith("[JavaOptions]")) {
                            jvmOptions = i;
                        }
                        if (line.startsWith("[ArgOptions]")) {
                            argOptions = i;
                        }
                        if (line.toLowerCase().contains("-xx:maxrampercentage")) {
                            lineXx = i;
                        }
                        if (line.toLowerCase().contains("-xmx")) {
                            lineXmx = i;
                        }
                        ++i;
                    }
                    if (lineXx >= 0) {
                        lines.set(lineXx, memory);
                    } else if (lineXmx >= 0) {
                        lines.set(lineXmx, memory);
                    } else if (argOptions > jvmOptions && jvmOptions >= 0) {
                        lines.add(jvmOptions + 1, memory);
                    } else {
                        logger.error("Cannot find where to insert memory request to .cfg file!");
                        return;
                    }
                    logger.info("Setting JVM option to {}", (Object)memory);
                    Files.copy(config, Paths.get(config.toString() + ".bkp", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    Files.write(config, lines, new OpenOption[0]);
                    return;
                }
                catch (AccessDeniedException e) {
                    logger.error("I'm not allowed to access the config file - see the QuPath installation instructions to set the memory manually", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("Unable to set max memory: " + e.getLocalizedMessage(), (Throwable)e);
                }
            });
        }
        return maxMemoryMB;
    }

    @Deprecated
    public static Preferences getUserPreferences() {
        return MANAGER.getPreferences();
    }

    public static synchronized boolean savePreferences() {
        try {
            MANAGER.save();
            logger.debug("Preferences have been saved");
            return true;
        }
        catch (BackingStoreException e) {
            logger.error("Failed to save preferences", (Throwable)e);
            return false;
        }
    }

    public static synchronized void resetPreferences() {
        try {
            MANAGER.reset();
            logger.info("Preferences have been reset");
        }
        catch (BackingStoreException e) {
            logger.error("Failed to reset preferences", (Throwable)e);
        }
    }

    public static IntegerProperty scrollSpeedProperty() {
        return scrollSpeedProperty;
    }

    public static double getScaledScrollSpeed() {
        double speed = (double)scrollSpeedProperty.get() / 100.0;
        if (!Double.isFinite(speed) || speed <= 0.0) {
            return 1.0;
        }
        return speed;
    }

    public static IntegerProperty navigationSpeedProperty() {
        return navigationSpeedProperty;
    }

    public static double getScaledNavigationSpeed() {
        double speed = (double)navigationSpeedProperty.get() / 100.0;
        if (!Double.isFinite(speed) || speed <= 0.0) {
            return 1.0;
        }
        return speed;
    }

    public static BooleanProperty navigationAccelerationProperty() {
        return navigationAccelerationProperty;
    }

    public static boolean getNavigationAccelerationProperty() {
        return navigationAccelerationProperty.get();
    }

    public static BooleanProperty skipMissingCoresProperty() {
        return skipMissingCoresProperty;
    }

    public static boolean getSkipMissingCoresProperty() {
        return skipMissingCoresProperty.get();
    }

    public static boolean getShowAllRGBTransforms() {
        return showAllRGBTransforms;
    }

    public static StringProperty scriptsPathProperty() {
        return scriptsPath;
    }

    public static BooleanProperty useTileBrushProperty() {
        return useTileBrush;
    }

    public static BooleanProperty selectionModeProperty() {
        return selectionMode;
    }

    public static BooleanProperty tempSelectionModeProperty() {
        return tempSelectionMode;
    }

    public static ObservableBooleanValue selectionModeStatus() {
        return selectionModeStatus;
    }

    public static BooleanProperty clipROIsForHierarchyProperty() {
        return clipROIsForHierarchy;
    }

    public static BooleanProperty showExperimentalOptionsProperty() {
        return showExperimentalOptions;
    }

    public static BooleanProperty showTMAOptionsProperty() {
        return showTMAOptions;
    }

    public static BooleanProperty showLegacyOptionsProperty() {
        return showLegacyOptions;
    }

    public static BooleanProperty doCreateLogFilesProperty() {
        return doCreateLogFilesProperty;
    }

    private static String blankStringToNull(String input) {
        if (input == null) {
            return null;
        }
        return input.isBlank() ? null : input;
    }

    public static ObjectProperty<String> userPathProperty() {
        return userPath;
    }

    public static ObservableList<URI> createPersistentUriList(String key, int maxUris, String ... extensions) throws IllegalArgumentException {
        String nextUri;
        if (maxUris <= 0 || maxUris > 1024) {
            throw new IllegalArgumentException("Max URIs must be between 1 and 1024");
        }
        ObservableList recentUris = FXCollections.observableArrayList();
        Preferences prefs = MANAGER.getPreferences();
        Set exts = Arrays.stream(extensions).map(String::toLowerCase).collect(Collectors.toSet());
        for (int i = 0; i < maxUris && (nextUri = prefs.get(key + i, null)) != null && !nextUri.isEmpty(); ++i) {
            String lowerUri = nextUri.toLowerCase();
            if (!exts.isEmpty()) {
                if (exts.stream().noneMatch(lowerUri::endsWith)) continue;
            }
            try {
                recentUris.add((Object)GeneralTools.toURI((String)nextUri));
                continue;
            }
            catch (URISyntaxException e) {
                logger.warn("Unable to parse URI from {}", (Object)nextUri, (Object)e);
            }
        }
        recentUris.addListener(c -> {
            Preferences prefsCurrent = MANAGER.getPreferences();
            for (int i = 0; i < maxUris; ++i) {
                if (i < recentUris.size()) {
                    prefsCurrent.put(key + i, ((URI)recentUris.get(i)).toString());
                    continue;
                }
                prefsCurrent.put(key + i, "");
            }
        });
        return recentUris;
    }

    public static ObservableList<URI> getRecentProjectList() {
        return recentProjects;
    }

    public static IntegerProperty maxUndoLevelsProperty() {
        return maxUndoLevels;
    }

    public static IntegerProperty maxUndoHierarchySizeProperty() {
        return maxUndoHierarchySize;
    }

    public static ObservableList<URI> getRecentScriptsList() {
        return recentScripts;
    }

    public static BooleanProperty skipProjectUriChecksProperty() {
        return skipProjectUriChecks;
    }

    public static BooleanProperty invertScrollingProperty() {
        return invertScrolling;
    }

    public static BooleanProperty invertZSliderProperty() {
        return invertZSlider;
    }

    public static DoubleProperty gridStartXProperty() {
        return gridStartX;
    }

    public static DoubleProperty gridStartYProperty() {
        return gridStartY;
    }

    public static DoubleProperty gridSpacingXProperty() {
        return gridSpacingX;
    }

    public static DoubleProperty gridSpacingYProperty() {
        return gridSpacingY;
    }

    public static BooleanProperty gridScaleMicronsProperty() {
        return gridScaleMicrons;
    }

    public static BooleanProperty showViewerPlaceholderTextProperty() {
        return showViewerPlaceholderText;
    }

    public static DoubleProperty autoBrightnessContrastSaturationPercentProperty() {
        return autoBrightnessContrastSaturation;
    }

    public static BooleanProperty keepDisplaySettingsProperty() {
        return keepDisplaySettings;
    }

    public static BooleanProperty doubleClickToZoomProperty() {
        return doubleClickToZoom;
    }

    public static ObjectProperty<ImageTypeSetting> imageTypeSettingProperty() {
        return imageTypeSettingProperty;
    }

    public static BooleanProperty paintSelectedBoundsProperty() {
        return paintSelectedBounds;
    }

    public static StringProperty tableDelimiterProperty() {
        return tableDelimiter;
    }

    public static BooleanProperty showMeasurementTableThumbnailsProperty() {
        return showMeasurementTableThumbnailsProperty;
    }

    public static BooleanProperty showMeasurementTableObjectIDsProperty() {
        return showMeasurementTableObjectIDsProperty;
    }

    public static BooleanProperty enableFreehandToolsProperty() {
        return enableFreehandTools;
    }

    public static String getSerializationExtension() {
        return "qpdata";
    }

    public static BooleanProperty useZoomGesturesProperty() {
        return useZoomGestures;
    }

    public static BooleanProperty useRotateGesturesProperty() {
        return useRotateGestures;
    }

    public static BooleanProperty useScrollGesturesProperty() {
        return useScrollGestures;
    }

    public static BooleanProperty brushCreateNewObjectsProperty() {
        return brushCreateNewObjects;
    }

    public static BooleanProperty brushScaleByMagProperty() {
        return brushScaleByMag;
    }

    public static IntegerProperty brushDiameterProperty() {
        return brushDiameter;
    }

    public static BooleanProperty returnToMoveModeProperty() {
        return returnToMoveMode;
    }

    public static DoubleProperty tileCachePercentageProperty() {
        return tileCachePercentage;
    }

    public static BooleanProperty useCalibratedLocationStringProperty() {
        return useCalibratedLocationString;
    }

    public static BooleanProperty useSelectedColorProperty() {
        return useSelectedColor;
    }

    public static BooleanProperty showPointHullsProperty() {
        return showPointHulls;
    }

    public static BooleanProperty multipointToolProperty() {
        return multipointTool;
    }

    public static DoubleProperty tmaExportDownsampleProperty() {
        return tmaExportDownsampleProperty;
    }

    public static DoubleProperty viewerGammaProperty() {
        return viewerGammaProperty;
    }

    public static IntegerProperty viewerBackgroundColorProperty() {
        return viewerBackgroundColor;
    }

    public static IntegerProperty colorDefaultObjectsProperty() {
        return colorDefaultObjects;
    }

    public static IntegerProperty colorSelectedObjectProperty() {
        return colorSelectedObject;
    }

    public static IntegerProperty colorTMAProperty() {
        return colorTMA;
    }

    public static DoubleProperty opacityTMAMissingProperty() {
        return opacityTMAMissing;
    }

    public static IntegerProperty colorTileProperty() {
        return colorTile;
    }

    public static ObjectProperty<PathClass> autoSetAnnotationClassProperty() {
        return autoSetAnnotationClass;
    }

    public static BooleanProperty alwaysPaintSelectedObjectsProperty() {
        return alwaysPaintSelectedObjects;
    }

    public static BooleanProperty viewerInterpolateBilinearProperty() {
        return viewerInterpolateBilinear;
    }

    public static ObjectProperty<DetectionTreeDisplayModes> detectionTreeDisplayModeProperty() {
        return detectionTreeDisplayMode;
    }

    public static IntegerProperty maxObjectsToClipboardProperty() {
        return maxObjectsToClipboard;
    }

    public static ObjectProperty<FontSize> scalebarFontSizeProperty() {
        return scalebarFontSize;
    }

    public static ObjectProperty<FontSize> locationFontSizeProperty() {
        return locationFontSize;
    }

    public static ObjectProperty<FontWeight> scalebarFontWeightProperty() {
        return scalebarFontWeight;
    }

    public static DoubleProperty scalebarLineWidthProperty() {
        return scalebarLineWidth;
    }

    public static DoubleProperty allredMinPercentagePositiveProperty() {
        return allredMinPercentagePositive;
    }

    public static IntegerProperty minPyramidDimensionProperty() {
        return minPyramidDimension;
    }

    public static IntegerProperty pointRadiusProperty() {
        return pointRadiusProperty;
    }

    public static BooleanProperty createPersistentPreference(String name, boolean defaultValue) {
        return MANAGER.createPersistentBooleanProperty(name, defaultValue);
    }

    public static IntegerProperty createPersistentPreference(String name, int defaultValue) {
        return MANAGER.createPersistentIntegerProperty(name, defaultValue);
    }

    public static DoubleProperty createPersistentPreference(String name, double defaultValue) {
        return MANAGER.createPersistentDoubleProperty(name, defaultValue);
    }

    public static LongProperty createPersistentPreference(String name, long defaultValue) {
        return MANAGER.createPersistentLongProperty(name, defaultValue);
    }

    public static StringProperty createPersistentPreference(String name, String defaultValue) {
        return MANAGER.createPersistentStringProperty(name, defaultValue);
    }

    public static <T extends Enum<T>> ObjectProperty<T> createPersistentPreference(String name, T defaultValue, Class<T> enumType) {
        return MANAGER.createPersistentEnumProperty(name, defaultValue, enumType);
    }

    public static <T> ObjectProperty<T> createPersistentPreference(String name, T defaultValue, Function<T, String> serializer, Function<String, T> deserializer) {
        return MANAGER.createPersistentObjectProperty(name, defaultValue, serializer, deserializer);
    }

    private static ObjectProperty<Locale> createPersistentPreference(String name, Locale.Category category, Locale defaultValue) {
        ObjectProperty property = MANAGER.createPersistentLocaleProperty(name, defaultValue);
        PathPrefs.updateLocale(category, (Locale)property.get());
        property.addListener((v, o, n) -> PathPrefs.updateLocale(category, n));
        return property;
    }

    private static void updateLocale(Locale.Category category, Locale locale) {
        if (locale == null) {
            logger.debug("Invalid null locale request (Category={}) - I will ignore it", (Object)category);
            return;
        }
        if (category == null) {
            logger.info("Setting default Locale to {}", (Object)locale);
            Locale.setDefault(locale);
        } else {
            logger.info("Setting Locale for {} to {}", (Object)category, (Object)locale);
            Locale.setDefault(category, locale);
        }
    }

    private static DoubleProperty ensurePositiveStrokeThickness(DoubleProperty property) {
        property.addListener((v, o, n) -> {
            if (n == null || n.doubleValue() <= 0.0) {
                double resetValue = o == null || o.doubleValue() <= 0.0 ? 1.0 : o.doubleValue();
                logger.warn("Attempted to set stroke thickness to invalid value ({}) - will be reset to {}", n, (Object)resetValue);
                property.set(o.doubleValue());
            }
        });
        return property;
    }

    public static DoubleProperty detectionStrokeThicknessProperty() {
        return strokeThinThickness;
    }

    public static DoubleProperty annotationStrokeThicknessProperty() {
        return strokeThickThickness;
    }

    public static BooleanProperty newDetectionRenderingProperty() {
        return newDetectionRendering;
    }

    public static BooleanProperty usePixelSnappingProperty() {
        return usePixelSnapping;
    }

    public static Path getDefaultQuPathUserDirectory() {
        Version version = QuPathGUI.getVersion();
        if (version != null) {
            return Paths.get(System.getProperty("user.home"), "QuPath", String.format("v%d.%d", version.getMajor(), version.getMinor()));
        }
        return Paths.get(System.getProperty("user.home"), "QuPath");
    }

    static {
        scrollSpeedProperty = PathPrefs.createPersistentPreference("Scroll speed %", 100);
        navigationSpeedProperty = PathPrefs.createPersistentPreference("Navigation speed %", 100);
        navigationAccelerationProperty = PathPrefs.createPersistentPreference("Navigation acceleration effects", true);
        skipMissingCoresProperty = PathPrefs.createPersistentPreference("Skip missing TMA cores", false);
        showAllRGBTransforms = true;
        useTileBrush = PathPrefs.createPersistentPreference("useTileBrush", false);
        selectionMode = MANAGER.createTransientBooleanProperty("selectionMode", false);
        tempSelectionMode = MANAGER.createTransientBooleanProperty("tempSelectionMode", false);
        selectionModeStatus = PathPrefs.selectionModeProperty().or((ObservableBooleanValue)PathPrefs.tempSelectionModeProperty());
        clipROIsForHierarchy = PathPrefs.createPersistentPreference("clipROIsForHierarchy", false);
        showExperimentalOptions = PathPrefs.createPersistentPreference("showExperimentalOptions", true);
        showTMAOptions = PathPrefs.createPersistentPreference("showTMAOptions", true);
        showLegacyOptions = PathPrefs.createPersistentPreference("showLegacyOptions", false);
        doCreateLogFilesProperty = PathPrefs.createPersistentPreference("requestCreateLogFiles", false);
        userPath = PathPrefs.createPersistentPreference("userPath", null, PathPrefs::blankStringToNull, PathPrefs::blankStringToNull);
        recentProjects = PathPrefs.createPersistentUriList("recentProject", 8, new String[0]);
        maxUndoLevels = PathPrefs.createPersistentPreference("undoMaxLevels", 10);
        maxUndoHierarchySize = PathPrefs.createPersistentPreference("undoMaxHierarchySize", 10000);
        recentScripts = PathPrefs.createPersistentUriList("recentScript", 8, new String[0]);
        skipProjectUriChecks = PathPrefs.createPersistentPreference("Skip checking URIs in the project browser", false);
        invertScrolling = PathPrefs.createPersistentPreference("invertScrolling", !GeneralTools.isMac());
        invertZSlider = PathPrefs.createPersistentPreference("invertZSlider", false);
        gridStartX = PathPrefs.createPersistentPreference("gridStartX", 0.0);
        gridStartY = PathPrefs.createPersistentPreference("gridStartY", 0.0);
        gridSpacingX = PathPrefs.createPersistentPreference("gridSpacingX", 250.0);
        gridSpacingY = PathPrefs.createPersistentPreference("gridSpacingY", 250.0);
        gridScaleMicrons = PathPrefs.createPersistentPreference("gridScaleMicrons", true);
        showViewerPlaceholderText = PathPrefs.createPersistentPreference("showViewerPlaceholderText", true);
        autoBrightnessContrastSaturation = PathPrefs.createPersistentPreference("autoBrightnessContrastSaturationPercentage", 0.1);
        keepDisplaySettings = PathPrefs.createPersistentPreference("keepDisplaySettings", true);
        doubleClickToZoom = PathPrefs.createPersistentPreference("doubleClickToZoom", false);
        imageTypeSettingProperty = PathPrefs.createPersistentPreference("imageTypeSetting", ImageTypeSetting.PROMPT, ImageTypeSetting.class);
        paintSelectedBounds = MANAGER.createTransientBooleanProperty("paintSelectedBounds", false);
        tableDelimiter = PathPrefs.createPersistentPreference("tableDelimiter", "\t");
        showMeasurementTableThumbnailsProperty = PathPrefs.createPersistentPreference("showMeasurementTableThumbnailsProperty", true);
        showMeasurementTableObjectIDsProperty = PathPrefs.createPersistentPreference("showMeasurementTableObjectIDsProperty", true);
        enableFreehandTools = PathPrefs.createPersistentPreference("enableFreehandTools", true);
        useZoomGestures = PathPrefs.createPersistentPreference("Use zoom gestures", false);
        useRotateGestures = PathPrefs.createPersistentPreference("Use rotate gestures", false);
        useScrollGestures = PathPrefs.createPersistentPreference("Use scroll gestures", false);
        brushCreateNewObjects = PathPrefs.createPersistentPreference("brushCreateNew", true);
        brushScaleByMag = PathPrefs.createPersistentPreference("brushScaleByMag", true);
        brushDiameter = PathPrefs.createPersistentPreference("brushDiameter", 50);
        returnToMoveMode = PathPrefs.createPersistentPreference("returnToMoveMode", true);
        tileCachePercentage = PathPrefs.createPersistentPreference("tileCachePercentage", 25.0);
        useCalibratedLocationString = PathPrefs.createPersistentPreference("useCalibratedLocationString", true);
        showPointHulls = MANAGER.createTransientBooleanProperty("showPointHulls", false);
        useSelectedColor = MANAGER.createTransientBooleanProperty("useSelectedColor", true);
        multipointTool = MANAGER.createTransientBooleanProperty("multipointTool", true);
        tmaExportDownsampleProperty = PathPrefs.createPersistentPreference("tmaExportDownsample", 4.0);
        viewerGammaProperty = PathPrefs.createPersistentPreference("viewerGammaProperty", 1.0);
        viewerBackgroundColor = PathPrefs.createPersistentPreference("viewerBackgroundColor", ColorTools.packRGB((int)0, (int)0, (int)0));
        colorDefaultObjects = PathPrefs.createPersistentPreference("colorDefaultAnnotations", ColorTools.packRGB((int)255, (int)0, (int)0));
        colorSelectedObject = PathPrefs.createPersistentPreference("colorSelectedObject", ColorTools.packRGB((int)255, (int)255, (int)0));
        colorTMA = PathPrefs.createPersistentPreference("colorTMA", ColorTools.packRGB((int)102, (int)128, (int)230));
        opacityTMAMissing = PathPrefs.createPersistentPreference("opacityTMAMissing", 0.4);
        colorTile = PathPrefs.createPersistentPreference("colorTile", ColorTools.packRGB((int)80, (int)80, (int)80));
        autoSetAnnotationClass = MANAGER.createTransientObjectProperty("autoSetAnnotationClass", (Object)null);
        alwaysPaintSelectedObjects = PathPrefs.createPersistentPreference("alwaysPaintSelectedObjects", true);
        viewerInterpolateBilinear = PathPrefs.createPersistentPreference("viewerInterpolateBilinear", false);
        detectionTreeDisplayMode = PathPrefs.createPersistentPreference("detectionTreeDisplayMode", DetectionTreeDisplayModes.WITH_ICONS, DetectionTreeDisplayModes.class);
        maxObjectsToClipboard = PathPrefs.createPersistentPreference("maxObjectsToClipboard", 5000);
        scalebarFontSize = PathPrefs.createPersistentPreference("scalebarFontSize", FontSize.MEDIUM, FontSize.class);
        locationFontSize = PathPrefs.createPersistentPreference("locationFontSize", FontSize.MEDIUM, FontSize.class);
        scalebarFontWeight = PathPrefs.createPersistentPreference("scalebarFontWeight", FontWeight.NORMAL, FontWeight.class);
        scalebarLineWidth = PathPrefs.createPersistentPreference("scalebarLineWidth", 3.0);
        allredMinPercentagePositive = PathPrefs.createPersistentPreference("allredMinPercentagePositive", 0.0);
        minPyramidDimension = PathPrefs.createPersistentPreference("minPyramidDimension", 4096);
        pointRadiusProperty = PathPrefs.createPersistentPreference("defaultPointRadius", 5);
        strokeThinThickness = PathPrefs.ensurePositiveStrokeThickness(PathPrefs.createPersistentPreference("thinLineThickness", 2.0));
        strokeThickThickness = PathPrefs.ensurePositiveStrokeThickness(PathPrefs.createPersistentPreference("thickLineThickness", 2.0));
        newDetectionRendering = PathPrefs.createPersistentPreference("newDetectionRendering", true);
        usePixelSnapping = PathPrefs.createPersistentPreference("usePixelSnapping", true);
        PathPrefs.addLocaleListeners();
        PathPrefs.addNumThreadsListener();
    }

    public static enum AutoUpdateType {
        QUPATH_ONLY,
        QUPATH_AND_EXTENSIONS,
        EXTENSIONS_ONLY,
        NONE;


        public String toString() {
            switch (this.ordinal()) {
                case 2: {
                    return "Extensions only";
                }
                case 3: {
                    return "None";
                }
                case 1: {
                    return "QuPath + extensions";
                }
                case 0: {
                    return "QuPath only";
                }
            }
            return super.toString();
        }
    }

    public static enum ImageTypeSetting {
        AUTO_ESTIMATE,
        PROMPT,
        NONE;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Auto estimate";
                }
                case 2: {
                    return "Unset";
                }
                case 1: {
                    return "Prompt";
                }
            }
            return "Unknown";
        }
    }

    public static enum DetectionTreeDisplayModes {
        NONE,
        WITHOUT_ICONS,
        WITH_ICONS;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "None";
                }
                case 1: {
                    return "Without icons";
                }
                case 2: {
                    return "With icons";
                }
            }
            return "Unknown";
        }
    }

    public static enum FontSize {
        TINY,
        SMALL,
        MEDIUM,
        LARGE,
        HUGE;


        public String getFontSize() {
            switch (this.ordinal()) {
                case 4: {
                    return "1.4em";
                }
                case 3: {
                    return "1.2em";
                }
                case 2: {
                    return "1.0em";
                }
                case 1: {
                    return "0.8em";
                }
                case 0: {
                    return "0.6em";
                }
            }
            return "1em";
        }

        public String toString() {
            switch (this.ordinal()) {
                case 4: {
                    return "Huge";
                }
                case 3: {
                    return "Large";
                }
                case 2: {
                    return "Medium";
                }
                case 1: {
                    return "Small";
                }
                case 0: {
                    return "Tiny";
                }
            }
            return "Unknown";
        }
    }
}

