/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.ScriptableWorkflowStep;
import qupath.lib.plugins.workflow.SimplePluginWorkflowStep;
import qupath.lib.plugins.workflow.Workflow;
import qupath.lib.plugins.workflow.WorkflowListener;
import qupath.lib.plugins.workflow.WorkflowStep;

public class WorkflowCommandLogView
implements ChangeListener<ImageData<BufferedImage>>,
WorkflowListener {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowCommandLogView.class);
    private QuPathGUI qupath;
    private BorderPane pane;
    private final boolean isStaticWorkflow;
    private ObjectProperty<Workflow> workflowProperty = new SimpleObjectProperty();
    private ListView<WorkflowStep> list = new ListView();
    private TableView<KeyValue<Object>> table = new TableView();
    private final KeyCodeCombination copyCombination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});

    public WorkflowCommandLogView(QuPathGUI qupath) {
        this.qupath = qupath;
        qupath.imageDataProperty().addListener((ChangeListener)this);
        ImageData<BufferedImage> imageData = qupath.getImageData();
        this.isStaticWorkflow = false;
        if (imageData != null) {
            Workflow workflow = imageData.getHistoryWorkflow();
            workflow.addWorkflowListener((WorkflowListener)this);
            this.workflowProperty.set((Object)workflow);
            this.workflowUpdated(workflow);
        }
        this.list.setOnKeyPressed(e -> {
            if (this.copyCombination.match(e)) {
                this.copyScriptToClipboard(this.getSelectedIndices());
                e.consume();
            }
        });
    }

    public WorkflowCommandLogView(QuPathGUI qupath, Workflow workflow) {
        this.qupath = qupath;
        Objects.requireNonNull(workflow);
        this.workflowProperty.set((Object)workflow);
        workflow.addWorkflowListener((WorkflowListener)this);
        this.list.getItems().addAll((Collection)workflow.getSteps());
        this.isStaticWorkflow = true;
    }

    public Pane getPane() {
        if (this.pane == null) {
            this.pane = this.createPane();
        }
        return this.pane;
    }

    protected BorderPane createPane() {
        BorderPane pane = new BorderPane();
        TableColumn col1 = new TableColumn("Parameter");
        col1.setCellValueFactory(c -> ((KeyValue)c.getValue()).keyProperty());
        TableColumn col2 = new TableColumn("Value");
        col2.setCellValueFactory(c -> ((KeyValue)c.getValue()).valueProperty());
        col2.setCellFactory(t -> new ParameterTableCell());
        this.table.getColumns().add((Object)col1);
        this.table.getColumns().add((Object)col2);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        SplitPane splitPane = new SplitPane();
        splitPane.setOrientation(Orientation.VERTICAL);
        splitPane.getItems().addAll((Object[])new Node[]{this.list, this.table});
        this.list.getSelectionModel().setSelectionMode(this.isStaticWorkflow ? SelectionMode.MULTIPLE : SelectionMode.SINGLE);
        this.list.getSelectionModel().selectedItemProperty().addListener((e, f, g) -> {
            WorkflowStep step = (WorkflowStep)this.list.getSelectionModel().getSelectedItem();
            WorkflowCommandLogView.populateList((ObservableList<KeyValue<Object>>)this.table.getItems(), step);
        });
        final ContextMenu contextMenu = new ContextMenu();
        MenuItem miCopyCommand = new MenuItem("Copy command" + (this.isStaticWorkflow ? "s" : ""));
        miCopyCommand.setOnAction(e -> {
            ObservableList indices = this.list.getSelectionModel().getSelectedIndices();
            if (indices == null || indices.isEmpty()) {
                return;
            }
            this.copyScriptToClipboard((List<Integer>)indices);
        });
        miCopyCommand.disableProperty().bind((ObservableValue)this.workflowProperty.isNull());
        contextMenu.getItems().setAll((Object[])new MenuItem[]{miCopyCommand});
        if (this.isStaticWorkflow) {
            MenuItem miRemoveSelected = new MenuItem("Remove selected items");
            miRemoveSelected.setOnAction(e -> {
                String message;
                List<Integer> steps = this.getSelectedIndices();
                if (steps == null || steps.isEmpty()) {
                    return;
                }
                String string = message = steps.size() == 1 ? "Remove workflow step?" : "Remove " + steps.size() + " workflow steps?";
                if (!Dialogs.showYesNoDialog((String)"Remove workflow steps", (String)message)) {
                    return;
                }
                Collections.sort(steps);
                for (int i = steps.size() - 1; i >= 0; --i) {
                    this.getWorkflow().removeStep(steps.get(i).intValue());
                }
            });
            miRemoveSelected.disableProperty().bind((ObservableValue)this.workflowProperty.isNull());
            MenuItem miMoveUp = new MenuItem("Move up");
            miMoveUp.setOnAction(e -> {
                int i;
                List<Integer> indices = this.getSelectedIndices();
                if (indices == null || indices.isEmpty() || indices.get(0) <= 0) {
                    return;
                }
                Workflow workflow = this.getWorkflow();
                ArrayList<WorkflowStep> steps = new ArrayList<WorkflowStep>(workflow.getSteps());
                WorkflowStep[] stepsRemoved = new WorkflowStep[indices.size()];
                workflow.removeSteps(steps);
                int[] newIndices = new int[indices.size()];
                for (i = indices.size() - 1; i >= 0; --i) {
                    int indNew;
                    int ind = indices.get(i);
                    newIndices[i] = indNew = ind - 1;
                    stepsRemoved[i] = (WorkflowStep)steps.remove(ind);
                }
                for (i = 0; i < indices.size(); ++i) {
                    steps.add(newIndices[i], stepsRemoved[i]);
                }
                workflow.addSteps(steps);
                this.list.getSelectionModel().clearSelection();
                this.list.getSelectionModel().selectIndices(newIndices[0], newIndices);
            });
            miMoveUp.disableProperty().bind((ObservableValue)this.workflowProperty.isNull());
            MenuItem miMoveDown = new MenuItem("Move down");
            miMoveDown.setOnAction(e -> {
                int i;
                List<Integer> indices = this.getSelectedIndices();
                Workflow workflow = this.getWorkflow();
                if (indices == null || indices.isEmpty() || indices.get(indices.size() - 1) >= workflow.size() - 1) {
                    return;
                }
                this.list.getSelectionModel().clearSelection();
                Collections.sort(indices);
                ArrayList<WorkflowStep> steps = new ArrayList<WorkflowStep>(workflow.getSteps());
                WorkflowStep[] stepsRemoved = new WorkflowStep[indices.size()];
                workflow.removeSteps(steps);
                int[] newIndices = new int[indices.size()];
                for (i = indices.size() - 1; i >= 0; --i) {
                    int indNew;
                    int ind = indices.get(i);
                    newIndices[i] = indNew = ind + 1;
                    stepsRemoved[i] = (WorkflowStep)steps.remove(ind);
                }
                for (i = 0; i < indices.size(); ++i) {
                    steps.add(newIndices[i], stepsRemoved[i]);
                }
                workflow.addSteps(steps);
                this.list.getSelectionModel().select(newIndices[0]);
                this.list.getSelectionModel().selectIndices(newIndices[0], newIndices);
            });
            miMoveDown.disableProperty().bind((ObservableValue)this.workflowProperty.isNull());
            contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), miMoveUp, miMoveDown, new SeparatorMenuItem(), miRemoveSelected});
        }
        this.list.setCellFactory((Callback)new Callback<ListView<WorkflowStep>, ListCell<WorkflowStep>>(){

            public ListCell<WorkflowStep> call(ListView<WorkflowStep> p) {
                ListCell<WorkflowStep> cell = new ListCell<WorkflowStep>(){

                    protected void updateItem(WorkflowStep value, boolean bln) {
                        super.updateItem((Object)value, bln);
                        if (value instanceof WorkflowStep) {
                            this.setText(value.getName());
                        } else if (value == null) {
                            this.setText(null);
                        } else {
                            this.setText(value.toString());
                        }
                        this.setContextMenu(contextMenu);
                        this.setOnMouseClicked(e -> {
                            if (!e.isPopupTrigger() && e.getClickCount() == 2) {
                                WorkflowCommandLogView.runWorkflowStepInteractively(WorkflowCommandLogView.this.qupath, value);
                            }
                        });
                        this.setOnKeyPressed(e -> {
                            if (WorkflowCommandLogView.this.copyCombination.match(e)) {
                                WorkflowCommandLogView.this.copyScriptToClipboard(WorkflowCommandLogView.this.getSelectedIndices());
                                e.consume();
                            }
                        });
                    }
                };
                return cell;
            }
        });
        pane.setCenter((Node)splitPane);
        Button btnCreateScript = new Button("Create script");
        btnCreateScript.setMaxWidth(Double.MAX_VALUE);
        btnCreateScript.setOnAction(e -> this.showScript());
        btnCreateScript.disableProperty().bind((ObservableValue)this.workflowProperty.isNull());
        Button btnCreateWorkflow = null;
        if (!this.isStaticWorkflow) {
            btnCreateWorkflow = new Button("Create workflow");
            btnCreateWorkflow.setMaxWidth(Double.MAX_VALUE);
            btnCreateWorkflow.setOnAction(e -> {
                Workflow workflow = this.getWorkflow();
                if (workflow == null) {
                    return;
                }
                Stage stage = new Stage();
                FXUtils.addCloseWindowShortcuts((Stage)stage);
                stage.initOwner((Window)this.qupath.getStage());
                stage.setTitle("Workflow");
                Workflow workflowNew = new Workflow();
                workflowNew.addSteps((Collection)workflow.getSteps());
                stage.setScene(new Scene((Parent)new WorkflowCommandLogView(this.qupath, workflowNew).getPane(), 400.0, 600.0));
                stage.show();
            });
            btnCreateWorkflow.disableProperty().bind((ObservableValue)this.workflowProperty.isNull());
            pane.setBottom((Node)GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnCreateWorkflow, btnCreateScript}));
        } else {
            pane.setBottom((Node)btnCreateScript);
        }
        return pane;
    }

    private List<Integer> getSelectedIndices() {
        Workflow workflow = this.getWorkflow();
        if (workflow == null) {
            return null;
        }
        return new ArrayList<Integer>((Collection<Integer>)this.list.getSelectionModel().getSelectedIndices());
    }

    private Workflow getWorkflow() {
        Workflow workflow = (Workflow)this.workflowProperty.get();
        if (workflow == null) {
            logger.error("Workflow is null!");
        }
        return workflow;
    }

    private void copyScriptToClipboard(List<Integer> indices) {
        List steps = this.getWorkflow().getSteps();
        String script = indices.stream().map(index -> ((ScriptableWorkflowStep)steps.get((int)index)).getScript()).collect(Collectors.joining(System.lineSeparator()));
        ClipboardContent content = new ClipboardContent();
        content.putString(script);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private static void runWorkflowStepInteractively(QuPathGUI qupath, WorkflowStep step) {
        ImageData<BufferedImage> imageData = qupath.getImageData();
        if (imageData == null) {
            GuiTools.showNoImageError("Run workflow step");
            return;
        }
        if (step instanceof SimplePluginWorkflowStep) {
            if (step instanceof SimplePluginWorkflowStep) {
                SimplePluginWorkflowStep pluginStep = (SimplePluginWorkflowStep)step;
                String pluginClassName = pluginStep.getPluginClass();
                PathPlugin<BufferedImage> plugin = null;
                try {
                    Class<?> cls = Class.forName(pluginClassName);
                    plugin = qupath.createPlugin(cls);
                    Map parameterMap = pluginStep.getParameterMap();
                    String arg = null;
                    if (parameterMap != null && !parameterMap.isEmpty()) {
                        arg = ParameterList.convertToJson((Map)parameterMap);
                    }
                    qupath.runPlugin(plugin, arg, true);
                }
                catch (ClassNotFoundException e1) {
                    Dialogs.showErrorNotification((String)"Plugin class not found", (String)("No plugin class found with name " + pluginClassName));
                }
                catch (Exception e1) {
                    Dialogs.showErrorNotification((String)"Plugin error", (String)("Error running plugin " + plugin.getName() + " - see log for details"));
                    logger.error(e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        } else if (step instanceof ScriptableWorkflowStep) {
            // empty if block
        }
    }

    void showScript() {
        WorkflowCommandLogView.showScript(this.qupath.getScriptEditor(), (Workflow)this.workflowProperty.get());
    }

    public static void showScript(ScriptEditor scriptEditor, Workflow workflow) {
        if (workflow == null) {
            return;
        }
        String script = workflow.createScript();
        logger.info("\n//---------------------------------\n" + script + "\n//---------------------------------");
        if (scriptEditor != null) {
            scriptEditor.showScript("New script", script);
        }
    }

    static void populateList(ObservableList<KeyValue<Object>> list, WorkflowStep step) {
        if (step == null) {
            list.clear();
            return;
        }
        ArrayList<KeyValue<Object>> listNew = new ArrayList<KeyValue<Object>>();
        for (Map.Entry entry : step.getParameterMap().entrySet()) {
            listNew.add(new KeyValue((String)entry.getKey(), entry.getValue()));
        }
        if (step instanceof ScriptableWorkflowStep) {
            String script = ((ScriptableWorkflowStep)step).getScript();
            listNew.add(new KeyValue<String>("Script", script));
        }
        list.setAll(listNew);
    }

    public void workflowUpdated(Workflow workflow) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.workflowUpdated(workflow));
            return;
        }
        if (workflow == null) {
            this.list.getItems().clear();
        } else {
            this.list.getItems().setAll((Collection)workflow.getSteps());
            WorkflowCommandLogView.populateList((ObservableList<KeyValue<Object>>)this.table.getItems(), (WorkflowStep)this.list.getSelectionModel().getSelectedItem());
        }
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        if (imageDataOld == imageDataNew) {
            return;
        }
        if (imageDataOld != null) {
            imageDataOld.getHistoryWorkflow().removeWorkflowListener((WorkflowListener)this);
        }
        if (imageDataNew != null) {
            imageDataNew.getHistoryWorkflow().addWorkflowListener((WorkflowListener)this);
            this.workflowProperty.set((Object)imageDataNew.getHistoryWorkflow());
            this.list.getSelectionModel().clearSelection();
            Workflow workflow = imageDataNew.getHistoryWorkflow();
            this.list.getItems().setAll((Collection)workflow.getSteps());
            this.workflowUpdated(workflow);
        } else {
            this.workflowProperty.set(null);
            this.list.getItems().clear();
            this.workflowUpdated(null);
        }
    }

    private static class KeyValue<T> {
        private final StringProperty key = new SimpleStringProperty();
        private final ObjectProperty<T> value = new SimpleObjectProperty();

        KeyValue(String key, T value) {
            this.key.set((Object)key);
            this.value.set(value);
        }

        public StringProperty keyProperty() {
            return this.key;
        }

        public ObjectProperty<T> valueProperty() {
            return this.value;
        }
    }

    static class ParameterTableCell<S, T>
    extends TableCell<S, T> {
        private Tooltip tooltip = new Tooltip();

        ParameterTableCell() {
            this.setWrapText(true);
            this.setMaxHeight(Double.MAX_VALUE);
        }

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setTooltip(null);
                return;
            }
            String text = Objects.toString(item);
            this.setText(text);
            this.tooltip.setText(text);
            this.setTooltip(this.tooltip);
        }
    }
}

