/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.panes.SimpleImageViewer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;

public class SlideLabelView
implements ChangeListener<ImageData<BufferedImage>> {
    private static Logger logger = LoggerFactory.getLogger(SlideLabelView.class);
    private QuPathGUI qupath;
    private SimpleImageViewer simpleImageViewer;
    private Stage stage;
    private BooleanProperty showing = PathPrefs.createPersistentPreference("showSlideLabel", false);
    private StringProperty placeholderText = new SimpleStringProperty();

    public SlideLabelView(QuPathGUI qupath) {
        this.qupath = qupath;
        qupath.imageDataProperty().addListener((ChangeListener)this);
    }

    private void createDialog() {
        this.simpleImageViewer = new SimpleImageViewer();
        this.simpleImageViewer.placeholderTextProperty().bind((ObservableValue)this.placeholderText);
        this.stage = this.simpleImageViewer.getStage();
        this.stage.initOwner((Window)this.qupath.getStage());
        if (this.simpleImageViewer.getImage() == null) {
            this.stage.setWidth(240.0);
            this.stage.setHeight(240.0);
        }
        this.showing.addListener((v, o, n) -> {
            if (n.booleanValue()) {
                if (!this.stage.isShowing()) {
                    GuiTools.showWithScreenSizeConstraints(this.stage, 0.8);
                }
            } else if (this.stage.isShowing()) {
                this.stage.hide();
            }
        });
        this.stage.showingProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.updateLabel(this.qupath.getImageData());
            }
            this.showing.set(n.booleanValue());
        });
        if (this.showing.get()) {
            Platform.runLater(() -> {
                this.updateLabel(this.qupath.getImageData());
                GuiTools.showWithScreenSizeConstraints(this.stage, 0.8);
            });
        }
    }

    public BooleanProperty showingProperty() {
        if (this.stage == null) {
            this.createDialog();
        }
        return this.showing;
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.updateLabel(imageDataNew);
    }

    private void updateLabel(ImageData<BufferedImage> imageData) {
        ImageServer server;
        if (this.stage == null || !this.stage.isShowing()) {
            return;
        }
        ImageServer imageServer = server = imageData == null ? null : imageData.getServer();
        if (server == null) {
            this.placeholderText.set((Object)"No image open in the current viewer");
            this.simpleImageViewer.resetImage();
        } else {
            String labelName = SlideLabelView.searchForLabelName(server);
            if (labelName == null) {
                this.placeholderText.set((Object)"No label found");
                this.simpleImageViewer.resetImage();
            } else {
                this.simpleImageViewer.updateImage(labelName, (BufferedImage)server.getAssociatedImage(labelName));
            }
        }
    }

    private static String searchForLabelName(ImageServer<?> server) {
        List associatedNames = server.getAssociatedImageList();
        if (associatedNames.isEmpty()) {
            return null;
        }
        String labelName = associatedNames.stream().filter(n -> n.toLowerCase().trim().equals("label")).findFirst().orElse(null);
        if (labelName == null) {
            labelName = associatedNames.stream().filter(n -> n.toLowerCase().trim().contains("(label)")).findFirst().orElse(null);
        }
        if (labelName == null) {
            labelName = associatedNames.stream().filter(n -> n.toLowerCase().trim().contains("label")).findFirst().orElse(null);
        }
        if (labelName == null) {
            labelName = associatedNames.stream().filter(n -> n.toLowerCase().trim().contains("macro")).findFirst().orElse(null);
        }
        if (labelName == null) {
            labelName = (String)associatedNames.get(0);
        }
        return labelName;
    }
}

