/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.utils.FXUtils;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.WrappedBufferedImageServer;

public class SimpleImageViewer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleImageViewer.class);
    private Stage stage;
    private LocalizedResourceManager resources = QuPathResources.getLocalizedResourceManager();
    private MenuBar menubar;
    private BorderPane pane;
    private ImageView imageView;
    private ContextMenu contextMenu;
    private StringProperty placeholderText = new SimpleStringProperty();
    private ObjectProperty<Text> placeholder = new SimpleObjectProperty();
    private BooleanProperty isNon8BitImage = new SimpleBooleanProperty(false);
    private DoubleProperty saturation = new SimpleDoubleProperty();
    private BooleanProperty expandToWindow = new SimpleBooleanProperty(false);
    private ReadOnlyObjectWrapper<String> imageName = new ReadOnlyObjectWrapper();
    private ReadOnlyObjectWrapper<BufferedImage> img = new ReadOnlyObjectWrapper();
    private ReadOnlyObjectWrapper<Image> image = new ReadOnlyObjectWrapper();
    @ActionConfig(value="SimpleImageViewer.Action.copy")
    @ActionAccelerator(value="shortcut+c")
    private Action actionCopy = ActionTools.createAction(this::handleCopyToClipboard);
    @ActionConfig(value="SimpleImageViewer.Action.close")
    @ActionAccelerator(value="shortcut+w")
    private Action actionClose = ActionTools.createAction(this::handleClose);
    @ActionConfig(value="SimpleImageViewer.Action.save")
    @ActionAccelerator(value="shortcut+shift+s")
    private Action actionSave = ActionTools.createAction(this::handleSaveImage);
    @ActionConfig(value="SimpleImageViewer.Action.saturation")
    private Action actionSaturation = ActionTools.createAction(this::handleSetSaturation);
    @ActionConfig(value="SimpleImageViewer.Action.expandToWindow")
    private Action actionExpandToWindow = ActionTools.createSelectableAction((ObservableValue<Boolean>)this.expandToWindow);

    public SimpleImageViewer() {
        this.initialize();
    }

    private void initialize() {
        logger.trace("Initializing SimpleImageViewer");
        this.pane = new BorderPane();
        this.saturation.bind((ObservableValue)PathPrefs.autoBrightnessContrastSaturationPercentProperty());
        this.saturation.addListener(this::handleSaturationChanged);
        this.initializePlaceholder();
        this.initializeActions();
        this.initializeImageView();
        this.initializeMenuBar();
        this.initializeContextMenu();
        this.stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.titleProperty().bind((ObservableValue)this.createTitleBinding());
        Scene scene = new Scene((Parent)this.pane);
        this.pane.backgroundProperty().bind(this.createBackgroundBinding());
        this.pane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        this.pane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        this.pane.centerProperty().bind(this.createCenterBinding());
        this.stage.setScene(scene);
    }

    private ObjectBinding<Background> createBackgroundBinding() {
        return Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill((Paint)SimpleImageViewer.getViewerBackgroundColor(), null, null)}), (Observable[])new Observable[]{PathPrefs.viewerBackgroundColorProperty()});
    }

    private ObjectBinding<Color> createPlaceholderTextFillBinding() {
        return Bindings.createObjectBinding(() -> {
            Color color = SimpleImageViewer.getViewerBackgroundColor();
            if (color.getBrightness() > 0.5) {
                return ColorToolsFX.getCachedColor(0, 0, 0, 127);
            }
            return ColorToolsFX.getCachedColor(255, 255, 255, 127);
        }, (Observable[])new Observable[]{PathPrefs.viewerBackgroundColorProperty()});
    }

    private static Color getViewerBackgroundColor() {
        return ColorToolsFX.getCachedColor(PathPrefs.viewerBackgroundColorProperty().get());
    }

    private ObjectBinding<Node> createCenterBinding() {
        return Bindings.createObjectBinding(() -> {
            if (this.imageView.getImage() != null) {
                return this.imageView;
            }
            return (Node)this.placeholder.get();
        }, (Observable[])new Observable[]{this.imageView.imageProperty()});
    }

    private void initializePlaceholder() {
        Text textPlaceholder = new Text();
        textPlaceholder.fillProperty().bind(this.createPlaceholderTextFillBinding());
        textPlaceholder.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.placeholderText.get() == null) {
                return this.resources.getString("SimpleImageViewer.placeholderText");
            }
            return (String)this.placeholderText.get();
        }, (Observable[])new Observable[]{this.placeholderText, PathPrefs.defaultLocaleDisplayProperty()}));
        this.placeholder.set((Object)textPlaceholder);
    }

    private void initializeActions() {
        ActionTools.getAnnotatedActions(this);
        this.actionSave.disabledProperty().bind((ObservableValue)this.img.isNull());
        this.actionCopy.disabledProperty().bind((ObservableValue)this.image.isNull());
        this.actionSaturation.disabledProperty().bind((ObservableValue)this.isNon8BitImage.not());
    }

    private void initializeImageView() {
        this.imageView = new ImageView();
        this.imageView.fitWidthProperty().bind((ObservableValue)this.createFitImageBinding(this::computeFitWidth));
        this.imageView.fitHeightProperty().bind((ObservableValue)this.createFitImageBinding(this::computeFitHeight));
        this.imageView.setPreserveRatio(true);
        this.imageView.imageProperty().bind(this.image);
    }

    private Double computeFitWidth() {
        Image imageFX = (Image)this.image.get();
        if (imageFX != null && !this.expandToWindow.get()) {
            return Math.min(this.pane.getWidth(), imageFX.getWidth());
        }
        return this.pane.getWidth();
    }

    private Double computeFitHeight() {
        Image imageFX = (Image)this.image.get();
        if (imageFX != null && !this.expandToWindow.get()) {
            return Math.min(this.pane.getHeight(), imageFX.getHeight());
        }
        return this.pane.getHeight();
    }

    private DoubleBinding createFitImageBinding(Callable<Double> func) {
        return Bindings.createDoubleBinding(func, (Observable[])new Observable[]{this.pane.widthProperty(), this.pane.heightProperty(), this.expandToWindow});
    }

    private void initializeMenuBar() {
        this.menubar = new MenuBar();
        this.menubar.getMenus().addAll((Object[])new Menu[]{this.createFileMenu(), this.createEditMenu(), this.createViewMenu()});
        SystemMenuBar.manageMainMenuBar(this.menubar);
        this.pane.setTop((Node)this.menubar);
    }

    private StringBinding createTitleBinding() {
        return Bindings.createStringBinding(this::getCurrentTile, (Observable[])new Observable[]{this.image, this.imageName, PathPrefs.defaultLocaleDisplayProperty()});
    }

    private String getCurrentTile() {
        String name = (String)this.imageName.get();
        if (name == null || name.isEmpty()) {
            return this.resources.getString("SimpleImageViewer.noTitle");
        }
        return name;
    }

    private Menu createFileMenu() {
        return MenuTools.createMenu("Menu.File", this.actionSave, this.actionClose);
    }

    private Menu createEditMenu() {
        return MenuTools.createMenu("Menu.Edit", this.actionCopy);
    }

    private Menu createViewMenu() {
        return MenuTools.createMenu("Menu.View", this.actionExpandToWindow, this.actionSaturation);
    }

    private void initializeContextMenu() {
        this.contextMenu = new ContextMenu();
        MenuItem miCopy = ActionTools.createMenuItem(this.actionCopy);
        MenuItem miExpandToWindow = ActionTools.createMenuItem(this.actionExpandToWindow);
        MenuItem miSaturation = ActionTools.createMenuItem(this.actionSaturation);
        miSaturation.visibleProperty().bind((ObservableValue)this.actionSaturation.disabledProperty().not());
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{miCopy, miExpandToWindow, miSaturation});
        this.pane.setOnContextMenuRequested(e -> this.contextMenu.show((Node)this.pane, e.getScreenX(), e.getScreenY()));
    }

    public String getPlaceholderText() {
        return (String)this.placeholderText.get();
    }

    public void setPlaceholderText(String placeholder) {
        this.placeholderText.set((Object)placeholder);
    }

    public StringProperty placeholderTextProperty() {
        return this.placeholderText;
    }

    public DoubleProperty saturationPercentProperty() {
        return this.saturation;
    }

    public double getSaturationPercent() {
        return this.saturation.get();
    }

    public void setSaturationPercent(double percent) {
        this.saturation.unbind();
        this.saturation.set(percent);
    }

    public BooleanProperty expandToWindowProperty() {
        return this.expandToWindow;
    }

    public boolean getExpandToWindow() {
        return this.expandToWindow.get();
    }

    public void setExpandToWindow(boolean limit) {
        this.expandToWindow.set(limit);
    }

    public Stage getStage() {
        return this.stage;
    }

    private void handleClose() {
        this.stage.close();
    }

    private void handleSaveImage() {
        String name = (String)this.imageName.get();
        File fileOutput = FileChoosers.promptToSaveFile((Window)this.stage, null, (File)(name == null || name.isEmpty() ? null : new File(name)), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"PNG", (String[])new String[]{".png"})});
        if (fileOutput != null) {
            try {
                ImageIO.write((RenderedImage)this.img.get(), "PNG", fileOutput);
            }
            catch (Exception e) {
                Dialogs.showErrorMessage((String)"Save image", (String)("Error saving " + fileOutput.getName() + "\n" + e.getLocalizedMessage()));
            }
        }
    }

    private void handleCopyToClipboard() {
        ClipboardContent content = new ClipboardContent();
        content.putImage((Image)this.image.get());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void updateImage(String name, Image image) {
        logger.trace("Updating JavaFX Image to {} ({})", (Object)name, (Object)image);
        this.image.set((Object)image);
        this.img.set((Object)this.convertToBufferedImage(image));
        this.imageName.set((Object)name);
        this.isNon8BitImage.set(SimpleImageViewer.requiresAutoContrast((BufferedImage)this.img.get()));
    }

    public void resetImage() {
        this.updateImage(null, (Image)null);
    }

    public void updateImage(String name, BufferedImage img) {
        logger.trace("Updating BufferedImage to {} ({})", (Object)name, (Object)img);
        this.img.set((Object)img);
        this.image.set((Object)this.convertToFXImage(img));
        this.imageName.set((Object)name);
        this.isNon8BitImage.set(SimpleImageViewer.requiresAutoContrast(img));
    }

    public ReadOnlyObjectProperty<String> imageNameProperty() {
        return this.imageName.getReadOnlyProperty();
    }

    public String getName() {
        return (String)this.imageName.get();
    }

    public ReadOnlyObjectProperty<Image> imageProperty() {
        return this.image.getReadOnlyProperty();
    }

    public Image getImage() {
        return (Image)this.image.get();
    }

    public ReadOnlyObjectProperty<BufferedImage> bufferedImageProperty() {
        return this.img.getReadOnlyProperty();
    }

    public BufferedImage getBufferedImage() {
        return (BufferedImage)this.img.get();
    }

    private BufferedImage convertToBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        return SwingFXUtils.fromFXImage((Image)image, null);
    }

    private static boolean requiresAutoContrast(BufferedImage img) {
        return img != null && !BufferedImageTools.is8bitColorType((int)img.getType()) && img.getType() != 10;
    }

    private Image convertToFXImage(BufferedImage imgBuffered) {
        if (imgBuffered == null) {
            return null;
        }
        if (SimpleImageViewer.requiresAutoContrast(imgBuffered)) {
            try {
                WrappedBufferedImageServer wrappedServer = new WrappedBufferedImageServer("Dummy", imgBuffered);
                ImageDisplay imageDisplay = ImageDisplay.create((ImageData<BufferedImage>)new ImageData((ImageServer)wrappedServer));
                for (ChannelDisplayInfo info : imageDisplay.selectedChannels()) {
                    imageDisplay.autoSetDisplayRange(info, this.saturation.get() / 100.0);
                }
                imgBuffered = imageDisplay.applyTransforms(imgBuffered, null);
            }
            catch (Exception e) {
                logger.error("Error applying auto contrast to image", (Throwable)e);
            }
        }
        return SwingFXUtils.toFXImage((BufferedImage)imgBuffered, null);
    }

    private void handleSetSaturation() {
        Double percent = Dialogs.showInputDialog((String)"Set saturation", (String)"Set saturation percentage", (Double)this.saturation.get());
        if (percent != null && Double.isFinite(percent) && percent >= 0.0 && percent < 100.0) {
            this.setSaturationPercent(percent);
        }
    }

    private void handleSaturationChanged(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        if (this.isNon8BitImage.get()) {
            this.updateImage((String)this.imageName.get(), (BufferedImage)this.img.get());
        }
    }
}

