/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.ProjectCommands;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;

public class ServerSelector {
    private static final Logger logger = LoggerFactory.getLogger(ServerSelector.class);
    private List<ImageServer<BufferedImage>> serverList = new ArrayList<ImageServer<BufferedImage>>();
    private boolean closeAfterPrompt = false;
    private static boolean buildParallel = true;

    public static ServerSelector createFromBuilders(Collection<? extends ImageServerBuilder.ServerBuilder<BufferedImage>> builders) {
        Stream stream = builders.stream();
        if (buildParallel) {
            stream = (Stream)stream.parallel();
        }
        List<ImageServer> list = stream.map(b -> {
            try {
                return b.build();
            }
            catch (Exception e) {
                logger.warn("Unable to build {}", b);
                return null;
            }
        }).filter(s -> s != null).toList();
        return new ServerSelector(list, true);
    }

    public static ServerSelector create(Collection<? extends ImageServer<BufferedImage>> servers) {
        return new ServerSelector(servers, false);
    }

    private ServerSelector(Collection<? extends ImageServer<BufferedImage>> servers, boolean closeAfterPrompt) {
        this.serverList.addAll(servers);
        this.closeAfterPrompt = closeAfterPrompt;
    }

    public ImageServer<BufferedImage> promptToSelectImage(String prompt, boolean alwaysShow) {
        List<ImageServer<BufferedImage>> result;
        if (!alwaysShow) {
            if (this.serverList.isEmpty()) {
                logger.warn("No images available!");
                return null;
            }
            if (this.serverList.size() == 1) {
                logger.warn("Only one image available!");
                return this.serverList.get(0);
            }
        }
        return (result = this.promptToSelectServers(false, prompt)).isEmpty() ? null : result.iterator().next();
    }

    public List<ImageServer<BufferedImage>> promptToSelectImages(String prompt) {
        return this.promptToSelectServers(true, prompt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImageServer<BufferedImage>> promptToSelectServers(boolean multiSelection, String promptBase) {
        boolean returnNothing;
        String prompt = promptBase == null ? "Select" : promptBase;
        ExecutorService executor = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"thumbnail-loader", (boolean)true));
        ListView listSeries = new ListView();
        listSeries.setPrefWidth(480.0);
        listSeries.setMinHeight(100.0);
        if (multiSelection) {
            listSeries.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        } else {
            listSeries.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        }
        HashMap thumbnailBank = new HashMap();
        for (ImageServer<BufferedImage> server : this.serverList) {
            double height;
            double downsample = server.getDownsampleForResolution(server.nResolutions() - 1);
            double width = (double)server.getWidth() / downsample;
            if (width * (height = (double)server.getHeight() / downsample) < 1.0E8) {
                executor.submit(() -> {
                    try {
                        thumbnailBank.put(server.getMetadata().getName(), ProjectCommands.getThumbnailRGB(server));
                        Platform.runLater(() -> listSeries.refresh());
                    }
                    catch (IOException e) {
                        logger.warn("Error loading thumbnail: " + e.getLocalizedMessage(), (Throwable)e);
                    }
                });
                continue;
            }
            logger.warn("Image too big! Not generating thumbnail for {}", server);
        }
        double thumbnailSize = 80.0;
        listSeries.setCellFactory(v -> new ImageAndNameListCell(thumbnailBank, thumbnailSize, thumbnailSize));
        FilteredList items = FXCollections.observableArrayList(this.serverList).filtered(p -> true);
        TextField tfFilter = new TextField();
        StringProperty filterText = tfFilter.textProperty();
        ObjectBinding predicateProperty = Bindings.createObjectBinding(() -> {
            String text = (String)filterText.get();
            if (text == null || text.isEmpty()) {
                return s -> true;
            }
            String textLower = text.toLowerCase();
            return s -> {
                String name = s.getMetadata().getName();
                return name != null && name.toLowerCase().contains(textLower);
            };
        }, (Observable[])new Observable[]{filterText});
        items.predicateProperty().bind((ObservableValue)predicateProperty);
        listSeries.setItems((ObservableList)items);
        TableView tableInfo = new TableView();
        tableInfo.setMinHeight(200.0);
        tableInfo.setMinWidth(500.0);
        TableColumn attributeCol = new TableColumn("Attribute");
        attributeCol.setResizable(true);
        attributeCol.setCellValueFactory(cellData -> new ReadOnlyObjectWrapper(cellData.getValue() == null ? null : ((Attribute)((Object)((Object)cellData.getValue()))).getText()));
        TableColumn valueCol = new TableColumn("Value");
        valueCol.setMinWidth(242.0);
        valueCol.setResizable(true);
        valueCol.setCellValueFactory(cellData -> {
            int ind = listSeries.getSelectionModel().getSelectedIndex();
            if (ind >= 0 && ind < this.serverList.size()) {
                return new ReadOnlyObjectWrapper((Object)ServerSelector.getServerAttribute(this.serverList.get(ind), (Attribute)((Object)((Object)cellData.getValue())), ind));
            }
            return null;
        });
        tableInfo.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableInfo.setRowFactory(tableView -> {
            TableRow row = new TableRow();
            row.hoverProperty().addListener(observable -> {
                Attribute element = (Attribute)((Object)((Object)((Object)row.getItem())));
                int ind = listSeries.getSelectionModel().getSelectedIndex();
                if (row.isHover() && ind >= 0 && ind < this.serverList.size()) {
                    String value = ServerSelector.getServerAttribute(this.serverList.get(ind), element, ind);
                    Tooltip tooltip = new Tooltip(value);
                    Tooltip.install((Node)row, (Tooltip)tooltip);
                }
            });
            return row;
        });
        tableInfo.getItems().setAll((Object[])Attribute.values());
        if (!this.sameUri()) {
            tableInfo.getItems().remove((Object)Attribute.INDEX);
        }
        tableInfo.getColumns().addAll((Object[])new TableColumn[]{attributeCol, valueCol});
        BorderPane paneSelector = new BorderPane();
        BorderPane paneSeries = new BorderPane((Node)listSeries);
        BorderPane paneInfo = new BorderPane((Node)tableInfo);
        paneInfo.setMaxHeight(100.0);
        paneSelector.setCenter((Node)paneSeries);
        BorderPane paneFilter = new BorderPane((Node)tfFilter);
        Label labelFilter = new Label("Search: ");
        labelFilter.setAlignment(Pos.CENTER_LEFT);
        labelFilter.setMaxHeight(Double.MAX_VALUE);
        labelFilter.setLabelFor((Node)tfFilter);
        paneFilter.setLeft((Node)labelFilter);
        paneInfo.setBottom((Node)paneFilter);
        paneFilter.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        paneSelector.setBottom((Node)paneInfo);
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)paneSelector);
        Dialog dialog = new Dialog();
        QuPathGUI qupath = QuPathGUI.getInstance();
        Stage mainStage = qupath == null ? null : qupath.getStage();
        Stage owner = Window.getWindows().stream().map(w -> w instanceof Stage ? (Stage)w : null).filter(s -> s != null).filter(s -> s.isFocused() && s.getModality() != Modality.NONE).findFirst().orElse(mainStage);
        dialog.initOwner((Window)owner);
        if (multiSelection) {
            dialog.setTitle(prompt + " images");
        } else {
            dialog.setTitle(prompt + " image");
        }
        ButtonType typeImportSelected = new ButtonType(prompt + " selected", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{typeImportSelected, ButtonType.CANCEL});
        dialog.getDialogPane().setContent((Node)pane);
        listSeries.getSelectionModel().selectedItemProperty().addListener((obs, previousSelectedRow, selectedRow) -> tableInfo.refresh());
        if (!multiSelection) {
            listSeries.setOnMouseClicked(click -> {
                ImageServer selectedItem = (ImageServer)listSeries.getSelectionModel().getSelectedItem();
                if (click.getClickCount() == 2 && selectedItem != null) {
                    Button acceptButton = (Button)dialog.getDialogPane().lookupButton(typeImportSelected);
                    acceptButton.fire();
                }
            });
        }
        IntegerBinding nSelected = Bindings.createIntegerBinding(() -> listSeries.getSelectionModel().getSelectedIndices().size(), (Observable[])new Observable[]{listSeries.getSelectionModel().getSelectedItems()});
        BooleanBinding selectAll = Bindings.createBooleanBinding(() -> {
            int n = nSelected.get();
            return n == 0 || n >= this.serverList.size();
        }, (Observable[])new Observable[]{nSelected});
        Button btnSelected = (Button)dialog.getDialogPane().lookupButton(typeImportSelected);
        if (multiSelection) {
            btnSelected.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> selectAll.get() ? prompt + " all" : prompt + " " + nSelected.get(), (Observable[])new Observable[]{selectAll}));
        } else {
            btnSelected.disableProperty().bind((ObservableValue)nSelected.isNotEqualTo(1));
        }
        Optional result = dialog.showAndWait();
        ButtonType resultType = result.orElse(ButtonType.CANCEL);
        Set<Object> selectedToReturn = resultType == ButtonType.CANCEL ? Collections.emptySet() : (multiSelection && selectAll.get() ? new LinkedHashSet<ImageServer<BufferedImage>>(this.serverList) : new LinkedHashSet(listSeries.getSelectionModel().getSelectedItems()));
        boolean bl = returnNothing = !result.isPresent() || result.get() != typeImportSelected || result.get() == ButtonType.CANCEL;
        if (returnNothing) {
            selectedToReturn = Collections.emptySet();
        }
        try {
            executor.shutdownNow();
        }
        catch (Exception e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (this.closeAfterPrompt) {
                try {
                    for (ImageServer<BufferedImage> server : this.serverList) {
                        if (selectedToReturn.contains(server)) continue;
                        server.close();
                    }
                }
                catch (Exception e) {
                    logger.debug(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (selectedToReturn.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ImageServer<BufferedImage>>(selectedToReturn);
    }

    private boolean sameUri() {
        HashSet set = new HashSet();
        for (ImageServer<BufferedImage> server : this.serverList) {
            set.addAll(server.getURIs());
        }
        return set.size() <= 1;
    }

    private static String getServerAttribute(ImageServer<?> server, Attribute attribute, int index) {
        switch (attribute.ordinal()) {
            case 2: {
                return String.valueOf(index);
            }
            case 0: {
                Collection uris = server.getURIs();
                if (uris.size() == 1) {
                    return ServerSelector.uriToString((URI)uris.iterator().next());
                }
                return "[" + server.getURIs().stream().map(ServerSelector::uriToString).collect(Collectors.joining(", ")) + "]";
            }
            case 7: {
                double pixelHeightTemp = server.getPixelCalibration().getPixelHeight().doubleValue();
                return GeneralTools.formatNumber((double)pixelHeightTemp, (int)4) + " " + server.getPixelCalibration().getPixelHeightUnit();
            }
            case 8: {
                return server.getPixelType().toString();
            }
            case 6: {
                double pixelWidthTemp = server.getPixelCalibration().getPixelWidth().doubleValue();
                return GeneralTools.formatNumber((double)pixelWidthTemp, (int)4) + " " + server.getPixelCalibration().getPixelWidthUnit();
            }
            case 1: {
                return server.getServerType();
            }
            case 3: {
                return server.getWidth() + " px";
            }
            case 4: {
                return server.getHeight() + " px";
            }
            case 5: {
                return String.format("%d x %d x %d", server.nChannels(), server.nZSlices(), server.nTimepoints());
            }
            case 9: {
                if (server.nResolutions() == 1) {
                    return "No";
                }
                return GeneralTools.arrayToString((Locale)Locale.getDefault(Locale.Category.FORMAT), (double[])server.getPreferredDownsamples(), (int)1);
            }
        }
        return null;
    }

    private static String uriToString(URI uri) {
        if (uri == null) {
            return "";
        }
        try {
            return URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return uri.toString();
        }
    }

    private static enum Attribute {
        PATH("Full Path"),
        TYPE("Server Type"),
        INDEX("Image index"),
        WIDTH("Width"),
        HEIGHT("Height"),
        DIMENSIONS("Dimensions (CZT)"),
        PIXEL_WIDTH("Pixel Width"),
        PIXEL_HEIGHT("Pixel Height"),
        PIXEL_TYPE("Pixel Type"),
        PYRAMID("Pyramid");

        private String text;

        private Attribute(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    static class ImageAndNameListCell
    extends ListCell<ImageServer<BufferedImage>> {
        private Map<String, BufferedImage> imageCache;
        private final Canvas canvas = new Canvas();
        private Image img;

        public ImageAndNameListCell(Map<String, BufferedImage> imageCache, double imgWidth, double imgHeight) {
            this.imageCache = imageCache;
            this.canvas.setStyle("-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.5), 4, 0, 1, 1);");
            this.canvas.setWidth(imgWidth);
            this.canvas.setHeight(imgHeight);
            this.canvas.heightProperty().bind((ObservableValue)this.canvas.widthProperty());
            this.setGraphicTextGap(10.0);
            this.setGraphic((Node)this.canvas);
            this.setText(null);
        }

        protected void updateItem(ImageServer<BufferedImage> entry, boolean empty) {
            super.updateItem(entry, empty);
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
            if (entry == null || empty) {
                this.setTooltip(null);
                this.setText(null);
                this.img = null;
                return;
            }
            String name = entry.getMetadata().getName();
            Object text = name == null || name.isBlank() ? "(No image name)" : name + "\n";
            text = (String)text + "(Image " + (this.getIndex() + 1) + ")";
            BufferedImage thumbnail = this.imageCache.get(name);
            if (thumbnail != null) {
                this.img = SwingFXUtils.toFXImage((BufferedImage)thumbnail, null);
            }
            this.setText(name);
            if (this.img == null) {
                return;
            }
            GuiTools.paintImage(this.canvas, this.img);
            Tooltip tooltip = new Tooltip();
            ImageView imageView = new ImageView(this.img);
            imageView.setFitHeight(250.0);
            imageView.setPreserveRatio(true);
            tooltip.setGraphic((Node)imageView);
            this.setTooltip(new Tooltip((String)text));
        }
    }
}

