/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;

public class SelectedMeasurementTableView
implements PathObjectSelectionListener,
ChangeListener<ImageData<BufferedImage>>,
PathObjectHierarchyListener,
PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(SelectedMeasurementTableView.class);
    private static int nDecimalPlaces = -4;
    private ObservableValue<ImageData<BufferedImage>> imageDataProperty;
    private ImageData<?> imageData;
    private BorderPane pane;
    private TableView<String> tableMeasurements;
    private final ObservableMeasurementTableData tableModel = new ObservableMeasurementTableData();
    private boolean delayedUpdate = false;
    private PredicateTextField<String> filter;
    private final BooleanProperty isShowing = new SimpleBooleanProperty(false);
    private final ObservableList<String> allKeys = FXCollections.observableArrayList();
    private final FilteredList<String> filteredKeys = new FilteredList(this.allKeys);
    private final BooleanProperty useRegex = new SimpleBooleanProperty(false);
    private final BooleanProperty ignoreCase = new SimpleBooleanProperty(true);
    private final StringProperty filterText = new SimpleStringProperty("");

    public SelectedMeasurementTableView(ObservableValue<ImageData<BufferedImage>> imageDataProperty) {
        this.imageDataProperty = imageDataProperty;
        imageDataProperty.addListener((ChangeListener)this);
    }

    private void ensureInitialized() {
        if (this.pane != null) {
            return;
        }
        this.tableMeasurements = this.createMeasurementTable();
        this.filter = this.createFilter();
        this.filteredKeys.predicateProperty().bind((ObservableValue)this.filter.predicateProperty());
        this.pane = new BorderPane();
        this.pane.setCenter(this.tableMeasurements);
        this.pane.setBottom(this.filter);
        this.isShowing.bind((ObservableValue)this.tableMeasurements.visibleProperty().and((ObservableBooleanValue)this.pane.visibleProperty()));
        this.isShowing.addListener((v, o, n) -> {
            if (n.booleanValue() && this.delayedUpdate) {
                this.updateTableModel();
            }
        });
    }

    private ObservableValue<String> tableKeyColumnValueFactory(TableColumn.CellDataFeatures<String, String> p) {
        return new SimpleStringProperty((String)p.getValue());
    }

    private ObservableValue<String> tableValueColumnValueFactory(TableColumn.CellDataFeatures<String, String> p) {
        return new SimpleStringProperty(this.getSelectedObjectMeasurementValue((String)p.getValue()));
    }

    private TableView<String> createMeasurementTable() {
        TableView tableMeasurements = new TableView();
        tableMeasurements.setPlaceholder((Node)GuiTools.createPlaceholderText("No image or object selected"));
        this.allKeys.setAll(this.tableModel.getAllNames());
        tableMeasurements.setItems(this.filteredKeys);
        TableColumn col1 = new TableColumn("Key");
        col1.setCellValueFactory(this::tableKeyColumnValueFactory);
        TableColumn col2 = new TableColumn("Value");
        col2.setCellValueFactory(this::tableValueColumnValueFactory);
        col2.setCellFactory(c -> new ValueTableCell());
        tableMeasurements.getColumns().addAll((Object[])new TableColumn[]{col1, col2});
        tableMeasurements.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        tableMeasurements.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        tableMeasurements.setRowFactory(this::createTableRow);
        tableMeasurements.setOnKeyPressed(this::handleTableKeyPress);
        return tableMeasurements;
    }

    private void handleTableKeyPress(KeyEvent e) {
        if (new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}).match(e)) {
            this.copyMeasurementsToClipboard((List<String>)this.tableMeasurements.getSelectionModel().getSelectedItems());
        }
        e.consume();
    }

    private TableRow<String> createTableRow(TableView<String> table) {
        TableRow row = new TableRow();
        ContextMenu menu = new ContextMenu();
        MenuItem copyItem = new MenuItem("Copy");
        menu.getItems().add((Object)copyItem);
        copyItem.setOnAction(ev -> this.copyMeasurementsToClipboard((List<String>)this.tableMeasurements.getSelectionModel().getSelectedItems()));
        row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)menu));
        Tooltip tooltip = new Tooltip();
        row.itemProperty().addListener((v, o, n) -> {
            String helpText;
            String string = helpText = n == null ? null : this.tableModel.getHelpText((String)n);
            if (helpText == null || helpText.isBlank()) {
                row.setTooltip(null);
            } else {
                tooltip.setText(helpText);
                row.setTooltip(tooltip);
            }
        });
        return row;
    }

    private void copyMeasurementsToClipboard(List<String> selectedMeasurements) {
        ClipboardContent content = new ClipboardContent();
        String values = selectedMeasurements.stream().map(item -> item + "\t" + this.getSelectedObjectMeasurementValue((String)item)).collect(Collectors.joining(System.lineSeparator()));
        content.putString(values);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private List<PathObject> getSelectedObjectList() {
        PathObject selected = this.getSelectedObject();
        if (selected == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(selected);
    }

    private PathObject getSelectedObject() {
        if (this.imageData == null) {
            return null;
        }
        PathObject selected = this.imageData.getHierarchy().getSelectionModel().getSelectedObject();
        if (selected == null) {
            return this.imageData.getHierarchy().getRootObject();
        }
        return selected;
    }

    private String getSelectedObjectMeasurementValue(String name) {
        PathObject selected = this.getSelectedObject();
        if (selected == null) {
            return null;
        }
        return this.tableModel.getStringValue(selected, name, nDecimalPlaces);
    }

    private PredicateTextField<String> createFilter() {
        PredicateTextField filter = new PredicateTextField();
        filter.useRegexProperty().bindBidirectional((Property)this.useRegex);
        filter.textProperty().bindBidirectional((Property)this.filterText);
        filter.ignoreCaseProperty().bindBidirectional((Property)this.ignoreCase);
        filter.promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.useRegex.get()) {
                return "Filter measurements by regular expression";
            }
            return "Filter measurements by key";
        }, (Observable[])new Observable[]{this.useRegex}));
        Tooltip tooltip = new Tooltip("Enter text to find specific measurements by key");
        Tooltip.install((Node)filter, (Tooltip)tooltip);
        return filter;
    }

    public TableView<String> getTable() {
        this.ensureInitialized();
        return this.tableMeasurements;
    }

    public Pane getPane() {
        this.ensureInitialized();
        return this.pane;
    }

    public PredicateTextField<String> getPredicateTextField() {
        return this.filter;
    }

    private void updateTableModel() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(this::updateTableModel);
            return;
        }
        if (!this.isShowing.get()) {
            logger.debug("Measurement table update skipped (not visible)");
            this.tableModel.setImageData(null, Collections.emptyList());
            this.allKeys.clear();
            this.delayedUpdate = true;
        } else {
            logger.debug("Measurement table update requested");
            this.tableModel.setImageData(this.imageData, this.getSelectedObjectList());
            this.allKeys.setAll(this.tableModel.getAllNames());
            this.tableMeasurements.refresh();
            this.delayedUpdate = false;
        }
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (event.isChanging()) {
            this.tableMeasurements.refresh();
        } else {
            this.updateTableModel();
        }
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        if (this.imageData != null) {
            this.imageData.removePropertyChangeListener((PropertyChangeListener)this);
            this.imageData.getHierarchy().removeListener((PathObjectHierarchyListener)this);
            this.imageData.getHierarchy().getSelectionModel().removePathObjectSelectionListener((PathObjectSelectionListener)this);
        }
        this.imageData = imageDataNew;
        if (this.imageData != null) {
            this.imageData.addPropertyChangeListener((PropertyChangeListener)this);
            this.imageData.getHierarchy().addListener((PathObjectHierarchyListener)this);
            this.imageData.getHierarchy().getSelectionModel().addPathObjectSelectionListener((PathObjectSelectionListener)this);
        }
        logger.trace("Image data set to {}", this.imageData);
        this.updateTableModel();
    }

    public void selectedPathObjectChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
        this.updateTableModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateTableModel();
    }

    private static Node ensureMinWidth(Node node) {
        if (node instanceof Region) {
            Region region = (Region)node;
            region.setMinWidth(Double.NEGATIVE_INFINITY);
            return region;
        }
        return SelectedMeasurementTableView.ensureMinWidth((Node)new BorderPane(node));
    }

    private static Node createObjectIdIcon(int size) {
        Node icon = IconFactory.createFontAwesome('\uf2c2', size);
        icon.setOpacity(0.4);
        return icon;
    }

    private static Node createObjectTypeIcon(String name, int size) {
        return switch (name.toLowerCase()) {
            case "annotation" -> IconFactory.createNode(size, size, IconFactory.PathIcons.ANNOTATIONS);
            case "tma core" -> IconFactory.createNode(size, size, IconFactory.PathIcons.TMA_GRID);
            case "detection", "cell", "tile" -> IconFactory.createNode(size, size, IconFactory.PathIcons.DETECTIONS);
            default -> null;
        };
    }

    private static Node createMeasurementListIcon(int size) {
        Node icon = IconFactory.createNode(FontAwesome.Glyph.LIST_OL, size);
        icon.setOpacity(0.4);
        Tooltip.install((Node)icon, (Tooltip)new Tooltip("Value stored in the object's measurement list.\nMay be used as a feature for an object classifier."));
        return icon;
    }

    private static Node createMetadataIcon(int size) {
        Node icon = IconFactory.createNode(FontAwesome.Glyph.LIST_UL, size);
        icon.setOpacity(0.4);
        Tooltip.install((Node)icon, (Tooltip)new Tooltip("Value is stored in the object's metadata map."));
        return icon;
    }

    private class ValueTableCell
    extends TableCell<String, String> {
        private final Label label = new Label();
        private final HBox pane = new HBox(new Node[]{this.label});
        private static final int ICON_SIZE = 12;
        private final Node measurementListIcon = SelectedMeasurementTableView.createMeasurementListIcon(12);
        private final Node metadataIcon = SelectedMeasurementTableView.createMetadataIcon(12);
        private final Node objectIdIcon = SelectedMeasurementTableView.createObjectIdIcon(12);
        private final Rectangle classIcon = new Rectangle(10.0, 10.0);

        private ValueTableCell() {
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.pane.setAlignment(Pos.CENTER);
            HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
            this.label.setMaxWidth(Double.MAX_VALUE);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            String measurement = (String)this.getTableRow().getItem();
            Node icon = null;
            this.setGraphic((Node)this.pane);
            this.label.setText(item);
            if ("Classification".equals(measurement)) {
                if (!item.isBlank()) {
                    Color color = ColorToolsFX.getPathClassColor(PathClass.fromString((String)item));
                    this.classIcon.setFill((Paint)color);
                    icon = this.classIcon;
                }
            } else if ("Object ID".equals(measurement)) {
                icon = this.objectIdIcon;
            } else if ("Object type".equals(measurement)) {
                icon = SelectedMeasurementTableView.createObjectTypeIcon(item, 12);
            } else if (SelectedMeasurementTableView.this.tableModel.isNumericMeasurement(measurement)) {
                PathObject selected = SelectedMeasurementTableView.this.getSelectedObject();
                if (selected != null && selected.getMeasurementList().containsKey(measurement)) {
                    icon = this.measurementListIcon;
                }
            } else {
                PathObject selected = SelectedMeasurementTableView.this.getSelectedObject();
                if (selected != null && selected.getMetadata().containsKey(measurement)) {
                    icon = this.metadataIcon;
                }
            }
            if (icon == null) {
                this.pane.getChildren().setAll((Object[])new Node[]{this.label});
            } else {
                this.pane.getChildren().setAll((Object[])new Node[]{this.label, SelectedMeasurementTableView.ensureMinWidth(icon)});
            }
        }
    }
}

