/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Objects;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;

abstract class ProjectTreeRow {
    ProjectTreeRow() {
    }

    abstract String getDisplayableString();

    abstract Type getType();

    static Collection<ProjectImageEntry<BufferedImage>> getEntries(Collection<ImageRow> imageRows) {
        return imageRows.stream().map(row -> row.getEntry()).toList();
    }

    static ProjectImageEntry<BufferedImage> getEntry(ProjectTreeRow projectTreeRow) {
        if (projectTreeRow.getType() == Type.IMAGE) {
            return ((ImageRow)projectTreeRow).getEntry();
        }
        return null;
    }

    static enum Type {
        ROOT,
        METADATA,
        IMAGE;

    }

    public static class ImageRow
    extends ProjectTreeRow {
        private ProjectImageEntry<BufferedImage> entry;

        ImageRow(ProjectImageEntry<BufferedImage> entry) {
            this.entry = entry;
        }

        @Override
        String getDisplayableString() {
            return this.entry.getImageName();
        }

        @Override
        Type getType() {
            return Type.IMAGE;
        }

        ProjectImageEntry<BufferedImage> getEntry() {
            return this.entry;
        }

        public int hashCode() {
            return Objects.hash(this.entry);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageRow other = (ImageRow)obj;
            return Objects.equals(this.entry, other.entry);
        }
    }

    static class MetadataRow
    extends ProjectTreeRow {
        private String originalString;

        MetadataRow(String value) {
            this.originalString = value;
        }

        @Override
        String getDisplayableString() {
            return this.originalString;
        }

        @Override
        Type getType() {
            return Type.METADATA;
        }

        public int hashCode() {
            return Objects.hash(this.originalString);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetadataRow other = (MetadataRow)obj;
            return Objects.equals(this.originalString, other.originalString);
        }
    }

    static class RootRow
    extends ProjectTreeRow {
        private Project<?> project;
        private String originalString;

        RootRow(Project<?> project) {
            this.originalString = project == null ? "No project" : project.getName();
            this.project = project;
        }

        @Override
        String getDisplayableString() {
            return this.originalString;
        }

        @Override
        Type getType() {
            return Type.ROOT;
        }

        public int hashCode() {
            return Objects.hash(this.project);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RootRow other = (RootRow)obj;
            return Objects.equals(this.project, other.project);
        }
    }
}

