/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.prefs.controlsfx.PropertyItemBuilder;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.commands.ProjectCommands;
import qupath.lib.gui.panes.ProjectTreeRow;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.io.UriUpdater;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;

public class ProjectBrowser
implements ChangeListener<ImageData<BufferedImage>> {
    private static final Logger logger = LoggerFactory.getLogger(ProjectBrowser.class);
    private static final BooleanProperty keepDescriptionPaneOpenPref = PathPrefs.createPersistentPreference("keepDescriptionOpen", false);
    private Project<BufferedImage> project;
    private int thumbnailWidth = 1000;
    private int thumbnailHeight = 600;
    private QuPathGUI qupath;
    private BorderPane panel;
    private ProjectImageTreeModel model = new ProjectImageTreeModel(null);
    private TreeView<ProjectTreeRow> tree;
    private Set<ProjectTreeRow> serversFailed = Collections.synchronizedSet(new HashSet());
    private StringProperty descriptionText = new SimpleStringProperty();
    private ObjectProperty<Predicate<String>> predicateProperty = new SimpleObjectProperty(s -> true);
    private static ObjectProperty<ProjectThumbnailSize> thumbnailSize = PathPrefs.createPersistentPreference("projectThumbnailSize", ProjectThumbnailSize.SMALL, ProjectThumbnailSize.class);
    private BooleanProperty contextMenuShowing = new SimpleBooleanProperty();
    private static final String UNASSIGNED_NODE = "(Unassigned)";
    private static final String UNDEFINED_VALUE = "Undefined";
    private static ExecutorService executor;

    public ProjectBrowser(QuPathGUI qupath) {
        this.project = qupath.getProject();
        this.qupath = qupath;
        this.tree = new TreeView();
        qupath.imageDataProperty().addListener((ChangeListener)this);
        executor = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"thumbnail-loader", (boolean)true));
        PathPrefs.maskImageNamesProperty().addListener((v, o, n) -> this.refreshTree(null));
        PathPrefs.skipProjectUriChecksProperty().addListener((v, o, n) -> this.tree.refresh());
        this.panel = new BorderPane();
        this.panel.getStyleClass().add((Object)"project-browser");
        this.tree.setCellFactory(n -> new ProjectTreeRowCell());
        thumbnailSize.addListener((v, o, n) -> this.tree.refresh());
        this.tree.setRoot(null);
        this.tree.setContextMenu(this.getPopup());
        this.tree.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                qupath.openImageEntry(this.getSelectedEntry());
                e.consume();
            }
        });
        this.tree.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                qupath.openImageEntry(this.getSelectedEntry());
                e.consume();
            }
        });
        Button editDescriptionButton = new Button(null, IconFactory.createNode(FontAwesome.Glyph.PENCIL, 13));
        editDescriptionButton.setTooltip(new Tooltip("Edit description"));
        editDescriptionButton.setOnAction(e -> this.promptToEditSelectedImageDescription());
        editDescriptionButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.tree.getSelectionModel().getSelectedItem() != null && ((ProjectTreeRow)((TreeItem)this.tree.getSelectionModel().getSelectedItem()).getValue()).getType().equals((Object)ProjectTreeRow.Type.IMAGE), (Observable[])new Observable[]{this.tree.getSelectionModel().selectedItemProperty()}));
        editDescriptionButton.managedProperty().bind((ObservableValue)editDescriptionButton.visibleProperty());
        ToggleButton keepDescriptionOpenButton = new ToggleButton(null, IconFactory.createNode(FontAwesome.Glyph.THUMB_TACK, 13));
        keepDescriptionOpenButton.selectedProperty().set(keepDescriptionPaneOpenPref.get());
        keepDescriptionOpenButton.selectedProperty().addListener((p, o, n) -> keepDescriptionPaneOpenPref.set(n.booleanValue()));
        keepDescriptionOpenButton.setTooltip(new Tooltip("Keep description pane open"));
        keepDescriptionOpenButton.setPadding(new Insets(1.0, 9.0, 1.0, 9.0));
        TitledPane textDescriptionContainer = GuiTools.createLeftRightTitledPane("Description", new Node[]{new HBox(5.0, new Node[]{editDescriptionButton, keepDescriptionOpenButton})});
        TextArea textDescription = new TextArea();
        textDescription.textProperty().bind((ObservableValue)this.descriptionText);
        textDescription.setWrapText(true);
        textDescription.setEditable(false);
        textDescriptionContainer.setContent((Node)textDescription);
        MasterDetailPane mdTree = new MasterDetailPane(Side.BOTTOM, this.tree, (Node)textDescriptionContainer, false);
        mdTree.showDetailNodeProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> keepDescriptionOpenButton.selectedProperty().get() || this.descriptionText.get() != null, (Observable[])new Observable[]{keepDescriptionOpenButton.selectedProperty(), this.descriptionText}));
        this.tree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tree.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (n != null && ((ProjectTreeRow)n.getValue()).getType() == ProjectTreeRow.Type.IMAGE) {
                this.descriptionText.set((Object)ProjectTreeRow.getEntry((ProjectTreeRow)n.getValue()).getDescription());
            } else {
                this.descriptionText.set(null);
            }
        });
        TitledPane titledTree = new TitledPane("Image list", (Node)mdTree);
        titledTree.setCollapsible(false);
        titledTree.setMaxHeight(Double.MAX_VALUE);
        PredicateTextField tfFilter = new PredicateTextField();
        tfFilter.setPromptText("Search entry in project");
        tfFilter.setSpacing(0.0);
        Tooltip tooltip = new Tooltip("Type some text to filter the project entries by name or type.");
        Tooltip.install((Node)tfFilter, (Tooltip)tooltip);
        this.predicateProperty.bind((ObservableValue)tfFilter.predicateProperty());
        this.predicateProperty.addListener((m, o, n) -> this.refreshTree(null));
        GridPane paneUserFilter = GridPaneUtils.createRowGrid((Node[])new Node[]{tfFilter});
        BorderPane panelTree = new BorderPane();
        panelTree.setCenter((Node)titledTree);
        this.panel.setBottom((Node)paneUserFilter);
        this.panel.setCenter((Node)panelTree);
        Button btnOpen = ActionTools.createButton(qupath.getCommonActions().PROJECT_OPEN);
        Button btnCreate = ActionTools.createButton(qupath.getCommonActions().PROJECT_NEW);
        Button btnAdd = ActionTools.createButton(qupath.getCommonActions().PROJECT_ADD_IMAGES);
        GridPane paneButtons = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnCreate, btnOpen, btnAdd});
        paneButtons.prefWidthProperty().bind((ObservableValue)this.panel.widthProperty());
        paneButtons.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.panel.setTop((Node)paneButtons);
        qupath.getPreferencePane().getPropertySheet().getItems().add((Object)new PropertyItemBuilder(thumbnailSize, ProjectThumbnailSize.class).propertyType(PropertyItemBuilder.PropertyType.CHOICE).name("Project thumbnail size").category("Appearance").choices(Arrays.asList(ProjectThumbnailSize.values())).description("Choose thumbnail size for the project pane").build());
    }

    ContextMenu getPopup() {
        Action actionOpenImage = new Action("Open image", e -> this.qupath.openImageEntry(this.getSelectedEntry()));
        Action actionRemoveImage = new Action("Remove image(s)", e -> this.promptToRemoveSelectedImages());
        Action actionDuplicateImages = new Action("Duplicate image(s)", e -> this.promptToDuplicateSelectedImages());
        Action actionSetImageName = new Action("Rename image", e -> this.promptToRenameSelectedImage());
        Action actionAddMetadataValue = new Action("Add metadata", e -> this.promptToAddMetadataToSelectedImages());
        Action actionEditDescription = new Action("Edit description", e -> this.promptToEditSelectedImageDescription());
        Action actionMaskImageNames = ActionTools.createSelectableAction((ObservableValue<Boolean>)PathPrefs.maskImageNamesProperty(), "Mask image names");
        Action actionRefreshThumbnail = new Action("Refresh thumbnail", e -> this.promptToRefreshSelectedThumbnails());
        Action actionOpenProjectDirectory = this.createBrowsePathAction("Project...", () -> this.getProjectPath());
        Action actionOpenProjectEntryDirectory = this.createBrowsePathAction("Project entry...", () -> this.getProjectEntryPath());
        Action actionOpenImageServerDirectory = this.createBrowsePathAction("Image...", () -> this.getImageServerPath());
        ContextMenu menu = new ContextMenu();
        BooleanBinding hasProjectBinding = this.qupath.projectProperty().isNotNull();
        Menu menuOpenDirectories = MenuTools.createMenu("Open directory...", actionOpenProjectDirectory, actionOpenProjectEntryDirectory, actionOpenImageServerDirectory);
        SeparatorMenuItem separatorOpenDirectories = new SeparatorMenuItem();
        separatorOpenDirectories.visibleProperty().bind((ObservableValue)menuOpenDirectories.visibleProperty());
        MenuItem miOpenImage = ActionUtils.createMenuItem((Action)actionOpenImage);
        MenuItem miRemoveImage = ActionUtils.createMenuItem((Action)actionRemoveImage);
        MenuItem miDuplicateImage = ActionUtils.createMenuItem((Action)actionDuplicateImages);
        MenuItem miSetImageName = ActionUtils.createMenuItem((Action)actionSetImageName);
        MenuItem miRefreshThumbnail = ActionUtils.createMenuItem((Action)actionRefreshThumbnail);
        MenuItem miEditDescription = ActionUtils.createMenuItem((Action)actionEditDescription);
        MenuItem miAddMetadata = ActionUtils.createMenuItem((Action)actionAddMetadataValue);
        CheckMenuItem miMaskImages = ActionUtils.createCheckMenuItem((Action)actionMaskImageNames);
        Menu menuSort = new Menu("Sort by...");
        menu.setOnShowing(e -> {
            TreeItem selected = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
            ProjectImageEntry<BufferedImage> selectedEntry = selected == null ? null : ProjectTreeRow.getEntry((ProjectTreeRow)selected.getValue());
            Collection<ProjectTreeRow.ImageRow> entries = this.getSelectedImageRowsRecursive();
            boolean isImageEntry = selectedEntry != null;
            this.populateSortByMenu(menuSort);
            int nSelectedEntries = ProjectTreeRow.getEntries(entries).size();
            if (nSelectedEntries == 1) {
                actionDuplicateImages.setText("Duplicate image");
                actionRemoveImage.setText("Remove image");
            } else {
                actionDuplicateImages.setText("Duplicate " + nSelectedEntries + " images");
                actionRemoveImage.setText("Remove " + nSelectedEntries + " images");
            }
            miOpenImage.setVisible(isImageEntry);
            miDuplicateImage.setVisible(isImageEntry);
            miSetImageName.setVisible(isImageEntry);
            miAddMetadata.setVisible(!entries.isEmpty());
            miEditDescription.setVisible(isImageEntry);
            miRefreshThumbnail.setVisible(isImageEntry && this.isCurrentImage(selectedEntry));
            miRemoveImage.setVisible(selected != null && this.project != null && !this.project.getImageList().isEmpty());
            if (this.project == null) {
                menuSort.setVisible(false);
                return;
            }
            menuSort.setVisible(true);
            menuOpenDirectories.setVisible(Desktop.isDesktopSupported() && hasProjectBinding.get());
            if (menu.getItems().isEmpty()) {
                e.consume();
            }
        });
        SeparatorMenuItem separator = new SeparatorMenuItem();
        separator.visibleProperty().bind((ObservableValue)menuSort.visibleProperty());
        menu.getItems().addAll((Object[])new MenuItem[]{miOpenImage, miRemoveImage, miDuplicateImage, new SeparatorMenuItem(), miSetImageName, miAddMetadata, miEditDescription, miMaskImages, this.createThumbnailSizeMenu(), miRefreshThumbnail, separator, menuSort, separatorOpenDirectories, menuOpenDirectories});
        this.contextMenuShowing.bind((ObservableValue)menu.showingProperty());
        return menu;
    }

    private Menu createThumbnailSizeMenu() {
        Menu menu = new Menu("Thumbnail size");
        ToggleGroup group = new ToggleGroup();
        for (ProjectThumbnailSize size : ProjectThumbnailSize.values()) {
            RadioMenuItem item = new RadioMenuItem(size.toString());
            item.setOnAction(e -> thumbnailSize.set((Object)size));
            item.setUserData((Object)size);
            menu.getItems().add((Object)item);
            group.getToggles().add((Object)item);
        }
        thumbnailSize.addListener((v, o, n) -> this.syncToggleGroupByUserData(group, n));
        this.syncToggleGroupByUserData(group, thumbnailSize.get());
        return menu;
    }

    private void syncToggleGroupByUserData(ToggleGroup group, Object userData) {
        for (Toggle toggle : group.getToggles()) {
            if (!Objects.equals(toggle.getUserData(), userData)) continue;
            group.selectToggle(toggle);
            return;
        }
    }

    private void promptToEditSelectedImageDescription() {
        Project<BufferedImage> project = this.getProject();
        ProjectImageEntry<BufferedImage> entry = this.getSelectedEntry();
        if (project != null && entry != null) {
            if (ProjectBrowser.showDescriptionEditor(entry)) {
                this.descriptionText.set((Object)entry.getDescription());
                ProjectBrowser.syncProject(project);
            }
        } else {
            Dialogs.showErrorMessage((String)"Edit image description", (String)"No entry is selected!");
        }
    }

    private void promptToRemoveSelectedImages() {
        Collection<ProjectTreeRow.ImageRow> imageRows = this.getSelectedImageRowsRecursive();
        Collection<ProjectImageEntry<BufferedImage>> entries = ProjectTreeRow.getEntries(imageRows);
        if (entries.isEmpty()) {
            return;
        }
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            ImageData<BufferedImage> imageData = viewer.getImageData();
            ProjectImageEntry entry = imageData == null ? null : this.getProject().getEntry(imageData);
            if (entry == null || !entries.contains(entry)) continue;
            Dialogs.showErrorMessage((String)"Remove project entries", (String)"Please close all images you want to remove!");
            return;
        }
        if (entries.size() == 1 ? !Dialogs.showConfirmDialog((String)"Remove project entry", (String)("Remove " + entries.iterator().next().getImageName() + " from project?")) : !Dialogs.showYesNoDialog((String)"Remove project entries", (String)String.format("Remove %d entries?", entries.size()))) {
            return;
        }
        ButtonType result = Dialogs.showYesNoCancelDialog((String)"Remove project entries", (String)"Delete all associated data?");
        if (result == ButtonType.CANCEL) {
            return;
        }
        this.project.removeAllImages(entries, result == ButtonType.YES);
        this.refreshTree(null);
        ProjectBrowser.syncProject(this.project);
        if (this.tree != null) {
            boolean isExpanded = this.tree.getRoot() != null && this.tree.getRoot().isExpanded();
            this.tree.setRoot((TreeItem)this.model.getRoot());
            this.tree.getRoot().setExpanded(isExpanded);
        }
    }

    private void promptToRefreshSelectedThumbnails() {
        TreeItem path = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (path == null) {
            return;
        }
        if (((ProjectTreeRow)path.getValue()).getType() == ProjectTreeRow.Type.IMAGE) {
            ProjectImageEntry<BufferedImage> entry = ProjectTreeRow.getEntry((ProjectTreeRow)path.getValue());
            if (!this.isCurrentImage(entry)) {
                logger.warn("Cannot refresh entry for image that is not open!");
                return;
            }
            BufferedImage imgThumbnail = this.qupath.getViewer().getRGBThumbnail();
            imgThumbnail = this.resizeForThumbnail(imgThumbnail);
            try {
                entry.setThumbnail((Object)imgThumbnail);
            }
            catch (IOException e1) {
                logger.error("Error writing thumbnail", (Throwable)e1);
            }
            this.tree.refresh();
        }
    }

    private void promptToDuplicateSelectedImages() {
        ParameterList params;
        Collection<ProjectTreeRow.ImageRow> imageRows = this.getSelectedImageRowsRecursive();
        if (imageRows.isEmpty()) {
            logger.debug("Nothing to duplicate - no entries selected");
            return;
        }
        boolean singleImage = false;
        Object name = "";
        String title = "Duplicate images";
        String namePrompt = "Append to image name";
        String nameHelp = "Specify text to append to the image name to distinguish duplicated images";
        if (imageRows.size() == 1) {
            title = "Duplicate image";
            namePrompt = "Duplicate image name";
            nameHelp = "Specify name for the duplicated image";
            singleImage = true;
            name = imageRows.iterator().next().getDisplayableString();
            name = GeneralTools.generateDistinctName((String)name, (Collection)this.project.getImageList().stream().map(p -> p.getImageName()).collect(Collectors.toSet()));
        }
        if (!GuiTools.showParameterDialog(title, params = new ParameterList().addStringParameter("name", namePrompt, (String)name, nameHelp).addBooleanParameter("copyData", "Also duplicate data files", true, "Duplicate any associated data files along with the image"))) {
            return;
        }
        boolean copyData = params.getBooleanParameterValue("copyData");
        name = params.getStringParameterValue("name");
        if (!singleImage && !((String)name).isBlank()) {
            name = " " + ((String)name).strip();
        }
        for (ProjectTreeRow.ImageRow imageRow : imageRows) {
            try {
                ProjectImageEntry newEntry = this.project.addDuplicate(ProjectTreeRow.getEntry(imageRow), copyData);
                if (newEntry == null || ((String)name).isBlank()) continue;
                if (singleImage) {
                    newEntry.setImageName((String)name);
                    continue;
                }
                newEntry.setImageName(newEntry.getImageName() + (String)name);
            }
            catch (Exception ex) {
                Dialogs.showErrorNotification((String)"Duplicating image", (String)("Error duplicating " + ProjectTreeRow.getEntry(imageRow).getImageName()));
                logger.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        try {
            this.project.syncChanges();
        }
        catch (Exception ex) {
            logger.error("Error synchronizing project changes: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
        this.refreshProject();
        if (imageRows.size() == 1) {
            logger.debug("Duplicated 1 image entry");
        } else {
            logger.debug("Duplicated {} image entries", (Object)imageRows.size());
        }
    }

    private void promptToRenameSelectedImage() {
        TreeItem path = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (path == null) {
            return;
        }
        if (((ProjectTreeRow)path.getValue()).getType() == ProjectTreeRow.Type.IMAGE && this.setProjectEntryImageName(ProjectTreeRow.getEntry((ProjectTreeRow)path.getValue())) && this.project != null) {
            ProjectBrowser.syncProject(this.project);
        }
    }

    private void promptToAddMetadataToSelectedImages() {
        Project<BufferedImage> project = this.getProject();
        Collection<ProjectTreeRow.ImageRow> imageRows = this.getSelectedImageRowsRecursive();
        if (project != null && !imageRows.isEmpty()) {
            TextField tfMetadataKey = new TextField();
            List suggestions = project.getImageList().stream().map(p -> p.getMetadataKeys()).flatMap(Collection::stream).distinct().sorted().toList();
            TextFields.bindAutoCompletion((TextField)tfMetadataKey, suggestions);
            TextField tfMetadataValue = new TextField();
            Label labKey = new Label("New key");
            Label labValue = new Label("New value");
            labKey.setLabelFor((Node)tfMetadataKey);
            labValue.setLabelFor((Node)tfMetadataValue);
            tfMetadataKey.setTooltip(new Tooltip("Enter the name for the metadata entry"));
            tfMetadataValue.setTooltip(new Tooltip("Enter the value for the metadata entry"));
            ProjectImageEntry<BufferedImage> entry = imageRows.size() == 1 ? ProjectTreeRow.getEntry(imageRows.iterator().next()) : null;
            int nMetadataValues = entry == null ? 0 : entry.getMetadataKeys().size();
            GridPane pane = new GridPane();
            pane.setVgap(5.0);
            pane.setHgap(5.0);
            pane.add((Node)labKey, 0, 0);
            pane.add((Node)tfMetadataKey, 1, 0);
            pane.add((Node)labValue, 0, 1);
            pane.add((Node)tfMetadataValue, 1, 1);
            Object name = imageRows.size() + " images";
            if (entry != null) {
                name = entry.getImageName();
                if (nMetadataValues > 0) {
                    Label labelCurrent = new Label("Current metadata");
                    TextArea textAreaCurrent = new TextArea();
                    textAreaCurrent.setEditable(false);
                    String keyString = entry.getMetadataSummaryString();
                    if (keyString.isEmpty()) {
                        textAreaCurrent.setText("No metadata entries yet");
                    } else {
                        textAreaCurrent.setText(keyString);
                    }
                    textAreaCurrent.setPrefRowCount(3);
                    labelCurrent.setLabelFor((Node)textAreaCurrent);
                    pane.add((Node)labelCurrent, 0, 2);
                    pane.add((Node)textAreaCurrent, 1, 2);
                }
            }
            Dialog dialog = new Dialog();
            dialog.setTitle("Metadata");
            dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            dialog.getDialogPane().setHeaderText("Set metadata for " + (String)name);
            dialog.getDialogPane().setContent((Node)pane);
            Optional result = dialog.showAndWait();
            if (result.isPresent() && result.get() == ButtonType.OK) {
                String key = tfMetadataKey.getText().trim();
                String value = tfMetadataValue.getText();
                if (key.isEmpty()) {
                    logger.warn("Attempted to set metadata value for {}, but key was empty!", name);
                } else {
                    for (ProjectTreeRow.ImageRow temp : imageRows) {
                        ProjectTreeRow.getEntry(temp).putMetadataValue(key, value);
                    }
                    ProjectBrowser.syncProject(project);
                    this.tree.refresh();
                }
            }
            ProjectTreeRow.ImageRow selectedImageRow = this.getSelectedImageRow();
            this.refreshTree(selectedImageRow);
        } else {
            Dialogs.showErrorMessage((String)"Edit image description", (String)"No entry is selected!");
        }
    }

    private Menu populateSortByMenu(Menu menuSort) {
        TreeMap<Object, MenuItem> newItems = new TreeMap<Object, MenuItem>();
        if (this.project != null) {
            for (ProjectImageEntry entry : this.project.getImageList()) {
                for (Object key : entry.getMetadataKeys()) {
                    if (newItems.containsKey(key)) continue;
                    newItems.put(key, ActionUtils.createMenuItem((Action)this.createSortByKeyAction((String)key, (String)key)));
                }
            }
        }
        menuSort.getItems().setAll(newItems.values());
        for (Object key : BaseMetadataKeys.values()) {
            if (newItems.containsKey(key.getKey())) continue;
            menuSort.getItems().add((Object)ActionUtils.createMenuItem((Action)this.createSortByKeyAction(key.getDisplayName(), key.getKey())));
        }
        menuSort.getItems().add(0, (Object)ActionUtils.createMenuItem((Action)this.createSortByKeyAction("None", null)));
        menuSort.getItems().add(1, (Object)new SeparatorMenuItem());
        return menuSort;
    }

    Path getProjectPath() {
        return this.project == null ? null : this.project.getPath();
    }

    Path getProjectEntryPath() {
        TreeItem selected = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return null;
        }
        ProjectTreeRow item = (ProjectTreeRow)selected.getValue();
        if (item.getType() == ProjectTreeRow.Type.IMAGE) {
            return ProjectTreeRow.getEntry(item).getEntryPath();
        }
        return null;
    }

    Path getImageServerPath() {
        TreeItem selected = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return null;
        }
        ProjectTreeRow item = (ProjectTreeRow)selected.getValue();
        if (item.getType() == ProjectTreeRow.Type.IMAGE) {
            try {
                Collection uris = ProjectTreeRow.getEntry(item).getURIs();
                if (!uris.isEmpty()) {
                    return GeneralTools.toPath((URI)((URI)uris.iterator().next()));
                }
            }
            catch (IOException e) {
                logger.debug("Error converting server path to file path", (Throwable)e);
            }
        }
        return null;
    }

    Action createBrowsePathAction(String text, Supplier<Path> func) {
        Action action = new Action(text, e -> {
            Path path = (Path)func.get();
            if (path == null) {
                return;
            }
            GuiTools.browseDirectory(path.toFile());
        });
        action.disabledProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> func.get() == null, (Observable[])new Observable[]{this.tree.getSelectionModel().selectedItemProperty()}));
        return action;
    }

    public static boolean syncProject(Project<?> project) {
        try {
            logger.info("Saving project {}...", project);
            project.syncChanges();
            return true;
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Save project", (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static boolean showDescriptionEditor(ProjectImageEntry<?> entry) {
        TextArea editor = new TextArea();
        editor.setWrapText(true);
        editor.setPromptText(String.format("Enter description for %s", entry.getImageName()));
        editor.setText(entry.getDescription());
        Dialog dialog = new Dialog();
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.setTitle("Image description");
        dialog.getDialogPane().setHeaderText(entry.getImageName());
        dialog.getDialogPane().setContent((Node)editor);
        Platform.runLater(() -> ((TextArea)editor).requestFocus());
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK && editor.getText() != null) {
            String text = editor.getText();
            entry.setDescription(text.isEmpty() ? null : text);
            return true;
        }
        return false;
    }

    private Project<BufferedImage> getProject() {
        return this.project;
    }

    public Pane getPane() {
        return this.panel;
    }

    public boolean setProject(Project<BufferedImage> project) {
        if (this.project == project) {
            return true;
        }
        this.project = project;
        ProjectTreeRowCell.resetUriStatus();
        this.model = new ProjectImageTreeModel(project);
        this.tree.setRoot((TreeItem)this.model.getRoot());
        this.tree.getRoot().setExpanded(true);
        Platform.runLater(() -> this.tree.getParent().layout());
        return true;
    }

    public void refreshProject() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.refreshProject());
            return;
        }
        this.refreshTree(null);
    }

    private void ensureServerInWorkspace(ImageData<BufferedImage> imageData) {
        if (imageData == null || this.project == null) {
            return;
        }
        if (this.project.getEntry(imageData) != null) {
            return;
        }
        ProjectImageEntry<BufferedImage> entry = ProjectCommands.addSingleImageToProject(this.project, (ImageServer<BufferedImage>)imageData.getServer(), null);
        if (entry != null) {
            boolean expanded = this.tree.getRoot() != null && this.tree.getRoot().isExpanded();
            this.tree.setRoot((TreeItem)this.model.getRoot());
            ProjectBrowser.setSelectedEntry(this.tree, this.tree.getRoot(), new ProjectTreeRow.ImageRow((ProjectImageEntry<BufferedImage>)this.project.getEntry(imageData)));
            ProjectBrowser.syncProject(this.project);
            if (expanded) {
                this.tree.getRoot().setExpanded(true);
            }
            if (!entry.hasImageData()) {
                try {
                    logger.info("Copying ImageData to {}", entry);
                    entry.saveImageData(imageData);
                }
                catch (IOException e) {
                    logger.error("Unable to save ImageData: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.qupath.refreshProject();
        }
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        if (imageDataNew == null || this.project == null) {
            return;
        }
        ProjectImageEntry entry = this.project.getEntry(imageDataNew);
        if (entry == null) {
            this.ensureServerInWorkspace(imageDataNew);
        } else if (!entry.equals(this.getSelectedEntry())) {
            ProjectBrowser.setSelectedEntry(this.tree, this.tree.getRoot(), this.getSelectedImageRow());
        }
        if (this.tree != null) {
            this.tree.refresh();
        }
    }

    private static <T> boolean setSelectedEntry(TreeView<T> treeView, TreeItem<T> item, T object) {
        if (item.getValue() == object) {
            treeView.getSelectionModel().select(item);
            return true;
        }
        for (TreeItem child : item.getChildren()) {
            if (!ProjectBrowser.setSelectedEntry(treeView, child, object)) continue;
            return true;
        }
        return false;
    }

    private BufferedImage resizeForThumbnail(BufferedImage imgThumbnail) {
        double scale = Math.min((double)this.thumbnailWidth / (double)imgThumbnail.getWidth(), (double)this.thumbnailHeight / (double)imgThumbnail.getHeight());
        if (scale > 1.0) {
            return imgThumbnail;
        }
        BufferedImage imgThumbnail2 = new BufferedImage((int)((double)imgThumbnail.getWidth() * scale), (int)((double)imgThumbnail.getHeight() * scale), imgThumbnail.getType());
        Graphics2D g2d = imgThumbnail2.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(imgThumbnail, 0, 0, imgThumbnail2.getWidth(), imgThumbnail2.getHeight(), null);
        g2d.dispose();
        return imgThumbnail2;
    }

    private ImageData<BufferedImage> getCurrentImageData() {
        return this.qupath.getViewer().getImageData();
    }

    private boolean isCurrentImage(ProjectImageEntry<BufferedImage> entry) {
        ImageData<BufferedImage> imageData = this.getCurrentImageData();
        if (imageData == null || entry == null || this.project == null) {
            return false;
        }
        return this.project.getEntry(imageData) == entry;
    }

    private Collection<ProjectTreeRow.ImageRow> getSelectedImageRowsRecursive() {
        ObservableList selected = this.tree.getSelectionModel().getSelectedItems();
        if (selected == null) {
            return Collections.emptyList();
        }
        return selected.stream().map(p -> {
            if (((ProjectTreeRow)p.getValue()).getType() == ProjectTreeRow.Type.IMAGE) {
                return Collections.singletonList((ProjectTreeRow.ImageRow)p.getValue());
            }
            return ProjectBrowser.getImageRowsRecursive((TreeItem<ProjectTreeRow>)p, null);
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private ProjectImageEntry<BufferedImage> getSelectedEntry() {
        TreeItem selected = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (selected != null && ((ProjectTreeRow)selected.getValue()).getType() == ProjectTreeRow.Type.IMAGE) {
            return ((ProjectTreeRow.ImageRow)selected.getValue()).getEntry();
        }
        return null;
    }

    private ProjectTreeRow.ImageRow getSelectedImageRow() {
        TreeItem selected = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (selected != null && ((ProjectTreeRow)selected.getValue()).getType() == ProjectTreeRow.Type.IMAGE) {
            return (ProjectTreeRow.ImageRow)selected.getValue();
        }
        return null;
    }

    private static Collection<ProjectTreeRow.ImageRow> getImageRowsRecursive(TreeItem<ProjectTreeRow> item, Collection<ProjectTreeRow.ImageRow> entries) {
        if (entries == null) {
            entries = new HashSet<ProjectTreeRow.ImageRow>();
        }
        if (((ProjectTreeRow)item.getValue()).getType() == ProjectTreeRow.Type.IMAGE) {
            entries.add((ProjectTreeRow.ImageRow)item.getValue());
        }
        for (TreeItem child : item.getChildren()) {
            entries = ProjectBrowser.getImageRowsRecursive((TreeItem<ProjectTreeRow>)child, entries);
        }
        return entries;
    }

    private Set<String> getAllMetadataValues(String metadataKey) {
        return this.project.getImageList().stream().map(entry -> {
            try {
                return ProjectBrowser.getDefaultValue(entry, metadataKey);
            }
            catch (IOException ex) {
                logger.warn("Could not get the URI(s) of " + entry.getImageName(), (Object)ex.getLocalizedMessage());
                return UNDEFINED_VALUE;
            }
        }).collect(Collectors.toSet());
    }

    private static <T> String getDefaultValue(ProjectImageEntry<T> entry, String key) throws IOException {
        if (key.equals(BaseMetadataKeys.URI.getKey())) {
            Collection URIs = entry.getURIs();
            Iterator it = URIs.iterator();
            if (URIs.size() == 0) {
                return UNDEFINED_VALUE;
            }
            if (URIs.size() == 1) {
                URI uri = (URI)it.next();
                String fullURI = uri.getPath();
                if (uri.getAuthority() != null) {
                    return "[remote] " + uri.getAuthority() + fullURI;
                }
                return fullURI.substring(fullURI.lastIndexOf("/") + 1, fullURI.length());
            }
            return "Multiple URIs";
        }
        if (key.equals(BaseMetadataKeys.IMAGE_NAME.getKey())) {
            return entry.getImageName();
        }
        if (key.equals(BaseMetadataKeys.ENTRY_ID.getKey())) {
            return entry.getID();
        }
        String value = entry.getMetadataValue(key);
        return value == null ? UNASSIGNED_NODE : value;
    }

    private void refreshTree(ProjectTreeRow.ImageRow imageToSelect) {
        Platform.runLater(() -> {
            this.tree.setRoot(null);
            this.tree.setRoot((TreeItem)new ProjectTreeRowItem(new ProjectTreeRow.RootRow(this.project)));
            this.tree.getRoot().setExpanded(true);
            try {
                ObservableList listOfChildren = this.tree.getRoot().getChildren();
                for (int i = 0; i < listOfChildren.size(); ++i) {
                    if (imageToSelect == null) {
                        if (((TreeItem)listOfChildren.get(i)).getChildren().size() <= 0) continue;
                        ((TreeItem)listOfChildren.get(i)).setExpanded(true);
                        this.tree.refresh();
                        break;
                    }
                    block3: for (TreeItem child : listOfChildren) {
                        if (((ProjectTreeRow)child.getValue()).getType() == ProjectTreeRow.Type.METADATA) {
                            for (TreeItem imageChild : child.getChildren()) {
                                if (!((ProjectTreeRow)imageChild.getValue()).equals(imageToSelect)) continue;
                                child.setExpanded(true);
                                this.tree.getSelectionModel().select((Object)imageChild);
                                continue block3;
                            }
                            continue;
                        }
                        if (!((ProjectTreeRow)child.getValue()).equals(imageToSelect)) continue;
                        this.tree.getSelectionModel().select((Object)child);
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Error getting children objects in the ProjectBrowser", (Throwable)ex);
            }
        });
    }

    private Action createSortByKeyAction(String name, String key) {
        return new Action(name, e -> {
            if (this.model == null) {
                return;
            }
            this.model.setMetadataKey(key);
            ProjectTreeRow.ImageRow selectedImageRow = this.getSelectedImageRow();
            this.refreshTree(selectedImageRow);
        });
    }

    private boolean setProjectEntryImageName(ProjectImageEntry<BufferedImage> entry) {
        Project<BufferedImage> project = this.qupath.getProject();
        if (project == null) {
            logger.error("Cannot set image name - project is null");
            return false;
        }
        if (entry == null) {
            logger.error("Cannot set image name - entry is null");
            return false;
        }
        String name = Dialogs.showInputDialog((String)"Set Image Name", (String)"Enter the new image name", (String)entry.getImageName());
        if (name == null) {
            return false;
        }
        if (name.trim().isEmpty() || name.equals(entry.getImageName())) {
            logger.warn("Cannot set image name to {} - will ignore", (Object)name);
            return false;
        }
        boolean changed = ProjectBrowser.setProjectEntryImageName(entry, name);
        if (changed) {
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                ImageServer server;
                ProjectImageEntry currentEntry;
                ImageData<BufferedImage> imageData = viewer.getImageData();
                if (imageData == null || !Objects.equals(entry, currentEntry = project.getEntry(imageData)) || name.equals((server = imageData.getServer()).getMetadata().getName())) continue;
                ImageServerMetadata metadata2 = new ImageServerMetadata.Builder(server.getMetadata()).name(name).build();
                imageData.updateServerMetadata(metadata2);
                imageData.getHierarchy().fireHierarchyChangedEvent((Object)this);
            }
            this.tree.refresh();
            this.qupath.refreshTitle();
        }
        return changed;
    }

    private static synchronized <T> boolean setProjectEntryImageName(ProjectImageEntry<T> entry, String name) {
        if (entry.getImageName().equals(name)) {
            logger.warn("Project image name already set to {} - will be left unchanged", (Object)name);
            return false;
        }
        if (name == null) {
            logger.warn("Project entry name cannot be null!");
            return false;
        }
        entry.setImageName(name);
        return true;
    }

    private List<ProjectTreeRow.ImageRow> getAllImageRows() {
        if (!PathPrefs.maskImageNamesProperty().get()) {
            return this.project.getImageList().stream().map(entry -> new ProjectTreeRow.ImageRow((ProjectImageEntry<BufferedImage>)entry)).toList();
        }
        List imageList = this.project.getImageList();
        ArrayList indices = IntStream.range(0, imageList.size()).boxed().collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(indices);
        return indices.stream().map(index -> new ProjectTreeRow.ImageRow((ProjectImageEntry<BufferedImage>)((ProjectImageEntry)imageList.get((int)index)))).toList();
    }

    private class ProjectImageTreeModel {
        private static final String SORT_KEY = "_SORT_KEY";
        private final ProjectTreeRowItem root;
        private String metadataKey;

        private ProjectImageTreeModel(Project<?> project) {
            this.root = new ProjectTreeRowItem(new ProjectTreeRow.RootRow(project));
            if (project != null) {
                this.metadataKey = (String)project.getMetadata().get(SORT_KEY);
            }
        }

        private String getMetadataKey() {
            return this.metadataKey;
        }

        private void setMetadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
            if (metadataKey == null) {
                ProjectBrowser.this.project.getMetadata().remove(SORT_KEY);
            } else {
                ProjectBrowser.this.project.getMetadata().put(SORT_KEY, metadataKey);
            }
        }

        private ProjectTreeRowItem getRoot() {
            return this.root;
        }
    }

    static enum ProjectThumbnailSize {
        HIDDEN,
        SMALL,
        MEDIUM,
        LARGE;

        private static int hiddenSize;
        private double defaultHeight = 40.0;
        private double defaultWidth = 50.0;

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Hidden";
                }
                case 3: {
                    return "Large";
                }
                case 2: {
                    return "Medium";
                }
                case 1: {
                    return "Small";
                }
            }
            return super.toString();
        }

        public double getWidth() {
            switch (this.ordinal()) {
                case 3: {
                    return this.defaultWidth * 3.0;
                }
                case 2: {
                    return this.defaultWidth * 2.0;
                }
                case 0: {
                    return hiddenSize;
                }
            }
            return this.defaultWidth;
        }

        public double getHeight() {
            switch (this.ordinal()) {
                case 3: {
                    return this.defaultHeight * 3.0;
                }
                case 2: {
                    return this.defaultHeight * 2.0;
                }
                case 0: {
                    return hiddenSize;
                }
            }
            return this.defaultHeight;
        }

        static {
            hiddenSize = 20;
        }
    }

    private class ProjectTreeRowItem
    extends TreeItem<ProjectTreeRow> {
        private boolean computed;

        private ProjectTreeRowItem(ProjectTreeRow obj) {
            super((Object)obj);
            this.computed = false;
        }

        public boolean isLeaf() {
            if (this.computed) {
                return super.getChildren().isEmpty();
            }
            return switch (((ProjectTreeRow)this.getValue()).getType()) {
                case ProjectTreeRow.Type.ROOT -> {
                    if (ProjectBrowser.this.project != null && !ProjectBrowser.this.project.getImageList().isEmpty() && ProjectBrowser.this.project.getImageList().stream().noneMatch(entry -> ((Predicate)ProjectBrowser.this.predicateProperty.get()).test(entry.getImageName()))) {
                        yield true;
                    }
                    yield false;
                }
                case ProjectTreeRow.Type.METADATA -> false;
                case ProjectTreeRow.Type.IMAGE -> true;
                default -> throw new IllegalArgumentException("Could not understand the type of the object: " + String.valueOf((Object)((ProjectTreeRow)this.getValue()).getType()));
            };
        }

        public ObservableList<TreeItem<ProjectTreeRow>> getChildren() {
            if (!this.isLeaf() && !this.computed) {
                ObservableList children = FXCollections.observableArrayList();
                Predicate filter = (Predicate)ProjectBrowser.this.predicateProperty.get();
                String metadataKey = ProjectBrowser.this.model.getMetadataKey();
                switch (((ProjectTreeRow)this.getValue()).getType()) {
                    case ROOT: {
                        if (ProjectBrowser.this.project == null) break;
                        if (metadataKey == null) {
                            for (ProjectTreeRow.ImageRow row : ProjectBrowser.this.getAllImageRows()) {
                                if (!filter.test(row.getDisplayableString())) continue;
                                children.add((Object)new ProjectTreeRowItem(row));
                            }
                            break;
                        }
                        ArrayList<String> values = new ArrayList<String>(ProjectBrowser.this.getAllMetadataValues(metadataKey));
                        GeneralTools.smartStringSort(values);
                        List<ProjectTreeRowItem> potentialChildren = values.stream().map(value -> new ProjectTreeRowItem(new ProjectTreeRow.MetadataRow((String)value))).toList();
                        if (metadataKey.equals(BaseMetadataKeys.IMAGE_NAME.getKey())) {
                            potentialChildren = potentialChildren.stream().flatMap(c -> {
                                if (c.isLeaf()) {
                                    return Stream.empty();
                                }
                                return c.getChildren().stream();
                            }).map(t -> (ProjectTreeRowItem)((Object)t)).toList();
                        }
                        if (metadataKey.equals(BaseMetadataKeys.ENTRY_ID.getKey())) {
                            potentialChildren.forEach(c -> c.setExpanded(true));
                        }
                        children.addAll(potentialChildren);
                        break;
                    }
                    case METADATA: {
                        if (metadataKey == null || metadataKey.isEmpty()) break;
                        for (ProjectTreeRow.ImageRow row : ProjectBrowser.this.getAllImageRows()) {
                            if (!filter.test(row.getDisplayableString())) continue;
                            try {
                                String value2 = ProjectBrowser.getDefaultValue(ProjectTreeRow.getEntry(row), metadataKey);
                                if (value2 == null || !value2.equals(((ProjectTreeRow.MetadataRow)this.getValue()).getDisplayableString())) continue;
                                children.add((Object)new ProjectTreeRowItem(row));
                            }
                            catch (IOException ex) {
                                logger.warn("Could not get {} from {}", new Object[]{metadataKey, row.getDisplayableString(), ex});
                            }
                        }
                    }
                    case IMAGE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not understand the type of the object: " + String.valueOf((Object)((ProjectTreeRow)this.getValue()).getType()));
                    }
                }
                this.computed = true;
                super.getChildren().setAll((Collection)children);
            }
            return super.getChildren();
        }
    }

    private static enum BaseMetadataKeys {
        IMAGE_NAME("Image name"),
        ENTRY_ID("Entry ID"),
        URI("URI");

        private final String displayName;

        private BaseMetadataKeys(String displayName) {
            this.displayName = displayName;
        }

        String getDisplayName() {
            return this.displayName;
        }

        String getKey() {
            return "SORT_KEY[" + this.toString() + "]";
        }
    }

    private class ProjectTreeRowCell
    extends TreeCell<ProjectTreeRow> {
        private Tooltip tooltip = new Tooltip();
        private Node missingGraphic;
        private StackPane viewPane = new StackPane();
        private Canvas viewCanvas = new Canvas();
        private ImageView viewTooltip = new ImageView();
        private ProjectTreeRow objectCell = null;
        private BooleanProperty showTooltip = new SimpleBooleanProperty();
        private BooleanProperty urisMissing = new SimpleBooleanProperty(false);
        private static Map<URI, UriUpdater.UriStatus> uriStatus = new ConcurrentHashMap<URI, UriUpdater.UriStatus>();
        private DoubleBinding viewWidth = Bindings.createDoubleBinding(() -> ((ProjectThumbnailSize)((Object)((Object)thumbnailSize.get()))).getWidth(), (Observable[])new Observable[]{thumbnailSize});
        private DoubleBinding viewHeight = Bindings.createDoubleBinding(() -> ((ProjectThumbnailSize)((Object)((Object)thumbnailSize.get()))).getHeight(), (Observable[])new Observable[]{thumbnailSize});

        static void resetUriStatus() {
            uriStatus.clear();
        }

        private ProjectTreeRowCell() {
            this.viewTooltip.setFitHeight(250.0);
            this.viewTooltip.setFitWidth(250.0);
            this.viewTooltip.setPreserveRatio(true);
            this.viewCanvas.getStyleClass().add((Object)"project-thumbnail");
            this.viewCanvas.widthProperty().bind((ObservableValue)this.viewWidth);
            this.viewCanvas.heightProperty().bind((ObservableValue)this.viewHeight);
            this.viewPane.getChildren().add((Object)this.viewCanvas);
            this.viewPane.prefWidthProperty().bind((ObservableValue)this.viewCanvas.widthProperty());
            this.viewPane.prefHeightProperty().bind((ObservableValue)this.viewCanvas.heightProperty());
            this.viewCanvas.opacityProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.urisMissing.get() ? 0.2 : 1.0, (Observable[])new Observable[]{this.urisMissing}));
            this.missingGraphic = IconFactory.createNode(15, 15, IconFactory.PathIcons.WARNING);
            this.missingGraphic.getStyleClass().add((Object)"missing-uri");
            Tooltip.install((Node)this.missingGraphic, (Tooltip)new Tooltip("File not found"));
            this.viewPane.getChildren().add((Object)this.missingGraphic);
            this.missingGraphic.visibleProperty().bind((ObservableValue)this.urisMissing);
            this.tooltipProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.showTooltip.get() && !ProjectBrowser.this.contextMenuShowing.get() ? this.tooltip : null, (Observable[])new Observable[]{ProjectBrowser.this.contextMenuShowing, this.showTooltip}));
        }

        public void updateItem(ProjectTreeRow item, boolean empty) {
            ProjectImageEntry<BufferedImage> entry;
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
                this.showTooltip.set(false);
                return;
            }
            this.getStyleClass().setAll((Object[])new String[]{"tree-cell"});
            this.urisMissing.set(false);
            if (item.getType() == ProjectTreeRow.Type.ROOT) {
                ObservableList children = this.getTreeItem().getChildren();
                this.setText(item.getDisplayableString() + (String)(!children.isEmpty() ? " (" + children.size() + ")" : ""));
                this.setGraphic(null);
                return;
            }
            if (item.getType() == ProjectTreeRow.Type.METADATA) {
                ObservableList children = this.getTreeItem().getChildren();
                this.setText(item.getDisplayableString() + (String)(!children.isEmpty() ? " (" + children.size() + ")" : ""));
                this.setGraphic(null);
                return;
            }
            ProjectImageEntry<BufferedImage> projectImageEntry = entry = item.getType() == ProjectTreeRow.Type.IMAGE ? ProjectTreeRow.getEntry(item) : null;
            if (ProjectBrowser.this.isCurrentImage(entry)) {
                this.getStyleClass().add((Object)"current-image");
            }
            if (entry != null && !entry.hasImageData()) {
                this.getStyleClass().add((Object)"no-saved-data");
            }
            if (entry != null && !PathPrefs.skipProjectUriChecksProperty().get()) {
                try {
                    for (URI uri : entry.getURIs()) {
                        if (uriStatus.computeIfAbsent(uri, ProjectTreeRowCell::checkUri) != UriUpdater.UriStatus.MISSING) continue;
                        this.urisMissing.set(true);
                        break;
                    }
                }
                catch (IOException e) {
                    logger.error("Exception checking URIs: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (entry == null) {
                this.setText(String.valueOf(item) + " (" + this.getTreeItem().getChildren().size() + ")");
                this.tooltip.setText(item.toString());
                this.showTooltip.set(true);
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.viewPane);
                this.tooltip.setGraphic(null);
                this.showTooltip.set(true);
                this.setText(entry.getImageName());
                if (this.urisMissing.get()) {
                    this.tooltip.setText("Warning: At least one file is missing!\n\n" + entry.getSummary());
                } else {
                    this.tooltip.setText(entry.getSummary());
                }
                if (thumbnailSize.get() == ProjectThumbnailSize.HIDDEN) {
                    this.viewTooltip.setImage(null);
                    this.viewCanvas.getGraphicsContext2D().clearRect(0.0, 0.0, this.viewCanvas.getWidth(), this.viewCanvas.getHeight());
                } else {
                    try {
                        BufferedImage img = (BufferedImage)entry.getThumbnail();
                        if (img != null) {
                            WritableImage image = SwingFXUtils.toFXImage((BufferedImage)img, null);
                            this.viewTooltip.setImage((Image)image);
                            this.tooltip.setGraphic((Node)this.viewTooltip);
                            GuiTools.paintImage(this.viewCanvas, (Image)image);
                            this.objectCell = item;
                            if (this.getGraphic() == null) {
                                this.setGraphic((Node)this.viewPane);
                            }
                        } else if (!ProjectBrowser.this.serversFailed.contains(item)) {
                            this.tooltip.setGraphic((Node)this.viewTooltip);
                            this.viewCanvas.getGraphicsContext2D().clearRect(0.0, 0.0, this.viewCanvas.getWidth(), this.viewCanvas.getHeight());
                            executor.submit(() -> {
                                block10: {
                                    ProjectTreeRow objectTemp = (ProjectTreeRow)this.getItem();
                                    ProjectImageEntry<BufferedImage> entryTemp = ProjectTreeRow.getEntry(objectTemp);
                                    try {
                                        if (entryTemp == null || this.objectCell == objectTemp || entryTemp.getThumbnail() != null) break block10;
                                        try (ImageServer server = entryTemp.getServerBuilder().build();){
                                            entryTemp.setThumbnail((Object)ProjectCommands.getThumbnailRGB((ImageServer<BufferedImage>)server));
                                            this.objectCell = objectTemp;
                                            ProjectBrowser.this.tree.refresh();
                                        }
                                        catch (Exception ex) {
                                            logger.warn("Error opening ImageServer (thumbnail generation): {}", (Object)ex.getLocalizedMessage(), (Object)ex);
                                            Platform.runLater(() -> this.setGraphic(IconFactory.createNode(15, 15, IconFactory.PathIcons.INACTIVE_SERVER)));
                                            ProjectBrowser.this.serversFailed.add(item);
                                        }
                                    }
                                    catch (IOException ex) {
                                        logger.warn("Error getting thumbnail: {}", (Object)ex.getLocalizedMessage());
                                        Platform.runLater(() -> this.setGraphic(IconFactory.createNode(15, 15, IconFactory.PathIcons.INACTIVE_SERVER)));
                                        ProjectBrowser.this.serversFailed.add(item);
                                    }
                                }
                            });
                        } else {
                            this.setGraphic(IconFactory.createNode(15, 15, IconFactory.PathIcons.INACTIVE_SERVER));
                        }
                    }
                    catch (Exception e) {
                        this.setGraphic(IconFactory.createNode(15, 15, IconFactory.PathIcons.INACTIVE_SERVER));
                        logger.warn("Unable to read thumbnail for {} ({})", (Object)entry.getImageName(), (Object)e.getMessage());
                        ProjectBrowser.this.serversFailed.add(item);
                    }
                }
            }
        }

        private static UriUpdater.UriStatus checkUri(URI uri) {
            Path path = GeneralTools.toPath((URI)uri);
            if (path == null) {
                return UriUpdater.UriStatus.UNKNOWN;
            }
            if (Files.notExists(path, new LinkOption[0])) {
                return UriUpdater.UriStatus.MISSING;
            }
            return UriUpdater.UriStatus.EXISTS;
        }
    }
}

