/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.util.Locale;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.localization.LocaleManager;
import qupath.fx.localization.LocaleSnapshot;
import qupath.fx.prefs.annotations.BooleanPref;
import qupath.fx.prefs.annotations.ColorPref;
import qupath.fx.prefs.annotations.DirectoryPref;
import qupath.fx.prefs.annotations.DoublePref;
import qupath.fx.prefs.annotations.FilePref;
import qupath.fx.prefs.annotations.IntegerPref;
import qupath.fx.prefs.annotations.LocalePref;
import qupath.fx.prefs.annotations.Pref;
import qupath.fx.prefs.annotations.PrefCategory;
import qupath.fx.prefs.controlsfx.PropertyEditorFactory;
import qupath.fx.prefs.controlsfx.PropertyItemBuilder;
import qupath.fx.prefs.controlsfx.PropertyItemParser;
import qupath.fx.prefs.controlsfx.PropertySheetBuilder;
import qupath.fx.prefs.controlsfx.PropertySheetUtils;
import qupath.lib.common.LogTools;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.logging.LogManager;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.QuPathStyleManager;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.tools.CommandFinderTools;

public class PreferencePane {
    private static final Logger logger = LoggerFactory.getLogger(PreferencePane.class);
    private PropertySheet propSheet;
    private static final LocaleManager localeManager = new LocaleManager(Locale.US, QuPathResources::hasDefaultBundleForLocale, false);
    private BorderPane pane;
    private final LocaleSnapshot localeSnapshot = new LocaleSnapshot();
    private final StringProperty localeChangedText = QuPathResources.getLocalizedResourceManager().createProperty("Prefs.localeChanged");
    private BooleanBinding localeChanged;

    public PreferencePane() {
        this.initializePane();
    }

    private void initializePane() {
        this.pane = new BorderPane();
        this.propSheet = this.createPropertySheet();
        Label label = this.createLocaleChangedLabel();
        this.localeSnapshot.refresh();
        this.pane.setCenter((Node)this.propSheet);
        this.pane.setBottom((Node)label);
    }

    private PropertySheet createPropertySheet() {
        PropertyEditorFactory factory = new PropertyEditorFactory();
        factory.setReformatEnums(new Class[]{SystemMenuBar.SystemMenuBarOption.class, FontWeight.class, PathPrefs.FontSize.class, LogManager.LogLevel.class, Level.class});
        PropertyItemParser parser = new PropertyItemParser().setResourceManager(QuPathResources.getLocalizedResourceManager()).setLocaleManager(localeManager);
        return new PropertySheetBuilder().parser(parser).editorFactory((Callback)factory).addAnnotatedProperties((Object)new AppearancePreferences()).addAnnotatedProperties((Object)new GeneralPreferences()).addAnnotatedProperties((Object)new UndoRedoPreferences()).addAnnotatedProperties((Object)new LocalePreferences()).addAnnotatedProperties((Object)new InputOutputPreferences()).addAnnotatedProperties((Object)new ViewerPreferences()).addAnnotatedProperties((Object)new ExtensionPreferences()).addAnnotatedProperties((Object)new MeasurementPreferences()).addAnnotatedProperties((Object)new ScriptingPreferences()).addAnnotatedProperties((Object)new DrawingPreferences()).addAnnotatedProperties((Object)new ObjectPreferences()).build();
    }

    public PropertySheet getPropertySheet() {
        return this.propSheet;
    }

    public Pane getPane() {
        return this.pane;
    }

    private Label createLocaleChangedLabel() {
        Label label = new Label();
        label.textProperty().bind((ObservableValue)this.localeChangedText);
        this.localeChanged = this.createLocaleChangedBinding();
        label.visibleProperty().bind((ObservableValue)this.localeChanged);
        label.setStyle("-fx-text-fill: -qp-script-error-color;");
        label.setPadding(new Insets(5.0));
        label.setMaxHeight(Double.MAX_VALUE);
        label.setWrapText(true);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        return label;
    }

    private BooleanBinding createLocaleChangedBinding() {
        Locale initalLocale = (Locale)PathPrefs.defaultLocaleProperty().get();
        Locale initalLocaleDisplay = (Locale)PathPrefs.defaultLocaleDisplayProperty().get();
        Locale initalLocaleFormat = (Locale)PathPrefs.defaultLocaleFormatProperty().get();
        return Bindings.createBooleanBinding(() -> !Objects.equals(initalLocale, PathPrefs.defaultLocaleProperty().get()) || !Objects.equals(initalLocaleDisplay, PathPrefs.defaultLocaleDisplayProperty().get()) || !Objects.equals(initalLocaleFormat, PathPrefs.defaultLocaleFormatProperty().get()), (Observable[])new Observable[]{PathPrefs.defaultLocaleProperty(), PathPrefs.defaultLocaleDisplayProperty(), PathPrefs.defaultLocaleFormatProperty()});
    }

    public void refreshAllEditors() {
        if (this.localeSnapshot.hasChanged()) {
            logger.info("Refreshing preferences because of locale change");
            PropertySheetUtils.refreshEditors((PropertySheet)this.propSheet);
            this.localeSnapshot.refresh();
        }
        localeManager.refreshAvailableLocales();
    }

    @Deprecated
    public <T> void addPropertyPreference(Property<T> prop, Class<? extends T> cls, String name, String category, String description) {
        LogTools.warnOnce((Logger)logger, (String)"PreferencePane.addPropertyPreference is deprecated - use PropertyItemBuilder instead");
        PropertySheet.Item item = new PropertyItemBuilder(prop, cls).resourceManager(QuPathResources.getLocalizedResourceManager()).name(name).category(category).description(description).build();
        this.propSheet.getItems().add((Object)item);
    }

    @Deprecated
    public void addColorPropertyPreference(IntegerProperty prop, String name, String category, String description) {
        LogTools.warnOnce((Logger)logger, (String)"PreferencePane.addColorPropertyPreference is deprecated - use PropertyItemBuilder instead");
        PropertySheet.Item item = new PropertyItemBuilder((Property)prop, Integer.class).resourceManager(QuPathResources.getLocalizedResourceManager()).name(name).category(category).description(description).propertyType(PropertyItemBuilder.PropertyType.COLOR).build();
        this.propSheet.getItems().add((Object)item);
    }

    @Deprecated
    public void addDirectoryPropertyPreference(Property<String> prop, String name, String category, String description) {
        LogTools.warnOnce((Logger)logger, (String)"PreferencePane.addDirectoryPropertyPreference is deprecated - use PropertyItemBuilder instead");
        PropertySheet.Item item = new PropertyItemBuilder(prop, String.class).resourceManager(QuPathResources.getLocalizedResourceManager()).name(name).category(category).description(description).propertyType(PropertyItemBuilder.PropertyType.DIRECTORY).build();
        this.propSheet.getItems().add((Object)item);
    }

    @Deprecated
    public <T> void addChoicePropertyPreference(Property<T> prop, ObservableList<T> choices, Class<? extends T> cls, String name, String category, String description) {
        this.addChoicePropertyPreference(prop, choices, cls, name, category, description, false);
    }

    @Deprecated
    public <T> void addChoicePropertyPreference(Property<T> prop, ObservableList<T> choices, Class<? extends T> cls, String name, String category, String description, boolean makeSearchable) {
        LogTools.warnOnce((Logger)logger, (String)"PreferencePane.addChoicePropertyPreference is deprecated - use PropertyItemBuilder instead");
        PropertySheet.Item item = new PropertyItemBuilder(prop, cls).resourceManager(QuPathResources.getLocalizedResourceManager()).name(name).category(category).description(description).choices(choices).propertyType(makeSearchable ? PropertyItemBuilder.PropertyType.SEARCHABLE_CHOICE : PropertyItemBuilder.PropertyType.CHOICE).build();
        this.propSheet.getItems().add((Object)item);
    }

    @Deprecated
    public static <T> PropertySheet.Item createPropertySheetItem(Property<T> property, Class<? extends T> cls) {
        LogTools.warnOnce((Logger)logger, (String)"PreferencePane.createPropertySheetItem is deprecated - use PropertyItemBuilder instead");
        return PropertySheetUtils.createPropertySheetItem(property, cls);
    }

    @PrefCategory(value="Prefs.Appearance")
    public static class AppearancePreferences {
        @Pref(value="Prefs.Appearance.theme", type=QuPathStyleManager.StyleOption.class, choiceMethod="getStyles")
        public final ObjectProperty<QuPathStyleManager.StyleOption> theme = QuPathStyleManager.selectedStyleProperty();
        @Pref(value="Prefs.Appearance.font", type=QuPathStyleManager.Fonts.class)
        public final ObjectProperty<QuPathStyleManager.Fonts> autoUpdate = QuPathStyleManager.fontProperty();
        @BooleanPref(value="Prefs.Appearance.badges")
        public final BooleanProperty badges = PathPrefs.showToolBarBadgesProperty();
        @Pref(value="Prefs.Appearance.systemMenubar", type=SystemMenuBar.SystemMenuBarOption.class)
        public final ObjectProperty<SystemMenuBar.SystemMenuBarOption> systemMenubar = SystemMenuBar.supportsSystemMenubar() ? SystemMenuBar.systemMenubarProperty() : null;

        public final ObservableList<QuPathStyleManager.StyleOption> getStyles() {
            return QuPathStyleManager.availableStylesProperty();
        }
    }

    @PrefCategory(value="Prefs.General")
    public static class GeneralPreferences {
        @BooleanPref(value="Prefs.General.showStartupMessage")
        public final BooleanProperty startupMessage = PathPrefs.showStartupMessageProperty();
        @BooleanPref(value="Prefs.General.showLicenseMessage")
        public final BooleanProperty licenseMessage = PathPrefs.showLicenseMessageOnStartupProperty();
        @FilePref(value="Prefs.General.startupScriptPath", extensions={"*.groovy"})
        public final StringProperty startupScriptPath = PathPrefs.startupScriptProperty();
        @Pref(value="Prefs.General.checkForUpdates", type=PathPrefs.AutoUpdateType.class)
        public final ObjectProperty<PathPrefs.AutoUpdateType> autoUpdate = PathPrefs.autoUpdateCheckProperty();
        @DoublePref(value="Prefs.General.maxMemory")
        public final DoubleProperty maxMemoryGB = PathPrefs.hasJavaPreferences() ? this.createMaxMemoryProperty() : null;
        @DoublePref(value="Prefs.General.tileCache")
        public final DoubleProperty tileCache = PathPrefs.tileCachePercentageProperty();
        @BooleanPref(value="Prefs.General.showImageNameInTitle")
        public final BooleanProperty showImageNameInTitle = PathPrefs.showImageNameInTitleProperty();
        @BooleanPref(value="Prefs.General.maskImageNames")
        public final BooleanProperty maskImageNames = PathPrefs.maskImageNamesProperty();
        @BooleanPref(value="Prefs.General.skipProjectUriChecks")
        public final BooleanProperty skipProjectUriChecks = PathPrefs.skipProjectUriChecksProperty();
        @BooleanPref(value="Prefs.General.logFiles")
        public final BooleanProperty createLogFiles = PathPrefs.doCreateLogFilesProperty();
        @Pref(value="Prefs.General.logLevel", type=LogManager.LogLevel.class)
        public final ObjectProperty<LogManager.LogLevel> logLevel = LogManager.rootLogLevelProperty();
        @IntegerPref(value="Prefs.General.numThreads")
        public final IntegerProperty numThreads = PathPrefs.numCommandThreadsProperty();
        @Pref(value="Prefs.General.imageType", type=PathPrefs.ImageTypeSetting.class)
        public final ObjectProperty<PathPrefs.ImageTypeSetting> setImageType = PathPrefs.imageTypeSettingProperty();
        @Pref(value="Prefs.General.commandBar", type=CommandFinderTools.CommandBarDisplay.class)
        public final ObjectProperty<CommandFinderTools.CommandBarDisplay> commandBarDisplay = CommandFinderTools.commandBarDisplayProperty();
        @BooleanPref(value="Prefs.General.showExperimental")
        public final BooleanProperty showExperimentalCommands = PathPrefs.showExperimentalOptionsProperty();
        @BooleanPref(value="Prefs.General.showTMA")
        public final BooleanProperty showTMACommands = PathPrefs.showTMAOptionsProperty();
        @BooleanPref(value="Prefs.General.showDeprecated")
        public final BooleanProperty showDeprecatedCommands = PathPrefs.showLegacyOptionsProperty();
        @Pref(value="Prefs.General.hierarchyDisplay", type=PathPrefs.DetectionTreeDisplayModes.class)
        public final ObjectProperty<PathPrefs.DetectionTreeDisplayModes> hierarchyDisplayMode = PathPrefs.detectionTreeDisplayModeProperty();

        private DoubleProperty createMaxMemoryProperty() {
            long maxMemoryMB = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            SimpleDoubleProperty propMemoryGB = new SimpleDoubleProperty((double)maxMemoryMB / 1024.0);
            propMemoryGB.addListener((arg_0, arg_1, arg_2) -> GeneralPreferences.lambda$createMaxMemoryProperty$0((DoubleProperty)propMemoryGB, arg_0, arg_1, arg_2));
            return propMemoryGB;
        }

        private static /* synthetic */ void lambda$createMaxMemoryProperty$0(DoubleProperty propMemoryGB, ObservableValue v, Number o, Number n) {
            int requestedMemoryMB = (int)Math.round(propMemoryGB.get() * 1024.0);
            if (requestedMemoryMB > 1024) {
                boolean success = false;
                try {
                    PathPrefs.maxMemoryMBProperty().set(requestedMemoryMB);
                    success = requestedMemoryMB == PathPrefs.maxMemoryMBProperty().get();
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                if (success) {
                    Dialogs.showInfoNotification((String)QuPathResources.getString("Prefs.General.maxMemory"), (String)QuPathResources.getString("Prefs.maxMemoryChanged"));
                } else {
                    Dialogs.showErrorMessage((String)QuPathResources.getString("Prefs.General.maxMemory"), (String)QuPathResources.getString("Prefs.maxMemoryFailed"));
                }
            }
        }
    }

    @PrefCategory(value="Prefs.Undo")
    public static class UndoRedoPreferences {
        @IntegerPref(value="Prefs.Undo.maxUndoLevels")
        public final IntegerProperty maxUndoLevels = PathPrefs.maxUndoLevelsProperty();
        @IntegerPref(value="Prefs.Undo.maxUndoHierarchySize")
        public final IntegerProperty maxUndoHierarchySize = PathPrefs.maxUndoHierarchySizeProperty();
    }

    @PrefCategory(value="Prefs.Locale")
    public static class LocalePreferences {
        @LocalePref(value="Prefs.Locale.default", availableLanguagesOnly=true)
        public final ObjectProperty<Locale> localeDefault = PathPrefs.defaultLocaleProperty();
        @LocalePref(value="Prefs.Locale.display", availableLanguagesOnly=true)
        public final ObjectProperty<Locale> localeDisplay = PathPrefs.defaultLocaleDisplayProperty();
        @LocalePref(value="Prefs.Locale.format")
        public final ObjectProperty<Locale> localeFormat = PathPrefs.defaultLocaleFormatProperty();
    }

    @PrefCategory(value="Prefs.InputOutput")
    public static class InputOutputPreferences {
        @IntegerPref(value="Prefs.InputOutput.minPyramidDimension")
        public final IntegerProperty minimumPyramidDimension = PathPrefs.minPyramidDimensionProperty();
        @DoublePref(value="Prefs.InputOutput.tmaExportDownsample")
        public final DoubleProperty tmaExportDownsample = PathPrefs.tmaExportDownsampleProperty();
    }

    @PrefCategory(value="Prefs.Viewer")
    public static class ViewerPreferences {
        @BooleanPref(value="Prefs.Viewer.placeholderText")
        public final BooleanProperty placeholderText = PathPrefs.showViewerPlaceholderTextProperty();
        @ColorPref(value="Prefs.Viewer.backgroundColor")
        public final IntegerProperty backgroundColor = PathPrefs.viewerBackgroundColorProperty();
        @BooleanPref(value="Prefs.Viewer.alwaysPaintSelected")
        public final BooleanProperty alwaysPaintSelected = PathPrefs.alwaysPaintSelectedObjectsProperty();
        @BooleanPref(value="Prefs.Viewer.keepDisplaySettings")
        public final BooleanProperty keepDisplaySettings = PathPrefs.keepDisplaySettingsProperty();
        @BooleanPref(value="Prefs.Viewer.interpolateBilinear")
        public final BooleanProperty interpolateBilinear = PathPrefs.viewerInterpolateBilinearProperty();
        @DoublePref(value="Prefs.Viewer.autoSaturationPercent")
        public final DoubleProperty autoSaturationPercent = PathPrefs.autoBrightnessContrastSaturationPercentProperty();
        @BooleanPref(value="Prefs.Viewer.invertZSlider")
        public final BooleanProperty invertZSlider = PathPrefs.invertZSliderProperty();
        @IntegerPref(value="Prefs.Viewer.scrollSpeed")
        public final IntegerProperty scrollSpeed = PathPrefs.scrollSpeedProperty();
        @IntegerPref(value="Prefs.Viewer.navigationSpeed")
        public final IntegerProperty navigationSpeed = PathPrefs.navigationSpeedProperty();
        @BooleanPref(value="Prefs.Viewer.navigationAcceleration")
        public final BooleanProperty navigationAcceleration = PathPrefs.navigationAccelerationProperty();
        @BooleanPref(value="Prefs.Viewer.skipMissingCores")
        public final BooleanProperty skipMissingCores = PathPrefs.skipMissingCoresProperty();
        @BooleanPref(value="Prefs.Viewer.iseScrollGestures")
        public final BooleanProperty iseScrollGestures = PathPrefs.useScrollGesturesProperty();
        @BooleanPref(value="Prefs.Viewer.invertScrolling")
        public final BooleanProperty invertScrolling = PathPrefs.invertScrollingProperty();
        @BooleanPref(value="Prefs.Viewer.useZoomGestures")
        public final BooleanProperty useZoomGestures = PathPrefs.useZoomGesturesProperty();
        @BooleanPref(value="Prefs.Viewer.useRotateGestures")
        public final BooleanProperty useRotateGestures = PathPrefs.useRotateGesturesProperty();
        @BooleanPref(value="Prefs.Viewer.enableFreehand")
        public final BooleanProperty enableFreehand = PathPrefs.enableFreehandToolsProperty();
        @BooleanPref(value="Prefs.Viewer.doubleClickToZoom")
        public final BooleanProperty doubleClickToZoom = PathPrefs.doubleClickToZoomProperty();
        @Pref(value="Prefs.Viewer.scalebarFontSize", type=PathPrefs.FontSize.class)
        public final ObjectProperty<PathPrefs.FontSize> scalebarFontSize = PathPrefs.scalebarFontSizeProperty();
        @Pref(value="Prefs.Viewer.scalebarFontWeight", type=FontWeight.class)
        public final ObjectProperty<FontWeight> scalebarFontWeight = PathPrefs.scalebarFontWeightProperty();
        @DoublePref(value="Prefs.Viewer.scalebarLineWidth")
        public final DoubleProperty scalebarLineWidth = PathPrefs.scalebarLineWidthProperty();
        @Pref(value="Prefs.Viewer.locationFontSize", type=PathPrefs.FontSize.class)
        public final ObjectProperty<PathPrefs.FontSize> locationFontSize = PathPrefs.locationFontSizeProperty();
        @BooleanPref(value="Prefs.Viewer.calibratedLocationString")
        public final BooleanProperty calibratedLocationString = PathPrefs.useCalibratedLocationStringProperty();
        @DoublePref(value="Prefs.Viewer.gridSpacingX")
        public final DoubleProperty gridSpacingX = PathPrefs.gridSpacingXProperty();
        @DoublePref(value="Prefs.Viewer.gridSpacingY")
        public final DoubleProperty gridSpacingY = PathPrefs.gridSpacingYProperty();
        @BooleanPref(value="Prefs.Viewer.gridScaleMicrons")
        public final BooleanProperty gridScaleMicrons = PathPrefs.gridScaleMicronsProperty();
    }

    @PrefCategory(value="Prefs.Extensions")
    public static class ExtensionPreferences {
        @DirectoryPref(value="Prefs.Extensions.userPath")
        public final Property<String> scriptsPath = PathPrefs.userPathProperty();
    }

    @PrefCategory(value="Prefs.Measurements")
    public static class MeasurementPreferences {
        @BooleanPref(value="Prefs.Measurements.thumbnails")
        public final BooleanProperty showMeasurementTableThumbnails = PathPrefs.showMeasurementTableThumbnailsProperty();
        @BooleanPref(value="Prefs.Measurements.ids")
        public final BooleanProperty showMeasurementTableObjectIDs = PathPrefs.showMeasurementTableObjectIDsProperty();
    }

    @PrefCategory(value="Prefs.Scripting")
    public static class ScriptingPreferences {
        @DirectoryPref(value="Prefs.Scripting.scriptsPath")
        public final StringProperty scriptsPath = PathPrefs.scriptsPathProperty();
    }

    @PrefCategory(value="Prefs.Drawing")
    public static class DrawingPreferences {
        @BooleanPref(value="Prefs.Drawing.returnToMove")
        public final BooleanProperty returnToMove = PathPrefs.returnToMoveModeProperty();
        @BooleanPref(value="Prefs.Drawing.pixelSnapping")
        public final BooleanProperty pixelSnapping = PathPrefs.usePixelSnappingProperty();
        @BooleanPref(value="Prefs.Drawing.clipROIsForHierarchy")
        public final BooleanProperty clipROIsForHierarchy = PathPrefs.clipROIsForHierarchyProperty();
        @IntegerPref(value="Prefs.Drawing.brushDiameter")
        public final IntegerProperty brushDiameter = PathPrefs.brushDiameterProperty();
        @BooleanPref(value="Prefs.Drawing.tileBrush")
        public final BooleanProperty tileBrush = PathPrefs.useTileBrushProperty();
        @BooleanPref(value="Prefs.Drawing.brushScaleByMag")
        public final BooleanProperty brushScaleByMag = PathPrefs.brushScaleByMagProperty();
        @BooleanPref(value="Prefs.Drawing.useMultipoint")
        public final BooleanProperty useMultipoint = PathPrefs.multipointToolProperty();
        @IntegerPref(value="Prefs.Drawing.pointRadius")
        public final IntegerProperty pointRadius = PathPrefs.pointRadiusProperty();
    }

    @PrefCategory(value="Prefs.Objects")
    public static class ObjectPreferences {
        @IntegerPref(value="Prefs.Objects.clipboard")
        public final IntegerProperty maxClipboardObjects = PathPrefs.maxObjectsToClipboardProperty();
        @DoublePref(value="Prefs.Objects.annotationLineThickness")
        public final DoubleProperty annotationStrokeThickness = PathPrefs.annotationStrokeThicknessProperty();
        @DoublePref(value="Prefs.Objects.detectionLineThickness")
        public final DoubleProperty detectonStrokeThickness = PathPrefs.detectionStrokeThicknessProperty();
        @BooleanPref(value="Prefs.Objects.newDetectionRendering")
        public final BooleanProperty newDetectionRendering = PathPrefs.newDetectionRenderingProperty();
        @BooleanPref(value="Prefs.Objects.useSelectedColor")
        public final BooleanProperty useSelectedColor = PathPrefs.useSelectedColorProperty();
        @ColorPref(value="Prefs.Objects.selectedColor")
        public final IntegerProperty selectedColor = PathPrefs.colorSelectedObjectProperty();
        @ColorPref(value="Prefs.Objects.defaultColor")
        public final IntegerProperty defaultColor = PathPrefs.colorDefaultObjectsProperty();
        @ColorPref(value="Prefs.Objects.tmaCoreColor")
        public final IntegerProperty tmaColor = PathPrefs.colorTMAProperty();
        @DoublePref(value="Prefs.Objects.tmaCoreMissingOpacity")
        public final DoubleProperty tmaMissingOpacity = PathPrefs.opacityTMAMissingProperty();
    }
}

