/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import org.controlsfx.control.BreadCrumbBar;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.PathObjectLabels;
import qupath.lib.images.ImageData;
import qupath.lib.objects.DefaultPathObjectComparator;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;

public class PathObjectHierarchyView
implements ChangeListener<ImageData<BufferedImage>>,
PathObjectSelectionListener,
PathObjectHierarchyListener {
    private static boolean synchronizePrimarySelectionOnly = true;
    private ObservableValue<ImageData<BufferedImage>> imageDataProperty;
    private PathObjectHierarchy hierarchy;
    private BooleanProperty disableUpdates = new SimpleBooleanProperty(false);
    private TreeView<PathObject> treeView;
    private BorderPane treeViewPane = new BorderPane();
    private boolean synchronizingModelToTree = false;
    private boolean synchronizingTreeToModel = false;

    public PathObjectHierarchyView(QuPathGUI qupath) {
        this(qupath, (ObservableValue<ImageData<BufferedImage>>)qupath.imageDataProperty());
    }

    public PathObjectHierarchyView(QuPathGUI qupath, ObservableValue<ImageData<BufferedImage>> imageDataProperty) {
        this.imageDataProperty = imageDataProperty;
        this.disableUpdates.addListener((v, o, n) -> {
            if (!n.booleanValue()) {
                this.enableUpdates();
            }
        });
        this.treeView = new TreeView(PathObjectHierarchyView.createNode((PathObject)new PathRootObject()));
        this.treeView.setCellFactory(t -> PathObjectLabels.createTreeCell());
        PathPrefs.colorDefaultObjectsProperty().addListener((v, o, n) -> this.treeView.refresh());
        PathPrefs.colorTMAProperty().addListener((v, o, n) -> this.treeView.refresh());
        PathPrefs.opacityTMAMissingProperty().addListener((v, o, n) -> this.treeView.refresh());
        PathPrefs.colorTileProperty().addListener((v, o, n) -> this.treeView.refresh());
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.treeView.getSelectionModel().getSelectedItems().addListener(c -> this.synchronizeSelectionModelToTree((ListChangeListener.Change<? extends TreeItem<PathObject>>)c));
        this.treeView.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.synchronizeSelectionModelToTree(null));
        this.treeView.expandedItemCountProperty().addListener((v, o, n) -> this.synchronizeTreeToSelectionModel());
        this.setImageData((ImageData<BufferedImage>)((ImageData)imageDataProperty.getValue()));
        imageDataProperty.addListener((ChangeListener)this);
        ContextMenu popup = new ContextMenu();
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioMenuItem miWithIcons = new RadioMenuItem("Show with icons");
        miWithIcons.setToggleGroup(toggleGroup);
        miWithIcons.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                PathPrefs.detectionTreeDisplayModeProperty().set((Object)PathPrefs.DetectionTreeDisplayModes.WITH_ICONS);
            }
        });
        RadioMenuItem miWithoutIcons = new RadioMenuItem("Show without icons");
        miWithoutIcons.setToggleGroup(toggleGroup);
        miWithoutIcons.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                PathPrefs.detectionTreeDisplayModeProperty().set((Object)PathPrefs.DetectionTreeDisplayModes.WITHOUT_ICONS);
            }
        });
        RadioMenuItem miHide = new RadioMenuItem("Don't show");
        miHide.setToggleGroup(toggleGroup);
        miHide.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                PathPrefs.detectionTreeDisplayModeProperty().set((Object)PathPrefs.DetectionTreeDisplayModes.NONE);
            }
        });
        miWithIcons.setSelected(PathPrefs.detectionTreeDisplayModeProperty().get() == PathPrefs.DetectionTreeDisplayModes.WITH_ICONS);
        miWithoutIcons.setSelected(PathPrefs.detectionTreeDisplayModeProperty().get() == PathPrefs.DetectionTreeDisplayModes.WITHOUT_ICONS);
        miHide.setSelected(PathPrefs.detectionTreeDisplayModeProperty().get() == PathPrefs.DetectionTreeDisplayModes.NONE);
        Menu menuDetectionDisplay = new Menu("Detection display");
        menuDetectionDisplay.getItems().setAll((Object[])new MenuItem[]{miWithIcons, miWithoutIcons, miHide});
        popup.getItems().setAll((Object[])new MenuItem[]{menuDetectionDisplay});
        this.treeView.setContextMenu(popup);
        this.treeView.setShowRoot(false);
        this.treeViewPane.setCenter(this.treeView);
        BreadCrumbBar breadCrumbBar = new BreadCrumbBar();
        breadCrumbBar.setAutoNavigationEnabled(false);
        breadCrumbBar.setStyle("-fx-font-size: 0.8em;");
        this.treeView.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> breadCrumbBar.setSelectedCrumb(n));
        breadCrumbBar.setOnCrumbAction(e -> {
            if (e.getSelectedCrumb() != null && this.hierarchy != null) {
                this.hierarchy.getSelectionModel().setSelectedObject((PathObject)e.getSelectedCrumb().getValue());
            }
        });
        this.treeViewPane.setBottom((Node)breadCrumbBar);
        PathPrefs.detectionTreeDisplayModeProperty().addListener((v, o, n) -> this.hierarchyChanged(null));
        this.treeView.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                PathObject pathObject;
                TreeItem item = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
                PathObject pathObject2 = pathObject = item == null ? null : (PathObject)item.getValue();
                if (pathObject == null || !pathObject.hasROI()) {
                    return;
                }
                qupath.getViewer().centerROI(pathObject.getROI());
            }
        });
    }

    private void enableUpdates() {
        if (this.hierarchy == null) {
            return;
        }
        this.hierarchyChanged(PathObjectHierarchyEvent.createStructureChangeEvent((Object)this, (PathObjectHierarchy)this.hierarchy, (PathObject)this.hierarchy.getRootObject()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeSelectionModelToTree(ListChangeListener.Change<? extends TreeItem<PathObject>> change) {
        if (this.synchronizingTreeToModel) {
            return;
        }
        PathObjectSelectionModel model = this.getHierarchySelectionModel();
        if (model == null) {
            return;
        }
        boolean wasSynchronizingToTree = this.synchronizingModelToTree;
        try {
            MultipleSelectionModel treeModel;
            ObservableList selectedItems;
            this.synchronizingModelToTree = true;
            boolean removed = false;
            if (change != null) {
                while (change.next()) {
                    removed |= change.wasRemoved();
                }
            }
            if ((selectedItems = (treeModel = this.treeView.getSelectionModel()).getSelectedItems()).isEmpty() && removed) {
                model.clearSelection();
                return;
            }
            if (selectedItems.size() == 1) {
                model.setSelectedObject((PathObject)((TreeItem)selectedItems.get(0)).getValue(), false);
                return;
            }
            Set toSelect = this.treeView.getSelectionModel().getSelectedItems().stream().map(t -> (PathObject)t.getValue()).collect(Collectors.toSet());
            TreeItem mainSelection = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            PathObject primary = mainSelection == null ? null : (PathObject)mainSelection.getValue();
            model.setSelectedObjects(toSelect, primary);
        }
        finally {
            this.synchronizingModelToTree = wasSynchronizingToTree;
        }
    }

    private PathObjectSelectionModel getHierarchySelectionModel() {
        return this.hierarchy == null ? null : this.hierarchy.getSelectionModel();
    }

    private void synchronizeTreeToSelectionModel() {
        PathObjectSelectionModel model = this.getHierarchySelectionModel();
        if (model == null) {
            this.synchronizeTreeToSelectionModel(null, Collections.emptySet());
        } else {
            this.synchronizeTreeToSelectionModel(model.getSelectedObject(), model.getSelectedObjects());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeTreeToSelectionModel(PathObject primarySelected, Collection<PathObject> allSelected) {
        if (this.synchronizingModelToTree) {
            return;
        }
        if (synchronizePrimarySelectionOnly) {
            boolean currentlySynchronizing = this.synchronizingTreeToModel;
            try {
                this.synchronizingTreeToModel = true;
                MultipleSelectionModel treeModel = this.treeView.getSelectionModel();
                if (primarySelected == null) {
                    treeModel.clearSelection();
                } else {
                    this.selectSingleObject(primarySelected);
                }
                return;
            }
            finally {
                this.synchronizingTreeToModel = currentlySynchronizing;
            }
        }
        boolean ownsChanges = !this.synchronizingTreeToModel;
        try {
            this.synchronizingTreeToModel = true;
            MultipleSelectionModel treeModel = this.treeView.getSelectionModel();
            if (primarySelected == null && allSelected.isEmpty()) {
                treeModel.clearSelection();
                return;
            }
            if (allSelected.size() == 1) {
                this.selectSingleObject(primarySelected);
                return;
            }
            if (!(allSelected instanceof Set)) {
                allSelected = new HashSet<PathObject>(allSelected);
            }
            int n = this.treeView.getExpandedItemCount();
            int mainObjectInd = -1;
            for (int i = 0; i < n; ++i) {
                TreeItem item = this.treeView.getTreeItem(i);
                if (item == null) {
                    treeModel.clearSelection(i);
                    continue;
                }
                PathObject temp = (PathObject)item.getValue();
                if (temp == primarySelected) {
                    mainObjectInd = i;
                }
                if (allSelected.contains(temp)) {
                    if (treeModel.isSelected(i)) continue;
                    treeModel.select(i);
                    continue;
                }
                treeModel.clearSelection(i);
            }
            if (mainObjectInd >= 0) {
                treeModel.select(mainObjectInd);
                this.treeView.scrollTo(mainObjectInd);
            }
        }
        finally {
            if (ownsChanges) {
                this.synchronizingTreeToModel = false;
            }
        }
    }

    private void selectSingleObject(PathObject pathObjectSelected) {
        if (pathObjectSelected == null) {
            return;
        }
        List ancestors = PathObjectTools.getAncestorList((PathObject)pathObjectSelected);
        if (ancestors.isEmpty() || this.treeView.getRoot() == null) {
            return;
        }
        ObservableList treeItems = new ArrayList();
        treeItems.add(this.treeView.getRoot());
        TreeItem deepestItem = null;
        while (!ancestors.isEmpty()) {
            PathObject pathObject = (PathObject)ancestors.remove(0);
            TreeItem found = null;
            for (TreeItem treeItem : treeItems) {
                if (treeItem.getValue() != pathObject) continue;
                found = treeItem;
                break;
            }
            if (found == null) {
                return;
            }
            deepestItem = found;
            treeItems = found.getChildren();
        }
        if (deepestItem != null && deepestItem.getValue() == pathObjectSelected) {
            for (TreeItem parent = deepestItem.getParent(); parent != null; parent = parent.getParent()) {
                parent.setExpanded(true);
            }
            int row = this.treeView.getRow(deepestItem);
            this.treeView.getSelectionModel().clearAndSelect(row);
            this.treeView.scrollTo(row);
        }
    }

    public Pane getPane() {
        return this.treeViewPane;
    }

    public BooleanProperty disableUpdatesProperty() {
        return this.disableUpdates;
    }

    void setImageData(ImageData<BufferedImage> imageData) {
        if (this.hierarchy != null) {
            this.hierarchy.getSelectionModel().removePathObjectSelectionListener((PathObjectSelectionListener)this);
            this.hierarchy.removeListener((PathObjectHierarchyListener)this);
        }
        PathObjectHierarchy pathObjectHierarchy = this.hierarchy = imageData == null ? null : imageData.getHierarchy();
        if (this.hierarchy != null) {
            this.hierarchy.addListener((PathObjectHierarchyListener)this);
            this.hierarchy.getSelectionModel().addPathObjectSelectionListener((PathObjectSelectionListener)this);
            this.treeView.setRoot(PathObjectHierarchyView.createNode(this.hierarchy.getRootObject()));
        } else {
            this.treeView.setRoot(PathObjectHierarchyView.createNode((PathObject)new PathRootObject()));
        }
    }

    public void selectedPathObjectChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
        if (Platform.isFxApplicationThread()) {
            if (this.disableUpdates.get()) {
                return;
            }
            this.synchronizeTreeToSelectionModel(pathObjectSelected, allSelected);
        }
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.setImageData(imageDataNew);
    }

    static TreeItem<PathObject> createNode(PathObject pathObject) {
        return new PathObjectTreeItem(pathObject);
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (this.hierarchy == null) {
            return;
        }
        if (event != null && event.isChanging()) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.hierarchyChanged(event));
            return;
        }
        if (this.disableUpdates.get()) {
            return;
        }
        this.synchronizingTreeToModel = true;
        this.treeView.setRoot(PathObjectHierarchyView.createNode(this.hierarchy.getRootObject()));
        this.synchronizeTreeToSelectionModel();
        this.synchronizingTreeToModel = false;
    }

    static class PathObjectTreeItem
    extends TreeItem<PathObject> {
        private boolean childrenSet = false;
        private Boolean isLeaf = null;

        public PathObjectTreeItem(PathObject value) {
            super((Object)value);
        }

        public ObservableList<TreeItem<PathObject>> getChildren() {
            ObservableList children = super.getChildren();
            PathObject value = (PathObject)this.getValue();
            if (!this.childrenSet && children.isEmpty()) {
                this.childrenSet = true;
                PathObject[] childArray = value.getChildObjectsAsArray();
                if (childArray.length > 0) {
                    ArrayList<PathObject> sortable = new ArrayList<PathObject>();
                    ArrayList<PathObject> tmaCores = new ArrayList<PathObject>();
                    boolean includeDetections = PathPrefs.detectionTreeDisplayModeProperty().get() != PathPrefs.DetectionTreeDisplayModes.NONE;
                    ArrayList<PathObject> others = new ArrayList<PathObject>();
                    for (PathObject child : childArray) {
                        assert (child != value);
                        if (child.isTMACore()) {
                            tmaCores.add(child);
                            continue;
                        }
                        if (child.isAnnotation() || child.hasChildObjects()) {
                            sortable.add(child);
                            continue;
                        }
                        if (!includeDetections) continue;
                        others.add(child);
                    }
                    Collections.sort(sortable, DefaultPathObjectComparator.getInstance());
                    ArrayList<TreeItem<PathObject>> newChildren = new ArrayList<TreeItem<PathObject>>();
                    for (PathObject child : sortable) {
                        newChildren.add(PathObjectHierarchyView.createNode(child));
                    }
                    for (PathObject child : tmaCores) {
                        newChildren.add(PathObjectHierarchyView.createNode(child));
                    }
                    for (PathObject child : others) {
                        newChildren.add(PathObjectHierarchyView.createNode(child));
                    }
                    children.setAll(newChildren);
                } else if (!children.isEmpty()) {
                    children.clear();
                }
            }
            return children;
        }

        public boolean isLeaf() {
            if (this.isLeaf == null) {
                PathObject pathObject = (PathObject)this.getValue();
                this.isLeaf = !pathObject.hasChildObjects() ? Boolean.valueOf(true) : (PathPrefs.detectionTreeDisplayModeProperty().get() != PathPrefs.DetectionTreeDisplayModes.NONE ? Boolean.valueOf(false) : Boolean.valueOf(Arrays.stream(pathObject.getChildObjectsAsArray()).allMatch(p -> p.isDetection())));
            }
            return this.isLeaf;
        }
    }
}

