/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;

class PathClassPane {
    private static final Logger logger = LoggerFactory.getLogger(PathClassPane.class);
    private static final KeyCombination copyCombo = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN});
    private static final KeyCombination pasteCombo = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN});
    private final QuPathGUI qupath;
    private final ObservableList<PathClass> availablePathClasses;
    private final Pane pane;
    private ListView<PathClass> listClasses;
    private final BooleanProperty doAutoSetPathClass = new SimpleBooleanProperty(false);

    PathClassPane(QuPathGUI qupath) {
        this.qupath = qupath;
        this.availablePathClasses = qupath.getAvailablePathClasses();
        Pane mainPane = this.createClassPane();
        TitledPane titled = GuiTools.createLeftRightTitledPane("Class list", new Node[]{this.createTitleNode()});
        titled.setContent((Node)mainPane);
        mainPane.setPadding(Insets.EMPTY);
        titled.setContentDisplay(ContentDisplay.RIGHT);
        this.pane = new BorderPane((Node)titled);
        OverlayOptions options = qupath.getOverlayOptions();
        InvalidationListener refresher = o -> this.listClasses.refresh();
        options.selectedClassVisibilityModeProperty().addListener(refresher);
        options.useExactSelectedClassesProperty().addListener(refresher);
        options.selectedClassesProperty().addListener(refresher);
    }

    private Pane createTitleNode() {
        int iconSize = 8;
        Action addNewAction = new Action(e -> this.promptToAddClass());
        addNewAction.setGraphic(IconFactory.createNode(FontAwesome.Glyph.PLUS, iconSize));
        addNewAction.setLongText("Add a new class to the list");
        Action removeSelected = new Action(e -> this.promptToRemoveSelectedClasses());
        removeSelected.setGraphic(IconFactory.createNode(FontAwesome.Glyph.MINUS, iconSize));
        removeSelected.disabledProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.listClasses.getSelectionModel().getSelectedItems().stream().noneMatch(p -> p != PathClass.NULL_CLASS), (Observable[])new Observable[]{this.listClasses.getSelectionModel().getSelectedItems()}));
        removeSelected.setLongText("Remove the selected classes from the list (this does not change or remove objects)");
        Button btnAdd = ActionUtils.createButton((Action)addNewAction);
        Button btnRemove = ActionUtils.createButton((Action)removeSelected);
        Button btnMore = GuiTools.createMoreButton(this.createClassesMenu(), Side.RIGHT);
        btnMore.setText(null);
        btnMore.setGraphic(IconFactory.createNode(FontAwesome.Glyph.CARET_RIGHT, 12));
        Pane spacer = new Pane();
        spacer.setPrefWidth(4.0);
        return new HBox(new Node[]{btnAdd, btnRemove, btnMore});
    }

    private Pane createClassPane() {
        this.listClasses = new ListView();
        FilteredList filteredList = this.availablePathClasses.filtered(p -> true);
        this.listClasses.setItems((ObservableList)filteredList);
        this.listClasses.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateAutoSetPathClassProperty());
        this.listClasses.setCellFactory(v -> new PathClassListCell(this.qupath));
        this.listClasses.getSelectionModel().select(0);
        this.listClasses.setPrefSize(100.0, 200.0);
        this.listClasses.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.listClasses.addEventFilter(KeyEvent.KEY_PRESSED, this::filterKeyPresses);
        this.listClasses.setOnMouseClicked(e -> {
            if (!e.isPopupTrigger() && e.getClickCount() == 2 && this.promptToEditSelectedClass()) {
                this.availablePathClasses.setAll(this.availablePathClasses.stream().toList());
            }
        });
        ContextMenu popup = this.createSelectedMenu();
        this.listClasses.setContextMenu(popup);
        BorderPane paneClasses = new BorderPane();
        paneClasses.setCenter(this.listClasses);
        Action setSelectedObjectClassAction = new Action("Set selected", e -> this.promptToSetClass());
        setSelectedObjectClassAction.setLongText("Set the class of the currently-selected objects");
        Action autoClassifyAnnotationsAction = new Action("Auto set");
        autoClassifyAnnotationsAction.setLongText("Automatically set all new annotations to the selected class");
        autoClassifyAnnotationsAction.selectedProperty().bindBidirectional((Property)this.doAutoSetPathClass);
        this.doAutoSetPathClass.addListener((e, f, g) -> this.updateAutoSetPathClassProperty());
        Button btnSetClass = ActionUtils.createButton((Action)setSelectedObjectClassAction);
        ToggleButton btnAutoClass = ActionUtils.createToggleButton((Action)autoClassifyAnnotationsAction);
        Button btnMoreObjects = GuiTools.createMoreButton(this.createSelectedMenu(), Side.RIGHT);
        GridPane paneClassButtons = new GridPane();
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        col2.setPercentWidth(50.0);
        paneClassButtons.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col1, col2});
        VBox paneMore = new VBox(new Node[]{btnMoreObjects});
        paneClassButtons.add((Node)btnSetClass, 0, 1);
        paneClassButtons.add((Node)btnAutoClass, 1, 1);
        PredicateTextField filter = new PredicateTextField();
        filter.setPromptText("Filter classes");
        filter.setIgnoreCase(true);
        filter.setUseRegex(true);
        Tooltip.install((Node)filter, (Tooltip)new Tooltip("Type to filter classes in list"));
        filteredList.predicateProperty().bind((ObservableValue)filter.predicateProperty());
        BorderPane paneBottom = new BorderPane((Node)paneClassButtons);
        paneBottom.setTop((Node)filter);
        paneBottom.setRight((Node)paneMore);
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{btnSetClass, btnAutoClass});
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{btnSetClass, btnAutoClass, filter});
        ChoiceBox comboSelectToShow = new ChoiceBox();
        comboSelectToShow.setConverter((StringConverter)new ClassVisibilityConverter());
        comboSelectToShow.getItems().setAll((Object[])OverlayOptions.ClassVisibilityMode.values());
        comboSelectToShow.setMaxWidth(Double.MAX_VALUE);
        Button btnMoreVisible = GuiTools.createMoreButton(this.createVisbilityMenu(), Side.RIGHT);
        BorderPane paneTop = new BorderPane((Node)comboSelectToShow);
        paneTop.setRight((Node)btnMoreVisible);
        comboSelectToShow.valueProperty().bindBidirectional(this.getOverlayOptions().selectedClassVisibilityModeProperty());
        comboSelectToShow.getSelectionModel().selectFirst();
        paneClasses.setTop((Node)paneTop);
        paneClasses.setBottom((Node)paneBottom);
        return paneClasses;
    }

    private void promptToSetClass() {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        PathClass pathClass = this.getSelectedPathClass();
        if (pathClass == PathClass.NULL_CLASS) {
            pathClass = null;
        }
        ArrayList pathObjects = new ArrayList(hierarchy.getSelectionModel().getSelectedObjects());
        ArrayList<PathObject> changed = new ArrayList<PathObject>();
        for (PathObject pathObject : pathObjects) {
            if (pathObject.getPathClass() == pathClass) continue;
            pathObject.setPathClass(pathClass);
            changed.add(pathObject);
        }
        if (!changed.isEmpty()) {
            hierarchy.fireObjectClassificationsChangedEvent((Object)this, changed);
            GuiTools.refreshList(this.listClasses);
        }
    }

    private void filterKeyPresses(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getCode() == KeyCode.SPACE || e.getCode() == KeyCode.T) {
            this.toggleSelectedClassesVisibility();
            e.consume();
            return;
        }
        if (e.getCode() == KeyCode.S) {
            this.setSelectedClassesVisibility(true);
            e.consume();
            return;
        }
        if (e.getCode() == KeyCode.H) {
            this.setSelectedClassesVisibility(false);
            e.consume();
            return;
        }
        if (e.getCode() == KeyCode.BACK_SPACE) {
            this.promptToRemoveSelectedClasses();
            e.consume();
            return;
        }
        if (e.getCode() == KeyCode.ENTER) {
            this.promptToEditSelectedClass();
            e.consume();
            return;
        }
        if (copyCombo.match(e)) {
            String s = this.listClasses.getSelectionModel().getSelectedItems().stream().map(PathClass::toString).collect(Collectors.joining(System.lineSeparator()));
            if (!s.isBlank()) {
                Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, s));
            }
            e.consume();
            return;
        }
        if (pasteCombo.match(e)) {
            logger.debug("Paste not implemented for class list!");
            e.consume();
            return;
        }
    }

    private Action createResetToDefaultClassesAction() {
        return new Action("Reset to default classes", e -> this.promptToResetClasses());
    }

    private Action createImportClassesFromProjectAction() {
        return new Action("Import classes from project", e -> this.promptToImportClasses());
    }

    private BooleanBinding createRemoveClassDisabledBinding() {
        return Bindings.createBooleanBinding(() -> {
            PathClass item = (PathClass)this.listClasses.getSelectionModel().getSelectedItem();
            return item == null || PathClass.NULL_CLASS == item;
        }, (Observable[])new Observable[]{this.listClasses.getSelectionModel().selectedItemProperty()});
    }

    private ContextMenu createClassesMenu() {
        ContextMenu menu = new ContextMenu();
        Action actionResetClasses = this.createResetToDefaultClassesAction();
        Action actionImportClasses = this.createImportClassesFromProjectAction();
        MenuItem miResetAllClasses = ActionUtils.createMenuItem((Action)actionResetClasses);
        MenuItem miPopulateFromImage = new MenuItem("All classes (including sub-classes)");
        miPopulateFromImage.setOnAction(e -> this.promptToPopulateFromImage(false));
        MenuItem miPopulateFromImageBase = new MenuItem("Base classes only");
        miPopulateFromImageBase.setOnAction(e -> this.promptToPopulateFromImage(true));
        MenuItem miPopulateFromChannels = new MenuItem("Populate from image channels");
        miPopulateFromChannels.setOnAction(e -> this.promptToPopulateFromChannels());
        Menu menuPopulate = new Menu("Populate from existing objects");
        menuPopulate.getItems().addAll((Object[])new MenuItem[]{miPopulateFromImage, miPopulateFromImageBase});
        menu.setOnShowing(e -> {
            PathObjectHierarchy hierarchy = this.getHierarchy();
            menuPopulate.setDisable(hierarchy == null);
            miPopulateFromImage.setDisable(hierarchy == null);
            miPopulateFromImageBase.setDisable(hierarchy == null);
            miPopulateFromChannels.setDisable(this.qupath.getImageData() == null);
        });
        MenuItem miImportFromProject = ActionUtils.createMenuItem((Action)actionImportClasses);
        menu.getItems().addAll((Object[])new MenuItem[]{menuPopulate, miPopulateFromChannels, miResetAllClasses, miImportFromProject});
        return menu;
    }

    private ContextMenu createVisbilityMenu() {
        ContextMenu menu = new ContextMenu();
        CheckMenuItem miSelectExact = new CheckMenuItem("Show/hide exact class matches only");
        miSelectExact.selectedProperty().bindBidirectional((Property)this.getOverlayOptions().useExactSelectedClassesProperty());
        MenuItem miResetClassVisibility = new MenuItem("Reset selected classes");
        miResetClassVisibility.setOnAction(e -> this.resetSelectedClassVisibility());
        MenuItem miRestoreClassVisibilityDefaults = new MenuItem("Restore class visibility to default settings");
        miRestoreClassVisibilityDefaults.setOnAction(e -> this.restoreClassVisibilityDefaults());
        menu.getItems().addAll((Object[])new MenuItem[]{miSelectExact, new SeparatorMenuItem(), miResetClassVisibility, miRestoreClassVisibilityDefaults});
        return menu;
    }

    private void resetSelectedClassVisibility() {
        OverlayOptions options = this.getOverlayOptions();
        options.selectedClassesProperty().clear();
    }

    private void restoreClassVisibilityDefaults() {
        OverlayOptions options = this.getOverlayOptions();
        options.setSelectedClassVisibilityMode(OverlayOptions.ClassVisibilityMode.HIDE_SELECTED);
        options.setUseExactSelectedClasses(false);
        options.selectedClassesProperty().clear();
    }

    private ContextMenu createSelectedMenu() {
        ContextMenu menu = new ContextMenu();
        MenuItem miSelectObjects = new MenuItem("Select objects by classification");
        miSelectObjects.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            PathClass item = (PathClass)this.listClasses.getSelectionModel().getSelectedItem();
            return item == null && this.getHierarchy() != null;
        }, (Observable[])new Observable[]{this.listClasses.getSelectionModel().selectedItemProperty(), this.qupath.imageDataProperty()}));
        miSelectObjects.setOnAction(e -> {
            ImageData<BufferedImage> imageData = this.qupath.getImageData();
            if (imageData == null) {
                return;
            }
            Commands.selectObjectsByClassification(imageData, (PathClass[])this.getSelectedPathClasses().toArray(PathClass[]::new));
        });
        menu.getItems().addAll((Object[])new MenuItem[]{miSelectObjects});
        return menu;
    }

    public void refresh() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(this::refresh);
            return;
        }
        this.listClasses.refresh();
    }

    private OverlayOptions getOverlayOptions() {
        return this.qupath.getOverlayOptions();
    }

    private void toggleSelectedClassesVisibility() {
        OverlayOptions overlayOptions = this.getOverlayOptions();
        for (PathClass pathClass : this.getSelectedPathClasses()) {
            overlayOptions.setPathClassHidden(pathClass, !overlayOptions.selectedClassesProperty().contains((Object)pathClass));
        }
        this.listClasses.refresh();
    }

    private void setSelectedClassesVisibility(boolean visible) {
        OverlayOptions overlayOptions = this.qupath.getViewer().getOverlayOptions();
        for (PathClass pathClass : this.getSelectedPathClasses()) {
            overlayOptions.setPathClassHidden(pathClass, !visible);
        }
        this.listClasses.refresh();
    }

    private void updateAutoSetPathClassProperty() {
        PathClass pathClass = null;
        if (this.doAutoSetPathClass.get()) {
            pathClass = this.getSelectedPathClass();
        }
        if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
            PathPrefs.autoSetAnnotationClassProperty().set(null);
        } else {
            PathPrefs.autoSetAnnotationClassProperty().set((Object)pathClass);
        }
    }

    private PathObjectHierarchy getHierarchy() {
        ImageData<BufferedImage> imageData = this.qupath.getImageData();
        return imageData == null ? null : imageData.getHierarchy();
    }

    private boolean promptToPopulateFromChannels() {
        ImageData<BufferedImage> imageData = this.qupath.getImageData();
        if (imageData == null) {
            return false;
        }
        ImageServer server = imageData.getServer();
        ArrayList<PathClass> newClasses = new ArrayList<PathClass>();
        for (ImageChannel channel : server.getMetadata().getChannels()) {
            newClasses.add(PathClass.fromString((String)channel.getName(), (Integer)channel.getColor()));
        }
        if (newClasses.isEmpty()) {
            Dialogs.showErrorMessage((String)"Set available classes", (String)"No channels found, somehow!");
            return false;
        }
        ArrayList<PathClass> currentClasses = new ArrayList<PathClass>((Collection<PathClass>)this.availablePathClasses);
        currentClasses.remove(null);
        if (currentClasses.equals(newClasses)) {
            Dialogs.showInfoNotification((String)"Set available classes", (String)"Class lists are the same - no changes to make!");
            return false;
        }
        newClasses.add(PathClass.StandardPathClasses.IGNORE);
        ButtonType btn = ButtonType.YES;
        if (this.availablePathClasses.size() > 1) {
            btn = Dialogs.showYesNoCancelDialog((String)"Set available classes", (String)"Keep existing available classes?");
        }
        if (btn == ButtonType.YES) {
            newClasses.removeAll((Collection<?>)this.availablePathClasses);
            return this.availablePathClasses.addAll(newClasses);
        }
        if (btn == ButtonType.NO) {
            newClasses.addFirst(PathClass.NULL_CLASS);
            return this.availablePathClasses.setAll(newClasses);
        }
        return false;
    }

    private boolean promptToPopulateFromImage(boolean baseClassesOnly) {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return false;
        }
        List newClasses = hierarchy.getFlattenedObjectList(null).stream().filter(p -> !p.isRootObject()).map(PathObject::getPathClass).filter(p -> p != null && p != PathClass.NULL_CLASS).map(p -> baseClassesOnly ? p.getBaseClass() : p).distinct().sorted().collect(Collectors.toCollection(ArrayList::new));
        if (newClasses.isEmpty()) {
            Dialogs.showErrorMessage((String)"Set available classes", (String)"No classes found in current image!");
            return false;
        }
        newClasses.add(PathClass.StandardPathClasses.IGNORE);
        ArrayList<PathClass> currentClasses = new ArrayList<PathClass>((Collection<PathClass>)this.availablePathClasses);
        currentClasses.remove(null);
        if (currentClasses.equals(newClasses)) {
            Dialogs.showInfoNotification((String)"Set available classes", (String)"Class lists are the same - no changes to make!");
            return false;
        }
        ButtonType btn = ButtonType.YES;
        if (this.availablePathClasses.size() > 1) {
            btn = Dialogs.showYesNoCancelDialog((String)"Set available classes", (String)"Keep existing available classes?");
        }
        if (btn == ButtonType.YES) {
            newClasses.removeAll((Collection<?>)this.availablePathClasses);
            return this.availablePathClasses.addAll((Collection)newClasses);
        }
        if (btn == ButtonType.NO) {
            newClasses.addFirst(PathClass.NULL_CLASS);
            return this.availablePathClasses.setAll((Collection)newClasses);
        }
        return false;
    }

    boolean promptToImportClasses() {
        File file = FileChoosers.promptForFile((String)"Import classifications", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath project", (String[])new String[]{ProjectIO.getProjectExtension()})});
        if (file == null) {
            return false;
        }
        if (!file.getAbsolutePath().toLowerCase().endsWith(ProjectIO.getProjectExtension())) {
            Dialogs.showErrorMessage((String)"Import PathClasses", (String)(file.getName() + " is not a project file!"));
            return false;
        }
        try {
            Project project = ProjectIO.loadProject((File)file, BufferedImage.class);
            List pathClasses = project.getPathClasses();
            if (pathClasses.isEmpty()) {
                Dialogs.showErrorMessage((String)"Import PathClasses", (String)("No classes found in " + file.getName()));
                return false;
            }
            if (pathClasses.size() == this.availablePathClasses.size() && this.availablePathClasses.containsAll((Collection)pathClasses)) {
                Dialogs.showInfoNotification((String)"Import PathClasses", (String)(file.getName() + " contains same classes - no changes to make"));
                return false;
            }
            this.availablePathClasses.setAll((Collection)pathClasses);
            return true;
        }
        catch (Exception ex) {
            Dialogs.showErrorMessage((String)"Error reading project", (Throwable)ex);
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean promptToResetClasses() {
        if (Dialogs.showConfirmDialog((String)"Reset classes", (String)"Reset all available classes?")) {
            return this.qupath.resetAvailablePathClasses();
        }
        return false;
    }

    private boolean promptToAddClass() {
        String input = Dialogs.showInputDialog((String)"Add class", (String)"Class name", (String)"");
        if (input == null || input.trim().isEmpty()) {
            return false;
        }
        PathClass pathClass = PathClass.fromString((String)input);
        if (this.availablePathClasses.contains((Object)pathClass)) {
            Dialogs.showErrorMessage((String)"Add class", (String)("Class '" + input + "' already exists!"));
            return false;
        }
        if (input.equalsIgnoreCase("null")) {
            Dialogs.showErrorMessage((String)"Add class", (String)"Cannot add a 'null' class, try another name!");
            return false;
        }
        this.availablePathClasses.add((Object)pathClass);
        this.listClasses.getSelectionModel().clearAndSelect(this.listClasses.getItems().size() - 1);
        return true;
    }

    private boolean promptToEditSelectedClass() {
        PathClass pathClassSelected = this.getSelectedPathClass();
        if (Commands.promptToEditClass(pathClassSelected)) {
            this.handleClassUpdated();
            return true;
        }
        return false;
    }

    private void handleClassUpdated() {
        GuiTools.refreshList(this.listClasses);
        Project<BufferedImage> project = this.qupath.getProject();
        if (project != null) {
            project.setPathClasses((Collection)this.listClasses.getItems());
        }
        this.qupath.getViewerManager().repaintAllViewers();
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null) {
            hierarchy.fireHierarchyChangedEvent(this.listClasses);
        }
    }

    public Pane getPane() {
        return this.pane;
    }

    ListView<PathClass> getListView() {
        return this.listClasses;
    }

    private boolean promptToRemoveSelectedClasses() {
        List<PathClass> pathClasses = this.getSelectedPathClasses().stream().filter(PathClassPane::isNotNull).toList();
        if (pathClasses.isEmpty()) {
            return false;
        }
        String message = pathClasses.size() == 1 ? "Remove '" + pathClasses.getFirst().toString() + "' from class list?" : "Remove " + pathClasses.size() + " classes from list?";
        if (Dialogs.showConfirmDialog((String)"Remove classes", (String)message)) {
            return this.availablePathClasses.removeAll(pathClasses);
        }
        return false;
    }

    private static boolean isNotNull(PathClass pathClass) {
        return !PathClassPane.isNull(pathClass);
    }

    private static boolean isNull(PathClass pathClass) {
        return pathClass == null || pathClass == PathClass.NULL_CLASS;
    }

    private PathClass getSelectedPathClass() {
        return (PathClass)this.listClasses.getSelectionModel().getSelectedItem();
    }

    private List<PathClass> getSelectedPathClasses() {
        return this.listClasses.getSelectionModel().getSelectedItems().stream().map(p -> p.getName() == null ? null : p).toList();
    }

    private static class ClassVisibilityConverter
    extends StringConverter<OverlayOptions.ClassVisibilityMode> {
        private ClassVisibilityConverter() {
        }

        public String toString(OverlayOptions.ClassVisibilityMode object) {
            return switch (object) {
                default -> throw new MatchException(null, null);
                case OverlayOptions.ClassVisibilityMode.HIDE_SELECTED -> "Show by default";
                case OverlayOptions.ClassVisibilityMode.SHOW_SELECTED -> "Hide by default";
            };
        }

        public OverlayOptions.ClassVisibilityMode fromString(String string) {
            return switch (string) {
                case "Show by default" -> OverlayOptions.ClassVisibilityMode.HIDE_SELECTED;
                case "Hide by default" -> OverlayOptions.ClassVisibilityMode.SHOW_SELECTED;
                default -> null;
            };
        }
    }

    private static class PathClassListCell
    extends ListCell<PathClass> {
        private final QuPathGUI qupath;
        private final OverlayOptions overlayOptions;
        private final BorderPane pane = new BorderPane();
        private final Label label = new Label();
        private final ColorPicker colorPicker = new ColorPicker();
        private final int colorPickerSize = 10;
        private final int eyeSize = 14;
        private final Node iconShowing = new StackPane(new Node[]{IconFactory.createNode(FontAwesome.Glyph.EYE, 14)});
        private final Node iconHidden = new StackPane(new Node[]{IconFactory.createNode(FontAwesome.Glyph.EYE_SLASH, 14)});
        private final Node iconUnavailable = new StackPane(new Node[]{GlyphFontRegistry.font((String)"FontAwesome").create('\uf2a8').size(14.0)});
        private static final String STYLE_HIDDEN = "-fx-font-family:arial; -fx-font-style:italic;";
        private static final String STYLE_SHOWING = "-fx-font-family:arial; -fx-font-style:normal;";
        private DoubleBinding opacityBinding = Bindings.createDoubleBinding(this::calculateOpacity, (Observable[])new Observable[]{this.hoverProperty(), this.selectedProperty(), this.itemProperty()});

        PathClassListCell(QuPathGUI qupath) {
            this.qupath = qupath;
            this.overlayOptions = qupath == null ? null : qupath.getOverlayOptions();
            this.label.setMaxWidth(Double.MAX_VALUE);
            this.label.setMinWidth(20.0);
            this.colorPicker.getStyleClass().addAll((Object[])new String[]{"minimal-color-picker", "always-opaque", "button"});
            this.colorPicker.setStyle("-fx-color-rect-width: 10; -fx-color-rect-height: 10;");
            this.colorPicker.setOnHiding(e -> this.handleColorChange((Color)this.colorPicker.getValue()));
            this.label.setGraphic((Node)this.colorPicker);
            Tooltip tooltip = new Tooltip("Available classes (right-click to add or remove).\nNames ending with an Asterisk* are 'ignored' under certain circumstances - see the docs for more info.");
            this.label.setTooltip(tooltip);
            this.label.setTextOverrun(OverrunStyle.ELLIPSIS);
            StackPane sp = new StackPane(new Node[]{this.label});
            this.label.setMaxWidth(Double.MAX_VALUE);
            sp.setPrefWidth(1.0);
            sp.setMinHeight(0.0);
            StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
            this.pane.setCenter((Node)sp);
            this.configureHiddenIcon();
            this.configureShowingIcon();
            this.configureUnavailableIcon();
        }

        private void handleColorChange(Color color) {
            int rgb;
            PathClass pathClass = (PathClass)this.getItem();
            if (pathClass != null && pathClass != PathClass.NULL_CLASS && !Objects.equals(rgb = ColorToolsFX.getRGB(color), pathClass.getColor())) {
                pathClass.setColor(Integer.valueOf(rgb));
                QuPathGUI qupath = QuPathGUI.getInstance();
                if (qupath != null) {
                    for (QuPathViewer viewer : qupath.getAllViewers()) {
                        PathObjectHierarchy hierarchy = viewer.getHierarchy();
                        if (hierarchy == null) continue;
                        hierarchy.fireHierarchyChangedEvent((Object)pathClass);
                    }
                }
            }
        }

        private void configureHiddenIcon() {
            this.iconHidden.opacityProperty().bind((ObservableValue)this.opacityBinding);
            if (this.overlayOptions != null) {
                Tooltip.install((Node)this.iconHidden, (Tooltip)new Tooltip("Class hidden - click to toggle visibility"));
                this.iconHidden.setOnMouseClicked(this::handleToggleVisibility);
            }
        }

        private void configureShowingIcon() {
            this.iconShowing.opacityProperty().bind((ObservableValue)this.opacityBinding);
            if (this.overlayOptions != null) {
                Tooltip.install((Node)this.iconShowing, (Tooltip)new Tooltip("Class showing - click to toggle visibility"));
                this.iconShowing.setOnMouseClicked(this::handleToggleVisibility);
            }
        }

        private boolean isSelected(PathClass pathClass) {
            return this.overlayOptions.selectedClassesProperty().contains((Object)pathClass);
        }

        private double calculateOpacity() {
            PathClass item = (PathClass)this.getItem();
            if (item == null) {
                return 0.0;
            }
            if (this.isHover() || this.isSelected()) {
                return 0.8;
            }
            OverlayOptions.ClassVisibilityMode mode = this.overlayOptions.getSelectedClassVisibilityMode();
            switch (mode) {
                case HIDE_SELECTED: {
                    if (this.isHidden(item)) {
                        return this.isSelected(item) ? 0.8 : 0.6;
                    }
                    return 0.1;
                }
                case SHOW_SELECTED: {
                    if (this.isHidden(item)) {
                        return 0.4;
                    }
                    return this.isSelected(item) ? 0.8 : 0.6;
                }
            }
            return 1.0;
        }

        private void configureUnavailableIcon() {
            this.iconUnavailable.opacityProperty().bind((ObservableValue)this.opacityBinding);
            if (this.overlayOptions != null) {
                Tooltip.install((Node)this.iconUnavailable, (Tooltip)new Tooltip("Derived class is hidden because a related class is already hidden"));
                this.iconUnavailable.setOnMouseClicked(this::handleToggleVisibility);
            }
        }

        private void handleToggleVisibility(MouseEvent e) {
            PathClass pathClass = (PathClass)this.getItem();
            OverlayOptions options = this.overlayOptions;
            if (pathClass != null && options != null) {
                options.setPathClassHidden(pathClass, !options.selectedClassesProperty().contains((Object)pathClass));
                this.getListView().refresh();
            }
            e.consume();
        }

        private PathObjectHierarchy getHierarchy() {
            ImageData<BufferedImage> imageData = this.qupath == null ? null : this.qupath.getImageData();
            return imageData == null ? null : imageData.getHierarchy();
        }

        private boolean isHidden(PathClass pathClass) {
            return this.overlayOptions != null && this.overlayOptions.isPathClassHidden(pathClass);
        }

        private long getAnnotationCount(PathClass pathClass) {
            PathObjectHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                try {
                    return hierarchy.getAnnotationObjects().stream().filter(p -> pathClass.equals(p.getPathClass())).count();
                }
                catch (Exception e) {
                    logger.debug("Exception while counting objects for class", (Throwable)e);
                }
            }
            return -1L;
        }

        private String getText(PathClass pathClass) {
            if (pathClass.getBaseClass() == pathClass && pathClass.getName() == null) {
                return "None";
            }
            long n = this.getAnnotationCount(pathClass);
            if (n > 0L) {
                return String.valueOf(pathClass) + " (" + n + ")";
            }
            return pathClass.toString();
        }

        private Color getColor(PathClass pathClass) {
            Integer rgb = pathClass.getColor();
            if (rgb == null || PathClassTools.isNullClass((PathClass)pathClass)) {
                return Color.TRANSPARENT;
            }
            return ColorToolsFX.getPathClassColor(pathClass);
        }

        protected void updateItem(PathClass value, boolean empty) {
            super.updateItem((Object)value, empty);
            if (value == null || empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.colorPicker.setValue((Object)this.getColor(value));
            this.colorPicker.setDisable(value == PathClass.NULL_CLASS);
            String text = this.getText(value);
            OverlayOptions.ClassVisibilityMode mode = this.overlayOptions.getSelectedClassVisibilityMode();
            if (this.isHidden(value)) {
                this.label.setStyle(STYLE_HIDDEN);
                if (value == PathClass.NULL_CLASS) {
                    this.pane.setRight(this.iconHidden);
                } else if (mode == OverlayOptions.ClassVisibilityMode.HIDE_SELECTED && !this.isSelected(value)) {
                    this.pane.setRight(this.iconUnavailable);
                } else {
                    this.pane.setRight(this.iconHidden);
                }
            } else {
                this.label.setStyle(STYLE_SHOWING);
                this.pane.setRight(this.iconShowing);
            }
            this.label.setText(text);
            this.setGraphic((Node)this.pane);
        }
    }
}

