/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.io.GsonTools;

public class ObjectTreeBrowser {
    private static final Logger logger = LoggerFactory.getLogger(ObjectTreeBrowser.class);

    private static <T> TreeTableView<T> createTreeTable() {
        TreeTableView treeTable = new TreeTableView();
        TreeTableColumn colName = new TreeTableColumn("Key");
        colName.setCellValueFactory(c -> {
            if (c.getValue() instanceof ObjectTreeItem) {
                return new ReadOnlyObjectWrapper((Object)((ObjectTreeItem)c.getValue()).getName());
            }
            return new ReadOnlyObjectWrapper();
        });
        TreeTableColumn colValue = new TreeTableColumn("Value");
        colValue.setCellValueFactory(c -> {
            if (c.getValue() instanceof ObjectTreeItem) {
                return new ReadOnlyObjectWrapper((Object)String.valueOf(((ObjectTreeItem)c.getValue()).getValue()));
            }
            return new ReadOnlyObjectWrapper();
        });
        treeTable.getColumns().add((Object)colName);
        treeTable.getColumns().add((Object)colValue);
        treeTable.setColumnResizePolicy(TreeTableView.CONSTRAINED_RESIZE_POLICY);
        treeTable.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem miRefresh = new MenuItem("Refresh");
        miRefresh.setOnAction(e -> {
            for (int i = 0; i < treeTable.getExpandedItemCount(); ++i) {
                TreeItem item = treeTable.getTreeItem(i);
                if (!(item instanceof ReflectiveObjectTreeItem)) continue;
                ((ReflectiveObjectTreeItem)item).invalidate();
            }
            treeTable.refresh();
        });
        menu.getItems().add((Object)miRefresh);
        treeTable.setContextMenu(menu);
        return treeTable;
    }

    public static TreeTableView<Object> createObjectTreeBrowser(String name, Object object) {
        TreeTableView tree = ObjectTreeBrowser.createTreeTable();
        Class<?> cls = object == null ? null : object.getClass();
        tree.setRoot((TreeItem)new ReflectiveObjectTreeItem(name, cls, object));
        return tree;
    }

    public static TreeTableView<JsonElement> createJsonTreeBrowser(String name, Object object) {
        JsonElement element = object instanceof JsonElement ? (JsonElement)object : GsonTools.getInstance().toJsonTree(object);
        TreeTableView tree = ObjectTreeBrowser.createTreeTable();
        tree.setRoot((TreeItem)new JsonTreeItem(name, element));
        return tree;
    }

    static class ReflectiveObjectTreeItem
    extends ObjectTreeItem<Object> {
        private static Set<Class<?>> leafClasses = new HashSet<Class>(Arrays.asList(Enum.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, Array.class));
        private Class<?> cls;
        private boolean isLeaf = false;
        private boolean childrenComputed = false;

        private ReflectiveObjectTreeItem(String name, Class<?> cls, Object object) {
            super(name, object);
            this.cls = cls;
            boolean bl = this.isLeaf = object == null || cls.isPrimitive() || leafClasses.contains(cls) || cls.isArray() && Array.getLength(object) > 100;
            if (!this.isLeaf) {
                for (Class<?> leafClass : leafClasses) {
                    if (!leafClass.isInstance(object)) continue;
                    this.isLeaf = true;
                    break;
                }
            }
        }

        private static Map<String, Field> getAllFields(Map<String, Field> fields, Class<?> type) {
            if (fields == null) {
                fields = new TreeMap<String, Field>();
            }
            for (Field f : type.getDeclaredFields()) {
                if (fields.containsKey(f.getName())) continue;
                fields.put(f.getName(), f);
            }
            if (type.getSuperclass() != null) {
                fields = ReflectiveObjectTreeItem.getAllFields(fields, type.getSuperclass());
            }
            return fields;
        }

        public void invalidate() {
            this.childrenComputed = false;
        }

        public ObservableList<TreeItem<Object>> getChildren() {
            if (!this.isLeaf() && !this.childrenComputed) {
                ArrayList<ReflectiveObjectTreeItem> children = new ArrayList<ReflectiveObjectTreeItem>();
                Object object = this.getValue();
                for (Field f : ReflectiveObjectTreeItem.getAllFields(null, this.cls).values()) {
                    try {
                        boolean tempAccessible = false;
                        if (!f.canAccess(object)) {
                            f.setAccessible(true);
                            tempAccessible = true;
                        }
                        Object child = f.get(object);
                        children.add(new ReflectiveObjectTreeItem(f.getName(), child == null ? f.getType() : child.getClass(), child));
                        if (!tempAccessible) continue;
                        f.setAccessible(false);
                    }
                    catch (Exception e) {
                        logger.trace("Exception accessing field {} of {}: {}", new Object[]{f, object, e.getLocalizedMessage()});
                    }
                }
                if (this.cls.isArray()) {
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object child = Array.get(object, i);
                        children.add(new ReflectiveObjectTreeItem(this.name + "[" + i + "]", child == null ? Object.class : child.getClass(), child));
                    }
                }
                this.childrenComputed = true;
                super.getChildren().setAll(children);
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    static class JsonTreeItem
    extends ObjectTreeItem<JsonElement> {
        private boolean isLeaf = false;
        private boolean childrenComputed = false;

        private JsonTreeItem(String name, JsonElement object) {
            super(name, object);
            this.isLeaf = object == null || object.isJsonPrimitive() || object.isJsonNull();
        }

        public ObservableList<TreeItem<JsonElement>> getChildren() {
            if (!this.isLeaf() && !this.childrenComputed) {
                ArrayList<JsonTreeItem> children = new ArrayList<JsonTreeItem>();
                JsonElement object = (JsonElement)this.getValue();
                if (object.isJsonArray()) {
                    JsonArray array = object.getAsJsonArray();
                    for (int i = 0; i < array.size(); ++i) {
                        children.add(new JsonTreeItem(Integer.toString(i), array.get(i)));
                    }
                } else if (object.isJsonObject()) {
                    for (Map.Entry entry : object.getAsJsonObject().entrySet()) {
                        children.add(new JsonTreeItem((String)entry.getKey(), (JsonElement)entry.getValue()));
                    }
                }
                this.childrenComputed = true;
                super.getChildren().setAll(children);
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    static class ObjectTreeItem<T>
    extends TreeItem<T> {
        protected String name;

        private ObjectTreeItem(String name, T object) {
            super(object);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + ": " + String.valueOf(this.getValue());
        }
    }
}

