/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.PathObjectLabels;
import qupath.lib.gui.tools.WebViews;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;

public class ObjectDescriptionPane<T> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectDescriptionPane.class);
    private ObservableValue<ImageData<T>> imageData;
    private ObjectObserver<T> observer;
    private BorderPane pane;
    private PathObjectLabels.PathObjectMiniPane pathObjectPane;
    private MarkdownConverter converter = new MarkdownConverter();
    private WebView webview = WebViews.create(true);

    private ObjectDescriptionPane(ObservableValue<ImageData<T>> imageData, boolean includeTitle) {
        this.imageData = imageData;
        this.observer = new ObjectObserver<T>(imageData);
        this.observer.selectedObjectProperty().addListener((v, o, n) -> this.updateItem());
        this.observer.addHierarchyListener(event -> this.updateItem());
        this.pane = new BorderPane();
        this.pane.setCenter((Node)this.webview);
        if (includeTitle) {
            this.pathObjectPane = PathObjectLabels.createPane();
            Pane title = this.pathObjectPane.getNode();
            title.setStyle("-fx-padding: 5 10 5 5;");
            BorderPane topPane = new BorderPane((Node)this.pathObjectPane.getNode());
            topPane.setStyle("-fx-padding: 5px; -fx-border-color: -fx-body-color;");
            Button btnEdit = new Button("Edit");
            btnEdit.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                PathObject selected = (PathObject)this.observer.selectedObjectProperty().get();
                return !(selected instanceof PathAnnotationObject);
            }, (Observable[])new Observable[]{this.observer.selectedObjectProperty()}));
            btnEdit.setOnAction(e -> GuiTools.promptToSetActiveAnnotationProperties((PathObjectHierarchy)this.observer.hierarchyProperty().get()));
            btnEdit.setTooltip(new Tooltip("Edit properties (only available for annotations)"));
            BorderPane.setAlignment((Node)btnEdit, (Pos)Pos.CENTER_RIGHT);
            topPane.setRight((Node)btnEdit);
            this.pane.setTop((Node)topPane);
        } else {
            this.pane.setCenter((Node)this.webview);
        }
        this.webview.setPageFill(Color.TRANSPARENT);
        this.webview.setFontScale(0.9);
        this.updateItem();
    }

    private Pane getPane() {
        return this.pane;
    }

    public static <T> Pane createPane(ObservableValue<ImageData<T>> imageData) {
        return new ObjectDescriptionPane<T>(imageData, false).getPane();
    }

    public static <T> Pane createPane(ObservableValue<ImageData<T>> imageData, boolean includeCell) {
        return new ObjectDescriptionPane<T>(imageData, includeCell).getPane();
    }

    public static <T> Stage createWindow(QuPathGUI qupath) {
        Pane pane = ObjectDescriptionPane.createPane(qupath.imageDataProperty(), true);
        Scene scene = new Scene((Parent)pane);
        Stage stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        stage.setScene(scene);
        stage.initOwner((Window)qupath.getStage());
        stage.setTitle("Object description");
        return stage;
    }

    private void updateItem() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(this::updateItem);
            return;
        }
        PathObject n = null;
        if (this.observer != null && (n = (PathObject)this.observer.selectedObjectProperty().get()) == null) {
            PathObjectHierarchy hierarchy = (PathObjectHierarchy)this.observer.hierarchyProperty().get();
            n = hierarchy == null ? null : hierarchy.getRootObject();
        }
        logger.debug("Updating details pane for {}", n);
        PathAnnotationObject annotation = n == null || !n.isAnnotation() ? null : (PathAnnotationObject)n;
        String description = annotation == null ? null : annotation.getDescription();
        WebEngine engine = this.webview.getEngine();
        if (description == null) {
            String msg = "No description available";
            msg = n == null ? "No object selected" : (!n.isAnnotation() ? "Selected object doesn't support descriptions" : "No description set");
            String spanString = "<span style=\"color: rgba(127, 127, 127, 0.8);\">%s</span>";
            engine.loadContent(String.format(spanString, msg));
        } else {
            if (description.startsWith("https://")) {
                engine.load(description.strip());
                return;
            }
            String html = description.trim().startsWith("<html>") ? description : this.converter.toHtml(description);
            engine.loadContent(html);
        }
        if (this.pathObjectPane != null) {
            this.pathObjectPane.setPathObject(n);
        }
    }

    static class MarkdownConverter {
        private Map<String, String> cache = new WeakHashMap<String, String>();
        private Parser parser = Parser.builder().build();
        private HtmlRenderer renderer = HtmlRenderer.builder().build();

        MarkdownConverter() {
        }

        public String toHtml(String markdown) {
            if (markdown == null) {
                return "";
            }
            return this.cache.computeIfAbsent(markdown, this::convertToHtml);
        }

        private String convertToHtml(String markdown) {
            org.commonmark.node.Node doc = this.parser.parse(markdown);
            return this.renderer.render(doc);
        }
    }

    static class ObjectObserver<T>
    implements PathObjectSelectionListener,
    ChangeListener<PathObjectHierarchy>,
    PathObjectHierarchyListener {
        private ObservableValue<ImageData<T>> imageDataOriginal;
        private ObjectProperty<ImageData<T>> imageDataProperty = new SimpleObjectProperty();
        private ObjectBinding<PathObjectHierarchy> hierarchyBinding = Bindings.createObjectBinding(() -> {
            ImageData imageData2 = (ImageData)this.imageDataProperty.get();
            return imageData2 == null ? null : imageData2.getHierarchy();
        }, (Observable[])new Observable[]{this.imageDataProperty});
        private ObjectProperty<PathObjectHierarchy> hierarchyProperty = new SimpleObjectProperty();
        private ObjectProperty<PathObject> selectedObject = new SimpleObjectProperty();
        private ObservableList<PathObject> selectedObjects = FXCollections.observableArrayList();
        private ObservableList<PathObject> selectedObjectsUnmodifiable = FXCollections.unmodifiableObservableList(this.selectedObjects);
        private List<PathObjectHierarchyListener> hierarchyListeners = new ArrayList<PathObjectHierarchyListener>();

        private ObjectObserver(ObservableValue<ImageData<T>> imageData) {
            this.imageDataOriginal = imageData;
            this.hierarchyProperty.bind(this.hierarchyBinding);
            this.hierarchyProperty.addListener((ChangeListener)this);
            this.imageDataProperty.set((Object)((ImageData)this.imageDataOriginal.getValue()));
            this.imageDataOriginal.addListener((v, o, n) -> this.imageDataProperty.set(n));
        }

        public ReadOnlyObjectProperty<ImageData<T>> imageDataProperty() {
            return this.imageDataProperty;
        }

        public ReadOnlyObjectProperty<PathObjectHierarchy> hierarchyProperty() {
            return this.hierarchyProperty;
        }

        public ReadOnlyObjectProperty<PathObject> selectedObjectProperty() {
            return this.selectedObject;
        }

        public ObservableList<PathObject> selectedObjectsProperty() {
            return this.selectedObjectsUnmodifiable;
        }

        public void addHierarchyListener(PathObjectHierarchyListener listener) {
            this.hierarchyListeners.add(listener);
        }

        public void removeHierarchyListener(PathObjectHierarchyListener listener) {
            this.hierarchyListeners.remove(listener);
        }

        public void selectedPathObjectChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
            this.selectedObject.set((Object)pathObjectSelected);
            this.selectedObjects.setAll(allSelected);
        }

        public void changed(ObservableValue<? extends PathObjectHierarchy> observable, PathObjectHierarchy oldValue, PathObjectHierarchy newValue) {
            if (oldValue != null) {
                oldValue.removeListener((PathObjectHierarchyListener)this);
                oldValue.getSelectionModel().removePathObjectSelectionListener((PathObjectSelectionListener)this);
            }
            if (newValue != null) {
                newValue.addListener((PathObjectHierarchyListener)this);
                newValue.getSelectionModel().addPathObjectSelectionListener((PathObjectSelectionListener)this);
                this.selectedObject.set((Object)newValue.getSelectionModel().getSelectedObject());
                this.selectedObjects.setAll((Collection)newValue.getSelectionModel().getSelectedObjects());
            } else {
                this.selectedObject.set(null);
                this.selectedObjects.clear();
            }
        }

        public void hierarchyChanged(PathObjectHierarchyEvent event) {
            for (PathObjectHierarchyListener listener : this.hierarchyListeners) {
                listener.hierarchyChanged(event);
            }
        }
    }
}

