/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.color.ColorMaps;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.UserDirectoryManager;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.MeasurementMapper;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

public class MeasurementMapPane {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementMapPane.class);
    private QuPathGUI qupath;
    private Map<String, MeasurementMapper> mapperMap = new HashMap<String, MeasurementMapper>();
    private BorderPane pane = new BorderPane();
    private ObservableList<ColorMaps.ColorMap> colorMaps = FXCollections.observableArrayList();
    private ObservableValue<ColorMaps.ColorMap> selectedColorMap;
    private ObservableList<String> baseList = FXCollections.observableArrayList();
    private FilteredList<String> filteredList = new FilteredList(this.baseList);
    private ListView<String> listMeasurements = new ListView(this.filteredList);
    private Slider sliderMin = new Slider(0.0, 1.0, 0.0);
    private Slider sliderMax = new Slider(0.0, 1.0, 1.0);
    private CheckBox cbExcludeOutside = new CheckBox("Exclude outside range");
    private Canvas colorMapKey;
    private Image colorMapKeyImage;
    private Label labelMin = new Label("");
    private Label labelMax = new Label("");
    private MeasurementMapper mapper = null;
    private BooleanProperty showMap;
    private boolean updatingSliders = false;
    private static StringProperty preferredMapperName = PathPrefs.createPersistentPreference("measurementMapperLUT", ColorMaps.getDefaultColorMap().getName());

    public MeasurementMapPane(QuPathGUI qupath) {
        this.qupath = qupath;
        logger.trace("Creating Measurement Map Pane");
        ColorMaps.installColorMaps((Path[])((Path[])MeasurementMapPane.getUserColormapPaths().toArray(Path[]::new)));
        this.colorMaps.setAll(ColorMaps.getColorMaps().values());
        this.updateMeasurements();
        this.cbExcludeOutside.setSelected(false);
        ToggleButton toggleShowMap = new ToggleButton("Show map");
        toggleShowMap.setTooltip(new Tooltip("Show/hide the map"));
        toggleShowMap.setSelected(true);
        this.showMap = toggleShowMap.selectedProperty();
        this.showMap.addListener((v, o, n) -> this.updateMap());
        this.listMeasurements.getSelectionModel().selectedItemProperty().addListener((e, f, g) -> this.updateMap());
        this.listMeasurements.setTooltip(new Tooltip("List of available measurements"));
        this.pane.setCenter(this.listMeasurements);
        this.cbExcludeOutside.selectedProperty().addListener((e, f, g) -> this.updateDisplay());
        this.sliderMin.valueProperty().addListener((e, f, g) -> this.updateDisplay());
        this.sliderMax.valueProperty().addListener((e, f, g) -> this.updateDisplay());
        this.sliderMin.setTooltip(new Tooltip("Min display value"));
        this.sliderMax.setTooltip(new Tooltip("Max display value"));
        BorderPane panelLabels = new BorderPane();
        this.labelMax.setTextAlignment(TextAlignment.RIGHT);
        this.labelMin.setTextAlignment(TextAlignment.LEFT);
        this.labelMin.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> MeasurementMapPane.setSliderValue(this.sliderMin, "Set minimum display"));
        this.labelMax.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> MeasurementMapPane.setSliderValue(this.sliderMax, "Set maximum display"));
        panelLabels.setLeft((Node)this.labelMin);
        panelLabels.setRight((Node)this.labelMax);
        Button btnRefresh = new Button("Update map");
        btnRefresh.setTooltip(new Tooltip("Update map data & recompute the min/max settings used to display colors"));
        btnRefresh.setOnAction(e -> {
            this.updateMeasurements();
            this.mapperMap.clear();
            this.updateMap();
        });
        final double canvasHeight = 10.0;
        this.colorMapKey = new Canvas(){

            public double minHeight(double width) {
                return canvasHeight;
            }

            public double maxHeight(double width) {
                return canvasHeight;
            }

            public double prefHeight(double width) {
                return canvasHeight;
            }

            public double minWidth(double width) {
                return 0.0;
            }

            public double maxWidth(double width) {
                return Double.MAX_VALUE;
            }

            public boolean isResizable() {
                return true;
            }

            public void resize(double width, double height) {
                super.setWidth(width);
                super.setHeight(height);
                MeasurementMapPane.this.updateColorMapperKey();
            }
        };
        Tooltip.install((Node)this.colorMapKey, (Tooltip)new Tooltip("Measurement map key"));
        ContextMenu colorMapContextMenu = new ContextMenu();
        MenuItem copyColorMap = new MenuItem("Copy");
        copyColorMap.setOnAction(event -> {
            if (this.colorMapKeyImage != null) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putImage(this.colorMapKeyImage);
                clipboard.setContent((Map)content);
                Dialogs.showInfoNotification((String)"Color map", (String)"Color map copied to clipboard");
            }
        });
        colorMapContextMenu.getItems().add((Object)copyColorMap);
        this.colorMapKey.setOnMousePressed(event -> {
            if (event.isSecondaryButtonDown()) {
                colorMapContextMenu.show((Node)this.pane, event.getScreenX(), event.getScreenY());
            }
        });
        PredicateTextField tfFilter = new PredicateTextField();
        Tooltip tooltip = new Tooltip("Enter text to filter measurement list");
        Tooltip.install((Node)tfFilter, (Tooltip)tooltip);
        tfFilter.setPromptText("Filter measurement list");
        this.filteredList.predicateProperty().bind((ObservableValue)tfFilter.predicateProperty());
        BorderPane paneFilter = new BorderPane();
        paneFilter.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        paneFilter.setCenter((Node)tfFilter);
        ComboBox comboMapper = new ComboBox(this.colorMaps);
        this.selectedColorMap = comboMapper.getSelectionModel().selectedItemProperty();
        String name = (String)preferredMapperName.get();
        if (name != null) {
            for (ColorMaps.ColorMap mapper : this.colorMaps) {
                if (!name.equalsIgnoreCase(mapper.getName())) continue;
                comboMapper.getSelectionModel().select((Object)mapper);
                break;
            }
        }
        if (comboMapper.getSelectionModel().isEmpty() && !comboMapper.getItems().isEmpty()) {
            comboMapper.getSelectionModel().selectFirst();
        }
        comboMapper.setTooltip(new Tooltip("Select color map"));
        this.selectedColorMap.addListener((v, o, n) -> {
            this.updateMap();
            if (n != null) {
                preferredMapperName.set((Object)n.getName());
            }
        });
        comboMapper.setMaxWidth(Double.MAX_VALUE);
        VBox vbButtons = new VBox(new Node[]{paneFilter, comboMapper, this.sliderMin, this.sliderMax, this.colorMapKey, panelLabels, btnRefresh, toggleShowMap});
        vbButtons.setSpacing(2.0);
        this.sliderMin.setMaxWidth(Double.MAX_VALUE);
        this.sliderMax.setMaxWidth(Double.MAX_VALUE);
        panelLabels.setMaxWidth(Double.MAX_VALUE);
        btnRefresh.setMaxWidth(Double.MAX_VALUE);
        toggleShowMap.setMaxWidth(Double.MAX_VALUE);
        vbButtons.setFillWidth(true);
        this.pane.setBottom((Node)vbButtons);
        this.pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
    }

    private static Collection<Path> getUserColormapPaths() {
        Path dirUser = UserDirectoryManager.getInstance().getColormapsDirectoryPath();
        if (dirUser != null && Files.isDirectory(dirUser, new LinkOption[0])) {
            return Collections.singletonList(dirUser);
        }
        return Collections.emptyList();
    }

    static void setSliderValue(Slider slider, String message) {
        Double val = Dialogs.showInputDialog((String)"Measurement mapper", (String)message, (Double)slider.getValue());
        if (val != null && Double.isFinite(val)) {
            if (val > slider.getMax()) {
                slider.setMax(val.doubleValue());
            } else if (val < slider.getMin()) {
                slider.setMin(val.doubleValue());
            }
            slider.setValue(val.doubleValue());
        }
    }

    public Pane getPane() {
        return this.pane;
    }

    private void updateMap() {
        if (this.showMap.get()) {
            this.showMap();
        } else {
            this.hideMap();
        }
    }

    private void showMap() {
        String measurement = (String)this.listMeasurements.getSelectionModel().getSelectedItem();
        QuPathViewer viewer = this.qupath.getViewer();
        if (viewer == null || measurement == null) {
            return;
        }
        this.mapper = this.mapperMap.get(measurement);
        ColorMaps.ColorMap colorMapper = (ColorMaps.ColorMap)this.selectedColorMap.getValue();
        if (this.mapper == null) {
            this.mapper = new MeasurementMapper(colorMapper, measurement, viewer.getHierarchy().getObjects(null, null));
            if (this.mapper.isValid()) {
                this.mapperMap.put(measurement, this.mapper);
            }
        } else if (colorMapper != null) {
            this.mapper.setColorMapper(colorMapper);
        }
        if (this.mapper != null && this.mapper.isValid()) {
            this.updatingSliders = true;
            this.sliderMin.setMin(Math.min(this.mapper.getDataMinValue(), this.mapper.getDisplayMinValue()));
            this.sliderMin.setMax(Math.max(this.mapper.getDataMaxValue(), this.mapper.getDisplayMaxValue()));
            this.sliderMin.setValue(this.mapper.getDisplayMinValue());
            this.sliderMin.setBlockIncrement((this.sliderMin.getMax() - this.sliderMin.getMin()) / 100.0);
            this.sliderMax.setMin(Math.min(this.mapper.getDataMinValue(), this.mapper.getDisplayMinValue()));
            this.sliderMax.setMax(Math.max(this.mapper.getDataMaxValue(), this.mapper.getDisplayMaxValue()));
            this.sliderMax.setValue(this.mapper.getDisplayMaxValue());
            this.sliderMax.setBlockIncrement((this.sliderMax.getMax() - this.sliderMax.getMin()) / 100.0);
            this.updatingSliders = false;
        }
        this.colorMapKeyImage = MeasurementMapPane.createPanelKey(this.mapper.getColorMapper());
        this.updateColorMapperKey();
        this.mapper.setExcludeOutsideRange(this.cbExcludeOutside.isSelected());
        viewer.forceOverlayUpdate();
        this.updateMapperBrightnessContrast();
        OverlayOptions overlayOptions = viewer.getOverlayOptions();
        if (overlayOptions != null) {
            overlayOptions.setMeasurementMapper(this.mapper);
        }
    }

    private void updateColorMapperKey() {
        GraphicsContext gc = this.colorMapKey.getGraphicsContext2D();
        double w = this.colorMapKey.getWidth();
        double h = this.colorMapKey.getHeight();
        gc.clearRect(0.0, 0.0, w, h);
        if (this.colorMapKeyImage != null) {
            gc.drawImage(this.colorMapKeyImage, 0.0, 0.0, this.colorMapKeyImage.getWidth(), this.colorMapKeyImage.getHeight(), 0.0, 0.0, w, h);
        }
    }

    private void updateMapperBrightnessContrast() {
        if (this.mapper == null || this.updatingSliders) {
            return;
        }
        double minValue = this.sliderMin.getValue();
        double maxValue = this.sliderMax.getValue();
        this.labelMin.setText(String.format("%.2f", minValue));
        this.labelMax.setText(String.format("%.2f", maxValue));
        this.mapper.setDisplayMinValue(minValue);
        this.mapper.setDisplayMaxValue(maxValue);
        this.mapper.setExcludeOutsideRange(this.cbExcludeOutside.isSelected());
    }

    private void hideMap() {
        OverlayOptions overlayOptions;
        QuPathViewer viewer = this.qupath.getViewer();
        if (viewer != null && (overlayOptions = viewer.getOverlayOptions()) != null) {
            overlayOptions.resetMeasurementMapper();
        }
    }

    public void updateMeasurements() {
        QuPathViewer viewer = this.qupath.getViewer();
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        if (hierarchy == null) {
            this.baseList.clear();
            return;
        }
        Collection pathObjects = hierarchy.getDetectionObjects();
        Set measurements = PathObjectTools.getAvailableFeatures((Collection)pathObjects);
        for (PathObject pathObject : pathObjects) {
            if (Double.isNaN(pathObject.getClassProbability())) continue;
            measurements.add("Class probability");
            break;
        }
        this.baseList.setAll((Collection)measurements);
    }

    private void updateDisplay() {
        this.updateMapperBrightnessContrast();
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            viewer.forceOverlayUpdate();
        }
    }

    private static Image createPanelKey(ColorMaps.ColorMap colorMapper) {
        BufferedImage imgKey = new BufferedImage(255, 10, 2);
        if (colorMapper != null) {
            for (int i = 0; i < imgKey.getWidth(); ++i) {
                Integer rgb = colorMapper.getColor((double)i, 0.0, 254.0);
                for (int j = 0; j < imgKey.getHeight(); ++j) {
                    imgKey.setRGB(i, j, rgb);
                }
            }
        }
        WritableImage img = SwingFXUtils.toFXImage((BufferedImage)imgKey, null);
        return img;
    }
}

