/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.control.MasterDetailPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.panes.SimpleImageViewer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;
import qupath.lib.scripting.QP;

public class ImageDetailsPane
implements ChangeListener<ImageData<BufferedImage>>,
PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ImageDetailsPane.class);
    private ImageData<BufferedImage> imageData;
    private StackPane pane = new StackPane();
    private TableView<ImageDetailRow> table = new TableView();
    private ListView<String> listAssociatedImages = new ListView();
    private Map<String, SimpleImageViewer> associatedImageViewers = new HashMap<String, SimpleImageViewer>();
    private static List<ImageDetailRow> brightfieldRows = Arrays.asList(ImageDetailRow.values());
    private static List<ImageDetailRow> otherRows = new ArrayList<ImageDetailRow>(brightfieldRows);

    public ImageDetailsPane(ObservableValue<ImageData<BufferedImage>> imageDataProperty) {
        imageDataProperty.addListener((ChangeListener)this);
        this.table.setPlaceholder((Node)GuiTools.createPlaceholderText("No image selected"));
        this.table.setMinHeight(200.0);
        this.table.setPrefHeight(250.0);
        this.table.setMaxHeight(Double.MAX_VALUE);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn columnName = new TableColumn("Name");
        columnName.setCellValueFactory(v -> new ReadOnlyStringWrapper(this.getName((ImageDetailRow)((Object)((Object)v.getValue())))));
        columnName.setEditable(false);
        columnName.setPrefWidth(150.0);
        TableColumn columnValue = new TableColumn("Value");
        columnValue.setCellValueFactory(v -> new ReadOnlyObjectWrapper(this.getValue((ImageDetailRow)((Object)((Object)v.getValue())))));
        columnValue.setEditable(false);
        columnValue.setPrefWidth(200.0);
        columnValue.setCellFactory(c -> new ImageDetailTableCell(imageDataProperty));
        this.table.getColumns().add((Object)columnName);
        this.table.getColumns().add((Object)columnValue);
        this.setImageData((ImageData<BufferedImage>)((ImageData)imageDataProperty.getValue()));
        this.listAssociatedImages.setOnMouseClicked(this::handleAssociatedImagesMouseClick);
        PathPrefs.maskImageNamesProperty().addListener((v, o, n) -> this.table.refresh());
        MasterDetailPane mdPane = new MasterDetailPane(Side.BOTTOM);
        mdPane.setMasterNode((Node)new StackPane(new Node[]{this.table}));
        TitledPane titlePaneAssociated = new TitledPane("Associated images", this.listAssociatedImages);
        titlePaneAssociated.setCollapsible(false);
        this.listAssociatedImages.setTooltip(new Tooltip("Extra images associated with the current image, e.g. a label or thumbnail"));
        mdPane.setDetailNode((Node)titlePaneAssociated);
        mdPane.showDetailNodeProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.listAssociatedImages.getItems().isEmpty(), (Observable[])new Observable[]{this.listAssociatedImages.getItems()}));
        this.pane.getChildren().add((Object)mdPane);
    }

    private void handleAssociatedImagesMouseClick(MouseEvent event) {
        if (event.getClickCount() < 2 || this.listAssociatedImages.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        String name = (String)this.listAssociatedImages.getSelectionModel().getSelectedItem();
        SimpleImageViewer simpleViewer = this.associatedImageViewers.get(name);
        if (simpleViewer == null) {
            simpleViewer = new SimpleImageViewer();
            BufferedImage img = (BufferedImage)this.imageData.getServer().getAssociatedImage(name);
            simpleViewer.updateImage(name, img);
            Stage stage = simpleViewer.getStage();
            Window owner = FXUtils.getWindow((Node)this.getPane());
            stage.initOwner(owner);
            stage.setOnCloseRequest(e -> {
                this.associatedImageViewers.remove(name);
                stage.close();
                e.consume();
            });
            GuiTools.showWithScreenSizeConstraints(stage, 0.8);
            this.associatedImageViewers.put(name, simpleViewer);
        } else {
            simpleViewer.getStage().show();
            simpleViewer.getStage().toFront();
        }
    }

    private static boolean hasOriginalMetadata(ImageServer<BufferedImage> server) {
        ImageServerMetadata metadata = server.getMetadata();
        ImageServerMetadata originalMetadata = server.getOriginalMetadata();
        return Objects.equals(metadata, originalMetadata);
    }

    private static boolean promptToResetServerMetadata(ImageData<BufferedImage> imageData) {
        ImageServer server = imageData.getServer();
        if (ImageDetailsPane.hasOriginalMetadata((ImageServer<BufferedImage>)server)) {
            logger.info("ImageServer metadata is unchanged!");
            return false;
        }
        ImageServerMetadata originalMetadata = server.getOriginalMetadata();
        if (Dialogs.showConfirmDialog((String)"Reset metadata", (String)"Reset to original metadata?")) {
            imageData.updateServerMetadata(originalMetadata);
            return true;
        }
        return false;
    }

    private static boolean promptToSetMagnification(ImageData<BufferedImage> imageData) {
        ImageServer server = imageData.getServer();
        Double mag = server.getMetadata().getMagnification();
        Double mag2 = Dialogs.showInputDialog((String)"Set magnification", (String)"Set magnification for full resolution image", (Double)mag);
        if (mag2 == null || Double.isInfinite(mag) || Objects.equals(mag, mag2)) {
            return false;
        }
        ImageServerMetadata metadata2 = new ImageServerMetadata.Builder(server.getMetadata()).magnification(mag2.doubleValue()).build();
        imageData.updateServerMetadata(metadata2);
        return true;
    }

    private static boolean promptToSetPixelSize(ImageData<BufferedImage> imageData, boolean requestZSpacing) {
        ImageServer server = imageData.getServer();
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        ROI roi = selected == null ? null : selected.getROI();
        PixelCalibration cal = server.getPixelCalibration();
        double pixelWidthMicrons = cal.getPixelWidthMicrons();
        double pixelHeightMicrons = cal.getPixelHeightMicrons();
        double zSpacingMicrons = cal.getZSpacingMicrons();
        if (!requestZSpacing && roi != null && !roi.isEmpty() && (roi.isArea() || roi.isLine())) {
            String message;
            boolean setPixelHeight = true;
            boolean setPixelWidth = true;
            Object units = GeneralTools.micrometerSymbol();
            double pixelWidth = cal.getPixelWidthMicrons();
            double pixelHeight = cal.getPixelHeightMicrons();
            if (!Double.isFinite(pixelWidth)) {
                pixelWidth = 1.0;
            }
            if (!Double.isFinite(pixelHeight)) {
                pixelHeight = 1.0;
            }
            Double defaultValue = null;
            if (roi.isLine()) {
                setPixelHeight = roi.getBoundsHeight() != 0.0;
                setPixelWidth = roi.getBoundsWidth() != 0.0;
                message = "Enter selected line length";
                defaultValue = roi.getScaledLength(pixelWidth, pixelHeight);
            } else {
                message = "Enter selected ROI area";
                units = (String)units + "^2";
                defaultValue = roi.getScaledArea(pixelWidth, pixelHeight);
            }
            if (Double.isNaN(defaultValue)) {
                defaultValue = 1.0;
            }
            ParameterList params = new ParameterList().addDoubleParameter("inputValue", message, defaultValue.doubleValue(), (String)units, "Enter calibrated value in " + (String)units + " for the selected ROI to calculate the pixel size").addBooleanParameter("squarePixels", "Assume square pixels", true, "Set the pixel width to match the pixel height");
            params.setHiddenParameters(setPixelHeight && setPixelWidth, new String[]{"squarePixels"});
            if (!GuiTools.showParameterDialog("Set pixel size", params)) {
                return false;
            }
            Double result = params.getDoubleParameterValue("inputValue");
            setPixelHeight = setPixelHeight || params.getBooleanParameterValue("squarePixels") != false;
            setPixelWidth = setPixelWidth || params.getBooleanParameterValue("squarePixels") != false;
            double sizeMicrons = roi.isLine() ? result / roi.getLength() : Math.sqrt(result / roi.getArea());
            if (setPixelHeight) {
                pixelHeightMicrons = sizeMicrons;
            }
            if (setPixelWidth) {
                pixelWidthMicrons = sizeMicrons;
            }
        } else {
            ParameterList params = new ParameterList().addDoubleParameter("pixelWidth", "Pixel width", pixelWidthMicrons, GeneralTools.micrometerSymbol(), "Enter the pixel width").addDoubleParameter("pixelHeight", "Pixel height", pixelHeightMicrons, GeneralTools.micrometerSymbol(), "Entry the pixel height").addDoubleParameter("zSpacing", "Z-spacing", zSpacingMicrons, GeneralTools.micrometerSymbol(), "Enter the spacing between slices of a z-stack");
            params.setHiddenParameters(server.nZSlices() == 1, new String[]{"zSpacing"});
            if (!GuiTools.showParameterDialog("Set pixel size", params)) {
                return false;
            }
            if (server.nZSlices() != 1) {
                zSpacingMicrons = params.getDoubleParameterValue("zSpacing");
            }
            pixelWidthMicrons = params.getDoubleParameterValue("pixelWidth");
            pixelHeightMicrons = params.getDoubleParameterValue("pixelHeight");
        }
        if (pixelWidthMicrons <= 0.0 || pixelHeightMicrons <= 0.0 || server.nZSlices() > 1 && zSpacingMicrons <= 0.0) {
            if (!Dialogs.showConfirmDialog((String)"Set pixel size", (String)"You entered values <= 0, do you really want to remove this pixel calibration information?")) {
                return false;
            }
            double d = zSpacingMicrons = server.nZSlices() > 1 && zSpacingMicrons > 0.0 ? zSpacingMicrons : Double.NaN;
            if (pixelWidthMicrons <= 0.0 || pixelHeightMicrons <= 0.0) {
                pixelWidthMicrons = Double.NaN;
                pixelHeightMicrons = Double.NaN;
            }
        }
        if (QP.setPixelSizeMicrons(imageData, (Number)pixelWidthMicrons, (Number)pixelHeightMicrons, (Number)zSpacingMicrons)) {
            DefaultScriptableWorkflowStep step;
            if (server.nZSlices() == 1) {
                Map<String, Double> map = Map.of("pixelWidthMicrons", pixelWidthMicrons, "pixelHeightMicrons", pixelHeightMicrons);
                script = String.format("setPixelSizeMicrons(%f, %f)", pixelWidthMicrons, pixelHeightMicrons);
                step = new DefaultScriptableWorkflowStep("Set pixel size " + GeneralTools.micrometerSymbol(), map, script);
            } else {
                Map<String, Double> map = Map.of("pixelWidthMicrons", pixelWidthMicrons, "pixelHeightMicrons", pixelHeightMicrons, "zSpacingMicrons", zSpacingMicrons);
                script = String.format("setPixelSizeMicrons(%f, %f, %f)", pixelWidthMicrons, pixelHeightMicrons, zSpacingMicrons);
                step = new DefaultScriptableWorkflowStep("Set pixel size " + GeneralTools.micrometerSymbol(), map, script);
            }
            imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
            return true;
        }
        return false;
    }

    public static boolean promptToSetImageType(ImageData<BufferedImage> imageData, ImageData.ImageType defaultType) {
        Object[] buttons;
        boolean isRGB;
        double size = 32.0;
        ToggleGroup group = new ToggleGroup();
        boolean bl = isRGB = imageData.getServerMetadata().getChannels().size() == 3;
        if (defaultType == null) {
            defaultType = ImageData.ImageType.UNSET;
        }
        LinkedHashMap<ImageData.ImageType, ToggleButton> buttonMap = new LinkedHashMap<ImageData.ImageType, ToggleButton>();
        Group iconUnspecified = (Group)ImageDetailsPane.createImageTypeCell(Color.GRAY, null, null, size);
        if (isRGB) {
            buttonMap.put(ImageData.ImageType.BRIGHTFIELD_H_E, ImageDetailsPane.createImageTypeButton(ImageData.ImageType.BRIGHTFIELD_H_E, "Brightfield\nH&E", ImageDetailsPane.createImageTypeCell(Color.WHITE, Color.PINK, Color.DARKBLUE, size), "Brightfield image with hematoylin & eosin stains\n(8-bit RGB only)", isRGB));
            buttonMap.put(ImageData.ImageType.BRIGHTFIELD_H_DAB, ImageDetailsPane.createImageTypeButton(ImageData.ImageType.BRIGHTFIELD_H_DAB, "Brightfield\nH-DAB", ImageDetailsPane.createImageTypeCell(Color.WHITE, Color.rgb((int)200, (int)200, (int)220), Color.rgb((int)120, (int)50, (int)20), size), "Brightfield image with hematoylin & DAB stains\n(8-bit RGB only)", isRGB));
            buttonMap.put(ImageData.ImageType.BRIGHTFIELD_OTHER, ImageDetailsPane.createImageTypeButton(ImageData.ImageType.BRIGHTFIELD_OTHER, "Brightfield\nOther", ImageDetailsPane.createImageTypeCell(Color.WHITE, Color.ORANGE, Color.FIREBRICK, size), "Brightfield image with other chromogenic stains\n(8-bit RGB only)", isRGB));
        }
        buttonMap.put(ImageData.ImageType.FLUORESCENCE, ImageDetailsPane.createImageTypeButton(ImageData.ImageType.FLUORESCENCE, "Fluorescence", ImageDetailsPane.createImageTypeCell(Color.BLACK, Color.LIGHTGREEN, Color.BLUE, size), "Fluorescence or fluorescence-like image with a dark background\nAlso suitable for imaging mass cytometry", true));
        buttonMap.put(ImageData.ImageType.OTHER, ImageDetailsPane.createImageTypeButton(ImageData.ImageType.OTHER, "Other", ImageDetailsPane.createImageTypeCell(Color.BLACK, Color.WHITE, Color.GRAY, size), "Any other image type", true));
        buttonMap.put(ImageData.ImageType.UNSET, ImageDetailsPane.createImageTypeButton(ImageData.ImageType.UNSET, "Unspecified", (Node)iconUnspecified, "Do not set the image type (not recommended for analysis)", true));
        for (ToggleButton toggleButton : buttons = (ToggleButton[])buttonMap.values().toArray(ToggleButton[]::new)) {
            if (!toggleButton.isDisabled()) continue;
            toggleButton.getTooltip().setText("Image type is not supported because image is not RGB");
        }
        List<ToggleButton> buttonList = Arrays.asList(buttons);
        group.getToggles().setAll(buttons);
        group.selectedToggleProperty().addListener((v, o, n) -> {
            if (n == null) {
                o.setSelected(true);
            }
        });
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])buttons);
        GridPaneUtils.setMaxHeight((double)Double.MAX_VALUE, (Region[])buttons);
        ToggleButton selectedButton = (ToggleButton)buttonMap.get(defaultType);
        group.selectToggle((Toggle)selectedButton);
        GridPane grid = new GridPane();
        int n2 = 3;
        int nVertical = (int)Math.ceil((double)buttons.length / (double)n2);
        grid.getColumnConstraints().setAll(IntStream.range(0, n2).mapToObj(i -> {
            ColumnConstraints c = new ColumnConstraints();
            c.setPercentWidth(100.0 / (double)nHorizontal);
            return c;
        }).toList());
        grid.getRowConstraints().setAll(IntStream.range(0, nVertical).mapToObj(i -> {
            RowConstraints c = new RowConstraints();
            c.setPercentHeight(100.0 / (double)nVertical);
            return c;
        }).toList());
        grid.setVgap(5.0);
        grid.setMaxWidth(Double.MAX_VALUE);
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            grid.add((Node)buttons[i2], i2 % n2, i2 / n2);
        }
        BorderPane content = new BorderPane((Node)grid);
        ComboBox comboOptions = new ComboBox();
        comboOptions.getItems().setAll((Object[])PathPrefs.ImageTypeSetting.values());
        Map<PathPrefs.ImageTypeSetting, String> prompts = Map.of(PathPrefs.ImageTypeSetting.AUTO_ESTIMATE, "Always auto-estimate type (don't prompt)", PathPrefs.ImageTypeSetting.PROMPT, "Always prompt me to set type", PathPrefs.ImageTypeSetting.NONE, "Don't set the image type");
        comboOptions.setButtonCell(FXUtils.createCustomListCell(p -> (String)prompts.get(p)));
        comboOptions.setCellFactory(c -> FXUtils.createCustomListCell(p -> (String)prompts.get(p)));
        comboOptions.setTooltip(new Tooltip("Choose whether you want to see these prompts when opening an image for the first time"));
        comboOptions.setMaxWidth(Double.MAX_VALUE);
        comboOptions.getSelectionModel().select((Object)((PathPrefs.ImageTypeSetting)((Object)PathPrefs.imageTypeSettingProperty().get())));
        if (nVertical > 1) {
            BorderPane.setMargin((Node)comboOptions, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        } else {
            BorderPane.setMargin((Node)comboOptions, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        }
        content.setBottom((Node)comboOptions);
        Label labelDetails = new Label("The image type is used for stain separation by some commands, e.g. 'Cell detection'.\nBrightfield types are only available for 8-bit RGB images.");
        labelDetails.setWrapText(true);
        labelDetails.prefWidthProperty().bind((ObservableValue)grid.widthProperty().subtract(10));
        labelDetails.setMaxHeight(Double.MAX_VALUE);
        labelDetails.setPrefHeight(-1.0);
        labelDetails.setPrefHeight(100.0);
        labelDetails.setAlignment(Pos.CENTER);
        labelDetails.setTextAlignment(TextAlignment.CENTER);
        Dialog dialog = Dialogs.builder().title("Set image type").headerText("What type of image is this?").content((Node)content).buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).expandableContent((Node)labelDetails).build();
        Node btnApply = dialog.getDialogPane().lookupButton(ButtonType.APPLY);
        Platform.runLater(() -> selectedButton.requestFocus());
        for (Object btn : buttons) {
            btn.setOnMouseClicked(arg_0 -> ImageDetailsPane.lambda$promptToSetImageType$14((ToggleButton)btn, btnApply, arg_0));
        }
        KeyCodeCombination enterPressed = new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]);
        KeyCodeCombination spacePressed = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[0]);
        dialog.getDialogPane().addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (enterPressed.match(e) || spacePressed.match(e)) {
                btnApply.fireEvent((Event)new ActionEvent());
                e.consume();
            } else if (e.getCode() == KeyCode.UP || e.getCode() == KeyCode.DOWN || e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.RIGHT) {
                ToggleButton selected = (ToggleButton)group.getSelectedToggle();
                int ind = buttonList.indexOf(selected);
                ToggleButton newSelected = selected;
                if (e.getCode() == KeyCode.UP && ind >= nHorizontal) {
                    newSelected = (ToggleButton)buttonList.get(ind - nHorizontal);
                }
                if (e.getCode() == KeyCode.LEFT && ind > 0) {
                    newSelected = (ToggleButton)buttonList.get(ind - 1);
                }
                if (e.getCode() == KeyCode.RIGHT && ind < buttonList.size() - 1) {
                    newSelected = (ToggleButton)buttonList.get(ind + 1);
                }
                if (e.getCode() == KeyCode.DOWN && ind < buttonList.size() - nHorizontal) {
                    newSelected = (ToggleButton)buttonList.get(ind + nHorizontal);
                }
                newSelected.requestFocus();
                group.selectToggle((Toggle)newSelected);
                e.consume();
            }
        });
        Optional response = dialog.showAndWait();
        if (response.orElse(ButtonType.CANCEL) == ButtonType.APPLY) {
            PathPrefs.imageTypeSettingProperty().set((Object)((PathPrefs.ImageTypeSetting)((Object)comboOptions.getSelectionModel().getSelectedItem())));
            ImageData.ImageType selectedType = (ImageData.ImageType)group.getSelectedToggle().getUserData();
            if (selectedType != imageData.getImageType()) {
                imageData.setImageType(selectedType);
                return true;
            }
        }
        return false;
    }

    private static ToggleButton createImageTypeButton(ImageData.ImageType type, String name, Node node, String tooltip, boolean isEnabled) {
        ToggleButton btn = new ToggleButton(name, node);
        if (tooltip != null) {
            btn.setTooltip(new Tooltip(tooltip));
        }
        btn.setTextAlignment(TextAlignment.CENTER);
        btn.setAlignment(Pos.TOP_CENTER);
        btn.setContentDisplay(ContentDisplay.BOTTOM);
        btn.setOpacity(0.6);
        btn.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                btn.setOpacity(1.0);
            } else {
                btn.setOpacity(0.6);
            }
        });
        btn.setUserData((Object)type);
        if (!isEnabled) {
            btn.setDisable(true);
        }
        return btn;
    }

    private static Node createImageTypeCell(Color bgColor, Color cytoColor, Color nucleusColor, double size) {
        Group group = new Group();
        if (bgColor != null) {
            Rectangle rect = new Rectangle(0.0, 0.0, size, size);
            rect.setFill((Paint)bgColor);
            rect.setEffect((Effect)new DropShadow(5.0, Color.BLACK));
            group.getChildren().add((Object)rect);
        }
        if (cytoColor != null) {
            Ellipse cyto = new Ellipse(size / 2.0, size / 2.0, size / 3.0, size / 3.0);
            cyto.setFill((Paint)cytoColor);
            cyto.setEffect((Effect)new DropShadow(2.5, Color.BLACK));
            group.getChildren().add((Object)cyto);
        }
        if (nucleusColor != null) {
            Ellipse nucleus = new Ellipse(size / 2.4, size / 2.4, size / 5.0, size / 5.0);
            nucleus.setFill((Paint)nucleusColor);
            nucleus.setEffect((Effect)new DropShadow(2.5, Color.BLACK));
            group.getChildren().add((Object)nucleus);
        }
        group.setOpacity(0.7);
        return group;
    }

    public Pane getPane() {
        return this.pane;
    }

    private void setImageData(ImageData<BufferedImage> imageData) {
        if (this.imageData != null) {
            this.imageData.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.imageData = imageData;
        ImageServer server = null;
        if (imageData != null) {
            imageData.addPropertyChangeListener((PropertyChangeListener)this);
            server = imageData.getServer();
        }
        this.table.getItems().setAll(this.getRows());
        this.table.refresh();
        if (this.listAssociatedImages != null) {
            if (server == null) {
                this.listAssociatedImages.getItems().clear();
            } else {
                this.listAssociatedImages.getItems().setAll((Collection)server.getAssociatedImageList());
            }
        }
        for (Map.Entry<String, SimpleImageViewer> entry : this.associatedImageViewers.entrySet()) {
            String name = entry.getKey();
            SimpleImageViewer simpleViewer = entry.getValue();
            logger.trace("Updating associated image viewer for {}", (Object)name);
            if (server == null || !server.getAssociatedImageList().contains(name)) {
                simpleViewer.updateImage(name, (BufferedImage)null);
                continue;
            }
            simpleViewer.updateImage(name, (BufferedImage)server.getAssociatedImage(name));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setImageData(this.imageData);
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.setImageData(imageDataNew);
    }

    private List<ImageDetailRow> getRows() {
        if (this.imageData == null || this.imageData.getServer() == null) {
            return Collections.emptyList();
        }
        ArrayList<ImageDetailRow> list = new ArrayList<ImageDetailRow>();
        if (this.imageData.isBrightfield()) {
            list.addAll(brightfieldRows);
        } else {
            list.addAll(otherRows);
        }
        if (this.imageData.getServer().nZSlices() == 1) {
            list.remove((Object)ImageDetailRow.Z_SPACING);
        }
        return list;
    }

    private String getName(ImageDetailRow row) {
        switch (row.ordinal()) {
            case 0: {
                return "Name";
            }
            case 1: {
                if (this.imageData != null && this.imageData.getServer().getURIs().size() == 1) {
                    return "URI";
                }
                return "URIs";
            }
            case 14: {
                return "Image type";
            }
            case 13: {
                return "Metadata changed";
            }
            case 2: {
                return "Pixel type";
            }
            case 3: {
                return "Magnification";
            }
            case 4: {
                return "Width";
            }
            case 5: {
                return "Height";
            }
            case 6: {
                return "Dimensions (CZT)";
            }
            case 7: {
                return "Pixel width";
            }
            case 8: {
                return "Pixel height";
            }
            case 9: {
                return "Z-spacing";
            }
            case 10: {
                return "Uncompressed size";
            }
            case 11: {
                return "Server type";
            }
            case 12: {
                return "Pyramid";
            }
            case 15: {
                return "Stain 1";
            }
            case 16: {
                return "Stain 2";
            }
            case 17: {
                return "Stain 3";
            }
            case 18: {
                return "Background";
            }
        }
        return null;
    }

    private static String decodeURI(URI uri) {
        try {
            return URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return uri.toString();
        }
    }

    private Object getValue(ImageDetailRow rowType) {
        if (this.imageData == null) {
            return null;
        }
        ImageServer server = this.imageData.getServer();
        PixelCalibration cal = server.getPixelCalibration();
        switch (rowType.ordinal()) {
            case 0: {
                ProjectImageEntry entry;
                Project<BufferedImage> project = QuPathGUI.getInstance().getProject();
                ProjectImageEntry projectImageEntry = entry = project == null ? null : project.getEntry(this.imageData);
                if (entry == null) {
                    return ServerTools.getDisplayableImageName((ImageServer)server);
                }
                return entry.getImageName();
            }
            case 1: {
                Collection uris = server.getURIs();
                if (uris.isEmpty()) {
                    return "Not available";
                }
                if (uris.size() == 1) {
                    return ImageDetailsPane.decodeURI((URI)uris.iterator().next());
                }
                return "[" + String.join((CharSequence)", ", uris.stream().map(ImageDetailsPane::decodeURI).toList()) + "]";
            }
            case 14: {
                return this.imageData.getImageType();
            }
            case 13: {
                return ImageDetailsPane.hasOriginalMetadata((ImageServer<BufferedImage>)this.imageData.getServer()) ? "No" : "Yes";
            }
            case 2: {
                Object type = server.getPixelType().toString().toLowerCase();
                if (server.isRGB()) {
                    type = (String)type + " (rgb)";
                }
                return type;
            }
            case 3: {
                double mag = server.getMetadata().getMagnification();
                if (Double.isNaN(mag)) {
                    return "Unknown";
                }
                return mag;
            }
            case 4: {
                if (cal.hasPixelSizeMicrons()) {
                    return String.format("%s px (%.2f %s)", server.getWidth(), (double)server.getWidth() * cal.getPixelWidthMicrons(), GeneralTools.micrometerSymbol());
                }
                return String.format("%s px", server.getWidth());
            }
            case 5: {
                if (cal.hasPixelSizeMicrons()) {
                    return String.format("%s px (%.2f %s)", server.getHeight(), (double)server.getHeight() * cal.getPixelHeightMicrons(), GeneralTools.micrometerSymbol());
                }
                return String.format("%s px", server.getHeight());
            }
            case 6: {
                return String.format("%d x %d x %d", server.nChannels(), server.nZSlices(), server.nTimepoints());
            }
            case 7: {
                if (cal.hasPixelSizeMicrons()) {
                    return String.format("%.4f %s", cal.getPixelWidthMicrons(), GeneralTools.micrometerSymbol());
                }
                return "Unknown";
            }
            case 8: {
                if (cal.hasPixelSizeMicrons()) {
                    return String.format("%.4f %s", cal.getPixelHeightMicrons(), GeneralTools.micrometerSymbol());
                }
                return "Unknown";
            }
            case 9: {
                if (cal.hasZSpacingMicrons()) {
                    return String.format("%.4f %s", cal.getZSpacingMicrons(), GeneralTools.micrometerSymbol());
                }
                return "Unknown";
            }
            case 10: {
                double size = (double)server.getWidth() / 1024.0 * (double)server.getHeight() / 1024.0 * (double)server.getPixelType().getBytesPerPixel() * (double)server.nChannels() * (double)server.nZSlices() * (double)server.nTimepoints();
                String units = " MB";
                if (size > 1000.0) {
                    size /= 1024.0;
                    units = " GB";
                }
                return GeneralTools.formatNumber((double)size, (int)1) + units;
            }
            case 11: {
                return server.getServerType();
            }
            case 12: {
                if (server.nResolutions() == 1) {
                    return "No";
                }
                return GeneralTools.arrayToString((Locale)Locale.getDefault(Locale.Category.FORMAT), (double[])server.getPreferredDownsamples(), (int)1);
            }
            case 15: {
                return this.imageData.getColorDeconvolutionStains().getStain(1);
            }
            case 16: {
                return this.imageData.getColorDeconvolutionStains().getStain(2);
            }
            case 17: {
                return this.imageData.getColorDeconvolutionStains().getStain(3);
            }
            case 18: {
                ColorDeconvolutionStains stains = this.imageData.getColorDeconvolutionStains();
                double[] whitespace = new double[]{stains.getMaxRed(), stains.getMaxGreen(), stains.getMaxBlue()};
                return whitespace;
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$promptToSetImageType$14(ToggleButton btn, Node btnApply, MouseEvent e) {
        if (!btn.isDisabled() && e.getClickCount() == 2) {
            btnApply.fireEvent((Event)new ActionEvent());
            e.consume();
        }
    }

    static {
        otherRows.remove((Object)ImageDetailRow.STAIN_1);
        otherRows.remove((Object)ImageDetailRow.STAIN_2);
        otherRows.remove((Object)ImageDetailRow.STAIN_3);
        otherRows.remove((Object)ImageDetailRow.BACKGROUND);
    }

    private static enum ImageDetailRow {
        NAME,
        URI,
        PIXEL_TYPE,
        MAGNIFICATION,
        WIDTH,
        HEIGHT,
        DIMENSIONS,
        PIXEL_WIDTH,
        PIXEL_HEIGHT,
        Z_SPACING,
        UNCOMPRESSED_SIZE,
        SERVER_TYPE,
        PYRAMID,
        METADATA_CHANGED,
        IMAGE_TYPE,
        STAIN_1,
        STAIN_2,
        STAIN_3,
        BACKGROUND;

    }

    private static class ImageDetailTableCell
    extends TableCell<ImageDetailRow, Object> {
        private ObservableValue<ImageData<BufferedImage>> imageDataProperty;

        ImageDetailTableCell(ObservableValue<ImageData<BufferedImage>> imageDataProperty) {
            this.imageDataProperty = imageDataProperty;
            this.setOnMouseClicked(this::handleMouseClick);
        }

        protected void updateItem(Object item, boolean empty) {
            String text;
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            String style = null;
            String tooltipText = text = item == null ? "" : item.toString();
            if (item instanceof double[]) {
                text = GeneralTools.arrayToString((Locale)Locale.getDefault(Locale.Category.FORMAT), (double[])((double[])item), (int)2);
                tooltipText = "Double-click to set background values for color deconvolution (either type values or use a small rectangle ROI in the image)";
            } else if (item instanceof StainVector) {
                StainVector stain = (StainVector)item;
                Integer color = stain.getColor();
                style = String.format("-fx-text-fill: rgb(%d, %d, %d);", ColorTools.red((int)color), ColorTools.green((int)color), ColorTools.blue((int)color));
                tooltipText = "Double-click to set stain color (either type values or use a small rectangle ROI in the image)";
            } else {
                ImageDetailRow type = (ImageDetailRow)((Object)this.getTableRow().getItem());
                if (type != null) {
                    if (type.equals((Object)ImageDetailRow.PIXEL_WIDTH) || type.equals((Object)ImageDetailRow.PIXEL_HEIGHT) || type.equals((Object)ImageDetailRow.Z_SPACING)) {
                        if ("Unknown".equals(item)) {
                            style = "-fx-text-fill: red;";
                        }
                        tooltipText = "Double-click to set pixel calibration (can use a selected line or area ROI in the image)";
                    } else if (type.equals((Object)ImageDetailRow.METADATA_CHANGED)) {
                        tooltipText = "Double-click to reset original metadata";
                    } else if (type.equals((Object)ImageDetailRow.UNCOMPRESSED_SIZE)) {
                        tooltipText = "Approximate memory required to store all pixels in the image uncompressed";
                    }
                }
            }
            this.setStyle(style);
            this.setText(text);
            this.setTooltip(new Tooltip(tooltipText));
        }

        private void handleMouseClick(MouseEvent event) {
            ImageData imageData = (ImageData)this.imageDataProperty.getValue();
            if (event.getClickCount() < 2 || imageData == null) {
                return;
            }
            TableCell c = (TableCell)event.getSource();
            Object value = c.getItem();
            if (value instanceof StainVector || value instanceof double[]) {
                ImageDetailTableCell.editStainVector((ImageData<BufferedImage>)imageData, value);
            } else if (value instanceof ImageData.ImageType) {
                ImageDetailsPane.promptToSetImageType((ImageData<BufferedImage>)imageData, imageData.getImageType());
            } else {
                ImageDetailRow type = (ImageDetailRow)((Object)c.getTableRow().getItem());
                boolean metadataChanged = false;
                if (type == ImageDetailRow.PIXEL_WIDTH || type == ImageDetailRow.PIXEL_HEIGHT || type == ImageDetailRow.Z_SPACING) {
                    metadataChanged = ImageDetailsPane.promptToSetPixelSize((ImageData<BufferedImage>)imageData, type == ImageDetailRow.Z_SPACING);
                } else if (type == ImageDetailRow.MAGNIFICATION) {
                    metadataChanged = ImageDetailsPane.promptToSetMagnification((ImageData<BufferedImage>)imageData);
                } else if (type == ImageDetailRow.METADATA_CHANGED && !ImageDetailsPane.hasOriginalMetadata((ImageServer<BufferedImage>)imageData.getServer())) {
                    metadataChanged = ImageDetailsPane.promptToResetServerMetadata((ImageData<BufferedImage>)imageData);
                }
                if (metadataChanged) {
                    c.getTableView().refresh();
                    imageData.getHierarchy().fireHierarchyChangedEvent((Object)this);
                }
            }
        }

        private static void editStainVector(ImageData<BufferedImage> imageData, Object value) {
            String title;
            boolean editableName;
            if (imageData == null || !(value instanceof StainVector) && !(value instanceof double[])) {
                return;
            }
            ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
            int num = -1;
            String name = null;
            String message = null;
            if (value instanceof StainVector) {
                StainVector stainVector = (StainVector)value;
                if (stainVector.isResidual() && imageData.getImageType() != ImageData.ImageType.BRIGHTFIELD_OTHER) {
                    logger.warn("Cannot set residual stain vector - this is computed from the known vectors");
                    return;
                }
                num = stains.getStainNumber(stainVector);
                if (num <= 0) {
                    logger.error("Could not identify stain vector {} inside {}", (Object)stainVector, (Object)stains);
                    return;
                }
                name = stainVector.getName();
                message = "Set stain vector from ROI?";
            } else {
                message = "Set color deconvolution background values from ROI?";
            }
            ROI roi = imageData.getHierarchy().getSelectionModel().getSelectedROI();
            boolean wasChanged = false;
            String warningMessage = null;
            boolean bl = editableName = imageData.getImageType() == ImageData.ImageType.BRIGHTFIELD_OTHER;
            if (roi != null) {
                if (roi instanceof RectangleROI && !roi.isEmpty() && roi.getArea() < 250000.0) {
                    if (Dialogs.showYesNoDialog((String)"Color deconvolution stains", (String)message)) {
                        ImageServer server = imageData.getServer();
                        BufferedImage img = null;
                        try {
                            img = (BufferedImage)server.readRegion(RegionRequest.createInstance((String)server.getPath(), (double)1.0, (ROI)roi));
                        }
                        catch (IOException e) {
                            Dialogs.showErrorMessage((String)"Set stain vector", (String)"Unable to read image region");
                            logger.error("Unable to read region", (Throwable)e);
                            return;
                        }
                        if (num >= 0) {
                            StainVector vectorValue = ColorDeconvolutionHelper.generateMedianStainVectorFromPixels((String)name, (BufferedImage)img, (double)stains.getMaxRed(), (double)stains.getMaxGreen(), (double)stains.getMaxBlue());
                            if (!Double.isFinite(vectorValue.getRed() + vectorValue.getGreen() + vectorValue.getBlue())) {
                                Dialogs.showErrorMessage((String)"Set stain vector", (String)"Cannot set stains for the current ROI!\nIt might be too close to the background color.");
                                return;
                            }
                            value = vectorValue;
                        } else if (BufferedImageTools.is8bitColorType((int)img.getType())) {
                            int rgb = ColorDeconvolutionHelper.getMedianRGB((int[])img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth()));
                            value = new double[]{ColorTools.red((int)rgb), ColorTools.green((int)rgb), ColorTools.blue((int)rgb)};
                        } else {
                            double r = ColorDeconvolutionHelper.getMedian((float[])ColorDeconvolutionHelper.getPixels((Raster)img.getRaster(), (int)0));
                            double g = ColorDeconvolutionHelper.getMedian((float[])ColorDeconvolutionHelper.getPixels((Raster)img.getRaster(), (int)1));
                            double b = ColorDeconvolutionHelper.getMedian((float[])ColorDeconvolutionHelper.getPixels((Raster)img.getRaster(), (int)2));
                            value = new double[]{r, g, b};
                        }
                        wasChanged = true;
                    }
                } else {
                    warningMessage = "Note: To set stain values from an image region, draw a small, rectangular ROI first";
                }
            }
            ParameterList params = new ParameterList();
            String nameBefore = null;
            String valuesBefore = null;
            String collectiveNameBefore = stains.getName();
            Object suggestedName = collectiveNameBefore.endsWith("default") ? collectiveNameBefore.substring(0, collectiveNameBefore.lastIndexOf("default")) + "modified" : collectiveNameBefore;
            params.addStringParameter("collectiveName", "Collective name", (String)suggestedName, "Enter collective name for all 3 stains (e.g. H-DAB Scanner A, H&E Scanner B)");
            if (value instanceof StainVector) {
                nameBefore = ((StainVector)value).getName();
                valuesBefore = ((StainVector)value).arrayAsString(Locale.getDefault(Locale.Category.FORMAT));
                params.addStringParameter("name", "Name", nameBefore, "Enter stain name").addStringParameter("values", "Values", valuesBefore, "Enter 3 values (red, green, blue) defining color deconvolution stain vector, separated by spaces");
                title = "Set stain vector";
            } else {
                nameBefore = "Background";
                valuesBefore = GeneralTools.arrayToString((Locale)Locale.getDefault(Locale.Category.FORMAT), (double[])((double[])value), (int)2);
                params.addStringParameter("name", "Stain name", nameBefore);
                params.addStringParameter("values", "Stain values", valuesBefore, "Enter 3 values (red, green, blue) defining background, separated by spaces");
                params.setHiddenParameters(true, new String[]{"name"});
                title = "Set background";
            }
            if (warningMessage != null) {
                params.addEmptyParameter(warningMessage);
            }
            ParameterPanelFX parameterPanel = new ParameterPanelFX(params);
            parameterPanel.setParameterEnabled("name", editableName);
            if (!Dialogs.showConfirmDialog((String)title, (Node)parameterPanel.getPane())) {
                return;
            }
            String collectiveName = params.getStringParameterValue("collectiveName");
            String nameAfter = params.getStringParameterValue("name");
            String valuesAfter = params.getStringParameterValue("values");
            if (collectiveName.equals(collectiveNameBefore) && nameAfter.equals(nameBefore) && valuesAfter.equals(valuesBefore) && !wasChanged) {
                return;
            }
            if (Set.of("Red", "Green", "Blue").contains(nameAfter)) {
                Dialogs.showErrorMessage((String)"Set stain vector", (String)"Cannot set stain name to 'Red', 'Green', or 'Blue' - please choose a different name");
                return;
            }
            double[] valuesParsed = ColorDeconvolutionStains.parseStainValues((Locale)Locale.getDefault(Locale.Category.FORMAT), (String)valuesAfter);
            if (valuesParsed == null) {
                logger.error("Input for setting color deconvolution information invalid! Cannot parse 3 numbers from {}", (Object)valuesAfter);
                return;
            }
            if (num >= 0) {
                try {
                    stains = stains.changeStain(StainVector.createStainVector((String)nameAfter, (double)valuesParsed[0], (double)valuesParsed[1], (double)valuesParsed[2]), num);
                }
                catch (Exception e) {
                    logger.error("Error setting stain vectors", (Throwable)e);
                    Dialogs.showErrorMessage((String)"Set stain vectors", (String)"Requested stain vectors are not valid!\nAre two stains equal?");
                }
            } else {
                stains = stains.changeMaxValues(valuesParsed[0], valuesParsed[1], valuesParsed[2]);
            }
            stains = stains.changeName(collectiveName);
            imageData.setColorDeconvolutionStains(stains);
        }
    }
}

